/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *  RX610 UARTp ȈSIOhCo
 */

#ifndef TOPPERS_RX610_UART_H
#define TOPPERS_RX610_UART_H

/* w\ȃNbN\[X */
#define CLK_F1	UINT_C(0x00)
#define CLK_F4	UINT_C(0x01)
#define CLK_F16	UINT_C(0x02)
#define CLK_F64	UINT_C(0x03)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_RDY_SND    (1U)        /* M\R[obN */
#define SIO_RDY_RCV    (2U)        /* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void rx600_uart_initialize(void);

/*
 * J[lÑoi[o͗p̏
 */
extern void rx600_uart_init(ID siopid , uint8_t baud , uint8_t clksrc);

/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
extern void rx600_uart_pol_putc(char_t c, ID siopid);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *rx600_uart_opn_por
	(ID siopid, intptr_t exinf , uint8_t baud , uint8_t clksrc);

/*
 *  VAI/O|[g̃N[Y
 */
extern void rx600_uart_cls_por(SIOPCB *p_siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t rx600_uart_snd_chr(SIOPCB *p_siopcb, char_t c);

/*
 *  VAI/O|[g̕M
 */
extern int_t rx600_uart_rcv_chr(SIOPCB *p_siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void  rx600_uart_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void rx600_uart_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void rx600_uart_tx_isr(ID siopid);
extern void rx600_uart_rx_isr(ID siopid);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void rx600_uart_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void rx600_uart_irdy_rcv(intptr_t exinf);


#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_RX610_UART_H */
