/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

#include "kernel_impl.h"
#include "task.h"

/*
 *  g[XO}ÑftHg`
 */

#ifndef LOG_DSP_ENTER
	#define LOG_DSP_ENTER(tskidx)
#endif /* LOG_DSP_ENTER */

#ifndef LOG_DSP_LEAVE
	#define LOG_DSP_LEAVE(tskidx)
#endif /* LOG_DSP_ENTER */


extern const intptr_t	tinib_exinf[];			/* ^XN̊g */
extern const TASK    	tinib_task[];			/* ^XN̋NԒn */
extern const uint_t  	tinib_epriority[];		/* ^XN̎sDxxi\j */


#ifdef TOPPERS_tskini

/*
 * sԃ^XN̋NDx
 */
uint_t runtsk_ipri;

/*
 *  fBL[T[`̂߂̃rbg}bv
 */
volatile uint_t	ready_primap;

/*
 *  ^XNfBXpb`NvtO
 */
bool_t	reqflg;

/*
 *  fBXpb`֎~
 */
bool_t	disdsp;

/*
 *  read_primap̏l
 */
extern const uint_t init_rdypmap;

#endif /* TOPPERS_tskini */

#ifdef TOPPERS_get_ipri_self

/*
 *  ^XNIDNDxo߂̃}N
 */
uint_t
get_ipri_self(ID tskid)
{
	uint_t inipri;
	
	if(tskid != TSK_SELF)
	{
		inipri = (uint_t)((tskid) - TMIN_TSKID);
	}
	else
	{
		inipri = runtsk_ipri;
	}
	return inipri;
}

#endif /* TOPPERS_get_ipri_self */

#ifdef TOPPERS_get_ipri

uint_t
get_ipri(ID tskid)
{
	return (uint_t)(tskid - TMIN_TSKID);
}

#endif /* TOPPERS_get_ipri */

/*
 *  rbg}bvT[`֐
 *
 *  bitmap1̃rbg̓CłʁiEĵ̂T[`C̃rb
 *  gԍԂDrbgԍ́Cŉʃrbg0ƂDbitmap0w
 *  Ă͂ȂȂD̊֐ł́Cbitmap8rbgł邱Ƃ肵C
 *  uint8_t^ƂĂD
 *
 *  rbgT[`߂vZbTł́CrbgT[`߂g悤
 *  ǂꍇD̂悤ȏꍇɂ́C^[Qbg
 *  ˑŃrbgT[`߂gbitmap_search`C
 *  OMIT_BITMAP_SEARCH}N`΂悢D܂CrbgT[`߂
 *  T[`tȂǂ̗RŗDxƃrbgƂ̑ΉύXꍇ
 *  ́CPRIMAP_BIT}N`΂悢D
 *
 *  ܂CWCuffsȂĈ悤ɒ`ĕWCu
 *  gǂ\D
 *		#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1U << (pri))
#endif /* PRIMAP_BIT */

#ifndef OMIT_BITMAP_SEARCH

static const uint8_t bitmap_search_table[] = { 0U, 1U, 0U, 2U, 0U, 1U, 0U,
												3U, 0U, 1U, 0U, 2U, 0U, 1U, 0U };

Inline uint_t
bitmap_search(uint_t bitmap)
{
	uint_t	n = 0U;

	if ((bitmap & 0x0fU) == 0U) {
		bitmap >>= 4U;
		n += 4U;
	}
	return (n + bitmap_search_table[(bitmap & 0x0fU) - 1U]);
}

#endif /* OMIT_BITMAP_SEARCH */

/*
 *  Dxrbg}bv󂩂̃`FbN
 */
Inline bool_t
primap_empty(void)
{
	return (ready_primap == 0U);
}

/*
 *  w肵Dx̗Dxrbg}bvZbgĂ邩ǂ̃`FbN
 */
Inline bool_t
primap_test(uint_t pri)
{
	return ((ready_primap & PRIMAP_BIT(pri)) != 0U);
}

/*
 *  Dxrbg}bṽT[`
 */
Inline uint_t
primap_search(void)
{
	return bitmap_search((uint_t)ready_primap);
}

/*
 *  Dxrbg}bṽZbg
 */
Inline void
primap_set(uint_t pri)
{
	ready_primap |= PRIMAP_BIT(pri);
}

/*
 *  Dxrbg}bṽNA
 */
Inline void
primap_clear(uint_t pri)
{
	ready_primap &= ~PRIMAP_BIT(pri);
}

/*
 *  ōD揇ʃ^XÑT[`
 */

#ifdef TOPPERS_tsksched

uint_t
search_schedtsk(void)
{
	return primap_search();
}

#endif /* TOPPERS_tsksched */

/*
 * w肵NDx̃^XNsłԂǂ̃eXg
 *
 * słꍇtrueԂD
 */
bool_t
test_dormant(uint_t ipri)
{
	return !primap_test(ipri);
}

/*
 *  ^XNǗW[̏
 */


#ifdef TOPPERS_tskini

void
initialize_task(void)
{
	/* fBL[̃rbg}bv */
	ready_primap = init_rdypmap;
	
	/* sDx̏ */
	runtsk_ipri = IPRI_NULL;
	
	/* ݋֎~tȌ */
	disdsp = false;
}

#endif /* TOPPERS_tskini */

/*
 *  ipri : NΏۃ^XN̋NDx(\)
 */

#ifdef TOPPERS_tskact

bool_t
make_active(uint_t ipri)
{
	bool_t dsp;
	
	primap_set(ipri);
	
	if(ipri < runtsk_ipri) {
		dsp = !disdsp;
	}
	else {
		dsp = false;
	}
	
	return dsp;
}

#endif /* TOPPERS_tskact */


/*
 *  apri : sJn^XN̋NDx
 *  ĂяoF CPUbN
 */

#ifdef TOPPERS_tskrun

void
run_task(uint_t ipri)
{
	uint_t next_pri;	/* ɎsJn^XN̋NDx */
	uint_t saved_pri;	/* Ăяo^XN̋NDx */
	
	next_pri = ipri;
	saved_pri = runtsk_ipri;
	
	do {
		runtsk_ipri = tinib_epriority[next_pri];
		
		/* CPUbN */
		t_unlock_cpu();
		
		/* ^XNsJn */
		(*((TASK)(tinib_task[next_pri])))(tinib_exinf[next_pri]);
		
		if (t_sense_lock()) {
			/*
			 *  CPUbNԂext_tskĂ΂ꂽꍇ́CCPUbN
			 *  Ă^XNID́CT[rXR[łCPU
			 *  bNȗ΂悢D
			 */
		}
		else {
			/*
			 *  t_lock_cpủdisdsp̐ݒ̂悤ɂȂ̂́C
			 *  CPUbNɍēxt_lock_cpuĂ΂Ȃ߂łD
			 */
			t_lock_cpu();
		}
		
		/* ݗDx}XN͑SԂ̂͂Ȃ̂ŁCȂ */
		
		/*
		 *  fBXpb`֎~Ԃext_tskĂ΂ꂽꍇ́CfBXpb
		 *  `ԂɂĂ^XNID
		 *
		 *	{͈ȉ̂悤ɋLqׂł邪Cɂdisdsp
		 *	falseɂ΂߁CPfalseɐݒ肷D
		 *
		 *		if (disdsp) {
		 *			disdsp = false;
		 *		}
		 */
		disdsp = false;
		
		/* rbg}bvNAD */
		primap_clear(next_pri);
		
	  /* ߂^XN̎sDx荂NDx^XNNꂽ */
	} while((!primap_empty()) && (saved_pri > (next_pri = search_schedtsk())));
	
	runtsk_ipri = saved_pri;
}

#endif /* TOPPERS_tskrun */

/*
 *  ̊֐͑S݃bNԂƓ̏Ԃ sta_ker Ă΂
 */

#ifdef TOPPERS_tsk_dsp

void
dispatcher(void)
{
	do {
		if(!primap_empty()) {
			/* ^XN̊Jn */
			run_task(search_schedtsk());
		}
		else {
			idle_loop();
		}
	} while(true);
}

#endif /* TOPPERS_tsk_dsp */
