/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *  nh@\
 */

#include "kernel_impl.h"
#include "check.h"
#include "time_event.h"
#include "cyclic.h"

/*
 *  g[XO}ÑftHg`
 */
#ifndef LOG_CYC_ENTER
#define LOG_CYC_ENTER(cycidx)
#endif /* LOG_CYC_ENTER */

#ifndef LOG_CYC_LEAVE
#define LOG_CYC_LEAVE(cycidx)
#endif /* LOG_CYC_LEAVE */

#ifndef LOG_STA_CYC_ENTER
#define LOG_STA_CYC_ENTER(cycid)
#endif /* LOG_STA_CYC_ENTER */

#ifndef LOG_STA_CYC_LEAVE
#define LOG_STA_CYC_LEAVE(ercd)
#endif /* LOG_STA_CYC_LEAVE */

#ifndef LOG_STP_CYC_ENTER
#define LOG_STP_CYC_ENTER(cycid)
#endif /* LOG_STP_CYC_ENTER */

#ifndef LOG_STP_CYC_LEAVE
#define LOG_STP_CYC_LEAVE(ercd)
#endif /* LOG_STP_CYC_LEAVE */


/* nhID^CCxgIDɕϊ */
#define CYC_EVTID(cycidx)	((ID)((cycidx) + cycevtid_offset))
#define INDEX_CYC(cycid)	((uint_t)((cycid) - TMIN_CYCID))


/* nh̓Ԃ\rbg}bv */
#define CYCACT_BIT(index)	(1U << (index))

/*
 *  nhN[`
 */
static void call_cychdr(uintptr_t cycidx);

/*
 *  nh@\̏
 */

#ifdef TOPPERS_ini_cyc

void
initialize_cyclic(void)
{
	uint_t i;
	
	/* nh̏Ԑݒ */
	cyccb_cycact = cycinib_cycact;
	
	for(i = 0U ; i < tnum_cyc ; i++) {
		cyccb_evttim[i] = 0U;
		
		/* nh̏N */
		if((cycinib_cycact & CYCACT_BIT(i)) != 0U) {
			time_event_enqueue(CYC_EVTID(i) ,
				(EVTTIM)cycinib_cycphs[i] , call_cychdr , i);
			cyccb_evttim[i] = cycinib_cycphs[i];
		}
	}
}

#endif /* TOPPERS_ini_cyc */

#ifdef TOPPERS_sta_cyc

ER
sta_cyc(ID cycid)
{
	ER ercd;
	uint_t index = INDEX_CYC(cycid);
	EVTTIM evttim;
	
	LOG_STA_CYC_ENTER(cycid);
	CHECK_TSKCTX_UNL();
	CHECK_CYCID(cycid);
	
	t_lock_cpu();
	
	if((cyccb_cycact & CYCACT_BIT(index)) != 0U) {
		time_event_dequeue(CYC_EVTID(index));
	}
	else {
		cyccb_cycact |= CYCACT_BIT(index);
	}

	evttim = current_time + cycinib_cycphs[index];
	time_event_enqueue(CYC_EVTID(index) ,
		 evttim , call_cychdr , index);
	cyccb_evttim[index] = evttim;
	
	ercd = E_OK;
	t_unlock_cpu();
	
  error_exit:
	LOG_STA_CYC_LEAVE(ercd);
	return ercd;
}

#endif /* TOPPERS_sta_cyc */


#ifdef TOPPERS_stp_cyc

ER
stp_cyc(ID cycid)
{
	ER ercd;
	uint_t index = INDEX_CYC(cycid);
	
	LOG_STP_CYC_ENTER(cycid);
	CHECK_TSKCTX_UNL();
	CHECK_CYCID(cycid);
	
	t_lock_cpu();
	
	if((cyccb_cycact & CYCACT_BIT(index)) != 0U) {
		cyccb_cycact &= ~CYCACT_BIT(index);
		time_event_dequeue(CYC_EVTID(index));
	}
	ercd = E_OK;
	t_unlock_cpu();
	
  error_exit:
	LOG_STA_CYC_LEAVE(ercd);
	return ercd;
}

#endif /* TOPPERS_stp_cyc */

#ifdef TOPPERS_cal_cyc

static void
call_cychdr(uintptr_t cycidx)
{
	cyccb_evttim[cycidx] += cycinib_cyctim[cycidx];

	/* ̃^CCxgo^ */
	time_event_enqueue((ID)cycidx ,
		cyccb_evttim[cycidx] , call_cychdr , cycidx);
	
	i_unlock_cpu();
	
	/* nhs */
	LOG_CYC_ENTER(cycidx);
	(*cycinib_cychdr[cycidx])(cycinib_exinf[cycidx]);
	LOG_CYC_LEAVE(cycidx);
	
	if (!i_sense_lock()) {
		i_lock_cpu();
	}
}

#endif /* TOPPERS_cal_cyc */
