//
// exp(x)*cos(x) = 1.3780246
//̒lo[Oϕɂ苁߂B 
//yvO8.3.1z 
/* Romberg's quadrature */ 
/* (trapezoid rule + Richardson extrapolation) */ 

##define KMAX 20

func f(float x) as float; 
	return exp(x)*cos(x) ; 
end func;

proc main; 
	float eps,a,b,val; 

	printf('torelence of Romberg''s quadrature: eps ? ');
	eps = getline();
//	scanf("%g", &eps); 
	printf('interval of quadrature: a, b ? '); 
	line = getline();
	n = getargs(line,1,2);
	a = $1;
	b = $2;
//	scanf("%g%g", &a, &b);
	if a >= b then
		printf('\n error!! a(%e) >= b(%e)\n',a,b); 
	else
		printf('\n n trapezoid \t\t*** extrapolation ***\n'); 
		[ret,val] = romberg(KMAX,eps,a,b,f,1);
		if ret < 0 then
			printf('divergent ?\n');
		end if;
		printf('\nintegral=%13.7g\n', val);
	end if;
	return ERROR;
end proc;

//*******1*********2*********3*********4*********5*********6*********7**
// @\ : ^ꂽ֐̋Ԃ̖ʐςo[Oϕɂ苁߂ 
//  : Kmax	: őJԂ
//		  eps	: 덷 (<=0.0 ̂ƂA1.0e-6)
//		  a		: ϕ͈͂̉l
//		  b		: ϕ͈͂̏l
//		  f		: ϕ֐
//		  opt	: <>0 ̂ƂAro߂o͂(default=0)
// ԋp : [^[l, ʐ]
//		  ^[l =  0 : 
//					 = -1 : 덷ݒlȉɂȂȂ
//**********************************************************************
func romberg(int Kmax=0,float eps=0.0,float a,float b,f,opt=0);
	float r,t[Kmax],t1[Kmax]; 
	int k,j; 
	float h,val; 
	int n,ret;

	if Kmax <= 0 thenl Kmxa = 20;
	if eps <= 0.0 thenl eps = 1.0e-6;
	n=1; 
	h=b-a; 
	t[0]=h*(f(a)+f(b))/2; 
	if opt thenl printf('%2d %13.6e\n', n, t[0]); 
	for(k=1;k<Kmax;k++);
		for(j=0;j<k;j++); 
			t1[j]=t[j]; 
		next;
		t[0] = (trapezoid2(n,h,a,f) + t1[0])*0.5; 
		h *= 0.5;
		n += n;
		r =1; 
		for(j=0;j<k;j++);
			r *= 4; 
			t[j+1] = (r*t[j]-t1[j])/(r-1); 
		next; 
		if opt then
			printf('%2d', n); 
			for(j=0;j<=k;j++);
				printf(' %13.6e', t[j]); 
			next;
			printf('\n');
		end if;
		if( abs((t[k]-t1[k-1])/t[k])<eps ) thenl break;
	next;
	if(k>=Kmax) then
//		printf('divergent ?\n');
		val = 0.0;
		ret = -1;
	else
		val = t[k];
		ret = k;
	end if;
	return [ret,val];
end func;

//*******1*********2*********3*********4*********5*********6*********7**
// @\ : ݕ̒_fun()Ƃ`̖ʐς𑫂lԂ
//  : n		: ݐ
//		  h		: ݕ
//		  a		: ϕ͈͂̉l
//		  fun	: ϕ֐
// ԋp : ʐ
//**********************************************************************
func trapezoid2(int n,float h,float a,fun) as float;
	float $sum;
	int i; 

	$sum=0;
	a += h*0.5;
	for(i=0;i<n;i++);
		$sum += fun(a);
		a += h;
	next;
	return h*$sum;
end func;
