static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi 2022.07.31		*/
/*											*/
/********************************************/
#include "akxcommon.h"

char *PC_SYS_DATE_FORMAT = "YYYY-MM-DD HH:MI:SS";
char *PC_DATE_TERM = "YMDHNS";

/********1*********2*********3*********4*********5*********6*********7**/
/*   : axConvDate                                                  */
/*  @\ : Nb̕񂩂NAAAAAb𐶐    */
/*         NAAAAAb́Aꂼ͈̐͂ɏC  */
/*         ̂Ƃ͓ɂ̌̓Ŋl̍        */
/*   : IN  : ymd    : N[b]̕                     */
/*                        ȉ̌`T|[g                     */
/*                        EN                                     */
/*                          [YY]YY{/|-|.}MM[{/|-|.}DD]                 */
/*                          [YY]YYMMDD                                 */
/*                          N100̂Ƃ́A>=50ȂA2000N    */
/*                                               < 50ȂA1900N    */
/*                        Eb                                     */
/*                          H[H]:N[N][:S[S]] or HH[MM[SS]]             */
/*         OUT : ymda() : ymda(0) = N                                 */
/*                        ymda(1) =                                  */
/*                        ymda(2) =                                  */
/*                        ȉ́Aymda̔z5ȏ̂Ƃݒ肳    */
/*                        ymda(3) =                                  */
/*                        ymda(4) =                                  */
/*                        ymda(5) = b                                 */
/*                        ymdŔN܂͎bȂƂ́A        */
/*                        ꂼ̑gŁASāA-1ݒ肳         */
/*               dlma() : dlma(0) = N1 Ԗڂ̋؂             */
/*                        dlma(1) = N2 Ԗڂ̋؂             */
/*                        ȉ́Adlma̔z2ȏ̂Ƃݒ肳    */
/*                        dlma(2) = b̋؂                     */
/*  ԋp :  = 0                                            */
/*                  = 0x01 NC                                */
/*                  = 0x02 C                                */
/*                  = 0x04 C                                */
/*                  = 0x10 C                                */
/*                  = 0x20 C                                */
/*                  = 0x40 bC                                */
/*                  < ymd`G[                                    */
/*  쐬 : 2016/12/26 Akito Kobayashi                                  */
/*  XV : 2017/01/20 Akito Kobayashi Add Time                         */
/***********************************************************************/
char *axConvDate(ymd,ymda,max_ymda,dlma,max_dlma)
char *ymd;
int ymda[],max_ymda,max_dlma;
char dlma[];
{
 max_ymda As Integer
    Dim ret As Integer
    Dim rc As Integer
    Dim yyyy As Integer
    Dim mm As Integer
    Dim dd As Integer
    Dim hh As Integer
    Dim nn As Integer
    Dim ss As Integer
    Dim pos1 As Integer
    Dim pos2 As Integer
    Dim size As Integer
    Dim c1 As String
    Dim c2 As String
    Dim c3 As String
    Dim dat As String
    Dim hns0 As String
    Dim hns As String
    Dim ymd0 As String

    dat = Trim(ymd)
    max_ymda = UBound(ymda)
    c1 = ""
    c2 = ""
    c3 = ""
    ret = 0
    yyyy = 0
    mm = 0
    dd = 0
    hh = 0
    nn = 0
    ss = 0
    hns0 = ""
    ymd0 = dat
    If dat <> "" Then
        hns = ""
        pos1 = InStr(dat, " ")
        If pos1 > 0 Then
            hns = Mid(dat, pos1 + 1)
            dat = Left(dat, pos1 - 1)
            ymd0 = dat
        End If
        On Error GoTo Err
        pos1 = str_chars(dat, "/-.")
        If pos1 = 1 Then
            ret = -1
        ElseIf pos1 > 0 Then
            c1 = Mid(dat, pos1, 1)
            If pos1 > 5 Then
                yyyy = 9999
            Else
                yyyy = Left(dat, pos1 - 1)
            End If
            If yyyy < 100 Then
                If yyyy <= 50 Then
                    yyyy = 2000 + yyyy
                Else
                    yyyy = 1900 + yyyy
                End If
            End If
            dat = Mid(dat, pos1 + 1)
            pos2 = str_chars(dat, "/-.")
            If pos2 = 1 Then
                ret = ret - 2
            ElseIf pos2 > 0 Then
                c2 = Mid(dat, pos2, 1)
                mm = Left(dat, pos2 - 1)
                dat = Mid(dat, pos2 + 1)
                If dat = "" Then
                    ret = ret - 4
                Else
                    dd = dat
                End If
            Else
                mm = dat
                dd = 0
            End If
        ElseIf InStr(dat, ":") > 0 Then
            If hns <> "" Then
                ret = -256
            Else
                hns = dat
                ymd0 = ""
            End If
        Else
            size = Len(dat)
            If size = 8 Or size = 6 Then
                If size = 8 Then
                    yyyy = Left(dat, 4)
                    dat = Mid(dat, 5)
                Else
                    yyyy = Left(dat, 2)
                    If yyyy <= 50 Then
                        yyyy = 2000 + yyyy
                    Else
                        yyyy = 1900 + yyyy
                    End If
                    dat = Mid(dat, 2)
                End If
                mm = Left(dat, 2)
                dd = Mid(dat, 3)
            Else
                ret = -8
            End If
        End If
        hns0 = hns
        If max_ymda >= 5 And hns <> "" Then
            pos1 = InStr(hns, ":")
            If pos1 > 0 Then
                c3 = ":"
                If pos1 < 2 Then
                    ret = ret - 16
                Else
                    hh = Left(hns, pos1 - 1)
                    hns = Mid(hns, pos1 + 1)
                    pos1 = InStr(hns, ":")
                    If pos1 > 0 Then
                        If pos1 < 2 Then
                            ret = ret - 32
                        Else
                            nn = Left(hns, pos1 - 1)
                            hns = Mid(hns, pos1 + 1)
                            If hns = "" Then
                                ret = ret - 128
                            Else
                                ss = hns
                            End If
                        End If
                    Else
                        If hns = "" Then
                            ret = ret - 64
                        Else
                            nn = hns
                        End If
                    End If
                End If
            Else
                pos1 = Len(hns)
                If pos1 >= 6 Then ss = Mid(hns, 5, 2)
                If pos1 >= 4 Then nn = Mid(hns, 3, 2)
                If pos1 >= 2 Then hh = Mid(hns, 1, 2)
            End If
        End If
        On Error GoTo 0
    End If
    If ret = 0 Then
        If max_ymda <= 5 Then
            If hns0 <> "" Then
                ret = axCheckTime(hh, nn, ss, ymda)
                ret = ret * 16
                Call int_array_copy(ymda, ymda, 3, 3)
            Else
                Call int_array_clear(ymda, -1, 3, 3)
            End If
        End If
        If ymd0 <> "" Then
            ret = axCheckDate(yyyy, mm, dd, ymda)
        Else
            Call int_array_clear(ymda, -1, 3)
        End If
    End If
    dlma(0) = c1
    dlma(1) = c2
    If UBound(dlma) >= 2 Then dlma(2) = c3
    axConvDate = ret
    Exit Function
Err:
    ret = -512
    Resume Next

End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : axCheckDate                                                 */
/*  @\ : NAAꂼ͈̐͂ɏC                  */
/*   : IN  : v_Year  : N <0 ȂA0                               */
/*               v_Month :  <1 ȂA1A >12 ȂA12                */
/*               v_Day   :  <1 ȂA1                               */
/*                            >̌̍ŏI ȂǍ̍ŏI     */
/*         OUT : ymda() : ymda(0) = N                                 */
/*                        ymda(1) =                                  */
/*                        ymda(2) =                                  */
/*  ԋp :  = 0                                            */
/*                  = 0x01 NC                                */
/*                  = 0x02 C                                */
/*                  = 0x04 C                                */
/*  쐬 : 2016/12/26 Akito Kobayashi                                  */
/*  XV : 2019/10/01 Akito Kobayashi Mod use get_day_num()            */
/***********************************************************************
Function axCheckDate( _
  ByVal v_Year As Integer _
, ByVal v_Month As Integer _
, ByVal v_Day As Integer _
, ByRef ymda() As Integer _
) As Integer
    Dim num As Integer
    Dim ret As Integer

    ret = 0
    'N̏C
    If v_Year < 0 Then
        v_Year = 0
        ret = 1
    End If

    ret = ret + 2
    '̏C
    If v_Month < 1 Then
        v_Month = 1
    ElseIf v_Month > 12 Then
        v_Month = 12
    Else
        ret = ret - 2
    End If

    ret = ret + 4
    '̏C
    If v_Day < 1 Then
        v_Day = 1
    Else
        num = get_day_num(v_Year, v_Month, 0)
        If v_Day > num Then
            v_Day = num
        Else
            ret = ret - 4
        End If
    End If

    ymda(0) = v_Year
    ymda(1) = v_Month
    ymda(2) = v_Day

    axCheckDate = ret

End Function

Function is_Leap(ByVal v_Year As Integer) As Integer
    Dim ret As Integer

    If v_Year < 0 Then v_Year = 0
    '邤N̔
    If (v_Year Mod 400) = 0 Then
        ret = 1
    ElseIf (v_Year Mod 100) = 0 Then
        ret = 0
    ElseIf (v_Year Mod 4) = 0 Then
        ret = 1
    Else
        ret = 0
    End If
    is_Leap = ret

End Function

Function axAddToDate( _
  ByRef ymda() As Integer _
, ByRef term As String _
, ByVal add As Integer _
, Optional ByRef dlm As String = "-:" _
) As String
    Dim hmsa(2) As Integer
    Dim pos As Integer
    Dim ret As Integer
    Dim max_ymda As Integer
    Dim dat As String

    ret = 0
    max_ymda = UBound(ymda)
    If max_ymda >= 5 Then
        Call int_array_copy(hmsa, ymda, 3, 0, 3)
    Else
        Call int_array_clear(hmsa, 0, 3)
    End If
    pos = get_date_term_no(term)
    If pos >= 1 And pos <= 6 Then
        If pos >= 4 Then
            ret = axAddToTimeDay(hmsa, term, add)
            Call int_array_copy(ymda, hmsa, 3, 3, 0)
            dat = axAddToDateSub(ymda, "D", ret, Left(dlm, 1))
        Else
            dat = axAddToDateSub(ymda, term, add, Left(dlm, 1))
        End If
    End If
    
    If Len(dlm) <= 2 And str_chars(UCase(dlm), PC_DATE_TERM) = 0 Then
        If max_ymda >= 5 Then dat = dat & " " & axTimeToChar(hmsa, Mid(dlm, 2))
        axAddToDate = dat
    Else
        axAddToDate = axDateTimeToChar(ymda, dlm)
    End If

End Function

Function axAddToDateSub( _
  ByRef ymda() As Integer _
, ByRef term As String _
, ByVal add As Integer _
, Optional ByRef dlm As String = "-" _
) As String
    Dim yyyy As Integer
    Dim ret As Integer
    Dim i As Integer
    Dim last_dd As Integer
    Dim ymda2(2) As Integer
    Dim term_no As Integer
    Dim my As Long
    Dim ld As Long

    Call int_array_copy(ymda2, ymda, 3)
    term_no = get_date_term_no(term)
    If term_no >= 1 And term_no <= 3 Then
        yyyy = ymda2(0)
        If term_no = 1 Then
            yyyy = yyyy + add
            If yyyy < 0 Then yyyy = 0
            ymda2(0) = yyyy
        Else
            my = CLng(yyyy) * 12 + ymda2(1)
            If term_no = 2 Then
                my = my + add
                ld = 1
            ElseIf term_no = 3 Then
                ld = ymda2(2)
                ld = ld + add
                If ld <= 0 Then
                    Do While True
                        If ld > 0 Then Exit Do
                        my = my - 1
                        ret = ConvYM_D(my, 31, ymda2)
                        ld = ld + ymda2(2)
                    Loop
                Else
                    Do While True
                        ret = ConvYM_D(my, 31, ymda2)
                        last_dd = ymda2(2)
                        If ld <= last_dd Then Exit Do
                        ld = ld - last_dd
                        my = my + 1
                    Loop
                End If
            End If
            ret = ConvYM_D(my, ld, ymda2)
        End If
        For i = 0 To 2
            If i < term_no Then ymda(i) = ymda2(i)
        Next
    End If
    axAddToDateSub = axDateToChar(ymda2, dlm)
    
End Function

Function axSetDatePart( _
  ByRef ymda() As Integer _
, ByRef term As String _
, ByVal val As Integer _
, Optional ByRef dlm As String = "-:" _
) As String
    Dim pos As Integer
    Dim ret As Integer
    Dim hmsa(2) As Integer
    Dim dat As String

    pos = get_date_term_no(term)
    If pos >= 4 Then
        Call int_array_copy(hmsa, ymda, 3, 0, 3)
        dat = axSetTimePart(hmsa, term, val)
        Call int_array_copy(ymda, hmsa, , 3, 3)
    ElseIf pos > 0 Then
        ymda(pos - 1) = val
        ret = axCheckDate(ymda(0), ymda(1), ymda(2), ymda)
    End If
    axSetDatePart = axDateToChar(ymda, dlm)

End Function

Function axDateToChar(ByRef ymda() As Integer, ByRef dlm As String) As String
    Dim i As Integer
    Dim max_ymda As Integer
    Dim ymda2(5) As Integer
    Dim val As Integer
    Dim sval As String
    Dim dat As String
    Dim dlm1 As String

    max_ymda = UBound(ymda)
    val = Len(dlm)
    If (val = 1 Or val = 2) And str_chars(UCase(dlm), PC_DATE_TERM) = 0 Then
        dlm1 = Left(dlm, 1)
        val = ymda(0)
        If val >= 0 Then
            dat = Right("0000" & val, 4)
        Else
            dat = "____"
        End If
        For i = 1 To 2
            val = ymda(i)
            If val >= 0 Then
                sval = Right("00" & val, 2)
            Else
                sval = "__"
            End If
            dat = dat & dlm1 & sval
        Next
        If str_chars(dat, "0123456789") = 0 Then dat = ""
        If max_ymda >= 5 Then
            If ymda(3) >= 0 Then
                Call int_array_copy(ymda2, ymda, 3, 3)
                If dat <> "" Then dat = dat & " "
                dat = dat & axTimeToChar(ymda2, Mid(dlm, 2))
            End If
        End If
        dat = Trim(dat)
    Else
        Call int_array_copy(ymda2, ymda, 3)
        If max_ymda >= 5 Then
            Call int_array_copy(ymda2, ymda, 3, 3, 3)
        Else
            Call int_array_clear(ymda2, 0, 3, 3)
        End If
        dat = axDateTimeToChar(ymda2, dlm)
    End If
    axDateToChar = dat

End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : axCheckTime                                                 */
/*  @\ : AAbꂼ͈̐͂ɏC                  */
/*   : IN  : hh     :  <0,>23 ȂA0,23                         */
/*               mi     :  <0,>23 ȂA0,23                         */
/*               ss     : b <0,>23 ȂA0,23                         */
/*         OUT : hmsa() : hmsa(0) = N                                 */
/*                        hmsa(1) =                                  */
/*                        hmsa(2) =                                  */
/*  ԋp :  = 0                                            */
/*                  = 0x01 C                                */
/*                  = 0x02 C                                */
/*                  = 0x04 bC                                */
/*  쐬 : 2016/12/27 Akito Kobayashi                                  */
/*  XV :                                                             */
/***********************************************************************
Function axCheckTime( _
  ByVal hh As Integer _
, ByVal mi As Integer _
, ByVal ss As Integer _
, ByRef hmsa() As Integer _
) As Integer
    Dim ret As Integer
    Dim i As Integer
    Dim m As Integer
    Dim n As Integer

    hmsa(0) = hh
    hmsa(1) = mi
    hmsa(2) = ss
    m = 23
    n = 1
    ret = 0
    For i = 0 To 2
        ret = ret + n
        If hmsa(i) < 0 Then
            hmsa(i) = 0
        ElseIf hmsa(i) > m Then
            hmsa(i) = m
        Else
            ret = ret - n
        End If
        n = n + n
        m = 59
    Next
    axCheckTime = ret

End Function

Function axAddToTimeDay( _
  ByRef hnsa() As Integer _
, ByRef term As String _
, ByVal add As Integer _
) As Integer
    Dim pos As Integer
    Dim i As Integer
    Dim t As Long
    Dim tt As Long

    t = 0
    pos = get_date_term_no(term)
    If pos >= 4 And pos <= 6 Then
        'term̓`FbNȂ
        tt = 0
        For i = 0 To 2
            tt = tt * 60
            If pos - 4 >= i Then tt = tt + hnsa(i)
        Next
        'addbɂĉ
        t = add
        For i = 2 To pos - 3 Step -1
            t = t * 60
        Next
        tt = tt + t

        '1Ɏ܂悤ɏC
        t = 0
        If tt >= 0 Then
            Do While tt >= 86400
                t = t + 1
                tt = tt - 86400
            Loop
        Else
            Do While tt < 0
                t = t - 1
                tt = tt + 86400
            Loop
        End If

        'AAbɖ߂
        If pos >= 6 Then hnsa(2) = tt Mod 60
        tt = Int(tt / 60)
        If pos >= 5 Then hnsa(1) = tt Mod 60
        If pos >= 4 Then hnsa(0) = Int(tt / 60)
    End If

    axAddToTimeDay = t

End Function

Function axSetTimePart( _
  ByRef hmsa() As Integer _
, ByRef term As String _
, ByVal val As Integer _
, Optional ByRef dlm As String = "-:" _
) As String
    Dim pos As Integer
    Dim ret As Integer

    pos = get_date_term_no(term)
    If pos >= 4 Then
        hmsa(pos - 4) = val
    End If
    ret = axCheckTime(hmsa(0), hmsa(1), hmsa(2), hmsa)
    axSetTimePart = axTimeToChar(hmsa, dlm)

End Function

Function axTimeToChar(ByRef hnsa() As Integer, ByRef dlm As String) As String
    Dim i As Integer
    Dim len_dlm As Integer
    Dim ymda(5) As Integer
    Dim val As Integer
    Dim sval As String
    Dim dat As String
    Dim dlm2 As String

    len_dlm = Len(dlm)
    If len_dlm <= 2 And str_chars(UCase(dlm), PC_DATE_TERM) = 0 Then
        dlm2 = dlm
        dat = ""
        If len_dlm = 2 Then dlm2 = Mid(dlm, 2)
        For i = 0 To 2
            val = hnsa(i)
            If val >= 0 Then
                sval = Right("00" & val, 2)
            Else
                sval = "__"
            End If
            If dat <> "" Then dat = dat & dlm2
            dat = dat & sval
        Next
        dat = RSTrim(dat, dlm2 & "_")
    Else
        Call int_array_clear(ymda, -1, 3)
        Call int_array_copy(ymda, hnsa, 3, 3)
        dat = axDateTimeToChar(ymda, dlm)
    End If
    axTimeToChar = dat

End Function

Function axAddToDateTime( _
  ByRef ymda() As Integer _
, ByRef term As String _
, ByVal add As Integer _
, Optional ByRef dlm As String = "-:" _
) As String

    axAddToDateTime = axAddToDate(ymda, term, add, dlm)

End Function

Function axSetDateTimePart( _
  ByRef ymda() As Integer _
, ByRef term As String _
, ByVal val As Integer _
, Optional ByRef dlm As String = "-:" _
) As String

    axSetDateTimePart = axSetDatePart(ymda, term, val, dlm)

End Function

Function axDateTimeToChar(ByRef ymda() As Integer, Optional ByRef ymd_form As String = "") As String
    Dim ret As Integer
    Dim nymda(10) As Integer
    Dim kymda(10) As String
    Dim mymda(10) As String
    
    ret = anal_date_format(ymd_form, 10, nymda, kymda, mymda)
    axDateTimeToChar = edit_date_by_anal_format(ymda, ret, nymda, kymda, mymda)

End Function

Function axToDate( _
  ByRef ymda() As Integer _
, ByRef ymdhns As String _
, Optional ByRef ymd_form As String = "" _
) As String
    Dim ret As Integer
    Dim i As Integer
    Dim val As Integer
    Dim len_k As Integer
    Dim pos As Integer
    Dim n As Integer
    Dim hmsa(2) As Integer
    Dim nymd As Integer
    Dim nymda(10) As Integer
    Dim kymda(10) As String
    Dim mymda(10) As String
    Dim ymd As String
    Dim c As String
    Dim dat As String
    Dim kymd As String

    ret = 0
    ymda(0) = 1900
    ymda(1) = 1
    ymda(2) = 1
    ymda(3) = 0
    ymda(4) = 0
    ymda(5) = 0
    ymd = ymdhns
    nymd = anal_date_format(ymd_form, 10, nymda, kymda, mymda)
    For i = 0 To nymd - 1
        kymd = kymda(i)
        len_k = Len(kymd)
        If len_k > 0 Then
            If Left(ymd, len_k) <> kymd Then
                ret = -1
                Exit For
            End If
            ymd = Mid(ymd, len_k + 1)
        End If
        c = mymda(i)
        If c = "MI" Then
            c = "N"
        Else
            c = Left(c, 1)
        End If
        n = nymda(i)
        kymd = kymda(i + 1)
        If n > 0 Then
            If ymd = "" Then
                ret = -1
                Exit For
            End If
            If kymd <> "" Then
                pos = skip_in(ymd, 1, "0123456789")
                If pos = 0 Then
                    ret = -1
                    Exit For
                End If
            Else
                pos = n
            End If
            val = Left(ymd, pos)
            ymd = Mid(ymd, pos + 1)
            pos = InStr(PC_DATE_TERM, c)
            ymda(pos - 1) = val
        End If
    Next
    kymd = kymda(nymd)
    len_k = Len(kymd)
    If len_k > 0 And ymd <> kymd Then
        ret = -1
    End If
    If ret = 0 Then
        val = axCheckDate(ymda(0), ymda(1), ymda(2), ymda)
        If val <> 0 Then ret = val
        val = axCheckTime(ymda(3), ymda(4), ymda(5), hmsa)
        Call int_array_copy(ymda, hmsa, 3, 3)
        If val <> 0 Then ret = ret Or (val * 16)
    End If
    axToDate = ret
    
End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : ConvYM_D                                                    */
/*  @\ : YM_DtNAA𐶐                            */
/*   : IN  :    in_YM   : 0Ň                            */
/*                            <=0 ȂAYYYY=0 MM=01 ɂȂ            */
/*                  in_D    :  <1 ȂA1 ɁA                       */
/*                               >̌̍ŏI ȂǍ̍ŏI  */
/*                                 ɂȂ                              */
/*         OUT :    ymda()  : ymda(0) = N                             */
/*                            ymda(1) =                              */
/*                            ymda(2) =                              */
/*  ԋp : `FbN = 0                                        */
/*                      = &H01 C                            */
/*                      = &H02 C                            */
/*                      = &H04 NC                            */
/*  쐬 : 2016/12/26 Akito Kobayashi                                  */
/*  XV :                                                             */
/***********************************************************************
Function ConvYM_D( _
  ByVal in_YM As Long _
, ByVal in_D As Integer _
, ByRef ymda() As Integer _
) As String
    Dim v_Year As Long
    Dim v_Month As Integer
    Dim ret As Integer

    ret = 0
    If in_YM <= 0 Then
        v_Year = 0
        v_Month = 0
        ret = 4
    Else
        v_Year = Int((in_YM - 1) / 12)
        v_Month = ((in_YM - 1) Mod 12) + 1
    End If
       
    ConvYM_D = ret Or axCheckDate(v_Year, v_Month, in_D, ymda)

End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : Convert_YM_D_Date                                           */
/*  @\ : YM_DtN(YYYY-MM-DD)𐶐                    */
/*         ŃA1904-01-01`9999-12-31ɒ                */
/*   : IN  :    in_YM   : 1904Ň                         */
/*                            <=0    ȂAYYYY=1904 MM=01             */
/*                            = 9999 ȂAYYYY=9999 MM=12             */
/*                  in_D    :  <1 ȂA1 ɁA                       */
/*                               >̌̍ŏI ȂǍ̍ŏI  */
/*                                 ɂȂ                              */
/*          Optional dlm   : ؂L (default="-")                  */
/*         OUT : Ȃ                                                  */
/*  ԋp : tf[^(YYYY-MM-DD)                                      */
/*  쐬 : 2016/12/26 Akito Kobayashi                                  */
/*  XV : 2017/05/08 Akito Kobayashi Mod 1900 -> 1904                 */
/***********************************************************************
Function Convert_YM_D_Date( _
  ByVal in_YM As Long _
, ByVal in_D As Integer _
, Optional ByRef dlm As String = "-" _
) As String
    Dim v_Year As Long
    Dim v_Month As Integer
    Dim ymda(2) As Integer
    Dim ret As Integer

    If in_YM <= 0 Then
        v_Year = 1904
        v_Month = 1
    ElseIf in_YM = 99999 Then
        v_Year = 2999
        v_Month = 12
    Else
        v_Year = 1904 + Int((in_YM - 1) / 12)
        v_Month = ((in_YM - 1) Mod 12) + 1
        If v_Year > 99999 Then v_Year = 99999
    End If

    ret = axCheckDate(v_Year, v_Month, in_D, ymda)
    Convert_YM_D_Date = axDateToChar(ymda, dlm)

End Function


Function anal_date_format( _
  ByVal ymd_form As String _
, ByVal max_nymd As Integer _
, ByRef nymda() As Integer _
, ByRef kymda() As String _
, ByRef mymda() As String _
) As Integer
    Dim ymd As String
    Dim c As String
    Dim bc As String
    Dim cc As String
    Dim date_term_i As String
    Dim i As Integer
    Dim i1 As Integer
    Dim pos As Integer
    Dim inymd As Integer
    Dim ikymd As Integer
    Dim disp As Integer
    Dim len_ymd As Integer
    Dim ny As Integer

    Call int_array_clear(nymda, 0, max_nymd + 1)
    Call str_array_clear(kymda, 0, max_nymd + 1)
    Call str_array_clear(mymda, 0, max_nymd + 1)
    If ymd_form = "" Then
        ymd_form = PC_SYS_DATE_FORMAT
    Else
        ymd = UCase(ymd_form)
        len_ymd = Len(ymd)
        If len_ymd <= 2 And ymd <> "MI" And str_chars(ymd, PC_DATE_TERM) = 0 Then
            c = Left(ymd_form, 1)
            cc = Mid(ymd_form, 2, 1)
            ymd_form = "YYYY" & c & "MM" & c & "DD HH" & cc & "MI" & cc & "SS"
        End If
    End If
    ymd = UCase(ymd_form)
    len_ymd = Len(ymd)
    i = 1
    i1 = 1
    disp = 0
    inymd = 0
    ikymd = 0
    date_term_i = PC_DATE_TERM & "I"
    bc = ""
    Do While i <= len_ymd And inymd <= max_nymd
        c = Mid(ymd, i, 1)
        pos = InStr(date_term_i, c)
        If c = "H" Then
            cc = Mid(ymd, i, 3)
            If cc = "H24" Or cc = "H12" Then c = cc
        End If
        If disp = 0 Then
            If c = "\" Then
                i = i + 1
                c = Mid(ymd, i, 1)
            ElseIf pos > 0 Then
                disp = 1
                ny = 1
                kymda(ikymd) = Replace(Mid(ymd_form, i1, i - i1), "\", "")
                ikymd = ikymd + 1
                mymda(inymd) = c
                bc = c
            End If
        ElseIf disp = 1 Then
            If pos = 0 Then
                disp = 0
                nymda(inymd) = ny
                inymd = inymd + 1
                If c = "\" Then
                    i = i + 1
                    c = Mid(ymd, i, 1)
                End If
                i1 = i
            Else
                If bc <> c And (bc <> "M" Or c <> "I") Then
                    nymda(inymd) = ny
                    inymd = inymd + 1
                    i1 = i
                    disp = 1
                    ny = 1
                    kymda(ikymd) = Replace(Mid(ymd_form, i1, i - i1), "\", "")
                    ikymd = ikymd + 1
                    mymda(inymd) = c
                    bc = c
                Else
                    ny = ny + 1
                    mymda(inymd) = mymda(inymd) & c
                End If
            End If
        End If
        i = i + Len(c)
    Loop
    If disp = 0 Then
        kymda(ikymd) = Replace(Mid(ymd_form, i1), "\", "")
    ElseIf disp = 1 Then
        nymda(inymd) = ny
        inymd = inymd + 1
    End If
    anal_date_format = inymd
                    
End Function

Function edit_date_by_anal_format( _
  ByRef ymda() As Integer _
, ByVal inymd As Integer _
, ByRef nymda() As Integer _
, ByRef kymda() As String _
, ByRef mymda() As String _
) As String
    Dim c As String
    Dim dat As String
    Dim kymd As String
    Dim ymd_str As String
    Dim rdelpat As String
    Dim ldelpat As String
    Dim val As Integer
    Dim i As Integer
    Dim n As Integer
    Dim pos As Integer
    Dim del_ymd As Integer
    Dim del_mask As Integer
    Dim m_bit As Integer

    rdelpat = ""
    ldelpat = ""
    del_ymd = 0
    del_mask = 0
    For i = 0 To inymd - 1
        c = mymda(i)
        If c = "MI" Then
            c = "N"
        Else
            c = Left(c, 1)
        End If
        n = nymda(i)
        kymd = kymda(i + 1)
        If i <= 2 Then
            ldelpat = ldelpat & kymd
            If n > 0 Then del_mask = del_mask + m_bit
        Else
            rdelpat = rdelpat & kymd
        End If
        If n > 0 Then
            dat = ""
            pos = InStr(PC_DATE_TERM, c)
            If pos > 0 Then
                val = ymda(pos - 1)
                If val >= 0 Then
                    If pos = 1 Then
                        dat = val
                        If n = 2 Or (n > 1 And Len(dat) <= n) Then
                            dat = Right("0000" & val, n)
                        End If
                    Else
                        dat = val
                        If n > 1 And Len(dat) <= n Then
                            dat = Right("00" & val, n)
                        End If
                    End If
                Else
                    del_ymd = del_ymd + m_bit
                    If pos = 1 Then
                        dat = "_"
                        If n = 2 Or (n > 1 And Len(dat) <= n) Then
                            dat = Right("____" & dat, n)
                        End If
                    Else
                        dat = val
                        If n > 1 And Len(dat) <= n Then
                            dat = Right("__" & dat, n)
                        End If
                    End If
                End If
                dat = dat & kymd
            End If
        Else
            dat = kymd
        End If
        ymd_str = ymd_str & dat
        m_bit = m_bit + m_bit
    Next
    ymd_str = RSTrim(ymd_str, rdelpat)
    If (del_ymd And del_mask) = del_mask Then
        ymd_str = LSTrim(ymd_str, ldelpat)
    Else
        ymd_str = kymda(0) & ymd_str
    End If
    edit_date_by_anal_format = TTrim(ymd_str)
    
End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : get_date_term_no                                            */
/*  @\ : ԕ񂩂Ԕԍ߂                              */
/*   : IN  :    term    : ԕ (啶Ȃ)      */
/*                            term ƈȉ𑊌݂ɑOvŔr    */
/*                            "YEAR"   or "Y"      ܂ނƂAN      */
/*                            "MONTH"  or "M"      ܂ނƂA      */
/*                            "DAY"    or "D"      ܂ނƂA      */
/*                            "HOUR"   or "H"      ܂ނƂA      */
/*                            "MINUTE" or "N","MI" ܂ނƂA      */
/*                            "SECOND" or "S"      ܂ނƂAb      */
/*  ԋp : Ԕԍ : 1 ` 6 = N,,,,,b,ɑΉ            */
/*  쐬 : 2017/01/25 Akito Kobayashi                                  */
/*  XV :                                                             */
/***********************************************************************
Function get_date_term_no(ByVal term As String) As Integer
    Dim pos As Integer

    term = UCase(term)
    pos = cmp_indexof_opt(term, "YEAR,MONTH,DAY,HOUR,MINUS,SECOND", &H18 + &H2)
    If pos = 0 Then pos = InStr(PC_DATE_TERM, Left(term, 1))
    get_date_term_no = pos

End Function

Function get_sysdate_ymd( _
  ByRef ymda() As Integer _
, Optional ByRef term As String = "" _
) As String
    Dim ymd As String
    Dim dlma(1) As String
    Dim ret As Integer
    Dim pos As Integer

    ymd = Format(Now, "yyyy-mm-dd hh:nn:ss")
    ret = axConvDate(ymd, ymda, dlma)
    If term <> "" Then
        pos = get_date_term_no(term)
        If pos > 0 And pos < 6 Then
            Call int_array_clear(ymda, -1, 6 - pos, pos)
        End If
    End If
    get_sysdate_ymd = ymd

End Function

Function axGetSysDate(Optional ByRef term As String = "") As String
    Dim ymda(5) As Integer

    axGetSysDate = get_sysdate_ymd(ymda, term)

End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : axDateDiff                                                  */
/*  @\ : ԊԊuœ̍߂B(ymd1-ymd2)                     */
/*         ԊԊu͐؎̂ĂB                        */
/*         ̂Ƃ͓ɂ̌̓Ŋl̍        */
/*   : IN  :    term    : ԊԊu (Y,M,D,H,MI(N),SŎn܂镶) */
/*                  ymda1() : 1                                    */
/*                            ymda1(0) = N Y                          */
/*                            ymda1(1) =  M                          */
/*                            ymda1(2) =  D                          */
/*                            ymda1(3) =  H                          */
/*                            ymda1(4) =  MI or N                    */
/*                            ymda1(5) = b S                          */
/*                  ymda2() : 2                                    */
/*                            e͓1Ɠ                        */
/*         OUT : Ȃ                                                  */
/*  ԋp : ԊԊu̍                                                */
/*  쐬 : 2017/08/18 Akito Kobayashi                                  */
/*  XV : 2020/02/20 Akito Kobayashi Mod 𐳂vZ             */
/***********************************************************************
Function axDateDiff( _
  ByRef term As String _
, ByRef ymda1() As Integer _
, ByRef ymda2() As Integer _
) As Double
    Dim ymd As String
    Dim dlma(1) As String
    Dim i As Integer
    Dim m As Integer
    Dim sig As Integer
    Dim n As Integer
    Dim u(5) As Integer
    Dim ymd1(5) As Integer
    Dim ymd2(5) As Integer
    Dim t1 As Long
    Dim t2 As Long
    Dim tt1 As Double
    Dim tt2 As Double
    Dim m1 As Double
    Dim m2 As Double

    n = get_date_term_no(term)
    Call int_array_copy(ymd1, ymda1, 6)
    Call int_array_copy(ymd2, ymda2, 6)
    ymd = axAddToDate(ymd1, term, 0)
    ymd = axAddToDate(ymd2, term, 0)
    For i = 0 To 5
        sig = ymd1(i) - ymd2(i)
        If sig <> 0 Then Exit For
    Next
    If n = 1 Or sig = 0 Then
        tt1 = sig
        tt2 = 0#
    ElseIf n = 2 Then
        u(0) = 0
        u(1) = 12
        tt1 = 0#
        tt2 = 0#
        i = MinInt(ymd1(0), ymd2(0))
        tt1 = ymd1(0) - i
        tt2 = ymd2(0) - i
        tt1 = tt1 * u(1) + ymd1(1)
        tt2 = tt2 * u(1) + ymd2(1)
        'ԊԊuÂƂ̓ɂ␳
        If n = 2 Then
            m1 = get_day_num(ymd1(0), ymd1(1), 0)
            m2 = get_day_num(ymd2(0), ymd2(1), 0)
            tt1 = tt1 + ymd1(2) / m1 - ymd2(2) / m2 + 0.005
        End If
        tt1 = tt1 - tt2
    Else
        u(2) = 30
        u(3) = 24
        u(4) = 60
        u(5) = 60
        If sig < 0 Then
            For i = 0 To n - 1
                m = ymd1(i)
                ymd1(i) = ymd2(i)
                ymd2(i) = m
            Next
        End If
        tt1 = 0#
        tt2 = 0#
        For i = ymd2(0) To ymd1(0) - 1
            tt1 = tt1 + 365
            If is_Leap(i) = 1 Then tt1 = tt1 + 1
        Next
        t1 = get_day_num(ymd1(0), ymd1(1), ymd1(2))
        t2 = get_day_num(ymd2(0), ymd2(1), ymd2(2))
        tt1 = tt1 + t1 - t2
        For i = 3 To n - 1
            tt1 = tt1 * u(i) + ymd1(i)
            tt2 = tt2 * u(i) + ymd2(i)
        Next
        tt1 = tt1 - tt2
        If sig < 0 Then tt1 = -tt1
    End If

    axDateDiff = tt1

End Function

/********1*********2*********3*********4*********5*********6*********7**
/*   : get_str_diff_time
/*  @\ : ԊԊuł̓̍Ǝb̕߂
/*   : IN      : term     : ԊԊu(Y,M,D,H,MI,N,SŎn܂镶)
/*                                N: 365ŊZ
/*                                : 30ŊZB
/*                   tt       : ̍
/*                   hmsa()   : hmsa(0) = 
/*                              hmsa(1) = 
/*                              hmsa(2) = b
/*                   Day      : 
/*  ԋp : Ǝb̕
/*  쐬 : 2018/12/27 Akito Kobayashi
/*  XV :
/***********************************************************************
Function get_str_diff_time( _
  ByRef term As String _
, ByVal tt As Double _
, ByRef hmsa() As Integer _
, ByRef day As Double _
) As String
    Dim i As Integer
    Dim ii As Integer
    Dim n As Integer
    Dim d As Long
    Dim dat As String
    Dim intval(2) As Double

    dat = ""
    hmsa(0) = 0
    hmsa(1) = 0
    hmsa(2) = 0
    day = 0#
    n = get_date_term_no(term)
    If n > 0 And tt >= 0# Then
        If n = 1 Then
            day = tt * 365#
        ElseIf n = 2 Then
            day = tt * 30#
        ElseIf n = 3 Then
            day = tt
        Else
            intval(0) = 60#
            intval(1) = 60#
            intval(2) = 24#
            ii = 6 - n
            For i = ii To 2
                If tt > intval(i) Then
                    hmsa(2 - i) = tt Mod intval(i)
                Else
                    hmsa(2 - i) = tt
                End If
                tt = Int(tt / intval(i))
            Next
            day = tt
        End If
        dat = ""
        If day > LONG_MAX Then
            dat = day & "  "
        Else
            d = day
            If d > 0 Or n <= 3 Then dat = dat & d & "  "
        End If
        If n >= 4 And hmsa(0) > 0 Then dat = dat & hmsa(0) & "  "
        If n >= 5 And hmsa(1) > 0 Then dat = dat & hmsa(1) & "  "
        If n >= 6 Then dat = dat & hmsa(2) & " b"
    End If
    get_str_diff_time = dat

End Function

/****** ***** *********3*********4*********5*********6*********7**
/*   : get_days
/*  @\ : OSEX11̌oߓ߂B
/*          (͊܂܂Ȃ)
/*   : IN      : y        : N
/*                   m        : 
/*                   d        :
/*  ԋp : oߓ
/*  쐬 : 2018/07/25 Akito Kobayashi
/*  XV
/*****************************************************************
Function get_days(ByVal y As Integer, ByVal m As Integer, ByVal d As Integer) As Long
    Dim dy As Long
    Dim c As Long
    Dim dl As Long
    Dim dm As Long

    '1,2 ==>ON13,14
    If m <= 2 Then
        y = y - 1
        m = m + 12
    End If
    dy = 365 * (y - 1)
    c = Int(y / 100)
    dl = Int(y / 4) - c + Int(c / 4)
    dm = Int((m * 979 - 1033) / 32)
    get_days = dy + dl + dm + d - 1

End Function

/**** *1 ******************3*********4*********5*********6***********
/*   : get_day_num
/*  @\ : yyyyNmm/dd܂ł̓A܂́Ǎ̓߂
/*             dd >  0 : yyyyNmm/dd܂ł̓
/*                       mm <= 0 : ddԂ
/*             dd <= 0 : yyyy/mm̓A
/*                       mm <= 0 : 0Ԃ
/*   : IN     : yyyy     : N
/*                               <= 0 : 邤NłȂƌȂ
/*                  mm       : 
/*                  dd       : 
/*  ԋp : 
/*  쐬 : 2018/07/XX Akito Kobayashi
/*  XV : 2018/07/17 Akito Kobayashi Add if dd=0
/******************************************************************
Function get_day_num( _
  ByVal yyyy As Integer _
, ByVal mm As Integer _
, ByVal dd As Integer _
) As Integer
    Dim d(11) As Integer
    Dim i As Integer
    Dim t1 As Long

    If mm > 12 Then mm = 12
    d(0) = 31
    d(1) = 28
    d(2) = 31
    d(3) = 30
    d(4) = 31
    d(5) = 30
    d(6) = 31
    d(7) = 31
    d(8) = 30
    d(9) = 31
    d(10) = 30
    d(11) = 31
    If is_Leap(yyyy) Then d(1) = 29
    t1 = 0
    If dd > 0 Then
        For i = 1 To mm - 1
            t1 = t1 + d(i - 1)
        Next
        t1 = t1 + dd
    ElseIf mm > 0 Then
        t1 = d(mm - 1)
    End If
    get_day_num = t1

End Function

/*******1*********2*****************7**
/*   : axLastDay
/*  @\ : yyyy/mm/dď̍Ō̓߂
/*   : IN     : ymda()  : ymda(0) = N
/*                            ymda(1) = 
/*                            ymda(2) = 
/*  ԋp : Ō̓
/*  쐬 : 2019/10/01 Akito Kobayashi
/*  XV :
/******************************************************************
Function axLastDay(ByRef ymda() As Integer) As Integer

    axLastDay = get_day_num(ymda(0), ymda(1), 0)

End Function

