.\" cover.ms
.\"
.\" Template for formatting document front-matter, based on "ms" macros,
.\" to be used in conjunction with the "pdfroff" program.
.\"
.\"
.\" $Id$
.\"
.\" This file is part of the groff-pdfmark extension to groff, the GNU
.\" roff type-setting system.
.\"
.\" Written by Keith Marshall <keith.d.marshall@ntlworld.com>
.\" Copyright (C) 2004-2023, Free Software Foundation, Inc.
.\"
.\" Copying and distribution of this file, with or without modification,
.\" is permitted, in any medium, without royalty, provided the copyright
.\" notice, and this notice are preserved.
.\"
.de pub@licensing
.\" Specify the document licensing terms, as they are to be stipulated on
.\" the copyright assignment page, within the document front-matter.
.\"
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3,
(or any later version published by the Free Software Foundation),
with the Front-Cover Texts being \(lq\s'-2.3z'A GNU MANUAL\s'+2.3z'\(rq,
with no Invariant Sections, and no Back-Cover Texts.
..
.de CS
.\" Usage: .CS
.\"
.\" Set up the formatter state, in preparation for output of the document
.\" cover sheet, and additional front-matter which is to be placed before
.\" the document's table of contents.
.\"
.   if !r CO .nr CO 0
.   if !r TL .nr TL 0
.   nr HM 0
.   nr PO (2.1c+\\n[CO]u)
.   nr LL 17.1c
.   nr HY 0
.   nop \&
.   nr PS 24
.   nr VS 30
.   CD
.   fam T
.   sp |(5.9c+\\n[TL]u)
.   als AU au@first
..
.de au@first
.\" Usage: .AU author name
.\"
.\" First-time handler for AU macro calls; sets the vertical space
.\" between the title block, on the cover sheet, and first of one,
.\" or more, author identification blocks, before reassignment and
.\" delegation of completion to the future call handler.
.\"
.   sp 1.5v
.   als AU au@next
.   nr au@count 0 1
.   AU \\$@
..
.de au@next
.\" Usage: .AU author name
.\"
.\" Universal handler for AU macro calls; entered indirectly, via
.\" the preceding au@first handler, when called for the first time,
.\" and directly on any subsequent call, to perform actual output
.\" of individual author identifications on the cover sheet.
.\"
.   DE
.   nr PS 18
.   nr VS 18
.   CD
.   sp 0.5v
.   nop \\$*
.   if \\n+[au@count]>2 .as au@list ", \\*[au@pending]\"
.   ds au@pending "\\$1\"
.   while \\n(.$>1 \{\
.      shift
.      as au@pending "\~\\$1\"
.   \}
.   if !d au@list .rn au@pending au@list
..
.de AI
.\" Usage: .AI institution name
.\"
.\" Rudimentary handler for optional specification of an institution
.\" identifier, following an author name on the cover sheet.
.\"
.   nop \H'-4z'\\$*\H'0'
..
.de CE
.\" Usage: .CE
.\"
.\" Terminate collection of front-matter setup data, from the document
.\" input stream, and write out the resultant formatted front-matter to
.\" the document output stream.
.\"
.   DE
.   sp |17.5c
.   PSPIC gnu.eps
.   nr PS 19
.   CD
.   fam H
.   tkf HR 10z 2p 20z 4p
.   nop \H'-4z'A GNU MANUAL\H'0'
.   DE
.   nr PS 10p
.   nr VS 12p
.   fam
.   bp 1
.   rs
.   pub@enum \\*[pub@series]
.   pub@rights
.   sp |22.0c
.   po +1c
.   ll -2c
.   pub@licensing
.   sp 0.5v
.   nop A copy of the license is included in \\*[FDL-SECTION]
.   nop entitled \(lq\\*[FDL-SECTION-TITLE]\(rq.
..
.de PUB de
.\" Usage: .PUB year ...
.\"
.\" Compile a list of years in which the document has been published,
.\" or revised; years should be enumerated in chronological order, and
.\" any individual year may be repeated, once per revision, to indicate
.\" multiple revisions within the same year.
.\"
.\" Macro may be called more than once, concatenating the sequence of
.\" years from each successive call, into a single list; the first call
.\" is handled directly, with subsequent calls being delegated to...
.\"
.   if \\n(.$ \{\
.      ds pub@series "\\$*\"
.      als PUB pub@collect
.   \}
.de pub@collect ds
.\" ...this replacement handler, for second and subsequent calls.
.\"
.   if \\n(.$ .as pub@series " \\$*\"
.ds pub@series
.
.de pub@post
.\" Usage (internal): .pub@post divname [keep]
.\"
.\" Post the content of the named division, as centred lines of text,
.\" to the document output stream; if the optional "keep" argument is
.\" not specified, as the exact word "keep", the division is deleted
.\" after output.
.\"
.   if '\\n(.z'\\$1' \{\
.   \" Still collecting content into the named diversion; terminate
.   \" it prior to output.
.   \"
.      br
.      di
.   \}
.   CD
.   \" Revert formatting of each collected line of text, within the
.   \" named diversion, centre them on output...
.   \"
.      unformat \\$1
.      \\$1
.
.   \" ...and clean up.
.   \"
.      if !'\\$2'keep' .rm \\$1
.   DE
..
.de pub@enum
.\" Usage (internal): .pub@enum \*[pub@series]
.\"
.\" Format the list of years of publication, as compiled by user calls
.\" to the PUB macro, for printing on the copyright assignment page of
.\" the document front-matter.
.\"
.   if \\n(.$ \{\
.      ds pub@last "\\$1\"
.      ds pub@copyright "Copyright \(co \\$1\"
.      shift
.      CD
.      ie \\n(.$ .pub@revised \\$*
.      el .pub@initial
.      nop \\*[pub@copyright], Free\~Software\~Foundation,\~Inc.
.      DE
.   \}
.   rm pub@copyright pub@revlist pub@last
.   ds pub@series
..
.de pub@initial
.\" Usage (internal): .pub@initial
.\"
.\" Internal handler, to which pub@enum delegates formatting when the
.\" \*[pub@series] argument specifies only one publication entry.
.\"
.   sp |7c
.   nop Published \\*[pub@last]
..
.de pub@revised
.\" Usage (internal): .pub@revised \*[pub@series]
.\"
.\" Alternative internal handler, to which pub@enum delegates formatting
.\" when the \*[pub@series] argument, after removal of its initial entry,
.\" specifies one or more additional revision entries.
.\"
.   sp |5c
.   nr pub@revcount 0
.   nop First published \\*[pub@last]
.   if !'\\$1'\\*[pub@last]' \{\
.   \" On entry, the collected copyright notice already includes
.   \" the year of first publication; append the year of the first
.   \" revision, only if it is different.
.   \"
.      as pub@copyright ", \\$1\"
.      ds pub@last \\$1
.   \}
.   ds pub@revlist "Revised \\$1\"
.   while \\n(.$ \{\
.   \" For each specified revision, count repetitions of any year...
.   \"
.      ie '\\$1'\\*[pub@last]' .nr pub@revcount +1
.      el \{\
.      \" ...while recording each change year, in both the revision
.      \" list, and copyright notice, and also resetting the counter
.      \" for accumulation of the revision count for another year.
.      \"
.         as pub@copyright ", \\$1\"
.         ie \\n[pub@revcount]>2 .as pub@revlist "\~(\\n[pub@revcount]\~times)\"
.         el .if \\n[pub@revcount]>1 .as pub@revlist "\~(twice)\"
.         as pub@revlist ", \\$1\"
.         nr pub@revcount 1
.         ds pub@last \\$1
.      \}
.      shift
.   \}
.   nop \\*[pub@revlist]
.   sp 1.5v
.   nop This edition published \\*[pub@last]
.   rr pub@revcount
..
.de ASSERT-RIGHTS
.\" Usage: .ASSERT-RIGHTS [his | her] [UK]
.\"
.\" Request inclusion of a rights assertion clause, on the
.\" copyright assignment page; the optional his/her requests
.\" use of the appropriate gender-specific pronoun, (replaced
.\" by "their" for multiple authors), in place of the neutral
.\" alternative, "the", while the optional UK argument causes
.\" the assertion to include a specific reference to the UK
.\" Copyright, Designs and Patents Act, 1988.
.\"
.   ds \\$0@his his
.   ds \\$0@her her
.   while \\n(.$ \{\
.      ie '\\$1'UK' .als au@asserted au@uk-asserted
.      el .if d \\$0@\\$1 .ds au@pronoun "\\*[\\$0@\\$1]\"
.      shift
.   \}
.   als pub@rights au@assert-rights
.   af au@count 1
..
.de pub@rights de
.de au@assert-rights
.\" Usage (internal): .pub@rights
.\"
.\" Does NOTHING by default, UNLESS armed by a prior call of
.\" ASSERT-RIGHTS, and preceded by at least one AU assignment
.\" call, in which case inserts a rights assertion clause, as
.\" required by the UK Copyright, Designs and Patents Act of
.\" 1988, on the copyright assignment page of the document
.\" front-matter.
.\"
.   if \\n[au@count] \{\
.      sp 2v
.      ll -4.425c
.      di pub@preformat.content
.      nop \\*[au@list]
.      ds au@plural \E$1
.      ie \\n[au@count]>1 \{\
.            nop and \\*[au@pending] have
.            if d au@pronoun .ds au@pronoun "their\"
.            ds au@plural \E$1s
.         \}
.      el has
.      if !d au@pronoun .ds au@pronoun "the\"
.      nop asserted \\*[au@pronoun] moral \\*[au@plural right] to be
.      nop identified as the \\*[au@plural author] of this
.      au@asserted work .
.      pub@post pub@preformat.content
.   \}
..
.de au@asserted
.\" Usage (internal): .au@asserted entity punctuation
.\"
.\" Complete the default form of the assertion, WITHOUT the
.\" UK Copyright, Designs and Patents Act reference; nominally
.\" the entity is specified as "work", and the punctuation to
.\" be appended is a period.
.\"
.   nop \\$1\\$2
..
.de au@uk-asserted
.\" Usage (internal): .au@asserted entity punctuation
.\"
.\" Complete the alternative form of the assertion, WITH the
.\" UK Copyright, Designs and Patents Act reference; replaces
.\" the default form of the call, when activated by the "UK"
.\" argument to ASSERT-RIGHTS; the additional reference is
.\" inserted between the entity and punctuation arguments.
.\"
.   nop \\$1, in accordance with the UK Copyright,
.   nop Designs and Patents Act, 1988\\$2
..
.de FDL-REFERENCE
.\" Usage: .FDL-REFERENCE ["section name" ["text for section title"]]
.\"
.\" Specify section name, (e.g. "Appendix A"), and the text which is to
.\" be used as the title for this section, when placing a reference to a
.\" copy of the document licence on the copyright assignment page.
.\"
.   if \\n(.$>1 .ds FDL-SECTION-TITLE "\\$2\"
.   if \\n(.$>0 .ds FDL-SECTION "\\$1\"
..
.\" Specify defaults for the above licence reference properties.
.\"
.FDL-REFERENCE "the section" "GNU Free Documentation License"
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: filetype=groff
.\"
.\" $RCSfile$: end of file
