/*		mpa.c		Multiple-Precision Arithmetic	*/
/*
	cc -g -DLINUX -I../include testmpa.c libakx.a -o testmpa
*/
#include	"akxcommon.h"

int main(int argc, char *argv[])
{
	MPA v, w, x, y, z, zz, x3;
	int k,len,precision,scale,ret;
	int i = 0;
	time_t now;
	double d;
	long lv;
	char buf[60],*file,line[128],n,*pv[10],parm[128],wnum[NMPA2];
	FILE *fp;
	MPA10W w10;
#if 0
	if (argc > 1) file = argv[1];
	else file = "testmpa.txt";
	if (!(fp=fopen(file,"r"))) {
		printf("file[%s] open error!\n",file); 
		exit(1);
	}
	while ((len=akxa_read_line(line,sizeof(line),fp)) > 0) {
		n = akxtgetargv2(line,pv,3,parm,sizeof(parm),5);
		if (n <= 0) break;
		printf("\n*** pv[0]=%s\n",pv[0]);
		m_set_a(&x,pv[0]);	m_print("x = ", &x, 1);
	/*
		m_mpa2l(&x,&lv);	printf("lv = %ld\n", lv);
		m_l2mpa(lv,&z);	m_print("z = ", &z, 1);
		m_mpa2d(&x,&d);	printf("d = %f\n", d);
		m_d2mpa(d,&z);	m_print("z = ", &z, 1);
	*/

		if (n == 2) {
			printf("*** pv[1]=%s\n",pv[1]);
			m_set_a(&y,pv[1]);	m_print("y = ", &y, 1);
		/*
			m_add(&z, &x, &y);	m_print("z = x + y", &z, 1);
			m_sub(&z, &x, &y);	m_print("z = x - y", &z, 1);
			m_mul(&z, &x, &y);	m_print("z = x * y", &z, 1);
			m_div(&z, &x, &y);	m_print("z = x / y", &z, 1);
		*/
			z = x;
			m_add1(&z, &y);	m_print("z = z + y", &z, 1);
			z = x;
			m_sub1(&z, &y);	m_print("z = z - y", &z, 1);
			z = x;
			m_mul1(&z, &y);	m_print("z = z * y", &z, 1);
			z = x;
			m_div1(&z, &y);	m_print("z = z / y", &z, 1);
		}

	/*
		if (n == 3) {
			precision = atoi(pv[1]);
			scale = atoi(pv[2]);
			printf("*** (%d,%d)\n",precision,scale);
		
			z = x;
			m_scale(&x,precision,scale,0);	m_print("x,0 = ", &x, 1);
			x = z;
			m_scale(&x,precision,scale,1);	m_print("x,1 = ", &x, 1);
			x = z;
			m_scale(&x,precision,scale,2);	m_print("x,2 = ", &x, 1);
		
			x = z;
			ret = m_pack(wnum,precision,scale,0,&x);
			akxaxdump("pack opt=0",wnum,ret+2);
			m_pack2str(buf,sizeof(buf),wnum,precision,scale);
			printf("buf=%s\n",buf);
			ret = m_unpack(&z,wnum,precision,scale);
			printf("m_unpack: ret=%d\n",ret);	m_print("z = ", &z, 1);

			ret = m_pack(wnum,precision,scale,1,&x);
			akxaxdump("pack opt=1",wnum,ret+2);
			ret = m_pack(wnum,precision,scale,2,&x);
			akxaxdump("pack opt=2",wnum,ret+2);
		}
	*/
	}
#endif
	printf("m_an_to_mpa10_opt()  0.0805 --> w10\n");
	m_an_to_mpa10_opt(&w10, "0.0805", 6, 0);
	m10w_print("0.0805", &w10, 0);
	m_10to100(&v,&w10);		m_print("v = ", &v, 1);

	printf("m_an_to_mpa10_opt()  1.0 --> w10\n");
	m_an_to_mpa10_opt(&w10, "1.0", 3, 0);
	m10w_print("1.0", &w10, 0);
	m_10to100(&v,&w10);		m_print("v = ", &v, 1);

	printf("m_an_to_mpa10_opt()  0.1 --> w10\n");
	m_an_to_mpa10_opt(&w10, "0.1", 3, 0);
	m10w_print("0.1", &w10, 0);
	m_10to100(&v,&w10);		m_print("v = ", &v, 1);

	printf("m_an_to_mpa10_opt()  0.01 --> w10\n");
	m_an_to_mpa10_opt(&w10, "0.01", 4, 0);
	m10w_print("0.01", &w10, 0);
	m_10to100(&v,&w10);		m_print("v = ", &v, 1);

	printf("m_set_a()   -00.08050 --> v\n");
	m_set_a(&v,"-00.08050");	m_print("v = ", &v, 1);
	m_mpa2an(&v,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** v = %s\n",buf);
	 
#if 0
	m_dset(&d,&v);
	printf("m_dset()    v --> %f\n",d);
	m_mpa2an(&v,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** v = %s\n",buf);
	
	printf("m_set_a()   0.19 --> w\n");
	m_set_a(&w,"0.19");	m_print("w = ", &w, 1);
	m_mpa2an(&w,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** w = %s\n",buf);

	printf("m_set_a()   2.0 --> x\n");
	m_set_a(&x,"2.0");	m_print("x = ", &x, 1);
	m_mpa2an(&x,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** x = %s\n",buf);

	printf("m_set_a()   3.0 --> x3\n");
	m_set_a(&x3,"3.0");	m_print("x3 = ", &x3, 1);
	m_mpa2an(&x3,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** x3 = %s\n",buf);

	printf("m_set_a()   0.11 --> y\n");
	m_set_a(&y,"0.11");	m_print("y = ", &y, 1);
	m_mpa2an(&y,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** y = %s\n",buf);

	printf("m_add(z,w,y) w+y --> z\n");
	m_add(&z, &w, &y);	m_print("z = 0.19 + 0.11 = ", &z, 1);

	printf("m_add(z,x,y) x+y --> z\n");
	m_add(&z, &x, &y);	m_print("z = 2.0 + 0.11 = ", &z, 1);

	printf("m_sub(z,x,y) x-y --> z\n");
	m_sub(&z, &x, &y);	m_print("z = 2.0 - 0.11 = ", &z, 1);

	printf("m_sub(z,w,y) w-y --> z\n");
	m_sub(&z, &w, &y);	m_print("z = 0.19 - 0.11 = ", &z, 1);

	printf("m_sub(zz,x,z) x-z --> zz\n");
	m_sub(&zz, &x, &z);	m_print("zz = 2.0 - 0.08 = ", &zz, 1);

	printf("m_add1(z,x) z+x --> z\n");
	m_add1(&z, &x);		m_print("z = 0.08 + 2.0 = ", &z, 1);

	printf("m_sub1(z,x) z-x --> z\n");
	m_sub1(&z, &x);		m_print("z = 2.08 - 2.0 = ", &z, 1);

	printf("m_mul(z,x,y) x*y --> z\n");
	m_mul(&z, &x, &y);	m_print("z = 2.0 * 0.11 = ", &z, 1);

	printf("m_mul(z,v,x)     v*x --> z\n");
	m_mul(&z, &v, &x);	m_print("z = -0.0805 * 2.0 = ", &z, 1);

	printf("m_mul1(z,x) z*x --> z\n");
	m_mul1(&z, &x);		m_print("z = -0.161 * 2.0 = ", &z, 1);

	printf("m_div(z,y,x) y/x --> z\n");
	m_div(&z, &y, &x);	m_print("z = 0.11 / 2.0 = ", &z, 1);

	printf("m_div(1,3)  1/3 --> z\n");
	m_div(&z, m_get_i(1), &x3);	m_print("z = 1 / 3 = ", &z, 1);

	printf("m_div(z,x,y) x/y --> z\n");
	m_div(&z, &x, &y);	m_print("z = 2.0 / 0.11 = ", &z, 1);
	m_mpa2an(&z,buf,sizeof(buf),0);
	printf("m_mpa2an()    *** z = %s\n",buf);

	printf("m_div1(x,y)  x/y --> x\n");
	m_div1(&x, &y);		m_print("x = 2.0 / 0.11 = ", &x, 1);

	printf("m_mul1(y,x)  y*x --> y\n");
	m_mul1(&y, &x);		m_print("y = 0.11 * (2/0.11) = ", &y, 1);

	printf("m_set_a()   19.0 --> x\n");
	m_set_a(&x,"19.0");	m_print("x = ", &x, 1);

	printf("m_add1(x,1)  x+1 --> x\n");
	m_add1(&x, m_get_i(1));		m_print("x = 19.0 + 1 = ", &x, 1);
#endif
#if 0
	printf("m_div1_s()  x/2 --> x\n");
	m_div1_s(&x, 2);	m_print("x = x / 2 = ", x, 1);

	printf("m_div1_s()  y/-3 --> y\n");
	m_div1_s(&y, -3);	m_print("y = y / -3 = ", y, 1);

	printf("m_set_a()   1.2 --> z\n");
	z = m_set_a("1.2");	m_print("z = ", z, 1);

	printf("m_inv()     1/z --> z\n");
	z = m_inv(z);		m_print("z = 1 / z = ", z, 1);
#endif
#if 0
	printf("m_sqrt()    sqrt(x) --> z\n");
	z = m_sqrt(x);		m_print("z = sqrt(x) = ", z, 1);

	printf("m_sqr()     sqr(z) --> x\n");
	x = m_sqr(z);		m_print("x = z * z = ", x, 1);

	printf("m_pwr_s()   x^3 --> z\n");
	z = m_pwr_s(x, 3L);	m_print("z = x ^ 3 = ", z, 1);

	printf("m_kaijo()   10! --> x\n");
	x = m_kaijo(10);	m_print("x = 10! = ", x, 1);

	printf("m_iset_s()  x --> (long)\n");
						printf("x = 10! = %ld\n", m_iset_s(x));

	printf("m_kaijo()   15! --> y\n");
	y = m_kaijo(15);	m_print("y = 15! = ", y, 1);

	printf("m_gcd()     gcd(x,y) --> z\n");
	z = m_gcd(x, y);	m_print("z = gcd(x, y) = ", z, 1);

	printf("m_lcm()     lcm(x,y) --> z\n");
	z = m_lcm(x, y);	m_print("z = lcm(x, y) = ", z, 1);

	printf("m_cmp() exec.\n");
	printf("(x : y) = %d    (y : z) = %d    (z : x) = %d\n",
		m_cmp(x, y), m_cmp(y, z), m_cmp(z, x)); 

	printf("m_iset(x)   x,y,z --> (double)\n");
	printf("x = %e, y = %e, z = %e\n", m_iset(x), m_iset(y), m_iset(z));

	m_print("pi()=", pi(), 0);
	m_print("_PI = ", _PI, 0);

	m_print("e()=", e(), 0);
	m_print("_E =", _E, 0);
	m_print("_2_PI", _2_PI, 0);
	m_print("_PI_2", _PI_2, 0);
	m_print("_PI_4", _PI_4, 0);

	x = _PI_4;
	printf("m_sin()     sin(/4) --> y\n");
	y = m_sin(x);		m_print("sin(pi/4) = ", y, 0);

	printf("m_cos()     cos(/4) --> z\n");
	z = m_cos(x);		m_print("cos(pi/4) = ", z, 0);

	printf("m_set_a()   0.9999 --> x\n");
	x = m_set_a("0.9999");	m_print("x = ", x, 1);

	printf("m_asin()    arc sin(x) --> z\n");
	z = m_asin(x);		m_print("asin(x) = ", z, 1);

	printf("m_acos()    arc cos(x) --> y\n");
	y = m_acos(x);		m_print("acos(x) = ", y, 1);

	printf("m_set_a()   0.0111 --> x\n");
	x = m_set_a("0.0111");	m_print("x = ", x, 1);

	printf("m_asin()    arc sin(x) --> z\n");
	z = m_asin(x);		m_print("asin(x) = ", z, 1);

	printf("m_acos()    arc cos(x) --> y\n");
	y = m_acos(x);		m_print("acos(x) = ", y, 1);

	printf("m_set_a()   -0.9999 --> x\n");
	x = m_set_a("-0.9999");	m_print("x = ", x, 1);

	printf("m_asin()    arc sin(x) --> z\n");
	z = m_asin(x);		m_print("asin(x) = ", z, 1);

	printf("m_acos()    arc cos(x) --> y\n");
	y = m_acos(x);		m_print("acos(x) = ", y, 1);

	printf("m_set_a()   -0.0111 --> x\n");
	x = m_set_a("-0.0111");	m_print("x = ", x, 1);

	printf("m_asin()    arc sin(x) --> z\n");
	z = m_asin(x);		m_print("asin(x) = ", z, 1);

	printf("m_acos()    arc cos(x) --> y\n");
	y = m_acos(x);		m_print("acos(x) = ", y, 1);

	printf("m_set_a()   123.456 --> x\n");
	x = m_set_a("123.456");	m_print("x = ", x, 1);

	printf("m_log()     ln(x) --> z\n");
	z = m_log(x);		m_print("log(x) = ", z, 1);

	printf("m_log10()   log10(x) --> y\n");
	y = m_log10(x);		m_print("log10(x) = ", y, 1);

	printf("m_set_a()   2 --> x\n");
	x = m_set_a("2");	m_print("x = ", x, 0);

	printf("m_x1n()     x^(1/3) --> z\n");
	z = m_x1n(x, 3);	m_print("z = 2 ^ (1/3) = ", z, 0);

	printf("m_sqr()     z^2 --> y\n");
	y = m_sqr(z);		m_print("y = z ^ 2 = ", y, 0);

	printf("m_set_a()   3 --> x\n");
	x = m_set_a("3");	m_print("x = ", x, 0);

	printf("m_x_y()     z^x --> y\n");
	y = m_x_y(z, x);	m_print("z ^ 3 = ", y, 0);

	printf("m_set_a()   3.2879 --> y\n");
	y = m_set_a("3.2879");	m_print("y = ", y, 0);

	printf("m_x_y()     x^y --> z\n");
	z = m_x_y(x, y);	m_print("x ^ y = ", z, 0);

	printf("m_exp()     e^x --> z\n");
	z = m_exp(x);		m_print("exp(x) = ", z, 1);

	printf("m_10()      10^x --> z\n");
	z = m_10(x);		m_print("10^(x) = ", z, 1);

	printf("m_set_a()   1.5 --> x\n");
	x = m_set_a("1.5");	m_print("x = ", x, 0);

	printf("m_hcos()    hcos(x) --> y\n");
	y = m_hcos(x);		m_print("hcos(x) = ", y, 1);

	printf("m_hsin()    hsin(x) --> y\n");
	y = m_hsin(x);		m_print("hsin(x) = ", y, 1);

	printf("m_htan()    htan(x) --> y\n");
	y = m_htan(x);		m_print("htan(x) = ", y, 1);

	printf("m_bino()    5 b 3 --> x\n");
	x = m_bino( 5,  3);	m_print(" 5 C 3  = ", x, 0);

	printf("m_bino()    10 b 5 --> x\n");
	x = m_bino(10,  5);	m_print("10 C 5  = ", x, 0);

	printf("m_bino()    50 b 30 --> x\n");
	x = m_bino(50, 30);	m_print("50 C 30 = ", x, 0);

	printf("m_set_a()   13783.1721389 --> x\n");
	x = m_set_a("13783.1721389");	m_print("x = ", x, 0);

	printf("m_round()   round(x,3) --> y\n");
	y = m_round(x, 3);	m_print("round(x, 3) = ", y, 0);

	printf("m_round()   round(x,0) --> y\n");
	y = m_round(x, 0);	m_print("round(x, 0) = ", y, 0);

	printf("m_round()   round(x,-3) --> y\n");
	y = m_round(x, -3);	m_print("round(x, -3) = ", y, 0);

	printf("m_srand() exec.\n");
	m_srand(time(&now));
	y = m_set_a("0.0001");
	for(k = 0; k < 10; k++)
	{
		i = 0;
		do
		{
			x = m_rand();
			i++;
		} while(m_cmp(x, y) >= 0);
		printf("count = %ld (target=10000) : ", i);
		m_print("r = ", x, 1);
	}

	printf("m_set_a()   3 --> x\n");
	x = m_set_a("3");	m_print("x = ", x, 0);

	printf("m_log()     ln(x) --> y\n");
	y = m_log(x);		m_print("ln(3)=", y, 0);

	printf("ln2()       ln(2) --> x\n");
	x = ln2();			m_print("ln(2)=", x, 0);

	printf("ln625()     ln(0.625) --> y\n");
	y = ln625();		m_print("ln(.625)=", y, 0);

	printf("m_mul_s()   x*4 --> z\n");
	z = m_mul_s(x, 4);	m_print("4*ln(2) = ", z, 0);

	printf("m_add1()    y+z --> y\n");
	m_add1(&y, z);		m_print("ln(10)=", y, 0);

	printf("m_div()     x/y --> z\n");
	z = m_div(x, y);	m_print("log10(2)=", z, 0);

	printf("ln75()      ln(0.75) --> z\n");
	z = ln75();			m_print("ln(.75)=", z, 0);

	printf("m_mul1_s()  x*2 --> x\n");
	m_mul1_s(&x, 2);	m_print("x = ", x, 0);

	printf("m_add1()    z+x --> z\n");
	m_add1(&z, x);		m_print("ln(3)=", z, 0);

	printf("m_div()     z/y --> x\n");
	x = m_div(z, y);	m_print("log10(3)=", x, 0);

	printf(" --> x\n");
	x = _PI;			m_print("x = ", x, 0);

	printf("m_div1_s()  x/3 --> x\n");
	m_div1_s(&x, 3);	m_print("x = ", x, 0);

	printf("m_tan()     tan(x) --> y\n");
	y = m_tan(x);		m_print("tan(x) =", y, 0);

	m_print("sqrt(3)=", _SQRT3, 0);

	printf("m_set_a()   0.5 --> x\n");
	x = m_set_a("0.5");	m_print("x = ", x, 0);

	printf("m_acos()    arc cos(x) --> y\n");
	y = m_acos(x);		m_print("acos(x)=", y, 0);

	printf("sqrt(3) --> x\n");
	x = _SQRT3;			m_print("x = ", x, 0);

	printf("m_div_s()   x/2 --> v\n");
	v = m_div_s(x, 2);	m_print("v = ", v, 0);

	printf("m_asin()    arc sin(v) --> y\n");
	y = m_asin(v);		m_print("asin(x)=", y, 0);

	printf("m_atan()    arc tan(x) --> y\n");
	y = m_atan(x);		m_print("atan(x)=", y, 0);

	printf(" --> z\n");
	z = _PI;			m_print("z = ", z, 0);

	printf("m_div1_s()  z/3 --> z\n");
	m_div1_s(&z, 3);	m_print("pi / 3 =", z, 0);
#endif
	return 0;
}
