static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akainitregist.c								*/
/*												*/
/*			coded by A.Kobayashi 2010/6/10		*/
/*												*/
/************************************************/
#include "akacommon.h"

tdtMsgCtl          tMsgCtl     = {-1};
tdtClassCtlHead    tClassHead  = {0,0,NULL};

static char *nullstring="";
static char *nullname=AKX_NULL_PRINT;

static void _instance_free();
static void _class_free();

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize()
{
	int iRc,i;
	char cProcName[D_RECORD_BUFSIZE];
	int n,parm[2],*pp;

	memset(&tMsgCtl,0,sizeof(tdtMsgCtl));
	tMsgCtl.iSd = 0;
	if (!(tMsgCtl.pTimerCtl = akxe_timer_new())) return -18502106;
	if (aka_get_msec(0)<0) return -18502105;
	tMsgCtl.iSendMsgTimeOut = 30000;	/* milli second */
	tMsgCtl.iSendMsgMinWait = -1;	/* milli second */
	tMsgCtl.iGetMsgWaitTime = 0;
	timerclear(&tMsgCtl.tGetMsgTimeOut);
	tMsgCtl.sWQSuspend = 0;
	tMsgCtl.ucShutMode = 0;
	tMsgCtl.ucShutSuspend = 0;
	tMsgCtl.ucRsv1 = 0;	/* message read/write flag */
	tMsgCtl.ucRsv2 = 0;	/* PRINTOUT LEVEL */
	if (!(tMsgCtl.cpSpoolDir = akb_akb_home(0)))
		tMsgCtl.cpSpoolDir = nullstring;

	/* New Ring Buff */
	tMsgCtl.pRbRCtl  = akxs_rb_new(0,0);
	if (!tMsgCtl.pRbRCtl) return -18502104;

	tClassHead.tpClass = NULL;

	akb_log_get_proc_name();

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
void  aka_terminate()
{
	int i;

	/* NX\̊J */
	_class_free(tClassHead.tpClass);
	tClassHead.tpClass = NULL;

	/* Oobt@ƃO̊J */
	akxs_rb_all_free(tMsgCtl.pRbRCtl);
	tMsgCtl.pRbRCtl = NULL;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_class(pFuncName,iClassId,iInstanceDataSize,iMaxThread,iOption,
                     cpClassName,cpUserArea)
int (*pFuncName)();	/* bZ[W֐ւ̃|C^ */
int  iClassId     ;	/* ֐̃NXʔԍ
                                0:	ʃvbgtH[piݒsj
                    65280 - 65535:	boeR}hp */
int  iInstanceDataSize;	/* P̏ŎgpϐGÃTCYioCgj */
int  iMaxThread   ;	/* bZ[W鑽dx̍ől */
int  iOption      ;	/* Prbg@PԐMpPbg󂯂Ȃ */
char *cpClassName;	/* NX */
char *cpUserArea;	/* [Ü */
{
	tdtClassCtl *next;
	tdtInstance *tpIns;
	int i,ret;

	if (!(next=(tdtClassCtl *)Malloc(sizeof(tdtClassCtl)))) {
		return -18502306;
	}
	memset(next,0,sizeof(tdtClassCtl));
	tClassHead.tpClass = next;
	next->pFuncName         = pFuncName;
	next->iClassId          = iClassId;
	next->iInstanceDataSize = iInstanceDataSize;
	next->iMaxThread        = iMaxThread;
	next->iOption           = iOption;
	if (cpClassName) next->cpClassName = Strdup(cpClassName);
	next->iPacketNumber     = 0;
	next->iUsedCount        = 0;
	if (!(tpIns = (tdtInstance *)Malloc(sizeof(tdtInstance)))) {
		return -18502307;
	}
	next->tpInstance = tpIns;
	if (ret = aka_instance_init(0,tpIns,iInstanceDataSize)) return ret;

	tpIns->tpRecvMsgCom->usDisposition = AKA_REGIST_CLASS;
	ret = pFuncName(iClassId,cpUserArea,tpIns->tpRecvMsgCom);

	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_instance_buf_free(tpIns)
tdtInstance *tpIns;
{
	char *p;

	if (!tpIns) return -1;
	if (tpIns->cpInstanceData) Free(tpIns->cpInstanceData);
	if (tpIns->tpRecvMsgCom)   Free(tpIns->tpRecvMsgCom);
	if (tpIns->tpPackHead)     Free(tpIns->tpPackHead);
	if (tpIns->cpToFree)       Free(tpIns->cpToFree);
	if (tpIns->cpComment)      Free(tpIns->cpComment);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static void _instance_free(tpIns,iMaxThread)
tdtInstance *tpIns;
int         iMaxThread;
{
	int i;

	for (i=0;i<iMaxThread;i++) {
		aka_instance_buf_free(&tpIns[i]);
	}
	Free(tpIns);
}

/********************************************************/
/*                                                      */
/********************************************************/
static void	_class_free(tpClass)
tdtClassCtl *tpClass;
{
	if (tpClass) {
		_class_free(tpClass->tpClassNext);
		if (tpClass->cpClassName)  Free(tpClass->cpClassName);
		if (tpClass->tpInstance)
			_instance_free(tpClass->tpInstance,tpClass->iMaxThread);
		Free (tpClass);
	}
}

/********************************************************/
/* iOpt = 0 : NAƗ̈m                          */
/* iOpt = 1 : NÂ                                */
/* iOpt = 2 : ̈mۂĂȂmۂ        */
/*             NA͂Ȃ                           */
/********************************************************/
int aka_instance_init(iOpt, tpIns, iInstanceDataSize)
int         iOpt;
tdtInstance *tpIns;
int         iInstanceDataSize;
{
	int iFlg;

	if (iOpt != 2) memset(tpIns,0,sizeof(tdtInstance));
	if (iOpt == 1) return 0;
	if (iInstanceDataSize > 0) {
		iFlg = 1;
		if (iOpt==2 && tpIns->cpInstanceData) iFlg = 0;
		if (iFlg) {
			if (!(tpIns->cpInstanceData = Malloc(iInstanceDataSize))) {
				return -18503002;
			}
		}
	}
	iFlg = 1;
	if (iOpt==2 && tpIns->tpRecvMsgCom) iFlg = 0;
	if (iFlg) {
		if (!(tpIns->tpRecvMsgCom =
		       (AKAMSGCOM *)Malloc(sizeof(AKAMSGCOM)+256*sizeof(char *)))) {
			return -18503003;
		}
		memset(tpIns->tpRecvMsgCom,0,sizeof(AKAMSGCOM));
	}
	iFlg = 1;
	if (iOpt==2 && tpIns->tpPackHead) iFlg = 0;
	if (iFlg) {
		if (!(tpIns->tpPackHead =
	   	     (qCommPackHead *)Malloc(sizeof(qCommPackHead)))) {
			return -18503004;
		}
		memset(tpIns->tpPackHead,0,sizeof(qCommPackHead));
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_nofree(iSet,level)
int iSet,level;
{
	if (tMsgCtl.iSd<0) return -18503201;

	if (iSet) {
		tMsgCtl.iMsgOpt |= AKA_MSO_EXEC_NOFREE;
		tMsgCtl.ucRsv2 = level;
	}
	else tMsgCtl.iMsgOpt &= ~AKA_MSO_EXEC_NOFREE;

	return 0;
}
