/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		^C}hCoiFRK-RX62Npj
 */
 
#ifndef TOPPERS_TARGET_TIMER_H
#define TOPPERS_TARGET_TIMER_H

#include <sil.h>
#include "frk_rx62n.h"
#include "target_syssvc.h"

/*
 *  ^C}݃nho^̂߂̒萔
 */
#define INHNO_TIMER		INT_CMT0_CMI				/* ݃nhԍ */
#define INTNO_TIMER		INT_CMT0_CMI				/* ݔԍ */
#define INTPRI_TIMER	-5							/* ݗDx */
#define INTATR_TIMER	(TA_ENAINT | TA_EDGE)		/* ݑ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef uint16_t	CLOCK;

/*
 *  ^C}l̓\ƃ~bPʂƂ̕ϊ
 *
 *  1ms̃^C}[荞݂gp̂ł̃NbN`D
 */
#define TIMER_CLOCK				(48000U / 6U)		/* PCLK/Œᕪ8 = 6MHz */
#define TO_CLOCK(nume, deno)	((CLOCK)(TIMER_CLOCK * (nume) / (deno)))
#define	TO_USEC(clock)			((SYSUTM)((clock) * 1000U / TIMER_CLOCK))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xFFFFU)

/*
 *  \]pVXeoۂ̏Ԃ̌ςliPʂ͓\j
 */
#define	GET_TOLERANCE	(100U)	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= (TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE))

/*
 *  RyA}b`^C}Rg[WX^̐ݒl
 */
/*
 *  NbNIrbg
 *
 *  bit7͗\̈ł, ݂1Œ
 */
#define CMT_PCLK_DIV_8			(0x0080U)
#define CMT_PCLK_DIV_32			(0x0081U)
#define CMT_PCLK_DIV_128		(0x0082U)
#define CMT_PCLK_DIV_512		(0x0083U)

/*
 *  RyA}b`^C}RX^gWX^iCMCORj
 *
 *  RyA}b`1msƂD
 *  ӃW[NbNiPCLKj50MHz8̂ŁC
 *  1160nsecƂȂC62501msi^CeBbN̎jƂD
 */
#define CMCOR_PERIOD			(TIMER_CLOCK)

/*
 * RyA}b`^C}荞ݗvݒ背WX^iiISELRijii= 荞݃xN^ԍj
 */
#define ICU_ISEL_CPU			(0x00U)




/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
extern void	target_timer_initialize(intptr_t exinf);

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
extern void	target_timer_terminate(intptr_t exinf);

/*
 *  ^C}WX^l̓ǂݏo
 */
Inline uint16_t rx600_cmt_getcount(void)
{
	return *CMT0_CMCNT_ADDR;
}

/*
 *  ^C}WX^l̏
 */
Inline void rx600_cmt_setcount(uint16_t count)
{
	*CMT0_CMCNT_ADDR = count;
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
target_timer_get_current(void)
{
	/* AbvJEĝ߃^C}WX^l̂܂ܕԂ	*/
	return (rx600_cmt_getcount());
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline bool_t
target_timer_probe_int(void)
{
	return(x_probe_int(INTNO_TIMER));
}

/*
 *  ^C}݃nh
 */
extern void	target_timer_handler(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_TIMER_H */
