/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		VAI/OfoCXiSIOjhCoiFRK-RX62Npj
 */

#ifndef TOPPERS_TARGET_SERIAL_H
#define TOPPERS_TARGET_SERIAL_H

#include "frk_rx62n.h"
#include "rx600/rx600_uart.h"

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO_TX	INT_SCI0_TEI			/* ݃nhԍ */
#define INTNO_SIO_TX	INT_SCI0_TEI			/* ݔԍ */
#define INHNO_SIO_RX	INT_SCI0_RXI			/* ݃nhԍ */
#define INTNO_SIO_RX	INT_SCI0_RXI			/* ݔԍ */
#define INTPRI_SIO		-4						/* ݗDx */
#define INTATR_SIO		(TA_NULL)				/* ݑ */

#ifndef TOPPERS_MACRO_ONLY


/*
 *  SIOhCȍ
 */
extern void		sio_initialize(intptr_t exinf);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*sio_opn_por(ID siopid, intptr_t exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void		sio_cls_por(SIOPCB *p_siopcb);

/*
 *  SIO̊݃nh
 */
extern void 	sio_tx_isr(intptr_t exinf);
extern void 	sio_rx_isr(intptr_t exinf);

/*
 *  VAI/O|[gւ̕M
 */
extern bool_t	sio_snd_chr(SIOPCB *siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern int_t	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void		sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void		sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void		sio_irdy_snd(intptr_t exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void		sio_irdy_rcv(intptr_t exinf);


#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_SERIAL_H */
