/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *  A[nh@\
 */

#include "alarm.h"
#include "check.h"
#include "time_event.h"

/*
 *  g[XO}ÑftHg`
 */

#ifndef LOG_ALM_ENTER
#define LOG_ALM_ENTER(almidx)
#endif /* LOG_ALM_ENTER */

#ifndef LOG_ALM_LEAVE
#define LOG_ALM_LEAVE(almidx)
#endif /* LOG_ALM_LEAVE */

#ifndef LOG_STA_ALM_ENTER
#define LOG_STA_ALM_ENTER(almid, almtim)
#endif /* LOG_STA_ALM_ENTER */

#ifndef LOG_STA_ALM_LEAVE
#define LOG_STA_ALM_LEAVE(ercd)
#endif /* LOG_STA_ALM_LEAVE */

#ifndef LOG_STP_ALM_ENTER
#define LOG_STP_ALM_ENTER(almid)
#endif /* LOG_STP_ALM_ENTER */

#ifndef LOG_STP_ALM_LEAVE
#define LOG_STP_ALM_LEAVE(ercd)
#endif /* LOG_STP_ALM_LEAVE */


/* nhID^CCxgIDɕϊ */
#define ALM_EVTID(almid)	((ID)(INDEX_ALM(almid) + almevtid_offset))
#define INDEX_ALM(almid)	((uint_t)((almid) - TMIN_ALMID))

/* A[nȟ */
#define tnum_alm			((uint_t)(tmax_almid - TMIN_ALMID + 1))

/* A[̓Ԃ\rbg}bv */
#define ALMACT_BIT(index)	(1U << (index))


/* A[nhs^CCxg */
void call_almhdr(uint_t almidx);


/*
 *  A[nh@\̏
 */

#ifdef TOPPERS_ini_alm

void
initialize_alarm(void)
{
	/* SẴA[~Ԃɂ */
	almcb_almact = 0U;
}

#endif /* TOPPERS_ini_alm */

/*
 *  A[̊Jn
 */

#ifdef TOPPERS_sta_alm

ER
sta_alm(ID almid , RELTIM almtim)
{
	ER ercd;
	uint_t index = INDEX_ALM(almid);
	
	LOG_STA_ALM_ENTER(almid, almtim);
	CHECK_TSKCTX_UNL();
	CHECK_ALMID(almid);
	
	t_lock_cpu();
	
	if((almcb_almact & ALMACT_BIT(index)) != 0U) {
		time_event_dequeue(ALM_EVTID(almid));
	}
	else {
		almcb_almact |= ALMACT_BIT(index);
	}
	
	time_event_enqueue(ALM_EVTID(almid) ,
		current_time + (EVTTIM)almtim , (CBACK)call_almhdr , index);
	
	ercd = E_OK;
	t_unlock_cpu();
	
  error_exit:
	LOG_STA_ALM_LEAVE(ercd);
	return ercd;
}

#endif /* TOPPERS_sta_alm */

/*
 *  A[̒~
 */

#ifdef TOPPERS_stp_alm

ER
stp_alm(ID almid)
{
	ER ercd;
	uint_t index = INDEX_ALM(almid);
	
	LOG_STP_ALM_ENTER(almid);
	CHECK_TSKCTX_UNL();
	CHECK_ALMID(almid);
	
	t_lock_cpu();
	
	if((almcb_almact & ALMACT_BIT(index)) != 0U) {
		almcb_almact &= ~ALMACT_BIT(index);
		time_event_dequeue(ALM_EVTID(almid));
	}
	ercd = E_OK;
	t_unlock_cpu();
	
  error_exit:
	LOG_STP_ALM_LEAVE(ercd);
	return ercd;
}

#endif /* TOPPERS_stp_alm */

/*
 *  A[nhN[`
 */

#ifdef TOPPERS_almcal

void
call_almhdr(uint_t almidx)
{
	/* A[nh~Ԃɂ */
	almcb_almact &= ~ALMACT_BIT(almidx);
	
	i_unlock_cpu();
	
	/* A[nh̎s */
	LOG_ALM_ENTER(almidx);
	(*alminib_almhdr[almidx])(alminib_exinf[almidx]);
	LOG_ALM_LEAVE(almidx);
	
	if (!i_sense_lock()) {
		i_lock_cpu();
	}
}

#endif /* TOPPERS_almcal */

