/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^[QbgVXeˑW[iStarter Kitpj
 */

#include "kernel_impl.h"
#include <sil.h>
#include "frk_rx62n.h"
#include "rx600/rx600_uart.h"

/*
 *  ^[QbgVXeˑ [`
 */
void
target_initialize( void )
{
	/*
	 *  vZbTˑ̏
	 */
	prc_initialize();

	/*
	 *  |[g̐ݒ
	 */
	rx600_uart_init( TARGET_PUTC_PORTID, UART_BAUDRATE0 , UART_CLKSRC );

	/* |[gP20TxD0, |[gP21RxD0 */
	/* f[^fBNVWX^(DDR)̐ݒ P21(RxD0)̓|[gɂ */
	sil_wrb_mem((void *)(PORT2_DDR_ADDR) , 
					sil_reb_mem((void *)(PORT2_DDR_ADDR)) & ~PORT_DDR_B1_BIT);
	/* ICRWX^̑ΉrbgLɂ */
	sil_wrb_mem((void *)(PORT2_ICR_ADDR) , 
					sil_reb_mem((void *)(PORT2_ICR_ADDR)) | PORT_DDR_B1_BIT);

	/* f[^fBNVWX^(DDR)̐ݒ P20(TxD0)o̓|[gɂ */
	sil_wrb_mem((void *)(PORT2_DDR_ADDR) , 
					sil_reb_mem((void *)(PORT2_DDR_ADDR)) | PORT_DDR_B0_BIT);
}


/*
 *  ^[QbgVXȅI[`
 */
void
target_exit( void )
{
	/*
	 *	vZbTˑ̏I
	 */
	prc_terminate();

	while ( 1 );
}


/*
 *  VXeO̒჌xo͂̂߂̕o
 */
void
target_fput_log( char_t c )
{
	if( c == '\n' ){
	   rx600_uart_pol_putc( '\r' , TARGET_PUTC_PORTID );
	}

    rx600_uart_pol_putc( c , TARGET_PUTC_PORTID );
}


