// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/set.h
//!
//! @brief WZ߂̃Cu
//!

#ifndef __INCLUDE_MIST_SET_H__
#define __INCLUDE_MIST_SET_H__


#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif

#include <iostream>
#include <set>
#include <algorithm>

// mistOԂ̎n܂
_MIST_BEGIN



//! @addtogroup set_group WZ
//!
//! @code ̃wb_CN[h
//! #include <mist/config/set.h>
//! @endcode
//!
//!  @{


/// @brief W߂̊{NX
//! 
//! @param SetType c NXistd::set  std::multisetj
//! 
template< class SetType >
class set_base : public SetType
{
protected:
	typedef SetType base;			///< @brief NXistd::set  std::multisetj

public:
	typedef typename base::key_type key_type;					///< @brief 
	typedef typename base::key_compare key_compare;				///< @brief 
	typedef typename base::value_compare value_compare;			///< @brief 
	typedef typename base::allocator_type allocator_type;		///< @brief STLReipAP[^^
	typedef typename base::size_type size_type;					///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename base::difference_type difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ

#if __MIST_MSVC__ != 6
	typedef typename base::pointer pointer;						///< @brief STL̃ReiɊi[f[^^̃|C^[^Dstd::set< data > ̏ꍇCdata * ƂȂ
	typedef typename base::const_pointer const_pointer;			///< @brief STL̃ReiɊi[f[^^ const |C^[^Dstd::set< data > ̏ꍇCconst data * ƂȂ
#endif

	typedef typename base::reference reference;								///< @brief STL̃ReiɊi[f[^^̎QƁDstd::set< data > ̏ꍇCdata & ƂȂ
	typedef typename base::const_reference const_reference;					///< @brief STL̃ReiɊi[f[^^ const QƁDstd::set< data > ̏ꍇCconst data & ƂȂ
	typedef typename base::iterator iterator;								///< @brief STL̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef typename base::const_iterator const_iterator;					///< @brief STL̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef typename base::reverse_iterator reverse_iterator;				///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef typename base::const_reverse_iterator const_reverse_iterator;	///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef typename base::value_type value_type;							///< @brief STL̃ReiɊi[f[^^Dstd::set< data >  data Ɠ


public:
	/// @brief ftHgRXgN^iW쐬j
	set_base( ) : base( ){ }

	/// @brief W̗vf̔rZqƂ pred p
	explicit set_base( const key_compare &pred ) : base( pred ){ }

	/// @brief 1vf key W쐬
	explicit set_base( const key_type &key ) : base( ){ base::insert( key ); }

	/// @brief W̗vf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	set_base( const key_compare &pred, const allocator_type &alloc ) : base( pred, alloc ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬
	template< class Iterator >
	set_base( Iterator first, Iterator last ) : base( first, last ){ }


	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred p
	template< class Iterator >
	set_base( Iterator first, Iterator last, const key_compare &pred ) : base( first, last, pred ){ }


	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	template< class Iterator >
	set_base( Iterator first, Iterator last, const key_compare &pred, const allocator_type &alloc ) : base( first, last, pred, alloc ){ }

public:
	/// @brief Wa
	//! 
	//! \f[ a = a \bigcup b \f]
	//! 
	set_base &operator +=( const set_base &s )
	{
#if __MIST_MSVC__ != 6
		base::insert( s.begin( ), s.end( ) );
#else
		// MSVC6 tSTLSETł̓Ce[^̎قȂ
		const_iterator site = s.begin( );
		const_iterator eite = s.end( );
		for( ; site != eite ; ++site )
		{
			base::insert( *site );
		}
#endif
		return( *this );
	}

	/// @brief W1vfǉ
	set_base &operator +=( const key_type &s ){ base::insert( s ); return( *this ); }


	/// @brief WvZ
	//! 
	//! \f[ a = a - \left( a \bigcap b \right) \f]
	//! 
	set_base &operator -=( const set_base &s )
	{
		if( &s == this )
		{
			base::clear( );
		}
		else
		{
			set_base a = *this;
			const_iterator site1 = a.begin( );
			const_iterator eite1 = a.end( );
			const_iterator site2 = s.begin( );
			const_iterator eite2 = s.end( );

			// g̓eۂɂ
			base::clear( );

			key_compare compare;
			while( site1 != eite1 && site2 != eite2 )
			{
				if( compare( *site1, *site2 ) )
				{
					base::insert( *site1 );
					++site1;
				}
				else if( compare( *site2, *site1 ) )
				{
					++site2;
				}
				else
				{
					++site1;
					++site2;
				}
			}

			if( site1 != eite1 )
			{
#if __MIST_MSVC__ != 6
				base::insert( site1, eite1 );
#else
				// MSVC6 tSTLSETł̓Ce[^̎قȂ
				for( ; site1 != eite1 ; ++site1 )
				{
					base::insert( *site1 );
				}
#endif
			}
		}
		return( *this );
	}

	/// @brief W1vf菜
	set_base &operator -=( const key_type &s ){ base::erase( s ); return( *this ); }


	/// @brief ϏWvZ
	//! 
	//! \f[ a = a \bigcap b \f]
	//! 
	set_base &operator *=( const set_base &s )
	{
		if( &s != this )
		{
			set_base a = *this;
			const_iterator site1 = a.begin( );
			const_iterator eite1 = a.end( );
			const_iterator site2 = s.begin( );
			const_iterator eite2 = s.end( );

			// g̓eۂɂ
			base::clear( );

			key_compare compare;
			while( site1 != eite1 && site2 != eite2 )
			{
				if( compare( *site1, *site2 ) )
				{
					++site1;
				}
				else if ( compare( *site2, *site1 ) )
				{
					++site2;
				}
				else
				{
					base::insert( *site1 );
					++site1;
					++site2;
				}
			}
		}
		return( *this );
	}


	/// @brief W1vf̏WԂ̐ς
	set_base &operator *=( const key_type &s )
	{
		set_base a = *this;
		const_iterator site = a.begin( );
		const_iterator eite = a.end( );

		// g̓eۂɂ
		base::clear( );

		key_compare compare;
		while( site != eite )
		{
			if( compare( *site, s ) )
			{
				++site;
			}
			else if ( compare( s, *site ) )
			{
				break;
			}
			else
			{
				base::insert( *site );
				++site;
			}
		}
		return( *this );
	}


	/// @brief WɏWǉ
	set_base &operator <<=( const set_base &s ){ return( operator +=( s ) ); }

	/// @brief W1vfǉ
	set_base &operator <<=( const key_type &s ){ return( operator +=( s ) ); }


	/// @brief W1vfǉWo͂
	set_base &operator <<( const key_type &s ) const { return( set_base( *this )+=( s ) ); }


	/// @brief SĂ̗vfǂ𔻒肷i\f$ a = b \f$j
	bool operator ==( const set_base &s ) const
	{
		if( base::size( ) != s.size( ) )
		{
			return( false );
		}

		key_compare compare;
		const_iterator ite1 = base::begin( );
		const_iterator eite1 = base::end( );
		const_iterator ite2 = s.begin( );
		for( ; ite1 != eite1 ; ++ite1, ++ite2 )
		{
			if( compare( *ite1, *ite2 ) || compare( *ite2, *ite1 ) )
			{
				return( false );
			}
		}
		return( true );
	}


	/// @brief SĂ̗vfǂ𔻒肷i1vfŁj
	bool operator ==( const key_type &s ) const
	{
		if( base::size( ) != 1 )
		{
			return( false );
		}

		key_compare compare;
		const_iterator ite = base::begin( );
		const_iterator eite = base::end( );
		for( ; ite != eite ; ++ite )
		{
			if( compare( *ite, s ) || compare( s, *ite ) )
			{
				return( false );
			}
		}
		return( true );
	}


	/// @brief SĂ̗vfȂǂ𔻒肷i\f$ a \neq b \f$j
	bool operator !=( const set_base &s ) const { return( !( *this == s ) ); }

	/// @brief SĂ̗vfȂǂ𔻒肷i1vfŁj
	bool operator !=( const key_type &s ) const { return( !( *this == s ) ); }

	/// @brief W̕܊֌W𒲂ׂi\f$ a \subset b \f$j
	bool operator < ( const set_base &s ) const
	{
		if( base::size( ) >= s.size( ) )
		{
			return( false );
		}

		return( std::includes( s.begin( ), s.end( ), base::begin( ), base::end( ), key_compare( ) ) );
	}

	/// @brief W̕܊֌W𒲂ׂi\f$ a \subseteq b \f$j
	bool operator <=( const set_base &s ) const
	{
		if( base::size( ) > s.size( ) )
		{
			return( false );
		}

		return( std::includes( s.begin( ), s.end( ), base::begin( ), base::end( ), key_compare( ) ) );
	}

	/// @brief W̕܊֌W𒲂ׂi\f$ a \supset b \f$j
	bool operator > ( const set_base &s ) const { return( s < *this ); }

	/// @brief W̕܊֌W𒲂ׂi\f$ a \supseteq b \f$j
	bool operator >=( const set_base &s ) const { return( s <= *this ); }
};


/// @brief aWvZ
template< class SetType > inline const set_base< SetType > operator +( const set_base< SetType > &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) += s2 ); }

/// @brief WvZ
template< class SetType > inline const set_base< SetType > operator -( const set_base< SetType > &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) -= s2 ); }

/// @brief ϏWvZ
template< class SetType > inline const set_base< SetType > operator *( const set_base< SetType > &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) *= s2 ); }


//inline const set_base operator /( const set_base &s1, const set_base &s2 ){ return( set_base( s1 ) /= s2 ); }
//inline const set_base operator %( const set_base &s1, const set_base &s2 ){ return( set_base( s1 ) %= s2 ); }
//inline const set_base operator |( const set_base &s1, const set_base &s2 ){ return( set_base( s1 ) |= s2 ); }
//inline const set_base operator &( const set_base &s1, const set_base &s2 ){ return( set_base( s1 ) &= s2 ); }
//inline const set_base operator ^( const set_base &s1, const set_base &s2 ){ return( set_base( s1 ) ^= s2 ); }



/// @brief W1vf̐ςvZ
template< class SetType > inline const set_base< SetType > operator *( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( set_base< SetType >( s1 ) *= s2 ); }

/// @brief 1vfƏW̐ςvZ
template< class SetType > inline const set_base< SetType > operator *( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) *= s2 ); }

/// @brief W1vf̘avZ
template< class SetType > inline const set_base< SetType > operator +( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( set_base< SetType >( s1 ) += s2 ); }

/// @brief 1vfƏW̘avZ
template< class SetType > inline const set_base< SetType > operator +( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s2 ) += s1 ); }

/// @brief W1vf̍vZ
template< class SetType > inline const set_base< SetType > operator -( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( set_base< SetType >( s1 ) -= s2 ); }

/// @brief 1vfƏW̍vZ
template< class SetType > inline const set_base< SetType > operator -( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) -= s2 ); }



/// @brief SĂ̗vfǂ𔻒肷i\f$ a = b \f$j
template< class SetType > bool operator ==( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( set_base< SetType >( s2 ) == s1 ); }

/// @brief SĂ̗vfȂǂ𔻒肷i\f$ a \neq b \f$j
template< class SetType > bool operator !=( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( set_base< SetType >( s2 ) != s1 ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \subset b \f$j
template< class SetType > bool operator < ( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( s1 <  set_base< SetType >( s2 ) ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \subseteq b \f$j
template< class SetType > bool operator <=( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( s1 <= set_base< SetType >( s2 ) ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \supset b \f$j
template< class SetType > bool operator > ( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( s1 >  set_base< SetType >( s2 ) ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \supseteq b \f$j
template< class SetType > bool operator >=( const set_base< SetType > &s1, const typename set_base< SetType >::key_type &s2 ){ return( s1 >= set_base< SetType >( s2 ) ); }



/// @brief SĂ̗vfǂ𔻒肷i\f$ a = b \f$j
template< class SetType > bool operator ==( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) == s2 ); }

/// @brief SĂ̗vfȂǂ𔻒肷i\f$ a \neq b \f$j
template< class SetType > bool operator !=( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) != s2 ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \subset b \f$j
template< class SetType > bool operator < ( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) <  s2 ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \subseteq b \f$j
template< class SetType > bool operator <=( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) <= s2 ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \supset b \f$j
template< class SetType > bool operator > ( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) >  s2 ); }

/// @brief W̕܊֌W𒲂ׂi\f$ a \supseteq b \f$j
template< class SetType > bool operator >=( const typename set_base< SetType >::key_type &s1, const set_base< SetType > &s2 ){ return( set_base< SetType >( s1 ) >= s2 ); }


/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     s   c W
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, ... , n
//! @endcode
//! 
template< class SetType >
inline std::ostream &operator <<( std::ostream &out, const set_base< SetType > &s )
{
	typename set_base< SetType >::const_iterator ite = s.begin( );
	if( ite != s.end( ) )
	{
		out << *ite++;
	}

	for( ; ite != s.end( ) ; ++ite )
	{
		out << ", " << *ite;
	}
	return( out );
}



/// @brief WZsƂłCSTL set ̊g
//! 
//! vf̏dȂW
//! 
//! @param Key       c W̊evf\^
//! @param Comp      c vfԂ̑召֌W\r֐iȗ < Kpj
//! @param Allocator c AP[^iȗSTL̃ftHgAP[^Kpj
//! 
template< class Key, class Comp = std::less< Key >, class Allocator = std::allocator< Key > >
class set : public set_base< std::set< Key, Comp, Allocator > >
{
protected:
	typedef set_base< std::set< Key, Comp, Allocator > > base;		///< @brief 

public:
	typedef typename base::key_type key_type;					///< @brief 
	typedef typename base::key_compare key_compare;				///< @brief 
	typedef typename base::value_compare value_compare;			///< @brief 
	typedef typename base::allocator_type allocator_type;		///< @brief STLReipAP[^^
	typedef typename base::size_type size_type;					///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename base::difference_type difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ

#if __MIST_MSVC__ != 6
	typedef typename base::pointer pointer;						///< @brief STL̃ReiɊi[f[^^̃|C^[^Dstd::set< data > ̏ꍇCdata * ƂȂ
	typedef typename base::const_pointer const_pointer;			///< @brief STL̃ReiɊi[f[^^ const |C^[^Dstd::set< data > ̏ꍇCconst data * ƂȂ
#endif

	typedef typename base::reference reference;								///< @brief STL̃ReiɊi[f[^^̎QƁDstd::set< data > ̏ꍇCdata & ƂȂ
	typedef typename base::const_reference const_reference;					///< @brief STL̃ReiɊi[f[^^ const QƁDstd::set< data > ̏ꍇCconst data & ƂȂ
	typedef typename base::iterator iterator;								///< @brief STL̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef typename base::const_iterator const_iterator;					///< @brief STL̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef typename base::reverse_iterator reverse_iterator;				///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef typename base::const_reverse_iterator const_reverse_iterator;	///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef typename base::value_type value_type;							///< @brief STL̃ReiɊi[f[^^Dstd::set< data >  data Ɠ

public:
	/// @brief ftHgRXgN^iW쐬j
	set( ) : base( ){ }

	/// @brief W̗vf̔rZqƂ pred p
	explicit set( const key_compare &pred ) : base( pred ){ }

	/// @brief 1vf key W쐬
	explicit set( const key_type &key ) : base( ){ base::insert( key ); }

	/// @brief W̗vf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	set( const key_compare &pred, const allocator_type &alloc ) : base( pred, alloc ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬
	template< class Iterator >
	set( Iterator first, Iterator last ) : base( first, last ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred p
	template< class Iterator >
	set( Iterator first, Iterator last, const key_compare &pred ) : base( first, last, pred ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	template< class Iterator >
	set( Iterator first, Iterator last, const key_compare &pred, const allocator_type &alloc ) : base( first, last, pred, alloc ){ }
};



/// @brief WZsƂłCSTL set ̊g
//! 
//! vf̏dW
//! 
//! @param Key       c W̊evf\^
//! @param Comp      c vfԂ̑召֌W\r֐iȗ < Kpj
//! @param Allocator c AP[^iȗSTL̃ftHgAP[^Kpj
//! 
template< class Key, class Comp = std::less< Key >, class Allocator = std::allocator< Key > >
class multiset : public set_base< std::multiset< Key, Comp, Allocator > >
{
protected:
	typedef set_base< std::multiset< Key, Comp, Allocator > > base;

public:
	typedef typename base::key_type key_type;					///< @brief 
	typedef typename base::key_compare key_compare;				///< @brief 
	typedef typename base::value_compare value_compare;			///< @brief 
	typedef typename base::allocator_type allocator_type;		///< @brief STLReipAP[^^
	typedef typename base::size_type size_type;					///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename base::difference_type difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ

#if __MIST_MSVC__ != 6
	typedef typename base::pointer pointer;						///< @brief STL̃ReiɊi[f[^^̃|C^[^Dstd::set< data > ̏ꍇCdata * ƂȂ
	typedef typename base::const_pointer const_pointer;			///< @brief STL̃ReiɊi[f[^^ const |C^[^Dstd::set< data > ̏ꍇCconst data * ƂȂ
#endif

	typedef typename base::reference reference;								///< @brief STL̃ReiɊi[f[^^̎QƁDstd::set< data > ̏ꍇCdata & ƂȂ
	typedef typename base::const_reference const_reference;					///< @brief STL̃ReiɊi[f[^^ const QƁDstd::set< data > ̏ꍇCconst data & ƂȂ
	typedef typename base::iterator iterator;								///< @brief STL̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef typename base::const_iterator const_iterator;					///< @brief STL̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef typename base::reverse_iterator reverse_iterator;				///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef typename base::const_reverse_iterator const_reverse_iterator;	///< @brief STL̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef typename base::value_type value_type;							///< @brief STL̃ReiɊi[f[^^Dstd::set< data >  data Ɠ

public:
	/// @brief ftHgRXgN^iW쐬j
	multiset( ) : base( ){ }

	/// @brief W̗vf̔rZqƂ pred p
	explicit multiset( const key_compare &pred ) : base( pred ){ }

	/// @brief 1vf key W쐬
	explicit multiset( const key_type &key ) : base( ){ base::insert( key ); }

	/// @brief W̗vf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	multiset( const key_compare &pred, const allocator_type &alloc ) : base( pred, alloc ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬
	template< class Iterator >
	multiset( Iterator first, Iterator last ) : base( first, last ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred p
	template< class Iterator >
	multiset( Iterator first, Iterator last, const key_compare &pred ) : base( first, last, pred ){ }

	/// @brief first  last ̊Ԃ̗vfpďW쐬Cvf̔rZqƂ pred pCalloc ̃Rs[𗘗p
	template< class Iterator >
	multiset( Iterator first, Iterator last, const key_compare &pred, const allocator_type &alloc ) : base( first, last, pred, alloc ){ }
};



/// @}
//  WZO[v̏I



// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_SET_H__
