// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

// generated by Fast Light User Interface Designer (fluid) version 1.0106

#include "image_test_window.h"

inline void image_test_window::cb_Open_i(Fl_Menu_*, void*) {
  const char *filename = fl_file_chooser( "Open Image", "Image File (*.{jpg,jpeg,bmp,tif,tiff,png,gif,pbm,pgm,ppm,pnm,tga})", "" );
if( filename == NULL ) return;

read_image_test( filename );

draw_area->redraw( );
Fl::wait( 0 );
}
void image_test_window::cb_Open(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Open_i(o,v);
}

inline void image_test_window::cb_Open1_i(Fl_Menu_*, void*) {
  const char *filename = fl_file_chooser( "Open DICOM", "DICOM File (*)", "" );
if( filename == NULL ) return;

read_dicom_test( filename );

draw_area->redraw( );
Fl::wait( 0 );
}
void image_test_window::cb_Open1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Open1_i(o,v);
}

inline void image_test_window::cb_Save_i(Fl_Menu_*, void*) {
  const char *filename = fl_file_chooser( "Save Image", "Image File (*.{jpg,jpeg,bmp,tif,tiff,png,gif,pbm,pgm,ppm,pnm,tga})", "" );
if( filename == NULL ) return;

write_image_test( filename );

draw_area->redraw( );
Fl::wait( 0 );
}
void image_test_window::cb_Save(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Save_i(o,v);
}

inline void image_test_window::cb_Save1_i(Fl_Menu_*, void*) {
  const char *filename = fl_file_chooser( "Save DICOM", "DICOM File (*)", "" );
if( filename == NULL ) return;

write_dicom_test( filename );

draw_area->redraw( );
Fl::wait( 0 );
}
void image_test_window::cb_Save1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Save1_i(o,v);
}

inline void image_test_window::cb_Exit_i(Fl_Menu_*, void*) {
  main_window->hide( );
}
void image_test_window::cb_Exit(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Exit_i(o,v);
}

inline void image_test_window::cb_Euclidean_i(Fl_Menu_*, void*) {
  euclidean_distance_transform_test( );
}
void image_test_window::cb_Euclidean(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Euclidean_i(o,v);
}

inline void image_test_window::cb_Euclidean1_i(Fl_Menu_*, void*) {
  euclidean_distance_skeleton_test( );
}
void image_test_window::cb_Euclidean1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Euclidean1_i(o,v);
}

inline void image_test_window::cb_Figure_i(Fl_Menu_*, void*) {
  figure_decomposition_test( );
}
void image_test_window::cb_Figure(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Figure_i(o,v);
}

inline void image_test_window::cb_Thresholding_i(Fl_Menu_*, void*) {
  thresholding_test( );
}
void image_test_window::cb_Thresholding(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Thresholding_i(o,v);
}

inline void image_test_window::cb_Labeling_i(Fl_Menu_*, void*) {
  labeling4_test( );
}
void image_test_window::cb_Labeling(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Labeling_i(o,v);
}

inline void image_test_window::cb_Labeling1_i(Fl_Menu_*, void*) {
  labeling8_test( );
}
void image_test_window::cb_Labeling1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Labeling1_i(o,v);
}

inline void image_test_window::cb_Thinning_i(Fl_Menu_*, void*) {
  thinning_test( );
}
void image_test_window::cb_Thinning(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Thinning_i(o,v);
}

inline void image_test_window::cb_Median_i(Fl_Menu_*, void*) {
  median_test( );
}
void image_test_window::cb_Median(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Median_i(o,v);
}

inline void image_test_window::cb_Mode_i(Fl_Menu_*, void*) {
  mode_test( );
}
void image_test_window::cb_Mode(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Mode_i(o,v);
}

inline void image_test_window::cb_Erosion_i(Fl_Menu_*, void*) {
  erosion_test( );
}
void image_test_window::cb_Erosion(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Erosion_i(o,v);
}

inline void image_test_window::cb_Dilation_i(Fl_Menu_*, void*) {
  dilation_test( );
}
void image_test_window::cb_Dilation(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Dilation_i(o,v);
}

inline void image_test_window::cb_Opening_i(Fl_Menu_*, void*) {
  opening_test( );
}
void image_test_window::cb_Opening(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Opening_i(o,v);
}

inline void image_test_window::cb_Closing_i(Fl_Menu_*, void*) {
  closing_test( );
}
void image_test_window::cb_Closing(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Closing_i(o,v);
}

inline void image_test_window::cb_Erosion1_i(Fl_Menu_*, void*) {
  erosion_triangle_test( );
}
void image_test_window::cb_Erosion1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Erosion1_i(o,v);
}

inline void image_test_window::cb_Dilation1_i(Fl_Menu_*, void*) {
  dilation_triangle_test( );
}
void image_test_window::cb_Dilation1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Dilation1_i(o,v);
}

inline void image_test_window::cb_Opening1_i(Fl_Menu_*, void*) {
  opening_triangle_test( );
}
void image_test_window::cb_Opening1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Opening1_i(o,v);
}

inline void image_test_window::cb_Closing1_i(Fl_Menu_*, void*) {
  closing_triangle_test( );
}
void image_test_window::cb_Closing1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Closing1_i(o,v);
}

inline void image_test_window::cb_Reso_i(Fl_Menu_*, void*) {
  interpolate_test( 0, true );
}
void image_test_window::cb_Reso(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso_i(o,v);
}

inline void image_test_window::cb_Reso1_i(Fl_Menu_*, void*) {
  interpolate_test( 1, true );
}
void image_test_window::cb_Reso1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso1_i(o,v);
}

inline void image_test_window::cb_Reso2_i(Fl_Menu_*, void*) {
  interpolate_test( 2, true );
}
void image_test_window::cb_Reso2(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso2_i(o,v);
}

inline void image_test_window::cb_Reso3_i(Fl_Menu_*, void*) {
  interpolate_test( 3, true );
}
void image_test_window::cb_Reso3(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso3_i(o,v);
}

inline void image_test_window::cb_Reso4_i(Fl_Menu_*, void*) {
  interpolate_test( 4, true );
}
void image_test_window::cb_Reso4(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso4_i(o,v);
}

inline void image_test_window::cb_Reso5_i(Fl_Menu_*, void*) {
  interpolate_test( 5, true );
}
void image_test_window::cb_Reso5(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso5_i(o,v);
}

inline void image_test_window::cb_Reso6_i(Fl_Menu_*, void*) {
  interpolate_test( 0, false );
}
void image_test_window::cb_Reso6(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso6_i(o,v);
}

inline void image_test_window::cb_Reso7_i(Fl_Menu_*, void*) {
  interpolate_test( 1, false );
}
void image_test_window::cb_Reso7(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso7_i(o,v);
}

inline void image_test_window::cb_Reso8_i(Fl_Menu_*, void*) {
  interpolate_test( 2, false );
}
void image_test_window::cb_Reso8(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso8_i(o,v);
}

inline void image_test_window::cb_Reso9_i(Fl_Menu_*, void*) {
  interpolate_test( 3, false );
}
void image_test_window::cb_Reso9(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Reso9_i(o,v);
}

inline void image_test_window::cb_Resoa_i(Fl_Menu_*, void*) {
  interpolate_test( 4, false );
}
void image_test_window::cb_Resoa(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Resoa_i(o,v);
}

inline void image_test_window::cb_Resob_i(Fl_Menu_*, void*) {
  interpolate_test( 5, false );
}
void image_test_window::cb_Resob(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Resob_i(o,v);
}

inline void image_test_window::cb_Interlace_i(Fl_Menu_*, void*) {
  interlace_test( false );
}
void image_test_window::cb_Interlace(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Interlace_i(o,v);
}

inline void image_test_window::cb_Interlace1_i(Fl_Menu_*, void*) {
  interlace_test( true );
}
void image_test_window::cb_Interlace1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Interlace1_i(o,v);
}

inline void image_test_window::cb_Expand_i(Fl_Menu_*, void*) {
  expand_test( );
}
void image_test_window::cb_Expand(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Expand_i(o,v);
}

inline void image_test_window::cb_Shrink_i(Fl_Menu_*, void*) {
  shrink_test( );
}
void image_test_window::cb_Shrink(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Shrink_i(o,v);
}

inline void image_test_window::cb_Boundary_i(Fl_Menu_*, void*) {
  boundary4_test( );
}
void image_test_window::cb_Boundary(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Boundary_i(o,v);
}

inline void image_test_window::cb_Boundary1_i(Fl_Menu_*, void*) {
  boundary8_test( );
}
void image_test_window::cb_Boundary1(Fl_Menu_* o, void* v) {
  ((image_test_window*)(o->parent()->user_data()))->cb_Boundary1_i(o,v);
}

Fl_Menu_Item image_test_window::menu_[] = {
 {"&File", 0,  0, 0, 64, 0, 0, 14, 56},
 {"&Open", 0,  0, 0, 64, 0, 0, 14, 56},
 {"Open &Image", 0,  (Fl_Callback*)image_test_window::cb_Open, 0, 0, 0, 0, 14, 56},
 {"Open &DICOM", 0,  (Fl_Callback*)image_test_window::cb_Open1, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"&Save", 0,  0, 0, 192, 0, 0, 14, 56},
 {"Save &Image", 0,  (Fl_Callback*)image_test_window::cb_Save, 0, 0, 0, 0, 14, 56},
 {"Save &DICOM", 0,  (Fl_Callback*)image_test_window::cb_Save1, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"&Exit", 0,  (Fl_Callback*)image_test_window::cb_Exit, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"&Edit", 0,  0, 0, 64, 0, 0, 14, 56},
 {"Euclidean Distance Transform", 0,  (Fl_Callback*)image_test_window::cb_Euclidean, 0, 0, 0, 0, 14, 56},
 {"Euclidean Skeleton", 0,  (Fl_Callback*)image_test_window::cb_Euclidean1, 0, 0, 0, 0, 14, 56},
 {"Figure Decomposition", 0,  (Fl_Callback*)image_test_window::cb_Figure, 0, 0, 0, 0, 14, 56},
 {"Thresholding", 0,  (Fl_Callback*)image_test_window::cb_Thresholding, 0, 0, 0, 0, 14, 56},
 {"Labeling 4", 0,  (Fl_Callback*)image_test_window::cb_Labeling, 0, 0, 0, 0, 14, 56},
 {"Labeling 8", 0,  (Fl_Callback*)image_test_window::cb_Labeling1, 0, 0, 0, 0, 14, 56},
 {"Thinning", 0,  (Fl_Callback*)image_test_window::cb_Thinning, 0, 0, 0, 0, 14, 56},
 {"Median", 0,  (Fl_Callback*)image_test_window::cb_Median, 0, 0, 0, 0, 14, 56},
 {"Mode", 0,  (Fl_Callback*)image_test_window::cb_Mode, 0, 0, 0, 0, 14, 56},
 {"Morphology", 0,  0, 0, 64, 0, 0, 14, 56},
 {"Erosion Circle", 0,  (Fl_Callback*)image_test_window::cb_Erosion, 0, 0, 0, 0, 14, 56},
 {"Dilation Circle", 0,  (Fl_Callback*)image_test_window::cb_Dilation, 0, 0, 0, 0, 14, 56},
 {"Opening Circle", 0,  (Fl_Callback*)image_test_window::cb_Opening, 0, 0, 0, 0, 14, 56},
 {"Closing Circle", 0,  (Fl_Callback*)image_test_window::cb_Closing, 0, 0, 0, 0, 14, 56},
 {"Erosion Triangle", 0,  (Fl_Callback*)image_test_window::cb_Erosion1, 0, 0, 0, 0, 14, 56},
 {"Dilation Triangle", 0,  (Fl_Callback*)image_test_window::cb_Dilation1, 0, 0, 0, 0, 14, 56},
 {"Opening Triangle", 0,  (Fl_Callback*)image_test_window::cb_Opening1, 0, 0, 0, 0, 14, 56},
 {"Closing Triangle", 0,  (Fl_Callback*)image_test_window::cb_Closing1, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"Resolution", 0,  0, 0, 64, 0, 0, 14, 56},
 {"Reso up with nearest", 0,  (Fl_Callback*)image_test_window::cb_Reso, 0, 0, 0, 0, 14, 56},
 {"Reso up with mean", 0,  (Fl_Callback*)image_test_window::cb_Reso1, 0, 0, 0, 0, 14, 56},
 {"Reso up with linear", 0,  (Fl_Callback*)image_test_window::cb_Reso2, 0, 0, 0, 0, 14, 56},
 {"Reso up with cubic", 0,  (Fl_Callback*)image_test_window::cb_Reso3, 0, 0, 0, 0, 14, 56},
 {"Reso up with sinc", 0,  (Fl_Callback*)image_test_window::cb_Reso4, 0, 0, 0, 0, 14, 56},
 {"Reso up with bspline", 0,  (Fl_Callback*)image_test_window::cb_Reso5, 0, 0, 0, 0, 14, 56},
 {"Reso down with nearest", 0,  (Fl_Callback*)image_test_window::cb_Reso6, 0, 0, 0, 0, 14, 56},
 {"Reso down with mean", 0,  (Fl_Callback*)image_test_window::cb_Reso7, 0, 0, 0, 0, 14, 56},
 {"Reso down with linear", 0,  (Fl_Callback*)image_test_window::cb_Reso8, 0, 0, 0, 0, 14, 56},
 {"Reso down with cubic", 0,  (Fl_Callback*)image_test_window::cb_Reso9, 0, 0, 0, 0, 14, 56},
 {"Reso down with sinc", 0,  (Fl_Callback*)image_test_window::cb_Resoa, 0, 0, 0, 0, 14, 56},
 {"Reso down with bspline", 0,  (Fl_Callback*)image_test_window::cb_Resob, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"Interlace Even", 0,  (Fl_Callback*)image_test_window::cb_Interlace, 0, 0, 0, 0, 14, 56},
 {"Interlace Odd", 0,  (Fl_Callback*)image_test_window::cb_Interlace1, 0, 0, 0, 0, 14, 56},
 {"Expand", 0,  (Fl_Callback*)image_test_window::cb_Expand, 0, 0, 0, 0, 14, 56},
 {"Shrink", 0,  (Fl_Callback*)image_test_window::cb_Shrink, 0, 0, 0, 0, 14, 56},
 {"Boundary 4", 0,  (Fl_Callback*)image_test_window::cb_Boundary, 0, 0, 0, 0, 14, 56},
 {"Boundary 8", 0,  (Fl_Callback*)image_test_window::cb_Boundary1, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

image_test_window::image_test_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = main_window = new Fl_Double_Window(551, 568);
    w = o;
    o->user_data((void*)(this));
    { Fl_Group* o = new Fl_Group(5, 30, 540, 530);
      o->box(FL_DOWN_BOX);
      { image_draw_area* o = draw_area = new image_draw_area(10, 35, 530, 520, "label");
        o->box(FL_FLAT_BOX);
        o->color((Fl_Color)40);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_BLACK);
        o->align(FL_ALIGN_CENTER);
        o->when(FL_WHEN_RELEASE);
      }
      o->end();
    }
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(0, 0, 550, 30);
      o->box(FL_FLAT_BOX);
      o->menu(menu_);
    }
    { Fl_Progress* o = progress_bar = new Fl_Progress(125, 5, 420, 20);
      o->box(FL_PLASTIC_THIN_UP_BOX);
      o->selection_color((Fl_Color)1);
      o->hide();
    }
    o->end();
  }
}

void image_test_window::show( ) {
  main_window->show( );
}
