// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/bitmap.h
//!
//! @brief WindowsSʂŗprbg}bv摜Rei
//!

#ifndef __INCLUDE_BITMAP_H__
#define __INCLUDE_BITMAP_H__


#ifndef __INCLUDE_MIST_CONF_H__
#include "config/mist_conf.h"
#endif

#ifndef __INCLUDE_MIST_H__
#include "mist.h"
#endif

#ifndef __INCLUDE_MIST_COLOR_H__
#include "config/color.h"
#endif



// mistOԂ̎n܂
_MIST_BEGIN

template < size_t BITS >
struct bitmap_type
{
	typedef bgr< unsigned char > value_type;
};

template < >
struct bitmap_type< 8 >
{
	typedef unsigned char value_type;
};


/// @brief vfς̃rbg}bv摜NX
//! 
//! 2摜߂̊{NX
//! i@ref mist/bitmap.h CN[hj
//! 
//! @attention MISTŒ񋟂قƂǂ̃ASYɑ΂Ė{Rei𒼐ڗp邱Ƃ͂ł܂D
//! @attention MIST̃ASY𗘗pꍇ́C @ref mist::convert ̃Ro[g֐𗘗pāCarray2 ^ɕϊĂsĂD
//! 
//! @param BITS      c rbg}bvŗp1f̃rbgi24rbg32rbĝ݂T|[gj
//! @param Allocator c MISTReipAP[^^Dȗꍇ́CSTL̃ftHgAP[^gp
//! 
template < size_t BITS, class Allocator = std::allocator< unsigned char > >
class bitmap : public array< unsigned char, Allocator >
{
public:
	typedef typename bitmap_type< BITS >::value_type value_type;	///< @brief f[^^
	typedef value_type* pointer;									///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef value_type& reference;									///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const value_type& const_reference;						///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef const value_type* const_pointer;						///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ


protected:
	typedef array< unsigned char, Allocator > base;		///< @brief NX
	size_type size1_;									///< @brief X̗vf
	size_type size2_;									///< @brief Y̗vf
	size_type nbytes_;									///< @brief Ps̃oCg

	/// @brief Pf\̂ɗpoCg
	static size_type pixel_bytes( )
	{
		return( BITS / 8 );
	}

	/// @brief PsɎgpoCg
	static size_type num_bytes( size_type width )
	{
		width = width * pixel_bytes( );
		if( width % 4 > 0 )
		{
			width += 4 - ( width % 4 );
		}
		return( width );
	}

public:
	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ~ num2 ɕύXCvfύXꂽꍇ̂ݑSĂ̗vflftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! @param[in] dmy1 c _~[ϐigpȂj
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1, size_type num2, size_type dmy1 = 0 )
	{
		nbytes_ = num_bytes( num1 );
		if( base::resize( nbytes_ * num2 ) )
		{
			size1_ = num1;
			size2_ = num2;
			return( true );
		}
		else
		{
			size1_ = size2_ = nbytes_ = 0;
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[in] x c g~OX̊Jnʒui[n܂CfbNXj
	//! @param[in] y c g~OY̊Jnʒui[n܂CfbNXj
	//! @param[in] w c g~OX̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in] h c g~OY̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( size_type x, size_type y, difference_type w = -1, difference_type h = -1 )
	{
		difference_type w_ = width( );
		difference_type h_ = height( );
		if( w_ <= static_cast< difference_type >( x ) || w_ < static_cast< difference_type >( x + w ) )
		{
			return( false );
		}
		else if( h_ <= static_cast< difference_type >( y ) || h_ < static_cast< difference_type >( y + h ) )
		{
			return( false );
		}
		else if( w_ == w && h_ == h )
		{
			return( true );
		}

		if( w < 0 )
		{
			w = w_ - x;
		}
		if( h < 0 )
		{
			h = h_ - y;
		}


		if( base::is_memory_shared( ) )
		{
			// O𗘗pĂꍇ
			bitmap o( *this );
			if( resize( w, h ) )
			{
				for( difference_type j = 0 ; j < h ; j++ )
				{
					for( difference_type i = 0 ; i < w ; i++ )
					{
						operator ()( i, j ) = o( i + x, j + y );
					}
				}
			}
			else
			{
				return( false );
			}
		}
		else
		{
			bitmap o( w, h );
			for( difference_type j = 0 ; j < h ; j++ )
			{
				for( difference_type i = 0 ; i < w ; i++ )
				{
					o( i, j ) = operator ()( i + x, j + y );
				}
			}

			swap( o );
		}

		return( true );
	}


	/// @brief ReȋSĂ̓eւD
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( bitmap &a )
	{
		if( base::swap( a ) )
		{
			size_type _dmy_size1 = size1_;
			size_type _dmy_size2 = size2_;
			size1_ = a.size1_;
			size2_ = a.size2_;
			a.size1_ = _dmy_size1;
			a.size2_ = _dmy_size2;
			return( true );
		}
		else
		{
			return( false );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		base::clear( );
		size1_ = size2_ = 0;
	}


	size_type size1( )  const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( )  const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type width( )  const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ

	size_type size( ) const { return( size1_ * size2_ ); }			///< @brief ReiɊi[Ăf[^Ԃ

public:
	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray< data >  datajقȂꍇ̑sD
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < size_t BBITS, class AAlocator >
	const bitmap& operator =( const bitmap< BBITS, AAlocator > &o )
	{
		if( resize( o.size1( ), o.size2( ) ) )
		{
			for( size_type j = 0 ; j < size2_ ; j++ )
			{
				for( size_type i = 0 ; i < size1_ ; i++ )
				{
					operator ()( i, j ) = o( i, j );
				}
			}
		}

		return( *this );
	}


	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray< data >  datajقȂꍇ̑sD
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class TT, class AAlocator >
	const bitmap& operator =( const array2< TT, AAlocator > &o )
	{
		if( resize( o.size1( ), o.size2( ) ) )
		{
			for( size_type j = 0 ; j < size2_ ; j++ )
			{
				for( size_type i = 0 ; i < size1_ ; i++ )
				{
					operator ()( i, j ) = o( i, j );
				}
			}
		}

		return( *this );
	}


	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	const bitmap& operator =( const bitmap &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );
		size1_ = o.size1_;
		size2_ = o.size2_;

		return( *this );
	}

// vfւ̃ANZX
protected:
	/// @brief index Ŏʒu̗vf̃|C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	pointer paccess( size_type i, size_type j )
	{
		return( reinterpret_cast< pointer >( base::data_ + i * pixel_bytes( ) + j * nbytes_ ) );
	}

	/// @brief index Ŏʒu̗vf const |C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	const_pointer paccess( size_type i, size_type j ) const
	{
		return( reinterpret_cast< const_pointer >( base::data_ + i * pixel_bytes( ) + j * nbytes_ ) );
	}

public:
	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator []( size_type index )
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		size_type j = index / size1_;
		size_type i = index - j * size1_;
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator []( size_type index ) const
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		size_type j = index / size1_;
		size_type i = index - j * size1_;
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvfQ
	//!
	reference at( size_type i, size_type j, size_type dmy = 0 )
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( size_type i, size_type j, size_type dmy = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( size_type i, size_type j, size_type dmy = 0 )
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( size_type i, size_type j, size_type dmy = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( reinterpret_cast< reference >( base::data_[ i * pixel_bytes( ) + j * nbytes_ ] ) );
	}


public:
	/// @brief fBtHgRXgN^Dvf 0C𑜓x 1.0 ~ 1.0 ̃Rei쐬
	bitmap( ) : base( ), size1_( 0 ), size2_( 0 ), nbytes_( 0 ) {}

	/// @brief AP[^ a ̃Rs[𗘗p
	explicit bitmap( const Allocator &a ) : base( a ), size1_( 0 ), size2_( 0 ), nbytes_( 0 ) {}

	/// @brief vf num1 ~ num2 ̃Rei쐬CftHglŗvf
	bitmap( size_type num1, size_type num2 ) : base( num_bytes( num1 ) * num2 ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) ) size1_ = size2_ = nbytes_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬CgpAP[^ a ɐݒ肷
	bitmap( size_type num1, size_type num2, const Allocator &a ) : base( num_bytes( num1 ) * num2, a ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) ) size1_ = size2_ = nbytes_ = 0;
	}


	/// @brief vf num1 ~ num2 ̃Rei쐬CSvf val ŏ
	bitmap( size_type num1, size_type num2, const value_type &val ) : base( num_bytes( num1 ) * num2, val ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) ) size1_ = size2_ = nbytes_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬CSvf val ŏCgpAP[^ a ɐݒ肷
	bitmap( size_type num1, size_type num2, const value_type &val, const Allocator &a ) : base( num_bytes( num1 ) * num2, val, a ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) ) size1_ = size2_ = nbytes_ = 0;
	}


	/// @brief ptr ẅɁCvf num1 ~ num2 ̃Rei쐬iptr w̗p\ȃʂ mem_available j
	bitmap( size_type num1, size_type num2, void *ptr, size_type mem_available ) : base( num_bytes( num1 ) * num2, reinterpret_cast< unsigned char * >( ptr ), mem_available ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) ) size1_ = size2_ = nbytes_ = 0;
	}

	/// @brief ptr ẅɁCvf num1 ~ num2 ̃Rei쐬CSvf val ŏiptr w̗p\ȃʂ mem_available j
	bitmap( size_type num1, size_type num2, const value_type &val, void *ptr, size_type mem_available ) : base( num_bytes( num1 ) * num2, reinterpret_cast< unsigned char * >( ptr ), mem_available ), size1_( num1 ), size2_( num2 ), nbytes_( num_bytes( num1 ) )
	{
		if( base::empty( ) )
		{
			size1_ = size2_ = nbytes_ = 0;
		}
		else
		{
			for( size_type j = 0 ; j < size2_ ; j++ )
			{
				for( size_type i = 0 ; i < size1_ ; i++ )
				{
					operator ()( i, j ) = val;
				}
			}
		}
	}


	/// @brief  bitmap zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < size_t BBITS, class AAlocator >
	bitmap( const bitmap< BBITS, AAlocator > &o ) : base( ), size1_( 0 ), size2_( 0 ), nbytes_( 0 )
	{
		if( resize( o.size1( ), o.size2( ) ) )
		{
			for( size_type j = 0 ; j < size2( ) ; j++ )
			{
				for( size_type i = 0 ; i < size1( ) ; i++ )
				{
					operator ()( i, j ) = o( i, j );
				}
			}
		}
	}


	/// @brief  array2 zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < class TT, class AAlocator >
	bitmap( const array2< TT, AAlocator > &o ) : base( ), size1_( 0 ), size2_( 0 ), nbytes_( 0 )
	{
		if( resize( o.size1( ), o.size2( ) ) )
		{
			for( size_type j = 0 ; j < size2( ) ; j++ )
			{
				for( size_type i = 0 ; i < size1( ) ; i++ )
				{
					operator ()( i, j ) = o( i, j );
				}
			}
		}
	}

	/// @brief  bitmap zœvf^̂̂pď
	bitmap( const bitmap< BITS, Allocator > &o ) : base( o ), size1_( o.size1_ ), size2_( o.size2_ ), nbytes_( o.nbytes_ ) {}
};



/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     a   c bitmap z
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, 3, 4
//! 5, 6, 7, 8
//! 9, 10, 11, 12
//! @endcode
//! 
template < size_t BITS, class Allocator >
inline std::ostream &operator <<( std::ostream &out, const bitmap< BITS, Allocator > &a )
{
	typename bitmap< BITS, Allocator >::size_type i, j;
	for( j = 0 ; j < a.size2( ) ; j++ )
	{
		if( j != 0 )
		{
			out << std::endl;
		}
		for( i = 0 ; i < a.size1( ) ; i++ )
		{
			out << a( i, j );
			if( i != a.size1( ) - 1 ) out << ", ";
		}
	}

	return( out );
}



// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_H__
