/****************************************************************************


****************************************************************************/

#ifndef QP3DPLOT_H
#define QP3DPLOT_H

#include <qgl.h>

#include<vector.h>
using std::vector;

#include "../generic/P3DPlot.h"

class QP3DPlot : public QGLWidget, public Carpenter
{
    Q_OBJECT

public:

    QP3DPlot( QWidget* parent, const char* name="" );
    ~QP3DPlot();

public slots:
  /*
    void		setXRotation( int degrees );
    void		setYRotation( int degrees );
  */
    void		setZRotation( int degrees );

 void                ToggleAutoRotate () {SetAutoRotate (!mAutoRotate);}; 

    void                SetAutoRotate (bool inBool) {mAutoRotate = inBool;}; 
 
    void             MakeDemoPlot (int);
    P3DPlot mPPlot;
protected:

    enum EMode {
      kMode_None,
      kMode_Line,
      kMode_Rect
    };

    void		initializeGL();
    void		paintGL();
    void		resizeGL( int w, int h );

    virtual GLuint 	makeObject();

    void timerEvent( QTimerEvent * );
private:
    void MakeLine (const PVertex &inVertex1, const PVertex &inVertex2);
    void MakePolygon (const vector<PVertex> &inVertices);
    void SetColor (int inR, int inG, int inB);
    void SetSurfaceNormal (const PVertex &inVertex);
    void Finish ();

    void AddVertex (const PVertex &inVertex);

    void SetMode (EMode inMode);

    GLuint mObject;
    GLfloat mZRot, mScale;
    EMode mMode;
    bool mAutoRotate;
};


#endif
