/***************************************************************************
              CocoaPainter.h  - Cocoa (Mac OS X) class for painting
                             -------------------
    begin                : Thu Oct 17 21:59:18 CEST 2002
    copyright            : (C) 2002 by Pier Philipsen
    email                : pier@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#import <Cocoa/Cocoa.h>
#import "PPlot.h"
#import "PPlotInteraction.h"


class CocoaPainter : public Painter {

  public:

    /** constructor */
    CocoaPainter(NSView *view=0);

    /** destructor */
    virtual ~CocoaPainter();

    /** Painter interface */
    virtual void DrawLine (float inX1, float inY1, float inX2, float inY2);
    virtual void InvertRect (int inX, int inY, int inW, int inH);
    virtual void FillRect (int inX, int inY, int inW, int inH);
    virtual void SetClipRect (int inX, int inY, int inW, int inH);
    virtual void SetLineColor (int, int, int);
    virtual void SetFillColor (int, int, int);
    virtual long GetWidth () const;
    virtual long GetHeight () const;
    virtual long GetFontHeight () const;
    virtual long CalculateTextDrawSize (const char *inString);
    virtual void DrawText (int inX, int inY, const char *inString);
    virtual void DrawRotatedText (int inX, int inY, float inDegrees, const char *inString);
    virtual void SetStyle (const PStyle &inStyle);
    
    void paint(void);

    /** Publicly accessible members */
    PPlot mPPlot;
    NSView *mView;
    
    DefaultInteractionContainer mInteractionContainer;

  protected:

    NSColor *mLineColor, *mFillColor;
    NSFont *mFont;
     
};
