/****************************************************************************************************************************
**       MIST ( Media Integration Standard Toolkit )
**
**        We defined following template classes.
**
**          array  : template class of one dimensionl array with STL support.
**          array1 : template class of one dimensionl array containing resolution.
**          array2 : template class of two dimensionl array containing pixel resolution.
**          array3 : template class of three dimensionl array containing voxel resolution.
**          matrix : template class of matrix with its operations, and impremented using expression template technique.
**          vector : template class of vector with its operations, and impremented using expression template technique.
**
**
**         We developed these programs since 2003/09/05.
**
**             $LastChangedDate::                      $
**             $LastChangedRevision$
**             $LastChangedBy$
**             $HeadURL$
**
**
**              Copyright MIST Project Team.
**                    All Rights Reserved.
**
****************************************************************************************************************************/

// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 


/// @file mist/mist.h
//!
//! @brief MIST̊{ƂȂ鉹E摜Rei
//!
//! MISTŒ񋟂SẴASYŗpReiiSTLj̏W܂łD
//! {Iɂ́CSTLiStandard Template LibraryjŒ񋟂ĂReiƂقڌ݊Ă܂D
//! ƂẮCReĩf[^̓ԏŘAƂȂ悤ɎĂ܂D
//! āCSTL̃ASYŗpCe[^̓C_ANZXCe[^Ă܂D
//! Ce[^̏ڍׂɊւẮCSTL̉{ɏ܂D
//! ܂CMIST̃Reił͑gݍ݌^ƃ[U[`^ŁCp郁ʂĂ܂D
//! 邱ƂŁCReȋŎ኱Ȏs\ƂȂĂ܂D
//!
//! MISTvWFNgŒ񋟂ReíCȉ̍v6̃Reiō\Ă܂D
//!
//! - 1ziSTL1zpReij
//! - 𑜓xt1zievf̉𑜓x̃f[^ێCႦ1mmȂǁj
//! - 𑜓xt2z
//! - 𑜓xt3z
//! - s
//! - xNg
//!

#ifndef __INCLUDE_MIST_H__
#define __INCLUDE_MIST_H__


#ifndef __INCLUDE_MIST_CONF_H__
#include "config/mist_conf.h"
#endif


#ifndef __INCLUDE_MIST_ALLOC_H__
#include "config/mist_alloc.h"
#endif

#ifndef __INCLUDE_MIST_ITERATOR_H__
#include "config/iterator.h"
#endif



// mistOԂ̎n܂
_MIST_BEGIN



/// @brief vfς1z
//! 
//! SĂMISTRei̊{ƂȂNX
//! i@ref mist/mist.h CN[hj
//! 
//! @param T         c MIST̃ReiɊi[f[^^
//! @param Allocator c MISTReipAP[^^Dȗꍇ́CSTL̃ftHgAP[^gp
//! 
template < class T, class Allocator = std::allocator< T > >
class array
{
public:
	typedef Allocator allocator_type;								///< @brief MISTReipAP[^^
	typedef typename Allocator::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Allocator::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Allocator::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Allocator::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Allocator::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	/// @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef mist_iterator1< T, ptrdiff_t, pointer, reference > iterator;

	/// @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > const_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, pointer, reference > > reverse_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > > const_reverse_iterator;

	/// @brief f[^^̕ϊs
	template < class TT, class AAllocator = std::allocator< TT > > 
	struct rebind
	{
		typedef array< TT, AAllocator > other;
	};


protected:
	mist_allocator< T, Allocator > allocator_;		///< @brief eReiŗpAP[^IuWFNg

private:
	size_type size_;								///< @brief ReiɊi[Ăvf

protected:
	T* data_;	///< @brief Reiňf[^̐擪\|C^

public:
	/// @brief Rei̗vfύX
	//! 
	//! ReĩTCY num ɕύXD
	//! ̃ReiTCYƈقȂꍇ́CIɃTCY𒲐D
	//! vfύXꂽꍇ̂ݑSĂ̗vf̒l̓ftHgRXgN^ŏD
	//! ܂Cgݍ݌^iint  double Ȃǁj̏ꍇ́CSĂ̗vf0ŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! @param[in] num  c TCỸRei̗vf
	//! @param[in] dmy1 c _~[ϐigpȂj
	//! @param[in] dmy2 c _~[ϐigpȂj
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num, size_type /* dmy1 */ = 0, size_type /* dmy2 */ = 0 )
	{
		if( size_ < num )
		{
			allocator_.deallocate_objects( data_, size_ );
			data_ = allocator_.allocate_objects( num );
			size_ = data_ == NULL ? 0 : num;
		}
		else if( size_ > num )
		{
			data_ = allocator_.trim_objects( data_, size_, num );
			size_ = data_ == NULL ? 0 : num;
		}

		return( data_ != NULL );
	}

	/// @brief Rei̗vfg~O
	//!
	//! ̊mۂɎsC̃ReiƂȂ
	//!
	//! @param[out] out   c g~Oʂi[IuWFNgiTCY͎ŕύX܂j
	//! @param[in]  index c g~O̊Jnʒui[n܂CfbNXj
	//! @param[in]  num   c g~O̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( array &out, size_type index, difference_type num = -1 ) const
	{
		difference_type num_ = size( );
		if( num_ <= static_cast< difference_type >( index ) || num_ < static_cast< difference_type >( index + num ) )
		{
			return( false );
		}
		else if( num_ == num )
		{
			out = *this;
			return( true );
		}

		if( num < 0 )
		{
			num = size( ) - index;
		}

		if( out.resize( num ) )
		{
			allocator_.copy_objects( paccess( index ), num, out.paccess( 0 ) );
			return( true );
		}
		else
		{
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//!
	//! ̊mۂɎsC̃ReiƂȂ
	//!
	//! @param[in] index c g~O̊Jnʒui[n܂CfbNXj
	//! @param[in] num   c g~O̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( size_type index, difference_type num = -1 )
	{
		if( is_memory_shared( ) )
		{
			// O𗘗pĂꍇ
			array o( *this );
			return( o.trim( *this, index, num ) );
		}
		else
		{
			difference_type num_ = size( );
			if( num_ <= static_cast< difference_type >( index ) || num_ < static_cast< difference_type >( index + num ) )
			{
				return( false );
			}
			else if( num_ == num )
			{
				return( true );
			}
			else
			{
				array o( num );

				if( this->trim( o, index, num ) )
				{
					swap( o );

					return( true );
				}
				else
				{
					return( false );
				}
			}
		}
	}


	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( array &a )
	{
		if( is_memory_shared( ) || a.is_memory_shared( ) )
		{
			return( false );
		}
		else
		{
			size_type _dmy_size = size_;
			size_ = a.size_;
			a.size_ = _dmy_size;

			value_type *dmy_data_ = data_;
			data_ = a.data_;
			a.data_ = dmy_data_;

			return( true );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		allocator_.deallocate_objects( data_, size_ );
		size_ = 0;
		data_ = NULL;
	}


	/// @brief Reĩf[^vfftHglŏ
	//! 
	//! ftHgRXgN^̒lŏD
	//! gݍ݌^iint  double Ȃǁj̏ꍇ́CSĂ̗vf0ŏD
	//! 
	void fill( )
	{
		allocator_.fill_objects( data_, size_ );
	}


	/// @brief Reĩf[^vfw肳ꂽlŏ
	//! 
	//! SĂ̗vfl val ŏD
	//! 
	//! @param[in] val c vfl
	//! 
	void fill( const value_type &val )
	{
		allocator_.fill_objects( data_, size_, val );
	}


	/// @brief Rei󂩂ǂ𔻒
	//! 
	//! @retval true  c Rei̗vfi0j̏ꍇ
	//! @retval false c Rei̗vfi0jłȂꍇ
	//! 
	bool empty( ) const { return( size_ == 0 ); }


	size_type size( ) const { return( size_ ); }		///< @brief ReiɊi[Ăf[^Ԃ
	size_type size1( ) const { return( size_ ); }		///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( ) const { return( 1 ); }			///< @brief ỸReiɊi[Ăf[^Ԃi1Ԃj
	size_type size3( ) const { return( 1 ); }			///< @brief Z̃ReiɊi[Ăf[^Ԃi1Ԃj
	size_type width( ) const { return( size_ ); }		///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( 1 ); }			///< @brief ỸReiɊi[Ăf[^Ԃi1Ԃj
	size_type depth( ) const { return( 1 ); }			///< @brief Z̃ReiɊi[Ăf[^Ԃi1Ԃj

	double reso1( double /* r1 */ ){ return( 1.0 ); }	///< @brief X̉𑜓xԂ
	double reso1( ) const { return( 1.0 ); }			///< @brief X̉𑜓xݒ肷
	double reso2( double /* r2 */ ){ return( 1.0 ); }	///< @brief Ỷ𑜓xԂ
	double reso2( ) const { return( 1.0 ); }			///< @brief Ỷ𑜓xݒ肷
	double reso3( double /* r3 */ ){ return( 1.0 ); }	///< @brief Z̉𑜓xԂ
	double reso3( ) const { return( 1.0 ); }			///< @brief Z̉𑜓xݒ肷j


	/// @brief Rei̗vf߂f[^ʂoCgPʂŕԂ
	size_type byte( ) const { return( size_ * sizeof( value_type ) ); }

	/// @brief OŊ蓖Ăꂽ̈gpĂ邩ǂ
	bool is_memory_shared( ) const { return( allocator_.is_memory_shared( ) ); }


	/// @brief Rei̐擪w_ANZXCe[^Ԃ
	//!
	//! @code _ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.begin( );
	//! for( ; ite1 != a.end( ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator begin( ){ return( iterator( paccess( 0 ), 1 ) ); }

	/// @brief Rei̐擪wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator begin( ) const { return( const_iterator( paccess( 0 ), 1 ) ); }


	/// @brief Rei̖w_ANZXCe[^Ԃ
	iterator end( ){ return( iterator( paccess( size( ) ), 1 ) ); }

	/// @brief Rei̖wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator end( ) const { return( const_iterator( paccess( size( ) ), 1 ) ); }



	/// @brief Rei̖wt_ANZXCe[^Ԃ
	//!
	//! @code t_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::reverse_iterator ite2 = a.rbegin( );
	//! for( ; ite2 != a.rend( ) ; ite2++ )
	//! {
	//! 	std::cout << *ite2 << " ";
	//! }
	//! std::cout << std::endl;
	//! @endcode
	//!
	reverse_iterator rbegin( ){ return( reverse_iterator( end( ) ) ); }

	/// @brief Rei̖wRXg^̃Rei𑀍삷t_ANZXCe[^Ԃ
	const_reverse_iterator rbegin( ) const { return( const_reverse_iterator( end( ) ) ); }


	/// @brief Rei̐擪wt_ANZXCe[^Ԃ
	reverse_iterator rend( ){ return( reverse_iterator( begin( ) ) ); }

	/// @brief Rei̐擪wRXg^̃Rei𑀍삷t_ANZXCe[^Ԃ
	const_reverse_iterator rend( ) const { return( const_reverse_iterator( begin( ) ) ); }


	/// @brief gpĂAP[^mۉ\ȃ̍őlԂ
	size_type max_size( ) const { return( allocator_.max_size( ) ); }



private: // T|[gȂrsk̊֐iEgpႾ߁j
	iterator erase( iterator i );
	iterator erase( iterator s, iterator e );
	iterator insert( iterator i, const value_type &val );
	void insert( iterator i, size_type num, const value_type &val );

public:
	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray< data >  datajقȂꍇ̑sD
	//! ̊mۂɎsC̃ReiƂȂ
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class TT, class AAlocator >
	const array& operator =( const array< TT, AAlocator >  &o )
	{
		if( size_ > o.size( ) )
		{
			data_ = allocator_.trim_objects( data_, size_, o.size( ) );
			size_ = data_ == NULL ? 0 : o.size( );
		}
		else if( size_ < o.size( ) )
		{
			allocator_.deallocate_objects( data_, size_ );
			data_ = allocator_.allocate_objects( o.size( ) );
			size_ = data_ == NULL ? 0 : o.size( );
		}

		if( data_ != NULL )
		{
			for( size_type i = 0 ; i < size_ ; i++ )
			{
				data_[ i ] = static_cast< value_type >( o[ i ] );
			}
		}

		return( *this );
	}

	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! ̊mۂɎsC̃ReiƂȂ
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	const array& operator =( const array  &o )
	{
		if( this == &o ) return( *this );

		// ܂CAP[^Rs[
		allocator_ = o.allocator_;

		if( size_ > o.size_ )
		{
			data_ = allocator_.trim_objects( data_, size_, o.size_ );
			size_ = data_ == NULL ? 0 : o.size( );
		}
		else if( size_ < o.size_ )
		{
			allocator_.deallocate_objects( data_, size_ );
			data_ = allocator_.allocate_objects( o.size( ) );
			size_ = data_ == NULL ? 0 : o.size( );
		}

		if( data_ != NULL )
		{
			allocator_.copy_objects( o.data_, size_, data_ );
		}

		return( *this );
	}

// Rei̗vfւ̃ANZXZq
protected:
	/// @brief index Ŏʒu̗vf̃|C^Ԃ
	//! 
	//! @param[in] index  c Rei̗vfʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	pointer paccess( size_type index )
	{
		return( data_ + index );
	}

	/// @brief index Ŏʒu̗vf const |C^Ԃ
	//! 
	//! @param[in] index  c Rei̗vfʒu
	//! 
	//! @return w肳ꂽvf const |C^
	//! 
	const_pointer paccess( size_type index ) const
	{
		return( data_ + index );
	}

public:
	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	/// @param[in] dmy1  c gpȂ
	/// @param[in] dmy2  c gpȂ
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference at( size_type index, size_type dmy1 = 0, size_type dmy2 = 0 )
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}


	/// @brief index Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	/// @param[in] dmy1  c gpȂ
	/// @param[in] dmy2  c gpȂ
	//! 
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( size_type index, size_type dmy1 = 0, size_type dmy2 = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	/// @param[in] dmy1  c gpȂ
	/// @param[in] dmy2  c gpȂ
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( size_type index, size_type dmy1 = 0, size_type dmy2 = 0 )
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}


	/// @brief index Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	/// @param[in] dmy1  c gpȂ
	/// @param[in] dmy2  c gpȂ
	//! 
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( size_type index, size_type dmy1 = 0, size_type dmy2 = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator []( size_type index )
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}


	/// @brief index Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ index LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator []( size_type index ) const
	{
		_CHECK_ACCESS_VIOLATION1U_( index )
		return( data_[ index ] );
	}

public:
	/// @brief fBtHgRXgN^Dvf 0 ̃Rei쐬
	array( ) : allocator_( ), size_( 0 ), data_( NULL ){}

	/// @brief AP[^ a ̃Rs[𗘗p
	explicit array( const Allocator &a ) : allocator_( a ), size_( 0 ), data_( NULL ){}


	/// @brief vf num ̃Rei쐬CftHglŗvf
	explicit array( size_type num ) : allocator_( ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_ );
		if( data_ == NULL ) size_ = 0;
	}
	/// @brief vf num ̃Rei쐬CAP[^ a ̃Rs[𗘗p
	array( size_type num, const Allocator &a ) : allocator_( a ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_ );
		if( data_ == NULL ) size_ = 0;
	}


	/// @brief vf num ̃Rei쐬Cl val ŏ
	array( size_type num, const value_type &val ) : allocator_( ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_, val );
		if( data_ == NULL ) size_ = 0;
	}
	/// @brief vf num ̃Rei쐬Cl val ŏCAP[^ a ̃Rs[𗘗p
	array( size_type num, const value_type &val, const Allocator &a ) : allocator_( a ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_, val );
		if( data_ == NULL ) size_ = 0;
	}


	/// @brief Ce[^ s  e ͈̔͂̒lpāCz
	array( const_iterator s, const_iterator e ) : allocator_( ), size_( e - s ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( s, e );
		if( data_ == NULL ) size_ = 0;
	}
	/// @brief Ce[^ s  e ͈̔͂̒lpāCzCAP[^ a ̃Rs[𗘗p
	array( const_iterator s, const_iterator e, const Allocator &a ) : allocator_( a ), size_( e - s ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( s, e );
		if( data_ == NULL ) size_ = 0;
	}


	/// @brief ptr ẅɁCvf num ̃Rei쐬iptr w̗p\ȃʂ mem_available j
	array( size_type num, pointer ptr, size_type mem_available ) : allocator_( ptr, mem_available ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_ );
		if( data_ == NULL ) size_ = 0;
	}
	/// @brief ptr ẅɁCvf num ̃Rei쐬l val ŏiptr w̗p\ȃʂ mem_available j
	array( size_type num, const value_type &val, pointer ptr, size_type mem_available ) : allocator_( ptr, mem_available ), size_( num ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_, val );
		if( data_ == NULL ) size_ = 0;
	}


	/// @brief  array zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < class TT, class AAlocator >
	array( const array< TT, AAlocator > &o ) : allocator_( ), size_( o.size( ) ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_ );
		if( data_ == NULL )
		{
			size_ = 0;
		}
		else
		{
			for( size_type i = 0 ; i < size_ ; i++ ) data_[i] = static_cast< value_type >( o[i] );
		}
	}

	/// @brief  array zœvf^̂̂pď
	array( const array< T, Allocator > &o ) : allocator_( o.allocator_ ), size_( o.size_ ), data_( NULL )
	{
		data_ = allocator_.allocate_objects( size_ );
		if( data_ == NULL )
		{
			size_ = 0;
		}
		else
		{
			allocator_.copy_objects( o.data_, size_, data_ );
		}
	}

	/// @brief ReipĂ郊\[XSĊJ
	~array( )
	{
		clear( );
	}
};



/// @brief vfς̉𑜓xt1z
//! 
//! ɉ߂̊{NX
//! i@ref mist/mist.h CN[hj
//! 
//! @param T         c MIST̃ReiɊi[f[^^
//! @param Allocator c MISTReipAP[^^Dȗꍇ́CSTL̃ftHgAP[^gp
//! 
template < class T, class Allocator = std::allocator< T > >
class array1 : public array< T, Allocator >
{
public:
	typedef Allocator allocator_type;								///< @brief MISTReipAP[^^
	typedef typename Allocator::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Allocator::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Allocator::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Allocator::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Allocator::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	/// @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef mist_iterator1< T, ptrdiff_t, pointer, reference > iterator;

	/// @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > const_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, pointer, reference > > reverse_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > > const_reverse_iterator;

	/// @brief f[^^̕ϊs
	template < class TT, class AAllocator = std::allocator< TT > > 
	struct rebind
	{
		typedef array1< TT, AAllocator > other;
	};

private:
	typedef array< T, Allocator > base;		///< @brief NX̕ʖ

protected:
	double reso1_;							///< @brief Rei̗vf̉𑜓xi~gȂǁj

public:
	double reso1( double r1 ){ return( reso1_ = r1 ); }											//< @brief X̉𑜓x r1 ɐݒ肵Cݒ̒lԂ
	double reso1( ) const { return( reso1_ ); }													//< @brief X̉𑜓xԂ
	void reso( double r1, double /* dmy1 */ = 1.0, double /* dmy2 */ = 1.0 ){ reso1_ = r1; }	//< @brief X̉𑜓x r1 ɐݒ肵Cݒ̒lԂ


/************************************************************************************************************
**
**      Xɑ΂鏇Et̔q
**
************************************************************************************************************/

	/// @brief X̐擪w_ANZXCe[^Ԃ
	//!
	//! @code _ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.x_begin( );
	//! for( ; ite1 != a.x_end( ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator x_begin( ){ return( base::begin( ) ); }

	/// @brief X̐擪wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator x_begin( ) const { return( base::begin( ) ); }


	/// @brief X̖w_ANZXCe[^Ԃ
	iterator x_end( ){ return( base::end( ) ); }

	/// @brief X̖wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator x_end( ) const { return( base::end( ) ); }



	/// @brief X̖wt_ANZXCe[^Ԃ
	//!
	//! @code t_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::reverse_iterator ite2 = a.x_rbegin( );
	//! for( ; ite2 != a.x_rend( ) ; ite2++ )
	//! {
	//! 	std::cout << *ite2 << " ";
	//! }
	//! std::cout << std::endl;
	//! @endcode
	//!
	reverse_iterator x_rbegin( ){ return( base::rbegin( ) ); }

	/// @brief X̖wRXg^̃Rei𑀍삷t_ANZXCe[^Ԃ
	const_reverse_iterator x_rbegin( ) const { return( base::rbegin( ) ); }


	/// @brief X̐擪wt_ANZXCe[^Ԃ
	reverse_iterator x_rend( ){ return( base::rend( ) ); }

	/// @brief X̐擪wRXg^̃Rei𑀍삷t_ANZXCe[^Ԃ
	const_reverse_iterator x_rend( ) const { return( base::rend( )  ); }


public: // zɑ΂鑀

	/// @brief Rei̗vfg~O
	//! 
	//! @param[out] out   c g~Oʂi[IuWFNgiTCY͎ŕύX܂j
	//! @param[in]  index c g~O̊Jnʒui[n܂CfbNXj
	//! @param[in]  num   c g~O̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( array1 &out, size_type index, difference_type num = -1 ) const
	{
		if( base::trim( out, index, num ) )
		{
			out.reso( reso1( ) );
			return( true );
		}
		else
		{
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[in] index c g~O̊Jnʒui[n܂CfbNXj
	//! @param[in] num   c g~O̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( size_type index, difference_type num = -1 )
	{
		double r = reso1( );
		if( base::trim( index, num ) )
		{
			reso( r );
			return( true );
		}
		else
		{
			return( false );
		}
	}


	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( array1 &a )
	{
		if( base::swap( a ) )
		{
			double dmy_reso1_ = reso1_;
			reso1_ = a.reso1_;
			a.reso1_ = dmy_reso1_;
			return( true );
		}
		else
		{
			return( false );
		}
	}

public:
	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray< data >  datajقȂꍇ̑sD
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class TT, class AAlocator >
	const array1& operator =( const array1< TT, AAlocator > &o )
	{
		base::operator =( o );
		reso1_ = o.reso1( );

		return( *this );
	}


	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	const array1& operator =( const array1 &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );
		reso1_ = o.reso1_;

		return( *this );
	}

public:
	/// @brief fBtHgRXgN^Dvf 0C𑜓x 1.0 ̃Rei쐬
	array1( ) : base( ), reso1_( 1.0 ) {}

	/// @brief AP[^ a ̃Rs[𗘗p
	explicit array1( const Allocator &a ) : base( a ), reso1_( 1.0 ) {}

	/// @brief vf num ̃Rei쐬CftHglŗvf
	explicit array1( size_type num ) : base( num ), reso1_( 1.0 ) {}


	/// @brief vf num ̃Rei쐬C𑜓x r1 ɐݒ肷
	array1( size_type num, double r1 ) : base( num ), reso1_( r1 ) {}

	/// @brief vf num ̃Rei쐬CgpAP[^ a ɐݒ肷
	array1( size_type num, const Allocator &a ) : base( num, a ), reso1_( 1.0 ) {}

	/// @brief vf num ̃Rei쐬C𑜓x r1CAP[^ a ɐݒ肷
	array1( size_type num, double r1, const Allocator &a ) : base( num, a ), reso1_( r1 ) {}


	/// @brief vf num ̃Rei쐬C𑜓x r1 ɐݒ肵CSvf val ŏ
	array1( size_type num, double r1, const value_type &val ) : base( num, val ), reso1_( r1 ) {}

	/// @brief vf num ̃Rei쐬C𑜓x r1 ɐݒ肵CSvf val ŏ
	array1( size_type num, const value_type &val, const Allocator &a ) : base( num, val, a ), reso1_( 1.0 ) {}

	/// @brief vf num ̃Rei쐬C𑜓x r1CAP[^ a  ɐݒ肵CSvf val ŏ
	array1( size_type num, double r1, const value_type &val, const Allocator &a ) : base( num, val, a ), reso1_( r1 ) {}


	/// @brief ptr ẅɁCvf num ̃Rei쐬iptr w̗p\ȃʂ mem_available j
	array1( size_type num, pointer ptr, size_type mem_available ) : base( num, ptr, mem_available ), reso1_( 1.0 ) {}

	/// @brief ptr ẅɁCvf num ̃Rei쐬C𑜓x r1 ɐݒ肷iptr w̗p\ȃʂ mem_available j
	array1( size_type num, double r1, pointer ptr, size_type mem_available ) : base( num, ptr, mem_available ), reso1_( r1 ) {}

	/// @brief ptr ẅɁCvf num ̃Rei쐬C𑜓x r1Cl val ŏiptr w̗p\ȃʂ mem_available j
	array1( size_type num, double r1, const value_type &val, pointer ptr, size_type mem_available ) : base( num, val, ptr, mem_available ), reso1_( r1 ) {}

	/// @brief  array1 zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < class TT, class AAlocator >
	explicit array1( const array1< TT, AAlocator > &o ) : base( o ), reso1_( o.reso1( ) ) {}

	/// @brief  array1 zœvf^̂̂pď
	array1( const array1< T, Allocator > &o ) : base( o ), reso1_( o.reso1_ ) {}
};



/// @brief vfς̉𑜓xt2z
//! 
//! 2摜߂̊{NX
//! i@ref mist/mist.h CN[hj
//! 
//! @param T         c MIST̃ReiɊi[f[^^
//! @param Allocator c MISTReipAP[^^Dȗꍇ́CSTL̃ftHgAP[^gp
//! 
template < class T, class Allocator = std::allocator< T > >
class array2 : public array1< T, Allocator >
{
public:
	typedef Allocator allocator_type;								///< @brief MISTReipAP[^^
	typedef typename Allocator::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Allocator::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Allocator::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Allocator::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Allocator::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	/// @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef mist_iterator1< T, ptrdiff_t, pointer, reference > iterator;

	/// @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > const_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, pointer, reference > > reverse_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef mist_reverse_iterator< mist_iterator1< T, ptrdiff_t, const_pointer, const_reference > > const_reverse_iterator;

	/// @brief f[^^̕ϊs
	template < class TT, class AAllocator = std::allocator< TT > > 
	struct rebind
	{
		typedef array2< TT, AAllocator > other;
	};


private:
	typedef array1< T, Allocator > base;	///< @brief NX
	size_type size2_;						///< @brief Y̗vf
	size_type size1_;						///< @brief X̗vf

protected:
	double reso2_;							///< @brief X̉𑜓x

public:
	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ~ num2 ɕύXCvfύXꂽꍇ̂ݑSĂ̗vflftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! @param[in] dmy1 c _~[ϐigpȂj
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1, size_type num2, size_type /* dmy1 */ = 0 )
	{
		if( base::resize( num1 * num2 ) )
		{
			size1_ = num1;
			size2_ = num2;
			return( true );
		}
		else
		{
			size1_ = size2_ = 0;
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[out] out c g~Oʂ̉摜i[IuWFNgi摜̃TCY͎ŕύX܂j
	//! @param[in]  x   c g~OX̊Jnʒui[n܂CfbNXj
	//! @param[in]  y   c g~OY̊Jnʒui[n܂CfbNXj
	//! @param[in]  w   c g~OX̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in]  h   c g~OY̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( array2 &out, size_type x, size_type y, difference_type w = -1, difference_type h = -1 ) const
	{
		difference_type w_ = width( );
		difference_type h_ = height( );
		if( w_ <= static_cast< difference_type >( x ) || w_ < static_cast< difference_type >( x + w ) )
		{
			return( false );
		}
		else if( h_ <= static_cast< difference_type >( y ) || h_ < static_cast< difference_type >( y + h ) )
		{
			return( false );
		}
		else if( w_ == w && h_ == h )
		{
			out = *this;
			return( true );
		}

		if( w < 0 )
		{
			w = w_ - x;
		}
		if( h < 0 )
		{
			h = h_ - y;
		}

		if( out.resize( w, h ) )
		{
			out.reso( base::reso1( ), base::reso2( ) );

			const_pointer pi = paccess( x, y );
			pointer       po = out.paccess( 0, 0 );
			for( difference_type j = 0 ; j < h ; j++ )
			{
				po = base::allocator_.copy_objects( pi, w, po );
				pi += this->width( );
			}

			return( true );
		}
		else
		{
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[in] x c g~OX̊Jnʒui[n܂CfbNXj
	//! @param[in] y c g~OY̊Jnʒui[n܂CfbNXj
	//! @param[in] w c g~OX̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in] h c g~OY̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( size_type x, size_type y, difference_type w = -1, difference_type h = -1 )
	{
		if( base::is_memory_shared( ) )
		{
			// O𗘗pĂꍇ
			array2 o( *this );
			return( o.trim( *this, x, y, w, h ) );
		}
		else
		{
			difference_type w_ = this->width( );
			difference_type h_ = this->height( );

			if( w_ <= static_cast< difference_type >( x ) || w_ < static_cast< difference_type >( x + w ) )
			{
				return( false );
			}
			else if( h_ <= static_cast< difference_type >( y ) || h_ < static_cast< difference_type >( y + h ) )
			{
				return( false );
			}
			else if( w_ == w && h_ == h )
			{
				return( true );
			}
			else
			{
				array2 o;

				if( this->trim( o, x, y, w, h ) )
				{
					swap( o );

					return( true );
				}
				else
				{
					return( false );
				}
			}
		}
	}

	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( array2 &a )
	{
		if( base::swap( a ) )
		{
			double dmy_reso2_ = reso2_;
			reso2_ = a.reso2_;
			a.reso2_ = dmy_reso2_;

			size_type _dmy_size1 = size1_;
			size_type _dmy_size2 = size2_;
			size1_ = a.size1_;
			size2_ = a.size2_;
			a.size1_ = _dmy_size1;
			a.size2_ = _dmy_size2;
			return( true );
		}
		else
		{
			return( false );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		base::clear( );
		size1_ = size2_ = 0;
	}


	size_type size1( )  const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( )  const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type width( )  const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ

	double reso2( double r2 ){ return( reso2_ = r2 ); }		///< @brief Ỷ𑜓x r2 ɐݒ肵Cݒ̒lԂ
	double reso2( ) const { return( reso2_ ); }				///< @brief Ỷ𑜓xԂ

	/// @brief XỶ𑜓x1xɐݒ肷
	//!
	//! @param[in] r1  c VX̉𑜓x
	//! @param[in] r2  c VỶ𑜓x
	//! @param[in] dmy c pȂ
	//!
	void reso( double r1, double r2, double /* dmy */ = 1.0 ){ base::reso1_ = r1; reso2_ = r2; }



/************************************************************************************************************
**
**      XŒ肵ꍇ̏Et̔q
**
************************************************************************************************************/

	/// @brief XŒ肵́CY̐擪w_ANZXCe[^Ԃ
	//!
	//! @code XŒ肵CY̐擪w_ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.x_begin( 1 );
	//! for( ; ite1 != a.x_end( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator x_begin( size_type i ){ return( iterator( paccess( i, 0 ), width( ) ) ); }

	/// @brief XŒ肵́CY̐擪wRXg^̃_ANZXCe[^Ԃ
	const_iterator x_begin( size_type i ) const { return( const_iterator( paccess( i, 0 ), width( ) ) ); }

	/// @brief XŒ肵́CY̖w_ANZXCe[^Ԃ
	iterator x_end( size_type i ){ return( iterator( paccess( i, height( ) ), width( ) ) ); }

	/// @brief XŒ肵́CY̖wRXg^̃_ANZXCe[^Ԃ
	const_iterator x_end( size_type i ) const { return( const_iterator( paccess( i, height( ) ), width( ) ) ); }


	/// @brief XŒ肵́CY̖wt_ANZXCe[^Ԃ
	//!
	//! @code XŒ肵́CY̋t_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::reverse_iterator ite2 = a.x_rbegin( 2 );
	//! for( ; ite2 != a.x_rend( 2 ) ; ite2++ )
	//! {
	//! 	std::cout << *ite2 << " ";
	//! }
	//! std::cout << std::endl;
	//! @endcode
	//!
	reverse_iterator x_rbegin( size_type i ){ return( reverse_iterator( x_end( i ) ) ); }

	/// @brief XŒ肵́CY̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator x_rbegin( size_type i ) const { return( const_reverse_iterator( x_end( i ) ) ); }


	/// @brief XŒ肵́CY̖wt_ANZXCe[^Ԃ
	reverse_iterator x_rend( size_type i ){ return( reverse_iterator( x_begin( i ) ) ); }

	/// @brief XŒ肵́CY̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator x_rend( size_type i ) const { return( const_reverse_iterator( x_begin( i ) ) ); }

/************************************************************************************************************
**
**      YŒ肵ꍇ̏Et̔q
**
************************************************************************************************************/

	/// @brief YŒ肵́CX̐擪w_ANZXCe[^Ԃ
	//!
	//! @code YŒ肵́CX̐擪w_ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.y_begin( 1 );
	//! for( ; ite1 != a.y_end( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator y_begin( size_type j ){ return( iterator( paccess( 0, j ), 1 ) ); }

	/// @brief YŒ肵́CX̖wRXg^̋t_ANZXCe[^Ԃ
	const_iterator y_begin( size_type j ) const { return( const_iterator( paccess( 0, j ), 1 ) ); }

	/// @brief YŒ肵́CX̖w_ANZXCe[^Ԃ
	iterator y_end( size_type j ){ return( iterator( paccess( width( ), j ), 1 ) ); }

	/// @brief YŒ肵́CX̖wRXg^̃_ANZXCe[^Ԃ
	const_iterator y_end( size_type j ) const { return( const_iterator( paccess( width( ), j ), 1 ) ); }


	/// @brief YŒ肵́CX̐擪wt_ANZXCe[^Ԃ
	//!
	//! @code YŒ肵́CX̐擪wt_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.y_rbegin( 1 );
	//! for( ; ite1 != a.y_rend( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	reverse_iterator y_rbegin( size_type j ){ return( reverse_iterator( y_end( j ) ) ); }

	/// @brief YŒ肵́CX̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator y_rbegin( size_type j ) const { return( const_reverse_iterator( y_end( j ) ) ); }

	/// @brief YŒ肵́CX̖wt_ANZXCe[^Ԃ
	reverse_iterator y_rend( size_type j ){ return( reverse_iterator( y_begin( j ) ) ); }

	/// @brief YŒ肵́CX̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator y_rend( size_type j ) const { return( const_reverse_iterator( y_begin( j ) ) ); }


public:
	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray< data >  datajقȂꍇ̑sD
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class TT, class AAlocator >
	const array2& operator =( const array2< TT, AAlocator > &o )
	{
		base::operator =( o );

		if( base::empty( ) )
		{
			size1_ = size2_ = 0;
		}
		else
		{
			size1_ = o.size1( );
			size2_ = o.size2( );
		}

		reso2_ = o.reso2( );

		return( *this );
	}


	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	const array2& operator =( const array2 &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );

		if( base::empty( ) )
		{
			size1_ = size2_ = 0;
		}
		else
		{
			size1_ = o.size1( );
			size2_ = o.size2( );
		}

		reso2_ = o.reso2( );

		return( *this );
	}

// vfւ̃ANZX
protected:
	/// @brief index Ŏʒu̗vf̃|C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	pointer paccess( size_type i, size_type j )
	{
		return( base::data_ + i + j * size1_ );
	}

	/// @brief index Ŏʒu̗vf const |C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	const_pointer paccess( size_type i, size_type j ) const
	{
		return( base::data_ + i + j * size1_ );
	}

public:
	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvfQ
	//!
	reference at( size_type i, size_type j, size_type dmy = 0 )
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( base::data_[ i + j * size1_ ] );
	}


	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( size_type i, size_type j, size_type dmy = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( base::data_[ i + j * size1_ ] );
	}


	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( size_type i, size_type j, size_type /* dmy */ = 0 )
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( base::data_[ i + j * size1_ ] );
	}


	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i   c ReiẌʒu
	/// @param[in] j   c ReiŸʒu
	/// @param[in] dmy c gpȂ
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( size_type i, size_type j, size_type /* dmy */ = 0 ) const
	{
		_CHECK_ACCESS_VIOLATION2U_( i, j )
		return( base::data_[ i + j * size1_ ] );
	}


public:
	/// @brief fBtHgRXgN^Dvf 0C𑜓x 1.0 ~ 1.0 ̃Rei쐬
	array2( ) : base( ), size2_( 0 ), size1_( 0 ), reso2_( 1.0 ) {}

	/// @brief AP[^ a ̃Rs[𗘗p
	explicit array2( const Allocator &a ) : base( a ), size2_( 0 ), size1_( 0 ), reso2_( 1.0 ) {}

	/// @brief vf num1 ~ num2 ̃Rei쐬CftHglŗvf
	array2( size_type num1, size_type num2 ) : base( num1 * num2 ), size2_( num2 ), size1_( num1 ), reso2_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}


	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2 ɐݒ肷
	array2( size_type num1, size_type num2, double r1, double r2 ) : base( num1 * num2, r1 ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬CgpAP[^ a ɐݒ肷
	array2( size_type num1, size_type num2, const Allocator &a ) : base( num1 * num2, a ), size2_( num2 ), size1_( num1 ), reso2_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2 ɐݒ肵CgpAP[^ a ɐݒ肷
	array2( size_type num1, size_type num2, double r1, double r2, const Allocator &a ) : base( num1 * num2, r1, a ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}


	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x 1.0 ~ 1.0 ɐݒ肵CSvf val ŏ
	array2( size_type num1, size_type num2, const value_type &val ) : base( num1 * num2, 1.0, val ), size2_( num2 ), size1_( num1 ), reso2_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2 ɐݒ肵CSvf val ŏ
	array2( size_type num1, size_type num2, double r1, double r2, const value_type &val ) : base( num1 * num2, r1, val ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2 ɐݒ肵CgpAP[^ a ɐݒ肷
	array2( size_type num1, size_type num2, const value_type &val, const Allocator &a ) : base( num1 * num2, val, a ), size2_( num2 ), size1_( num1 ), reso2_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief vf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2CgpAP[^ a ɐݒ肵CSvf val ŏ
	array2( size_type num1, size_type num2, double r1, double r2, const value_type &val, const Allocator &a ) : base( num1 * num2, r1, val, a ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}


	/// @brief ptr ẅɁCvf num1 ~ num2 ̃Rei쐬iptr w̗p\ȃʂ mem_available j
	array2( size_type num1, size_type num2, pointer ptr, size_type mem_available ) : base( num1 * num2, ptr, mem_available ), size2_( num2 ), size1_( num1 ), reso2_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief ptr ẅɁCvf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2 ɐݒ肷iptr w̗p\ȃʂ mem_available j
	array2( size_type num1, size_type num2, double r1, double r2, pointer ptr, size_type mem_available ) : base( num1 * num2, r1, ptr, mem_available ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief ptr ẅɁCvf num1 ~ num2 ̃Rei쐬C𑜓x r1 ~ r2Cl val ŏiptr w̗p\ȃʂ mem_available j
	array2( size_type num1, size_type num2, double r1, double r2, const value_type &val, pointer ptr, size_type mem_available ) : base( num1 * num2, r1, val, ptr, mem_available ), size2_( num2 ), size1_( num1 ), reso2_( r2 )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}



	/// @brief  array2 zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < class TT, class AAlocator >
	array2( const array2< TT, AAlocator > &o ) : base( o ), size2_( o.size2( ) ), size1_( o.size1( ) ), reso2_( o.reso2( ) )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}

	/// @brief  array2 zœvf^̂̂pď
	array2( const array2< T, Allocator > &o ) : base( o ), size2_( o.size2_ ), size1_( o.size1_ ), reso2_( o.reso2_ )
	{
		if( base::empty( ) ) size1_ = size2_ = 0;
	}
};





/// @brief vfς̉𑜓xt3z
//! 
//! 3摜߂̊{NX
//! i@ref mist/mist.h CN[hj
//! 
//! @param T         c MIST̃ReiɊi[f[^^
//! @param Allocator c MISTReipAP[^^Dȗꍇ́CSTL̃ftHgAP[^gp
//! 
template < class T, class Allocator = std::allocator< T > >
class array3 : public array2< T, Allocator >
{
public:
	typedef Allocator allocator_type;								///< @brief MISTReipAP[^^
	typedef typename Allocator::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Allocator::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Allocator::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Allocator::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Allocator::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	/// @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef mist_iterator2< T, ptrdiff_t, pointer, reference > iterator;

	/// @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef mist_iterator2< T, ptrdiff_t, const_pointer, const_reference > const_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef mist_reverse_iterator< mist_iterator2< T, ptrdiff_t, pointer, reference > > reverse_iterator;

	/// @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg
	typedef mist_reverse_iterator< mist_iterator2< T, ptrdiff_t, const_pointer, const_reference > > const_reverse_iterator;

	/// @brief f[^^̕ϊs
	template < class TT, class AAllocator = std::allocator< TT > > 
	struct rebind
	{
		typedef array3< TT, AAllocator > other;
	};


private:
	typedef array2< T, Allocator > base;	///< @brief NX
	size_type size3_;						///< @brief Z̗vf
	size_type size2_;						///< @brief Y̗vf
	size_type size1_;						///< @brief X̗vf

protected:
	double reso3_;							///< @brief Z̉𑜓x

public:
	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ~ num2 ~ num3 ɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! @param[in] num3 c TCYZ̗vf
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1, size_type num2, size_type num3 )
	{
		if( base::resize( num1 * num2, num3 ) )
		{
			size1_ = num1;
			size2_ = num2;
			size3_ = num3;
			return( true );
		}
		else
		{
			size1_ = size2_ = size3_ = 0;
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[out] out c g~Oʂ̉摜i[IuWFNgi摜̃TCY͎ŕύX܂j
	//! @param[in]  x   c g~OX̊Jnʒui[n܂CfbNXj
	//! @param[in]  y   c g~OY̊Jnʒui[n܂CfbNXj
	//! @param[in]  z   c g~OZ̊Jnʒui[n܂CfbNXj
	//! @param[in]  w   c g~OX̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in]  h   c g~OY̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in]  d   c g~OZ̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( array3 &out, size_type x, size_type y, size_type z, difference_type w = -1, difference_type h = -1, difference_type d = -1 ) const
	{
		difference_type w_ = width( );
		difference_type h_ = height( );
		difference_type d_ = depth( );
		if( w_ <= static_cast< difference_type >( x ) || w_ < static_cast< difference_type >( x + w ) )
		{
			return( false );
		}
		else if( h_ <= static_cast< difference_type >( y ) || h_ < static_cast< difference_type >( y + h ) )
		{
			return( false );
		}
		else if( d_ <= static_cast< difference_type >( z ) || d_ < static_cast< difference_type >( z + d ) )
		{
			return( false );
		}
		else if( w_ == w && h_ == h && d_ == d )
		{
			out = *this;
			return( true );
		}

		if( w < 0 )
		{
			w = w_ - x;
		}
		if( h < 0 )
		{
			h = h_ - y;
		}
		if( d < 0 )
		{
			d = d_ - z;
		}

		if( out.resize( w, h, d ) )
		{
			out.reso( base::reso1( ), base::reso2( ), reso3( ) );

			const_pointer pi = paccess( x, y, z );
			pointer       po = out.paccess( 0, 0, 0 );
			size_type     s1 = paccess( x, y + 1, z ) - pi;
			size_type     s2 = paccess( x, y, z + 1 ) - paccess( x, y + h, z );

			for( difference_type k = 0 ; k < d ; k++ )
			{
				for( difference_type j = 0 ; j < h ; j++ )
				{
					po = base::allocator_.copy_objects( pi, w, po );
					pi += s1;
				}

				pi += s2;
			}

			return( true );
		}
		else
		{
			return( false );
		}
	}

	/// @brief Rei̗vfg~O
	//! 
	//! @param[in] x c g~OX̊Jnʒui[n܂CfbNXj
	//! @param[in] y c g~OY̊Jnʒui[n܂CfbNXj
	//! @param[in] z c g~OZ̊Jnʒui[n܂CfbNXj
	//! @param[in] w c g~OX̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in] h c g~OY̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! @param[in] d c g~OZ̗vfi-1̏ꍇ́CŌ܂łRs[j
	//! 
	//! @retval true  c g~OɐꍇiƃTCYςȂꍇ܂ށj
	//! @retval false c sȃg~OsƂꍇ
	//! 
	bool trim( size_type x, size_type y, size_type z, difference_type w = -1, difference_type h = -1, difference_type d = -1 )
	{
		if( base::is_memory_shared( ) )
		{
			// O𗘗pĂꍇ
			array3 o( *this );
			return( o.trim( *this, x, y, z, w, h, d ) );
		}
		else
		{
			difference_type w_ = this->width( );
			difference_type h_ = this->height( );
			difference_type d_ = this->depth( );
			if( w_ <= static_cast< difference_type >( x ) || w_ < static_cast< difference_type >( x + w ) )
			{
				return( false );
			}
			else if( h_ <= static_cast< difference_type >( y ) || h_ < static_cast< difference_type >( y + h ) )
			{
				return( false );
			}
			else if( d_ <= static_cast< difference_type >( z ) || d_ < static_cast< difference_type >( z + d ) )
			{
				return( false );
			}
			else if( w_ == w && h_ == h && d_ == d )
			{
				return( true );
			}
			else
			{
				array3 o;

				if( this->trim( o, x, y, z, w, h, d ) )
				{
					swap( o );

					return( true );
				}
				else
				{
					return( false );
				}
			}
		}
	}

	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( array3 &a )
	{
		if( base::swap( a ) )
		{
			double dmy_reso3_ = reso3_;
			reso3_ = a.reso3_;
			a.reso3_ = dmy_reso3_;

			size_type _dmy_size1 = size1_;
			size_type _dmy_size2 = size2_;
			size_type _dmy_size3 = size3_;
			size1_ = a.size1_;
			size2_ = a.size2_;
			size3_ = a.size3_;
			a.size1_ = _dmy_size1;
			a.size2_ = _dmy_size2;
			a.size3_ = _dmy_size3;

			return( true );
		}
		else
		{
			return( true );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		base::clear( );
		size1_ = size2_ = size3_ = 0;
	}


	size_type size1( ) const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( ) const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type size3( ) const { return( size3_ ); }			///< @brief Z̃ReiɊi[Ăf[^Ԃ
	size_type width( ) const { return( size1_ ); }			///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( size2_ ); }			///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type depth( ) const { return( size3_ ); }			///< @brief Z̃ReiɊi[Ăf[^Ԃ

	double reso3( double r3 ){ return( reso3_ = r3 ); }		///< @brief Z̉𑜓x r3 ɐݒ肵Cݒ̒lԂ
	double reso3( ) const { return( reso3_ ); }				///< @brief Z̉𑜓xԂ

	/// @brief XYZ̉𑜓x1xɐݒ肷
	//!
	//! @param[in] r1 c VX̉𑜓x
	//! @param[in] r2 c VỶ𑜓x
	//! @param[in] r3 c VỶ𑜓x
	//!
	void reso( double r1, double r2, double r3 ){ base::reso1_ = r1; base::reso2_ = r2; reso3_ = r3; }



	/// @brief Rei̐擪w_ANZXCe[^Ԃ
	//!
	//! @code _ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.begin( );
	//! for( ; ite1 != a.end( ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator begin( ){ return( iterator( paccess( 0, 0, 0 ), 0, base::size( ), 0 ) ); }

	/// @brief Rei̐擪wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator begin( ) const { return( const_iterator( paccess( 0, 0, 0 ), 0, base::size( ), 0 ) ); }

	/// @brief Rei̖w_ANZXCe[^Ԃ
	iterator end( ){ return( iterator( paccess( 0, 0, 0 ), base::size( ), base::size( ), 0 ) ); }

	/// @brief Rei̖wRXg^̃Rei𑀍삷郉_ANZXCe[^Ԃ
	const_iterator end( ) const { return( const_iterator( paccess( 0, 0, 0 ), base::size( ), base::size( ), 0 ) ); }


	/// @brief Rei̖wt_ANZXCe[^Ԃ
	//!
	//! @code t_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::reverse_iterator ite2 = a.rbegin( );
	//! for( ; ite2 != a.rend( ) ; ite2++ )
	//! {
	//! 	std::cout << *ite2 << " ";
	//! }
	//! std::cout << std::endl;
	//! @endcode
	//!
	reverse_iterator rbegin( ){ return( reverse_iterator( end( ) ) ); }

	/// @brief Rei̖wRXg^̃Rei𑀍삷t_ANZXCe[^Ԃ
	const_reverse_iterator rbegin( ) const { return( const_reverse_iterator( end( ) ) ); }

	/// @brief Rei̐擪wt_ANZXCe[^Ԃ
	reverse_iterator rend( ){ return( reverse_iterator( begin( ) ) ); }

	/// @brief gpĂAP[^mۉ\ȃ̍őlԂ
	const_reverse_iterator rend( ) const { return( const_reverse_iterator( begin( ) ) ); }

/************************************************************************************************************
**
**      XŒ肵ꍇ̏Et̔q
**
************************************************************************************************************/

	/// @brief XŒ肵́CYZ(Sagittal)̐擪w_ANZXCe[^Ԃ
	//!
	//! @code XŒ肵CYZ(Sagittal)̐擪w_ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.x_begin( 1 );
	//! for( ; ite1 != a.x_end( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator x_begin( size_type i ){ return( iterator( paccess( i, 0, 0 ), 0, 1, width( ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̐擪wRXg^̃_ANZXCe[^Ԃ
	const_iterator x_begin( size_type i ) const { return( const_iterator( paccess( i, 0, 0 ), 0, 1, width( ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̖w_ANZXCe[^Ԃ
	iterator x_end( size_type i ){ return( iterator( paccess( i, 0, 0 ), height( ) * depth( ), 1, width( ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̖wRXg^̃_ANZXCe[^Ԃ
	const_iterator x_end( size_type i ) const { return( const_iterator( paccess( i, 0, 0 ), height( ) * depth( ), 1, width( ) ) ); }



	/// @brief XŒ肵́CYZ(Sagittal)̖wt_ANZXCe[^Ԃ
	//!
	//! @code XŒ肵́CYZ(Sagittal)̋t_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::reverse_iterator ite2 = a.x_rbegin( 2 );
	//! for( ; ite2 != a.x_rend( 2 ) ; ite2++ )
	//! {
	//! 	std::cout << *ite2 << " ";
	//! }
	//! std::cout << std::endl;
	//! @endcode
	//!
	reverse_iterator x_rbegin( size_type i ){ return( reverse_iterator( x_end( i ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator x_rbegin( size_type i ) const { return( const_reverse_iterator( x_end( i ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̖wt_ANZXCe[^Ԃ
	reverse_iterator x_rend( size_type i ){ return( reverse_iterator( x_begin( i ) ) ); }

	/// @brief XŒ肵́CYZ(Sagittal)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator x_rend( size_type i ) const { return( const_reverse_iterator( x_begin( i ) ) ); }


/************************************************************************************************************
**
**      YŒ肵ꍇ̏Et̔q
**
************************************************************************************************************/

	/// @brief YŒ肵́CXZ(Coronal)̐擪w_ANZXCe[^Ԃ
	//!
	//! @code YŒ肵́CXZʂ̐擪w_ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.y_begin( 1 );
	//! for( ; ite1 != a.y_end( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator y_begin( size_type j ){ return( iterator( paccess( 0, j, 0 ), 0, height( ), width( ) * height( ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖wRXg^̋t_ANZXCe[^Ԃ
	const_iterator y_begin( size_type j ) const { return( const_iterator( paccess( 0, j, 0 ), 0, height( ), width( ) * height( ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖w_ANZXCe[^Ԃ
	iterator y_end( size_type j ){ return( iterator( paccess( 0, j, 0 ), width( ) * depth( ), height( ), width( ) * height( ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖wRXg^̃_ANZXCe[^Ԃ
	const_iterator y_end( size_type j ) const { return( const_iterator( paccess( 0, j, 0 ), width( ) * depth( ), height( ), width( ) * height( ) ) ); }


	/// @brief YŒ肵́CXZ(Coronal)̐擪wt_ANZXCe[^Ԃ
	//!
	//! @code YŒ肵́CXZ(Coronal)̐擪wt_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.y_rbegin( 1 );
	//! for( ; ite1 != a.y_rend( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	reverse_iterator y_rbegin( size_type j ){ return( reverse_iterator( y_end( j ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator y_rbegin( size_type j ) const { return( const_reverse_iterator( y_end( j ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖wt_ANZXCe[^Ԃ
	reverse_iterator y_rend( size_type j ){ return( reverse_iterator( y_begin( j ) ) ); }

	/// @brief YŒ肵́CXZ(Coronal)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator y_rend( size_type j ) const { return( const_reverse_iterator( y_begin( j ) ) ); }


/************************************************************************************************************
**
**      ZŒ肵ꍇ̏Et̔q
**
************************************************************************************************************/

	/// @brief ZŒ肵́CXY(Axial)̐擪w_ANZXCe[^Ԃ
	//!
	//! @code ZŒ肵́CXYʂ̐擪w_ANZXCe[^̎gp
	//! std::cout << "_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.z_begin( 1 );
	//! for( ; ite1 != a.z_end( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	iterator z_begin( size_type k ){ return( iterator( paccess( 0, 0, k ), 0, 1, 1 ) ); }

	/// @brief ZŒ肵́CXY(Axial)̖wRXg^̋t_ANZXCe[^Ԃ
	const_iterator z_begin( size_type k ) const { return( const_iterator( paccess( 0, 0, k ), 0, 1, 1 ) ); }

	/// @brief ZŒ肵́CXY(Axial)̖w_ANZXCe[^Ԃ
	iterator z_end( size_type k ){ return( iterator( paccess( 0, 0, k ), width( ) * height( ), 1, 1 ) ); }

	/// @brief ZŒ肵́CXY(Axial)̖wRXg^̃_ANZXCe[^Ԃ
	const_iterator z_end( size_type k ) const { return( const_iterator( paccess( 0, 0, k ), width( ) * height( ), 1, 1 ) ); }


	/// @brief ZŒ肵́CXY(Axial)̐擪wt_ANZXCe[^Ԃ
	//!
	//! @code ZŒ肵́CXY(Axial)̐擪wt_ANZXCe[^̎gp
	//! std::cout << "t_ANZXCe[^" << std::endl;
	//! mist::array< int >::iterator ite1 = a.z_rbegin( 1 );
	//! for( ; ite1 != a.z_rend( 1 ) ; ite1++ )
	//! {
	//! 	std::cout << *ite1 << " ";
	//! }
	//! std::cout << std::endl << std::endl;
	//! @endcode
	//!
	reverse_iterator z_rbegin( size_type k ){ return( reverse_iterator( z_end( k ) ) ); }

	/// @brief ZŒ肵́CXY(Axial)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator z_rbegin( size_type k ) const { return( const_reverse_iterator( z_end( k )) ); }

	/// @brief ZŒ肵́CXY(Axial)̖wt_ANZXCe[^Ԃ
	reverse_iterator z_rend( size_type k ){ return( reverse_iterator( z_begin( k ) ) ); }

	/// @brief ZŒ肵́CXY(Axial)̖wRXg^̋t_ANZXCe[^Ԃ
	const_reverse_iterator z_rend( size_type k ) const { return( const_reverse_iterator( z_begin( k ) ) ); }


public:
	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! Rs[ƃRs[Ńf[^^iarray3< data >  datajقȂꍇ̑sD
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class TT, class AAlocator >
	const array3& operator =( const array3< TT, AAlocator > &o )
	{
		base::operator =( o );

		if( base::empty( ) )
		{
			size1_ = size2_ = size3_ = 0;
		}
		else
		{
			size1_ = o.size1( );
			size2_ = o.size2( );
			size3_ = o.size3( );
		}

		reso3_ = o.reso3( );

		return( *this );
	}


	/// @brief vf̌^قȂRei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	const array3& operator =( const array3 &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );

		if( base::empty( ) )
		{
			size1_ = size2_ = size3_ = 0;
		}
		else
		{
			size1_ = o.size1( );
			size2_ = o.size2( );
			size3_ = o.size3( );
		}

		reso3_ = o.reso3( );

		return( *this );
	}


// vfւ̃ANZX
protected:
	/// @brief index Ŏʒu̗vf̃|C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	pointer paccess( size_type i, size_type j, size_type k )
	{
		return( base::data_ + i + ( j + k * size2_ ) * size1_ );
	}

	/// @brief index Ŏʒu̗vf const |C^Ԃ
	//! 
	//! @param[in] i c ReiẌʒu
	//! @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//! 
	//! @return w肳ꂽvf|C^
	//! 
	const_pointer paccess( size_type i, size_type j, size_type k ) const
	{
		return( base::data_ + i + ( j + k * size2_ ) * size1_ );
	}

public:
	/// @brief ( i, j, k ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j, k ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference at( size_type i, size_type j, size_type k )
	{
		_CHECK_ACCESS_VIOLATION3U_( i, j, k )
		return( base::data_[ i + ( j + k * size2_ ) * size1_ ] );
	}


	/// @brief ( i, j, k ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j, k ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( size_type i, size_type j, size_type k ) const
	{
		_CHECK_ACCESS_VIOLATION3U_( i, j, k )
		return( base::data_[ i + ( j + k * size2_ ) * size1_ ] );
	}


	/// @brief ( i, j, k ) Ŏʒu̗vf̎QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j, k ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( size_type i, size_type j, size_type k )
	{
		_CHECK_ACCESS_VIOLATION3U_( i, j, k )
		return( base::data_[ i + ( j + k * size2_ ) * size1_ ] );
	}


	/// @brief ( i, j, k ) Ŏʒu̗vf const QƂԂ
	//!
	//! DEBUG }NLɂiNDEBUG}N`Ȃjꍇ́Cw肳ꂽ ( i, j, k ) LȔ͈͓ɂ邩`FbN
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//! @param[in] k c ReiZ̈ʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( size_type i, size_type j, size_type k ) const
	{
		_CHECK_ACCESS_VIOLATION3U_( i, j, k )
		return( base::data_[ i + ( j + k * size2_ ) * size1_ ] );
	}


public:
	/// @brief fBtHgRXgN^Dvf 0C𑜓x 1.0 ~ 1.0 ~ 1.0 ̃Rei쐬
	array3( ) : base( ), size3_( 0 ), size2_( 0 ), size1_( 0 ), reso3_( 1.0 ) {}

	/// @brief AP[^ a ̃Rs[𗘗p
	explicit array3( const Allocator &a ) : base( a ), size3_( 0 ), size2_( 0 ), size1_( 0 ), reso3_( 1.0 ) {}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬CftHglŗvf
	array3( size_type num1, size_type num2, size_type num3 ) : base( num1 * num2, num3 ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3 ɐݒ肷
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3 ) : base( num1 * num2, num3, r1, r2 ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬CgpAP[^ a ɐݒ肷
	array3( size_type num1, size_type num2, size_type num3, const Allocator &a ) : base( num1 * num2, num3, a ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3 ɐݒ肵CgpAP[^ a ɐݒ肷
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3, const Allocator &a ) : base( num1 * num2, num3, r1, r2, a ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}


	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x 1.0 ~ 1.0 ~ 1.0 ɐݒ肵CSvf val ŏ
	array3( size_type num1, size_type num2, size_type num3, const value_type &val ) : base( num1 * num2, num3, val ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3 ɐݒ肵CSvf val ŏ
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3, const value_type &val ) : base( num1 * num2, num3, r1, r2, val ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3 ɐݒ肵CgpAP[^ a ɐݒ肷
	array3( size_type num1, size_type num2, size_type num3, const value_type &val, const Allocator &a ) : base( num1 * num2, num3, val, a ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief vf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3CgpAP[^ a ɐݒ肵CSvf val ŏ
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3, const value_type &val, const Allocator &a ) : base( num1 * num2, num3, r1, r2, val, a ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}



	/// @brief ptr ẅɁCvf num1 ~ num2 ~ num3 ̃Rei쐬iptr w̗p\ȃʂ mem_available j
	array3( size_type num1, size_type num2, size_type num3, pointer ptr, size_type mem_available ) : base( num1 * num2, num3, ptr, mem_available ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( 1.0 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief ptr ẅɁCvf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3 ɐݒ肷iptr w̗p\ȃʂ mem_available j
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3, pointer ptr, size_type mem_available ) : base( num1 * num2, num3, r1, r2, ptr, mem_available ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief ptr ẅɁCvf num1 ~ num2 ~ num3 ̃Rei쐬C𑜓x r1 ~ r2 ~ r3Cl val ŏiptr w̗p\ȃʂ mem_available j
	array3( size_type num1, size_type num2, size_type num3, double r1, double r2, double r3, const value_type &val, pointer ptr, size_type mem_available ) : base( num1 * num2, num3, r1, r2, val, ptr, mem_available ), size3_( num3 ), size2_( num2 ), size1_( num1 ), reso3_( r3 )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}



	/// @brief  array3 zŗvf̌^قȂ̂瓯vf̔z쐬
	//!
	//! @attention قȂvf^ԂŃf[^̕ϊ\łȂĂ͂ȂȂ
	//!
	template < class TT, class AAlocator >
	array3( const array3< TT, AAlocator > &o ) : base( o ), size3_( o.size3( ) ), size2_( o.size2( ) ), size1_( o.size1( ) ), reso3_( o.reso3( ) )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}

	/// @brief  array3 zœvf^̂̂pď
	array3( const array3< T, Allocator > &o ) : base( o ), size3_( o.size3_ ), size2_( o.size2_ ), size1_( o.size1_ ), reso3_( o.reso3_ )
	{
		if( base::empty( ) ) size1_ = size2_ = size3_ = 0;
	}
};




/// @brief 摜̂ӂɃ}[Wz
//! 
//! 1E2E3摜Ƀ}[W邽߂̊{NX
//! i@ref mist/mist.h CN[hj
//! 
//! @param Array c 1E2E3摜NXw肷
//! 
template < class Array >
class marray : public Array
{
public:
	typedef typename Array::allocator_type allocator_type;		///< @brief MISTReipAP[^^
	typedef typename Array::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Array::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Array::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Array::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Array::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Array::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Array::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	typedef typename Array::iterator iterator;								///< @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef typename Array::const_iterator const_iterator;					///< @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef typename Array::reverse_iterator reverse_iterator;				///< @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef typename Array::const_reverse_iterator const_reverse_iterator;	///< @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg


protected:
	typedef Array base;						///< @brief NX
	size_type margin1_;						///< @brief X̃}[W
	size_type margin2_;						///< @brief Ỹ}[W
	size_type margin3_;						///< @brief Z̃}[W

public:
	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ɕύXCSĂ̗vfftHglŏD
	//! 
	//! @param[in] num1 c TCY̑Svf
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1 )
	{
		return( base::resize( num1 + margin1_ * 2 ) );
	}


	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ~ num2 ɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1, size_type num2 )
	{
		return( base::resize( num1 + margin1_ * 2, num2 + margin2_ * 2 ) );
	}


	/// @brief Rei̗vfύX
	//! 
	//! vf num1 ~ num2 ~ num3 ɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! @param[in] num3 c TCYZ̗vf
	//! 
	//! @retval true  c ɃTCYI
	//! @retval false c TCỸmۂłȂꍇ
	//! 
	bool resize( size_type num1, size_type num2, size_type num3 )
	{
		return( base::resize( num1 + margin1_ * 2, num2 + margin2_ * 2, num3 + margin3_ * 2 ) );
	}



	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( marray &a )
	{
		if( base::swap( a ) )
		{
			size_type tmp = margin1_;
			margin1_ = a.margin1_;
			a.margin1_ = tmp;

			tmp = margin2_;
			margin2_ = a.margin2_;
			a.margin2_ = tmp;

			tmp = margin3_;
			margin3_ = a.margin3_;
			a.margin3_ = tmp;

			return( true );
		}
		else
		{
			return( false );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		base::clear( );
		margin1_ = margin2_ = margin3_ = 0;
	}


	/// @brief Reĩ}[W̃f[^vfw肳ꂽlŏ
	//! 
	//! }[W̗vfl val ŏD
	//! 
	//! @param[in] val c vfl
	//! 
	void fill_margin( const value_type &val = value_type( ) )
	{
		if( !base::empty( ) )
		{
			base &o = *this;

			size_type i, j, k;
			for( k = 0 ; k < margin3( ) ; k++ )
			{
				for( j = 0 ; j < o.size2( ) ; j++ )
				{
					for( i = 0 ; i < o.size1( ) ; i++ )
					{
						o( i, j, k ) = val;
					}
				}
			}
			for( k = o.size3( ) - margin3( ) ; k < o.size3( ) ; k++ )
			{
				for( j = 0 ; j < o.size2( ) ; j++ )
				{
					for( i = 0 ; i < o.size1( ) ; i++ )
					{
						o( i, j, k ) = val;
					}
				}
			}

			for( j = 0 ; j < margin2( ) ; j++ )
			{
				for( k = 0 ; k < o.size3( ) ; k++ )
				{
					for( i = 0 ; i < o.size1( ) ; i++ )
					{
						o( i, j, k ) = val;
					}
				}
			}
			for( j = o.size2( ) - margin2( ) ; j < o.size2( ) ; j++ )
			{
				for( k = 0 ; k < o.size3( ) ; k++ )
				{
					for( i = 0 ; i < o.size1( ) ; i++ )
					{
						o( i, j, k ) = val;
					}
				}
			}

			for( i = 0 ; i < margin1( ) ; i++ )
			{
				for( k = 0 ; k < o.size3( ) ; k++ )
				{
					for( j = 0 ; j < o.size2( ) ; j++ )
					{
						o( i, j, k ) = val;
					}
				}
			}
			for( i = o.size1( ) - margin1( ) ; i < o.size1( ) ; i++ )
			{
				for( k = 0 ; k < o.size3( ) ; k++ )
				{
					for( j = 0 ; j < o.size2( ) ; j++ )
					{
						o( i, j, k ) = val;
					}
				}
			}
		}
	}


	size_type size1( ) const { return( base::empty( ) ? 0 : base::size1( ) - 2 * margin1_ ); }	///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( ) const { return( base::empty( ) ? 0 : base::size2( ) - 2 * margin2_ ); }	///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type size3( ) const { return( base::empty( ) ? 0 : base::size3( ) - 2 * margin3_ ); }	///< @brief Z̃ReiɊi[Ăf[^Ԃ

	size_type width( ) const { return( size1( ) ); }		///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( size2( ) ); }		///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type depth( ) const { return( size3( ) ); }		///< @brief Z̃ReiɊi[Ăf[^Ԃ

	size_type margin1( ) const { return( margin1_ ); }		///< @brief X̃}[WԂ
	size_type margin2( ) const { return( margin2_ ); }		///< @brief Ỹ}[WԂ
	size_type margin3( ) const { return( margin3_ ); }		///< @brief Z̃}[WԂ

private:
	/// @brief array Reif[^Rs[
	//! 
	//! @attention }[Wɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& copy( const array< T, Allocator > &o )
	{
		size_type length = base::size( ) < o.size( ) ? base::size( ) : o.size( );
		for( size_type i = 0 ; i < length ; i++ )
		{
			( *this )[ i ] = static_cast< value_type >( o[ i ] );
		}
		return( *this );
	}


	/// @brief array1 Reif[^Rs[
	//! 
	//! @attention }[Wɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& copy( const array1< T, Allocator > &o )
	{
		size_type length = base::size( ) < o.size( ) ? base::size( ) : o.size( );
		for( size_type i = 0 ; i < length ; i++ )
		{
			( *this )[ i ] = static_cast< value_type >( o[ i ] );
		}
		return( *this );
	}


	/// @brief array2 Reif[^Rs[
	//! 
	//! @attention }[Wɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& copy( const array2< T, Allocator > &o )
	{
		size_type w = width( )  < o.width( )  ? width( )  : o.width( );
		size_type h = height( ) < o.height( ) ? height( ) : o.height( );
		for( size_type j = 0 ; j < h ; j++ )
		{
			for( size_type i = 0 ; i < w ; i++ )
			{
				( *this )( i, j ) = static_cast< value_type >( o( i, j ) );
			}
		}
		return( *this );
	}


	/// @brief array3 Reif[^Rs[
	//! 
	//! @attention }[Wɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& copy( const array3< T, Allocator > &o )
	{
		size_type w = width( )  < o.width( )  ? width( )  : o.width( );
		size_type h = height( ) < o.height( ) ? height( ) : o.height( );
		size_type d = depth( )  < o.depth( )  ? depth( )  : o.depth( );
		for( size_type k = 0 ; k < d ; k++ )
		{
			for( size_type j = 0 ; j < h ; j++ )
			{
				for( size_type i = 0 ; i < w ; i++ )
				{
					( *this )( i, j, k ) = static_cast< value_type >( o( i, j, k ) );
				}
			}
		}
		return( *this );
	}

public:
	/// @brief ^ marray Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ marray Rei
	//! 
	//! @return g
	//! 
	const marray& operator =( const marray &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );
		margin1_ = o.margin1_;
		margin2_ = o.margin2_;
		margin3_ = o.margin3_;

		return( *this );
	}


	/// @brief vf̌^قȂ array Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& operator =( const array< T, Allocator > &o )
	{
		if( base::resize( o.size( ) + margin1_ * 2 ) )
		{
			return( copy( o ) );
		}
		else
		{
			return( *this );
		}
	}


	/// @brief vf̌^قȂ array1 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array1 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& operator =( const array1< T, Allocator > &o )
	{
		if( base::resize( o.size( ) + margin1_ * 2 ) )
		{
			reso1( o.reso1( ) );
			return( copy( o ) );
		}
		else
		{
			return( *this );
		}
	}


	/// @brief vf̌^قȂ array2 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array2 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& operator =( const array2< T, Allocator > &o )
	{
		if( base::resize( o.size1( ) + margin1_ * 2, o.size2( ) + margin2_ * 2 ) )
		{
			reso1( o.reso1( ) );
			reso2( o.reso2( ) );
			return( copy( o ) );
		}
		else
		{
			return( *this );
		}
	}


	/// @brief vf̌^قȂ array3 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array3 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const marray& operator =( const array3< T, Allocator > &o )
	{
		if( base::resize( o.size1( ) + margin1_ * 2, o.size2( ) + margin2_ * 2, o.size3( ) + margin3_ * 2 ) )
		{
			reso1( o.reso1( ) );
			reso2( o.reso2( ) );
			reso3( o.reso3( ) );
			return( copy( o ) );
		}
		else
		{
			return( *this );
		}
	}

// vfւ̃ANZX
public:
	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference at( difference_type index )
	{
		return( base::at( index + margin1_ ) );
	}

	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference at( difference_type i, difference_type j )
	{
		return( base::at( i + margin1_, j + margin2_ ) );
	}

	/// @brief ( i, j, k ) Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	/// @param[in] k c ReiŸʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference at( difference_type i, difference_type j, difference_type k )
	{
		return( base::at( i + margin1_, j + margin2_, k + margin3_ ) );
	}


	/// @brief index Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( difference_type index ) const
	{
		return( base::at( index + margin1_ ) );
	}

	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( difference_type i, difference_type j ) const
	{
		return( base::at( i + margin1_, j + margin2_ ) );
	}

	/// @brief ( i, j, k ) Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	/// @param[in] k c ReiŸʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference at( difference_type i, difference_type j, difference_type k ) const
	{
		return( base::at( i + margin1_, j + margin2_, k + margin3_ ) );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator []( difference_type index )
	{
		return( base::operator []( index ) );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( difference_type index )
	{
		return( base::operator ()( index + margin1_ ) );
	}

	/// @brief ( i, j ) Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( difference_type i, difference_type j )
	{
		return( base::operator ()( i + margin1_, j + margin2_ ) );
	}

	/// @brief ( i, j, k ) Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	/// @param[in] k c ReiŸʒu
	//!
	/// @return w肳ꂽvfQ
	//!
	reference operator ()( difference_type i, difference_type j, difference_type k )
	{
		return( base::operator ()( i + margin1_, j + margin2_, k + margin3_ ) );
	}


	/// @brief index Ŏʒu̗vf̎QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvfQ
	//!
	const_reference operator []( difference_type index ) const
	{
		return( base::operator []( index ) );
	}

	/// @brief index Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] index c Rei̗vfʒu
	//! 
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( difference_type index ) const
	{
		return( base::operator ()( index + margin1_ ) );
	}

	/// @brief ( i, j ) Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( difference_type i, difference_type j ) const
	{
		return( base::operator ()( i + margin1_, j + margin2_ ) );
	}

	/// @brief ( i, j, k ) Ŏʒu̗vf const QƂԂ
	//!
	/// @param[in] i c ReiẌʒu
	/// @param[in] j c ReiŸʒu
	/// @param[in] k c ReiŸʒu
	//!
	/// @return w肳ꂽvf const Q
	//!
	const_reference operator ()( difference_type i, difference_type j, difference_type k ) const
	{
		return( base::operator ()( i + margin1_, j + margin2_, k + margin3_ ) );
	}


public:
	/// @brief fBtHgRXgN^Dvf 0C}[W 0 ̃Rei쐬
	marray( ) : base( ), margin1_( 0 ), margin2_( 0 ), margin3_( 0 ) {}

	/// @brief }[W margin ̃Rei쐬
	marray( size_type margin ) : base( ), margin1_( margin ), margin2_( margin ), margin3_( margin ) {}

	/// @brief Rs[RXgN^
	marray( const marray &o ) : base( o ), margin1_( o.margin1( ) ), margin2_( o.margin2( ) ), margin3_( o.margin3( ) ) {}



	/// @brief }[W margin ̃Rei쐬
	marray( size_type w, size_type margin ) : base( w + margin * 2 ), margin1_( margin ), margin2_( 0 ), margin3_( 0 ) {}

	/// @brief }[W margin ̃Rei쐬
	marray( size_type w, size_type h, size_type margin ) : base( w + margin * 2, h + margin * 2 ), margin1_( margin ), margin2_( margin ), margin3_( 0 ) {}

	/// @brief }[W margin ̃Rei쐬
	marray( size_type w, size_type h, size_type d, size_type margin ) : base( w + margin * 2, h + margin * 2, d + margin * 2 ), margin1_( margin ), margin2_( margin ), margin3_( margin ) {}




	/// @brief array z o ̔z̑傫ƁCX̃}[W margin1 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array< T, Allocator > &o, size_type margin1, const value_type &val = value_type( 0 ) )
		: base( o.size( ) + margin1 * 2 ), margin1_( margin1 ), margin2_( 0 ), margin3_( 0 )
	{
		fill_margin( val );
		copy( o );
	}


	/// @brief array1 z o ̔z̑傫ƁCX̃}[W margin1 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array1< T, Allocator > &o, size_type margin1, const value_type &val = value_type( ) )
		: base( o.size( ) + margin1 * 2, o.reso1( ) ), margin1_( margin1 ), margin2_( 0 ), margin3_( 0 )
	{
		fill_margin( val );
		copy( o );
	}


	/// @brief array2 z o ̔z̑傫ƁCX̃}[W margin1CỸ}[W margin2 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array2< T, Allocator > &o, size_type margin1, size_type margin2, const value_type &val = value_type( ) )
		: base( o.size1( ) + margin1 * 2, o.size2( ) + margin2 * 2, o.reso1( ), o.reso2( ) ), margin1_( margin1 ), margin2_( margin2 ), margin3_( 0 )
	{
		fill_margin( val );
		copy( o );
	}

	/// @brief array2 z o ̔z̑傫ƁCX̃}[W margin1CỸ}[W margin2 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array2< T, Allocator > &o, size_type margin1, size_type margin2, size_type /* margin3 */, const value_type &val )
		: base( o.size1( ) + margin1 * 2, o.size2( ) + margin2 * 2, o.reso1( ), o.reso2( ) ), margin1_( margin1 ), margin2_( margin2 ), margin3_( 0 )
	{
		fill_margin( val );
		copy( o );
	}


	/// @brief array3 z o ̔z̑傫ƁCX̃}[W margin1CỸ}[W margin2CZ̃}[W margin3 pďCSvf val ŏ
	//! 
	template < class T, class Allocator >
	marray( const array3< T, Allocator > &o, size_type margin1, size_type margin2, size_type margin3, const value_type &val = value_type( ) )
		: base( o.size1( ) + margin1 * 2, o.size2( ) + margin2 * 2, o.size3( ) + margin3 * 2, o.reso1( ), o.reso2( ), o.reso3( ) ), margin1_( margin1 ), margin2_( margin2 ), margin3_( margin3 )
	{
		fill_margin( val );
		copy( o );
	}


	/// @brief array2 z o ̔z̑傫ƁCXEỸ}[W margin1 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array2< T, Allocator > &o, size_type margin1, const value_type &val = value_type( ) )
		: base( o.size1( ) + margin1 * 2, o.size2( ) + margin1 * 2, o.reso1( ), o.reso2( ) ), margin1_( margin1 ), margin2_( margin1 ), margin3_( 0 )
	{
		fill_margin( val );
		copy( o );
	}

	/// @brief array3 z o ̔z̑傫ƁCXEYEZ̃}[W margin1 pďCSvf val ŏ
	template < class T, class Allocator >
	marray( const array3< T, Allocator > &o, size_type margin1, const value_type &val = value_type( ) )
		: base( o.size1( ) + margin1 * 2, o.size2( ) + margin1 * 2, o.size3( ) + margin1 * 2, o.reso1( ), o.reso2( ), o.reso3( ) ), margin1_( margin1 ), margin2_( margin1 ), margin3_( margin1 )
	{
		fill_margin( val );
		copy( o );
	}
};





/// @brief Pӂ2̎w̃obt@摜쐬
//! 
//! 1E2E3摜̂Pӂ2̎wɂ邽߂̊{NX
//! 
//! @param Array c 1E2E3摜NXw肷
//! 
template < class Array >
class buffered_array : public Array
{
public:
	typedef typename Array::allocator_type allocator_type;		///< @brief MISTReipAP[^^
	typedef typename Array::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Array::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Array::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Array::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Array::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Array::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Array::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

	typedef typename Array::iterator iterator;								///< @brief MIST̃Rei𑀍삷CSTLŌ̃_ANZXCe[^
	typedef typename Array::const_iterator const_iterator;					///< @brief MIST̃Rei𑀍삷C̃_ANZXCe[^̃RXg
	typedef typename Array::reverse_iterator reverse_iterator;				///< @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^
	typedef typename Array::const_reverse_iterator const_reverse_iterator;	///< @brief MIST̃Rei𑀍삷Ct̃_ANZXCe[^̃RXg

protected:
	typedef Array base;						///< @brief NX
	size_type size1_;						///< @brief X̗vf
	size_type size2_;						///< @brief Y̗vf
	size_type size3_;						///< @brief Z̗vf

	/// @brief w肳ꂽlȏ̐ōłŏ2̎wvZC̎wԂ
	//! 
	//! @param[in] v c Cӂ̔񕉂̐
	//!
	/// @return ͂ꂽ𒴂łŏ2̎w̎w
	//! 
	inline size_t floor_square_index( size_t v )
	{
		if( v == 0 )
		{
			return( 0 );
		}

		for( size_t i = 1, _2 = 2 ; i < 64 ; i++ )
		{
			if( v <= _2 )
			{
				return( i );
			}
			_2 *= 2;
		}

		return( 0 );
	}

	/// @brief w肳ꂽlȏ̐ōłŏ2̎wvZ
	//! 
	//! @param[in] v c Cӂ̔񕉂̐
	//!
	/// @return ͂ꂽ𒴂łŏ2̎w\
	//! 
	inline size_t floor_square( size_t v )
	{
		if( v == 0 )
		{
			return( 0 );
		}

		for( size_t i = 1, _2 = 2 ; i < 64 ; i++ )
		{
			if( v <= _2 )
			{
				return( _2 );
			}
			_2 *= 2;
		}

		return( 0 );
	}

public:
	/// @brief Rei̗vfύX
	//! 
	//! e̗vfw肳ꂽȏōŏ2̎wɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! 
	bool resize( size_type num1 )
	{
		if( base::resize( floor_square( num1 ) ) )
		{
			size1_ = num1;
			return( true );
		}
		else
		{
			size1_ = 0;
			return( false );
		}
	}


	/// @brief Rei̗vfύX
	//! 
	//! e̗vfw肳ꂽȏōŏ2̎wɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! 
	bool resize( size_type num1, size_type num2 )
	{
		size_type s1 = floor_square( num1 );
		size_type s2 = floor_square( num2 );
		size1_ = num1;
		size2_ = num2;
		s1 = s1 > s2 ? s1 : s2;
		if( !base::resize( s1, s1 ) )
		{
			size1_ = size2_ = 0;
			return( false );
		}

		return( true );
	}


	/// @brief Rei̗vfύX
	//! 
	//! e̗vfw肳ꂽȏōŏ2̎wɕύXCvfύXꂽꍇ̂ݑSĂ̗vfftHglŏD
	//! 
	//! @attention Kvf邽߂ɂ́Cfill ֐𗘗pĂD
	//! 
	//! 
	//! @param[in] num1 c TCYX̗vf
	//! @param[in] num2 c TCYY̗vf
	//! @param[in] num3 c TCYZ̗vf
	//! 
	bool resize( size_type num1, size_type num2, size_type num3 )
	{
		size_type s1 = floor_square( num1 );
		size_type s2 = floor_square( num2 );
		size_type s3 = floor_square( num3 );
		size1_ = num1;
		size2_ = num2;
		size3_ = num3;
		s1 = s1 > s2 ? s1 : s2;
		s1 = s1 > s3 ? s1 : s3;

		if( !base::resize( s1, s1, s1 ) )
		{
			size1_ = size2_ = size3_ = 0;
			return( false );
		}

		return( true );
	}


	/// @brief ReȋSĂ̓eւD
	//! 
	//! @attention ǂ炩̃ReiO𗘗pĂꍇ́CXbv͕Ks
	//! 
	//! ւ̃Rei a ̒gƑSēւ
	//! 
	//! @param[in] a  c eւΏ
	//! 
	//! @retval true  c f[^̃Xbvɐ
	//! @retval false c f[^̃XbvɎs
	//! 
	bool swap( buffered_array &a )
	{
		if( base::swap( a ) )
		{
			size_type tmp = size1_;
			size1_ = a.size1_;
			a.size1_ = tmp;

			tmp = size2_;
			size2_ = a.size2_;
			a.size2_ = tmp;

			tmp = size3_;
			size3_ = a.size3_;
			a.size3_ = tmp;

			return( true );
		}
		else
		{
			return( false );
		}
	}


	/// @brief Rei̗vfɂ
	//! 
	//! ReiɊi[Ăf[^Sč폜CReiivf0jɂ
	//! 
	void clear( )
	{
		base::clear( );
		size1_ = size2_ = size3_ = 0;
	}

	size_type size1( ) const { return( size1_ > 0 ? size1_ : base::size1( ) ); }	///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type size2( ) const { return( size2_ > 0 ? size2_ : base::size2( ) ); }	///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type size3( ) const { return( size3_ > 0 ? size3_ : base::size3( ) ); }	///< @brief Z̃ReiɊi[Ăf[^Ԃ
	size_type width( ) const { return( size1( ) ); }								///< @brief X̃ReiɊi[Ăf[^Ԃ
	size_type height( ) const { return( size2( ) ); }								///< @brief ỸReiɊi[Ăf[^Ԃ
	size_type depth( ) const { return( size3( ) ); }								///< @brief Z̃ReiɊi[Ăf[^Ԃ


private:
	/// @brief array Reif[^Rs[
	//! 
	//! @attention ]ȉ摜ɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& copy( const array< T, Allocator > &o )
	{
		size_type length = base::size( ) < o.size( ) ? base::size( ) : o.size( );
		for( size_type i = 0 ; i < length ; i++ )
		{
			( *this )[ i ] = static_cast< value_type >( o[ i ] );
		}
		return( *this );
	}


	/// @brief array1 Reif[^Rs[
	//! 
	//! @attention ]ȉ摜ɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& copy( const array1< T, Allocator > &o )
	{
		size_type length = base::size( ) < o.size( ) ? base::size( ) : o.size( );
		for( size_type i = 0 ; i < length ; i++ )
		{
			( *this )[ i ] = static_cast< value_type >( o[ i ] );
		}
		return( *this );
	}


	/// @brief array2 Reif[^Rs[
	//! 
	//! @attention ]ȉ摜ɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& copy( const array2< T, Allocator > &o )
	{
		size_type w = width( )  < o.width( )  ? width( )  : o.width( );
		size_type h = height( ) < o.height( ) ? height( ) : o.height( );
		for( size_type j = 0 ; j < h ; j++ )
		{
			for( size_type i = 0 ; i < w ; i++ )
			{
				( *this )( i, j ) = static_cast< value_type >( o( i, j ) );
			}
		}
		return( *this );
	}


	/// @brief array3 Reif[^Rs[
	//! 
	//! @attention ]ȉ摜ɂ͕ύX͉Ȃ
	//!
	//! @param[in] o  c Rs[̃Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& copy( const array3< T, Allocator > &o )
	{
		size_type w = width( )  < o.width( )  ? width( )  : o.width( );
		size_type h = height( ) < o.height( ) ? height( ) : o.height( );
		size_type d = depth( )  < o.depth( )  ? depth( )  : o.depth( );
		for( size_type k = 0 ; k < d ; k++ )
		{
			for( size_type j = 0 ; j < h ; j++ )
			{
				for( size_type i = 0 ; i < w ; i++ )
				{
					( *this )( i, j, k ) = static_cast< value_type >( o( i, j, k ) );
				}
			}
		}
		return( *this );
	}


public:
	/// @brief ^ buffered_array Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ buffered_array Rei
	//! 
	//! @return g
	//! 
	const buffered_array& operator =( const buffered_array &o )
	{
		if( this == &o ) return( *this );

		base::operator =( o );

		if( base::empty( ) )
		{
			size1_ = size2_ = size3_ = 0;
		}
		else
		{
			size1_ = o.size1_;
			size2_ = o.size2_;
			size3_ = o.size3_;
		}

		return( *this );
	}


	/// @brief vf̌^قȂ array Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& operator =( const array< T, Allocator > &o )
	{
		resize( o.size( ) );
		return( copy( o ) );
	}


	/// @brief vf̌^قȂ array1 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array1 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& operator =( const array1< T, Allocator > &o )
	{
		resize( o.size( ) );
		reso1( o.reso1( ) );
		return( copy( o ) );
	}


	/// @brief vf̌^قȂ array2 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array2 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& operator =( const array2< T, Allocator > &o )
	{
		resize( o.size1( ), o.size2( ) );
		reso1( o.reso1( ) );
		reso2( o.reso2( ) );
		return( copy( o ) );
	}


	/// @brief vf̌^قȂ array3 Rei
	//! 
	//! Rs[łRei o ƑSRei쐬D
	//! Rs[ił͎gj̗vf o ƈقȂꍇ́CIɃTCY𒲐D
	//! 
	//! @param[in] o  c Rs[ array3 Rei
	//! 
	//! @return g
	//! 
	template < class T, class Allocator >
	const buffered_array& operator =( const array3< T, Allocator > &o )
	{
		resize( o.size1( ), o.size2( ), o.size3( ) );
		reso1( o.reso1( ) );
		reso2( o.reso2( ) );
		reso3( o.reso3( ) );
		return( copy( o ) );
	}

public:
	/// @brief fBtHgRXgN^Dvf 0 ̃Rei쐬
	buffered_array( ) : base( ), size1_( 0 ), size2_( 0 ), size3_( 0 ) {}

	/// @briefRs[RXgN^
	buffered_array( const buffered_array &o ) : base( o ), size1_( o.size1( ) ), size2_( o.size2( ) ), size3_( o.size3( ) ) {}

	/// @brief array z o pďCӂ̒2̎wɂ
	template < class T, class Allocator >
	buffered_array( const array< T, Allocator > &o )
		: base( floor_square( o.size( ) ) ), size1_( o.size( ) ), size2_( 0 ), size3_( 0 )
	{
		copy( o );
	}

	/// @brief array1 z o pďCӂ̒2̎wɂ
	template < class T, class Allocator >
	buffered_array( const array1< T, Allocator > &o )
		: base( floor_square( o.size( ) ), o.reso1( ) ), size1_( o.size( ) ), size2_( 0 ), size3_( 0 )
	{
		copy( o );
	}

	/// @brief array2 z o pďCӂ̒2̎wɂ
	template < class T, class Allocator >
	buffered_array( const array2< T, Allocator > &o )
		: base( floor_square( o.size1( ) ), floor_square( o.size2( ) ), o.reso1( ), o.reso2( ) ), size1_( o.size1( ) ), size2_( o.size2( ) ), size3_( 0 )
	{
		copy( o );
	}

	/// @brief array3 z o pďCӂ̒2̎wɂ
	template < class T, class Allocator >
	buffered_array( const array3< T, Allocator > &o )
		: base( floor_square( o.size1( ) ), floor_square( o.size2( ) ), floor_square( o.size3( ) ), o.reso1( ), o.reso2( ), o.reso3( ) ),
			size1_( o.size1( ) ), size2_( o.size2( ) ), size3_( o.size3( ) )
	{
		copy( o );
	}
};


/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     a   c array z
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, 3, 4
//! @endcode
//! 
template < class T, class Allocator >
inline std::ostream &operator <<( std::ostream &out, const array< T, Allocator > &a )
{
	typename array< T, Allocator >::size_type i;
	for( i = 0 ; i < a.size( ) ; i++ )
	{
		out << a[ i ];
		if( i != a.size1( ) - 1 ) out << ", ";
	}

	return( out );
}


/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     a   c array1 z
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, 3, 4
//! @endcode
//! 
template < class T, class Allocator >
inline std::ostream &operator <<( std::ostream &out, const array1< T, Allocator > &a )
{
	typename array1< T, Allocator >::size_type i;
	for( i = 0 ; i < a.size( ) ; i++ )
	{
		out << a[ i ];
		if( i != a.size1( ) - 1 ) out << ", ";
	}

	return( out );
}


/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     a   c array2 z
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, 3, 4
//! 5, 6, 7, 8
//! 9, 10, 11, 12
//! @endcode
//! 
template < class T, class Allocator >
inline std::ostream &operator <<( std::ostream &out, const array2< T, Allocator > &a )
{
	typename array2< T, Allocator >::size_type i, j;
	for( j = 0 ; j < a.size2( ) ; j++ )
	{
		if( j != 0 )
		{
			out << std::endl;
		}
		for( i = 0 ; i < a.size1( ) ; i++ )
		{
			out << a( i, j );
			if( i != a.size1( ) - 1 ) out << ", ";
		}
	}

	return( out );
}


/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     a   c array3 z
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1, 2, 3, 4
//! 5, 6, 7, 8
//! 9, 10, 11, 12
//! ----- separator -----
//! 1, 2, 3, 4
//! 5, 6, 7, 8
//! 9, 10, 11, 12
//! @endcode
//! 
template < class T, class Allocator >
inline std::ostream &operator <<( std::ostream &out, const array3< T, Allocator > &a )
{
	typename array3< T, Allocator >::size_type i, j, k;
	for( k = 0 ; k < a.size3( ) ; k++ )
	{
		for( j = 0 ; j < a.size2( ) ; j++ )
		{
			for( i = 0 ; i < a.size1( ) ; i++ )
			{
				out << a( i, j, k );
				if( i != a.size1( ) - 1 ) out << ", ";
			}
			out << std::endl;
		}
		if( k != a.size3( ) - 1 )
		{
			out << "----- separator -----";
		}
		out << std::endl;
	}

	return( out );
}



// eReiɑ΂摜ԉZ

#if defined(_ARRAY_BIND_OPERATION_SUPPORT_) && _ARRAY_BIND_OPERATION_SUPPORT_ != 0
#include "operator/operator_array.h"
#endif

#if defined(_ARRAY1_BIND_OPERATION_SUPPORT_) && _ARRAY1_BIND_OPERATION_SUPPORT_ != 0
#include "operator/operator_array1.h"
#endif

#if defined(_ARRAY2_BIND_OPERATION_SUPPORT_) && _ARRAY2_BIND_OPERATION_SUPPORT_ != 0
#include "operator/operator_array2.h"
#endif

#if defined(_ARRAY3_BIND_OPERATION_SUPPORT_) && _ARRAY3_BIND_OPERATION_SUPPORT_ != 0
#include "operator/operator_array3.h"
#endif


// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_H__
