static    char    sccsid[]="%Z% %M% %I% %E% %U%";
#include "akxcommon.h"
#define M 2
#define keytype int

typedef struct _tag_Page
{
    int                 n;
    keytype             key[2*M];
    char               *datp[2*M];
    struct _tag_Page   *branch[2*M+1];
} Page;
/********
݂ɂȂ܂BŐkeyɂ͂intA()^ɂĂ邯ǁA͔͂rł^ȂȂł܂܂B


--------------------------------------------------------------------------------

T
Ƃ΁Å֐ɍ(root)ւ̃|C^ƒTL[^ƁÃL[܂ރy[W܂B

*********************************************************/
int search( Page* page, int key, Page **node)
{
	int k,max;

printf("search: key=%d page=%08x\n",key,page);

	if (node) *node = NULL;
	if (!page) return 0;
	k = 0;
	max = page->n;
    while ( k < max  &&  page->key[k] < key ) {
printf("search: k=%d page->key=%d\n",k,page->key[k]);
        k++;
	}
    if ( k < max  &&  page->key[k] == key ) {
		if (node) *node = page;
		return k + 1;
	}
    else
        return search( page->branch[k], key, node);
}
/***********************************************************************
T́A(root)͂߂āAy[WƂɌĂ܂B

ey[Wɂ́ÃL[(key)Ǝ}(branch)ւ̃|C^݂ɕł܂B̂ƂATf[^ƈvL[AƂ̂ƂƂłˁBvL[ȂꍇAL[̒l̑召֌WAǂ̎}TׂAƂ̂킩܂BvL[ȂāA}LтĂȂꍇÃc[ɂ͒Tf[^͊܂܂ĂȂƂƂ킩܂B

y[WɊ܂܂L[̐ő2MƂƁAy[Ŵ̂𒲂ׂƂ̃[v񐔂ő 2MAČȂăy[WǂĂȂ΂ȂȂ񐔂AőłN(c[Ɋ܂܂f[^̌)(MƂ)ΐɂȂ̂ŁA`T͂邩ɍłB


--------------------------------------------------------------------------------

}
TƓlɂāA璲ׂĂ܂B̂ƂA}f[^̃L[ƈvL[A͂łɃc[Ɋ܂܂ĂƂƂȂ̂ŉȂŏI܂BȂi}|C^NULLjꍇÃy[W̃L[̌2Mł΁Ãy[WɐVL[}܂B̃y[W̃L[̌2MłꍇAVL[܂߂2M+1̃L[̂M͂̃y[WɎcA傫MŐVy[W܂BcĺÃy[W獪ɌĂP߂y[WɒǉB̂Ƃɒǉ}|C^A傫Mōy[Ww悤ɂB邱ƂŁAP߂y[W̃L[̌2M𒴂΁A肩B
*************************************************************/
typedef struct {
	int  datalen;
	char *datap;
	char *adatp;
	int  index;
} qDataInfo;

static int _btree_get_data(qDataInfo *datinfp)
{
	char *p1,*p2;
	int  ret,adlen;

	if (!datinfp) return -1;
	p2 = NULL;
	ret = 0;
	if (p1=datinfp->datap) {
		if ((ret=akxt_get_gep_data(datinfp->datalen,p1,NULL,&adlen)) >= 0) {
printf("_btree_get_data: adlen=%d\n",adlen);
			if (!(p2 = Memdup(p1,adlen))) ret = -2;
		}
	}
	datinfp->adatp = p2;
	return ret;
}

Page*   create_page( void )
{
    Page* p;

	if (p = (Page *)Malloc(sizeof(Page))) {
		memset(p,0,sizeof(Page));
	}
    return p;
}

void   insert_item( Page* p, int k, int key, Page* newp, qDataInfo *datinfp )
{
    int i;

printf("insert_item: page=%08x k=%d key=%d\n",p,k,key);
    for ( i = p->n;  i > k;  i-- )
    {
        p->key[i] = p->key[i-1];
        p->branch[i+1] = p->branch[i];
    }
    p->key[k] = key;
    p->branch[k+1] = newp;
    p->n++;
	_btree_get_data(datinfp);
	p->datp[k] = datinfp->adatp;
	datinfp->index = k + 1;
}

void   insert_split( Page* p, int k, int* key, Page** newp, qDataInfo *datinfp )
{
    int j,m;
    Page* q;

printf("insert_split: page=%08x k=%d key=%d\n",p,k,*key);
    if ( k <= M )
        m = M;
    else
        m = M + 1;
    q = create_page();
    for (j=m+1; j<=2*M; j++)
    {
        q->key[j-m-1] = p->key[j-1];
        q->branch[j-m] = p->branch[j];
    }
    q->n = 2 * M - m;

    p->n = m;
    if ( k <= M )
        insert_item( p, k, *key, *newp, datinfp );
    else
        insert_item( q, k - m, *key, *newp, datinfp );

    *key = p->key[ p->n - 1 ];
    q->branch[0] = p->branch[ p->n ];
    p->n--;

    *newp = q;
}

int   insert_sub( Page* p, int* key, Page** newp, qDataInfo *datinfp )
{
    int k;

printf("insert_sub: key=%d page=%08x\n",*key,p);
    if ( p == NULL )
    {
        *newp = NULL;
        return 0;
    }

    k = 0;
    while ( k < p->n  &&  p->key[k]  <  *key ) {
printf("insert_sub: k=%d page->key=%d\n",k,p->key[k]);
        k++;
	}
    if ( k < p->n  &&  p->key[k] == *key )
        return 1;   /* łɓo^Ă*/

    if ( insert_sub( p->branch[k], key, newp, datinfp ) )
        return 1;   /* o^*/

    if ( p->n < 2*M )
    {
        insert_item( p, k, *key, *newp, datinfp );
        return 1;   /* o^*/
    }
    else
    {
        insert_split( p, k, key, newp, datinfp );
        return 0;
        /* y[W𕪊ł܂o^ĂȂ */
    }
}

int insert( Page** root, int key, qDataInfo *datinfp )
/* root|C^͕ύX\̂ŁA|C^œn */
{
	int ret;
    Page* newp;

    if (!(ret=insert_sub(*root, &key, &newp, datinfp))) {
        Page* p;
        p = create_page();
        p->n = 1;
        p->key[0] = key;
        p->branch[0] = *root;
        p->branch[1] = newp;
        *root = p;
		_btree_get_data(datinfp);
		p->datp[0] = datinfp->adatp;
		datinfp->index = 1;
		ret = 1;
printf("insert: ret=%d root=%08x page=%08x\n",ret,p,newp);
    }
	else if (ret > 0) {
printf("insert: ret=%d page=%08x\n",ret,newp);
		ret = datinfp->index;
	}
	return ret;
}
/************************************************
--------------------------------------------------------------------------------

폜
tłȂy[W̃L[ɂẮÃL[̎ɑ傫L[͕Ktɂ̂ŁA̍ڂꊷ΁A폜͕KtŋN悤ɂłBtL[폜ăL[MɂȂȂΗtłȂy[W̃L[ɂẮÃL[̎ɑ傫L[͕Ktɂ̂ŁA̍ڂꊷ΁A폜͕KtŋN悤ɂłBtL[폜ăL[MɂȂȂ΁AOiɋ߂j̃y[Wɖ߂āAߑaɂȂy[W̍Eǂ炩̃y[WPL[ĂBEǂL[MȂ΁Aǂ炩ƌăy[W炷Bitɋ߂j̃y[W΁Ãy[W̃|C^炳˂΂Ȃ炸Aăf[^炳Ȃ΂ȂȂ̂ŁAf[^PA
***********************************************************/
int delete_sub(Page *p, int i)
{
	int ret;
	Page *node,**br;

printf("delete_sub: page=%08x i=%d\n",p,i);
	if (!p) return 0;
	if (p->datp[i]) {
		Free(p->datp[i]);
		p->datp[i] = NULL;
	}
	br = &p->branch[0];
	if (!br[i] && !br[i+1]) {
		p->key[i] = 0;
		p->n--;
printf("delete_sub: leaf n=%d\n",p->n);
	}
	else if (node=br[i+1]) {
		p->key[i]  = node->key[0];
		p->datp[i] = node->datp[0];
		delete_sub(node,0);
	}
	else {
		for (;i<p->n-1;i++) {
			p->key[i]    = p->key[i+1];
			p->datp[i]   = p->datp[i+1];
			p->branch[i] = p->branch[i+1];
		}
		p->key[i]    = 0;
		p->datp[i]   = NULL;
		p->branch[i] = NULL;
		p->n--;
printf("delete_sub: move n=%d\n",p->n);
	}
	return 0;
}

int delete(Page** root, int key)
/* root|C^͕ύX\̂ŁA|C^œn */
{
	int ret,i;
	Page *node,**br;

	ret = search(*root, key, &node);
	if (ret > 0) {
printf("delete: key=%d ret=%d root=%08x node=%08x\n",key,ret,*root,node);
		i = ret -1;
		delete_sub(node, ret-1);
	}
	return ret;
}

int btree_proc(func,tph)
char  func;
HASHB *tph;
{
	int keylen,klen,d,aklen,adlen,ret,key;
	char cmd,*p1,*p2;
	Page *prev,*node,*next;
	qDataInfo datinf;

	if (!tph) return -1;
	if (!(p1=tph->ha_key)) return -2;
	keylen = tph->ha_keylen;
	next = (Page *)tph->ha_reg;
	key = atoi(p1);

	if ((cmd=toupper(func))=='R') {
		ret = search(next, key, &node);
		if (ret > 0) {
			tph->ha_next = (int *)node->datp[ret-1];
		}
	}
	else if (cmd=='S') {
		datinf.datalen = (int)tph->ha_maxreg;
		datinf.datap   = (char *)tph->ha_next;
		ret = insert((Page **)&tph->ha_reg, key, &datinf);
	}
	else if (func=='D') {
		ret = delete((Page **)&tph->ha_reg, key);
	}
	return ret;
}

HASHB *btree_new(sKeyLen,sDatLen,iOpt)
short sKeyLen;
short sDatLen;
int   iOpt;
{
	HASHB *tph;

	if (!(tph=(HASHB *)Malloc(sizeof(HASHB)))) return NULL;
	memset(tph,0,sizeof(HASHB));
	tph->ha_id[0] = 'B';
	tph->ha_id[1] = 'T';
	tph->ha_keylen    = sKeyLen;
	tph->ha_maxreg = sDatLen;
	return tph;
}

static void _node_free(p)
Page *p;
{
	int i;

	for (i=0;i<2*M+1;i++) {
		if (p->branch[i]) _node_free(p->branch[i]);
		if (p->datp[i]) Free(p->datp[i]);
	}
printf("_node_free: page=%08x\n",p);
	Free(p);
}

int btree_free(tph)
HASHB *tph;
{
	if (tph) {
		if (tph->ha_reg) _node_free((Page *)tph->ha_reg);
		Free(tph);
	}
	return 0;
}
