static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akasysclass.c
 *
 *        coded by A.Kobayashi 2004/02/21
 *
 *************************************************/
#include "akacommon.h"


extern tdtMSG_CTL          tMsgCtl;
extern tdtCLASS_CTLHead    tClassHead;
extern tdtSTATISTICS      tStatistics,tStat2;

static char *nullstring="";
static char *nullname=AKX_NULL_PRINT;

static int  sys_reg_del_class();
static int  sys_watch_class();
static int  sys_log_class();
static int  sys_shut_class();
static int  sys_statistics_class();
extern int  aka_sys_password_class();
static int _statistics();
static int _statistics_fileout();
static int _statistics_edit();
static int _statistics_Timer();
static int _statistics_que();
static int _statistics_cha_rb();
static int _statistics_time_out();
static int _statistics_rwbuf();
static int _statistics_memory();
static int _statistics_class();
static int _statistics_channel();
static int  sys_version_class();
static int  sys_memory_class();
static int  sys_help_class();
static int  sys_property_class();
static int  sys_query_class();

/********************************************************/
/*                                                      */
/********************************************************/
int aka_regist_sys_class()
{
	int iRc;

	if (iRc = aka_register_class2(sys_watch_class,AKA_CLASS_WATCH,0,1,1,
	                            AKA_CLASS_NAME_WATCH)) return iRc;
	if (iRc = aka_register_class2(sys_log_class,AKA_CLASS_LOG,0,1,1,
	                            AKA_CLASS_NAME_LOG)) return iRc;
	if (iRc = aka_register_class2(sys_shut_class,AKA_CLASS_SHUT,0,1,1,
	                            AKA_CLASS_NAME_SHUT)) return iRc;
	if (iRc = aka_register_class2(sys_shut_class,AKA_CLASS_FSHUT,0,1,1,
	                            AKA_CLASS_NAME_FSHUT)) return iRc;
	if (iRc = aka_register_class2(sys_statistics_class,AKA_CLASS_STATISTICS,0,2,2,
	                            AKA_CLASS_NAME_STATISTICS)) return iRc;
	if (iRc = aka_register_class2(aka_sys_password_class,AKA_CLASS_PASSWORD,0,1,1,
	                            AKA_CLASS_NAME_PASSWORD)) return iRc;
	if (iRc = aka_register_class2(sys_reg_del_class,AKA_CLASS_REGIST,0,1,0,
	                            AKA_CLASS_NAME_REGIST)) return iRc;
	if (iRc = aka_register_class2(sys_reg_del_class,AKA_CLASS_DELETE,0,1,0,
	                            AKA_CLASS_NAME_DELETE)) return iRc;
	if (iRc = aka_register_class2(sys_version_class,AKA_CLASS_VERSION,0,1,0,
	                            AKA_CLASS_NAME_VERSION)) return iRc;
	if (iRc = aka_register_class2(sys_memory_class,AKA_CLASS_MEMORY,0,1,0,
	                            AKA_CLASS_NAME_MEMORY)) return iRc;
	if (iRc = aka_register_class2(sys_help_class,AKA_CLASS_HELP,0,1,0,
	                            AKA_CLASS_NAME_HELP)) return iRc;
	if (iRc = aka_register_class2(sys_property_class,AKA_CLASS_PROPERTY,0,1,0,
	                            AKA_CLASS_NAME_PROPERTY)) return iRc;
	if (iRc = aka_register_class2(sys_query_class,AKA_CLASS_QUERY,0,1,0,
	                            AKA_CLASS_NAME_QUERY)) return iRc;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int shut_control_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
DEBUGOUTL1(AKA_LOG_GROUP|254,"shut_control_timer: ShutMode=%d",cpParm[0]);
/*	aka_shut_control(AKA_SHUT_MODE,cpParm);	*/
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_shut_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	AKAMSGCOM    tReplyMsg;
	tdtINST_HNDL tInstHndl;
	uchar ucShutMode[2],*up;
	int ret;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_disp > 0 ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
	}

	aka_wake_up_msg(AKA_CLASS_STATISTICS,D_ERR_SHUT_WAKEUP);

DEBUGOUTL3(AKA_LOG_GROUP|254,
"sys_shut_class: lInstanceHandle=%08x AkbOption=%08x lOption=%08x",
lInstanceHandle,tpRecvMsg->msg_aopt,tpRecvMsg->msg_kopt);

	if (!(tpRecvMsg->msg_aopt & AKA_AKO_EXTENSION) ||
	    !(tpRecvMsg->msg_kopt & AKA_EXO_COMMAND)) {
		aka_conv_inst_hndl2(lInstanceHandle,&tInstHndl,0);
DEBUGOUTL1(AKA_LOG_GROUP|254,"sys_shut_class: iClassId=%d",tInstHndl.class_id);
		if (tInstHndl.class_id == AKA_CLASS_SHUT) {
			ucShutMode[0] = 1;
			tpRecvMsg->msg_pmsg = "R -254";
		}
		else {
			ucShutMode[0] = 2;
			tpRecvMsg->msg_pmsg = "R -255";
		}
		tpRecvMsg->msg_mlen = strlen(tpRecvMsg->msg_pmsg);
#if 1
	/*	up = (uchar *)Malloc(2);
		memcpy(up,ucShutMode,2);	*/
		aka_register_timer("shut_control_timer",shut_control_timer,500,up);
#endif
		aka_shut_control(AKA_SHUT_MODE,ucShutMode);
	}
	if (tMsgCtl.regist_dest_pid != tpRecvMsg->msg_prid) {
		ret = aka_reply_msg(lInstanceHandle,tpRecvMsg);
DEBUGOUTL1(AKA_LOG_GROUP|254,"sys_shut_class: aka_reply_msg ret=%d",ret);
	}

	return 0;
}
#if 0
/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics(buf, iopt, mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	static char *stat[]={"start","stop "};
	int len,ret=0,i,n,iLen,opt0_1,opt0_2;
	tdtCLASS_CTL   *tpClass;
	tdtINSTANCE   *tpIns;
	tdtWAIT_PACKET *tpNext;
	char          *p,*p2;
	tdtTIMER_CTL   *next;
	tdtCHANNEL    *pCh,**ppCh;
	tdtREP_HEAD    *pRH;
	tdtCHANNEL_USER_IO *pCuio;
	pCOMM_PACK_HEAD pHd;
	char wrk[AKA_CHANNEL_SEQMAX*2+1];
	struct timeval tval;
	struct tm t;
	tdtMETHOD *pMethod;

	if (!(p=akb_log_get_proc_name())) p = nullname;
	aka_get_msec(&tval);
	akxe_edit_elapse_time(tval.tv_sec,&t);
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\n\nMaxThreadTotal : %d   UsedThreadTotal : %d\n\nClassId    Option  DataSize  MaxThread  UsedCount  Name\n",
	        p,tMsgCtl.proc,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec,
	        tClassHead.max_thread_total,tClassHead.used_thread_total);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	opt0_1 = iopt[0] & 0x01;	/* display instance */
	opt0_2 = iopt[0] & 0x02;	/* display no_display class */
	tpClass = tClassHead.class;
	while (tpClass) {
		if (((tpClass->class_id >= AKA_CLASS_FSHUT) ||
		     ((tpClass->class_id < AKA_CLASS_FSHUT) &&
		      (tpClass->option & AKA_RCO_NODISPLAY))) && !opt0_2) {
			tpClass = tpClass->class_next;
			continue;
		}
		sprintf(buf,"%7d  %08x  %8d  %9d  %9d  %s",
		        tpClass->class_id,tpClass->option,
		        tpClass->instance_data_size,
		        tpClass->max_thread,tpClass->used_count,tpClass->class_name);
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		if (tpClass->func_name2) {
			if (!(p=tpClass->class_name2)) p = nullname;
			sprintf(buf,"(%s[%d])\n",p,tpClass->instance_data_size2);
		}
		else strcpy(buf,"\n");
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		/* print Method */
		if (pMethod=tpClass->method) {
			for (i=0;i<tpClass->max_method;i++,pMethod++) {
				if (!(p=pMethod->method_name)) p = nullname;
				if (!(p2=pMethod->explain)) p2 = nullname;
				sprintf(buf,"               method maxparm=%3d option=%08x [%s %s]\n",pMethod->max_parm,pMethod->option,p,p2);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
			}
		}
		/* print Instance */
		if (opt0_1 && tpClass->used_count > 0) {
			tpIns = &tpClass->instance[0];
			for (i=0;i<tpClass->max_thread;i++,tpIns++) {
				if (tpIns->used) {
					n = 0;
					tpNext = tpIns->wait_next;
					while (tpNext) {
						n++;
						tpNext = tpNext->wait_next;
					}
					sprintf(buf,"                   thread no=%3d wait packet =%3d",i+1,n);
					if ((ret = akxtmcats(mcat,buf))<0) return ret;
					if (tpIns->comment) {
						if ((ret = akxtmcats(mcat," <"))<0) return ret;
						if ((ret = akxtmcats(mcat,tpIns->comment))<0) return ret;
						if ((ret = akxtmcats(mcat,">"))<0) return ret;
					}
					if ((ret = akxtmcats(mcat,"\n"))<0) return ret;
				}
			}
		}
		tpClass = tpClass->class_next;
	}

	if ((ret = _statistics_que(buf,mcat)) < 0) return ret;

	if ((ret = _statistics_edit(tval.tv_sec,buf,mcat)) < 0) return ret;

	if (iopt[1]) {
		if ((ret = akxtmcats(mcat,"\nChannelNo Status Socket Select HeadLen Heads Opt   SysOpt\n"))<0) return ret;
		ppCh = tMsgCtl.channel_pa;
		for (i=0;i<tMsgCtl.channel_used;i++,ppCh++) {
			if ((pCh = *ppCh) && pCh->status) {
				sprintf(buf,"%9d     %02x %6d %6d %7d %5d  %02x %08x\n",
				        pCh->index, pCh->status, pCh->sd,
				        pCh->select, pCh->head_len, pCh->resv4,
				        pCh->opt, pCh->sys_opt);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
#ifndef NO_CHANNEL_QUE
				akxs_que_move(pCh->wpack_que,QUE_TOP_PREV);
				while ((n=akxs_que_peek(pCh->wpack_que,QUE_NEXT,&pRH)) > 0) {
					if (pRH) {
						pHd = (pCOMM_PACK_HEAD )pRH;
						iLen = ntohl(pHd->cph_plen);
						wrk[akxcxtoc(pRH->sequence,iLen,wrk)] = '\0';
						sprintf(buf,"    Seq InstHandl=%08x len=%2d No=%s [%s]\n",
							pRH->instance_handle,iLen,wrk,pRH->sequence);
						if ((ret = akxtmcats(mcat,buf))<0) return ret;
					}
				}
#endif
				if (pCuio=pCh->cuio) {
					sprintf(buf,"\n    SelectInterval=%d Parm=%08x\n    Open    =%08x Connect =%08x Select  =%08x\n    Read    =%08x Write   =%08x WriteEnd=%08x\n    Shutdown=%08x Close   =%08x Accept  =%08x\n",
						pCuio->select_interval, pCuio->parm,
						pCuio->open, pCuio->connect, pCuio->select,
						pCuio->read, pCuio->write, pCuio->write_end,
						pCuio->shutdown, pCuio->close, pCuio->accept);
					if ((ret = akxtmcats(mcat,buf))<0) return ret;
				}
			}
		}
		if (iopt[1] & 0x02) {
			if ((ret = _statistics_rwbuf(buf,mcat)) < 0) return ret;
		}
		if (iopt[1] & 0x04) {
			if ((ret = _statistics_cha_rb(buf,mcat)) < 0) return ret;
		}
	}
	if (iopt[2]) {
		if ((ret = _statistics_timer(buf,mcat)) < 0) return ret;
	}
	if (iopt[3]) {
		if ((ret = _statistics_time_out(buf,mcat)) < 0) return ret;
	}
	if ((ret = _statistics_memory(buf,mcat)) < 0) return ret;
	return 0;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
static int sys_reg_del_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	tdtINST_HNDL tInstHndl;
	AKAMSGCOM tSendMsg;
	int iRc,iClass,iReply,iCh;
	uchar ucShutMode[2];
	tdtCHANNEL *pCh;
	INT4 lHostId;
	tdtRW_QUE *pRQ,*pWQ;
	char buf[16],*p;

	aka_conv_inst_hndl2(lInstanceHandle,&tInstHndl,0);
	iClass = tInstHndl.class_id;
	iReply = 0;
	switch (tpRecvMsg->msg_disp) {
	case AKA_REGIST_CLASS:
		break;
	case 0:
		if (tpRecvMsg->msg_pret < 0) break;
	/*
		if (tpRecvMsg->msg_prid == aka_get_regist_pid()) {
	*/
		if ((tpRecvMsg->msg_aopt & AKA_AKO_EXTENSION) &&
		    (tpRecvMsg->msg_kopt & AKA_EXO_COMMAND)) {
			if (tpRecvMsg->msg_aopt & AKA_AKO_CHANNEL_CMD) {
				akb_get_text_addr4(htonl(tpRecvMsg->msg_hoid),buf,sizeof(buf));
				iCh = tpRecvMsg->msg_prid;
				if (tpRecvMsg->msg_mlen > 0) {
					p = tpRecvMsg->msg_pmsg;
					akxtsrepc(p,'\r',' ');
					akxtsrepc(p,'\n',';');
				}
				else p = "";
				if (iClass == AKA_CLASS_REGIST) {
					if (pCh=aka_channel_get(iCh)) {
					/*	pCh->lHostId = tpRecvMsg->lHostId;	*/
						lHostId = tpRecvMsg->msg_hoid;
						pRQ = tMsgCtl.read_que_pa[iCh];
						pWQ = tMsgCtl.write_que_pa[iCh];
						if (pRQ && pWQ) {
							if (lHostId != tMsgCtl.my_host_id) {
								pRQ->rwq_option = AKB_RQUE_OPT_XTOF;
								pWQ->rwq_option = AKB_WQUE_OPT_MAKE_XPACK;
							}
							else {
								pRQ->rwq_option = 0;
								pWQ->rwq_option = 0;
							}
						}
					}
					PRINTOUT3("*** Term Registed: HID[%s],TermID[%d],Info[%s]",
					         buf,iCh,p);
				}
				else {
					PRINTOUT3("*** Term Canceled: HID[%s],TermID[%d],Info[%s]",
					         buf,iCh,p);
				}
			}
		}
		else {
			if ((iClass==AKA_CLASS_REGIST && !aka_init_status(AKA_IST_REGISTED,0)) ||
			    (iClass==AKA_CLASS_DELETE && aka_init_status(AKA_IST_REGISTED,0))) {
				memset(&tSendMsg,0,sizeof(AKAMSGCOM));
				tSendMsg.msg_pmsg   = tpRecvMsg->msg_pmsg;
				tSendMsg.msg_mlen = tpRecvMsg->msg_mlen;
				tSendMsg.msg_prid  = AKB_PRID_PROM;
				tSendMsg.msg_clid = iClass;
				tSendMsg.msg_disp = 2;
				tSendMsg.msg_aopt = AKA_AKO_EXTENSION;
				tSendMsg.msg_kopt = AKA_EXO_COMMAND;
				iRc = aka_send_msg(lInstanceHandle,&tSendMsg);
				if (!iRc) return 1;
				ERROROUT2("SysRegDel:class=%d SedMsg ret=%d",iClass,iRc);
			}
			else ERROROUT("SysRegDel:o^ς݁A܂́A폜ς");
		}
		iReply = tpRecvMsg->msg_resv;
		break;
	case 2:
		if ((iRc=tpRecvMsg->msg_pret) < 0) {
			ERROROUT2("SysRegDel:class=%d akberr=%d",iClass,iRc);
			if (iClass == AKA_CLASS_REGIST) {
				ucShutMode[0] = 2;	/* FSHUT */
				aka_shut_control(AKA_SHUT_MODE,ucShutMode);
			}
		}
		else {
			if (iClass == AKA_CLASS_REGIST) {
				aka_init_status(AKA_IST_REGISTED,1);
				aka_set_regist_dest_pid(tpRecvMsg->msg_prid);
			}
			else if (iClass == AKA_CLASS_DELETE) aka_init_status(AKA_IST_REGISTED,-1);
		}
		iReply = tpRecvMsg->msg_resv;
		break;
	}
	if (iReply) {
		tpRecvMsg->msg_aopt = AKA_AKO_EXTENSION;
		tpRecvMsg->msg_kopt = AKA_EXO_REGIST;
		tpRecvMsg->msg_mlen = 0;
		iRc = aka_reply_msg(lInstanceHandle,tpRecvMsg);
DEBUGOUTL1(AKA_LOG_GROUP|254,"sys_reg_del_class: aka_reply_msg ret=%d",iRc);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_version_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
tdtMSG_COM *tpRecvMsg;
{
	char *pver,*pdate,*pVD[2];
	int  vrlen,dtlen,iVDL[2];
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};

	switch (tpRecvMsg->msg_disp) {
	case AKA_REGIST_CLASS:
		break;
	case 0:
		if (tpRecvMsg->msg_pret < 0) break;
		if (!mcat.mc_bufp) {
			aka_get_ver_date(pVD,iVDL);
			vrlen = iVDL[0];
			dtlen = iVDL[1];
			pver  = pVD[0];
			pdate = pVD[1];
			akxtmcat(&mcat,pver,vrlen);
			akxtmcat(&mcat,"\n",1);
			akxtmcat(&mcat,pdate,dtlen);
			akxtmcat(&mcat,"\n",2);
		}
		memset(tpRecvMsg,0,sizeof(tdtMSG_COM));
		tpRecvMsg->msg_pmsg   = mcat.mc_bufp;
		tpRecvMsg->msg_mlen = mcat.mc_ipos;
		aka_reply_msg(lInstanceHandle,tpRecvMsg);
	}
	return 0;
}

static int sys_query_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
tdtMSG_COM *tpRecvMsg;
{
	char buf[256],*p;

	switch (tpRecvMsg->msg_disp) {
	case AKA_REGIST_CLASS:
		break;
	case 0:
		if (tpRecvMsg->msg_pret < 0) break;
		p = buf;
		strcpy(p,"*********  Process Table (                  )  *********\n");
		p += strlen(p);
		strcpy(p,"No. Socket Regist ShutOd Status ProcId V ProcessName    \n");
		p += strlen(p);
		sprintf(p,"%3d %6d %6d %6d   %04x %6d %c %s\n",1,aka_get_connect_sd(),
			     aka_get_regist_pid(),0,aka_init_status(0xff,0),
			     aka_get_regist_pid(),aka_get_regist_ver(),akb_log_get_proc_name());
		memset(tpRecvMsg,0,sizeof(tdtMSG_COM));
		tpRecvMsg->msg_pmsg   = buf;
		tpRecvMsg->msg_mlen = strlen(buf);
		aka_reply_msg(lInstanceHandle,tpRecvMsg);
	}
	return 0;
}

#define AKA_INCLUDE
#include "../akas/akaclass.c"
