/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.dnj;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DokonanJar {
    private String userHome = System.getProperty("user.home");
    private List<File> gradleJarList;
    private List<File> mavenJarList;

    public DokonanJar(Properties prop) {
        String customUserHome = prop.getProperty("user.home");
        if (customUserHome != null && customUserHome.trim().length() > 0) {
            this.userHome = customUserHome;
        }
    }

    public int[] initSearch() {
        this.gradleJarList = this.getAllJarForGradle();
        this.mavenJarList = this.getAllJarForMaven();
        return new int[]{this.gradleJarList.size(), this.mavenJarList.size()};
    }

    public List<File> getAllJarForGradle() {
        ArrayList<File> fileList = new ArrayList<File>();
        File gradleDir = new File(this.userHome, ".gradle");
        File[] dirs = gradleDir.listFiles();
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String fname = f.getName();
                if (fname.equals("caches") || fname.equals("wrapper")) {
                    this.searchFiles(f, null, fileList);
                }
                ++n2;
            }
        }
        return fileList;
    }

    public List<File> getAllJarForMaven() {
        ArrayList<File> fileList = new ArrayList<File>();
        File gradleDir = new File(this.userHome, ".m2");
        File[] dirs = gradleDir.listFiles();
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.searchFiles(f, null, fileList);
                ++n2;
            }
        }
        return fileList;
    }

    public List<File> searchFiles(File dir, String path, List<File> fileList) {
        File[] files;
        if (fileList == null) {
            fileList = new ArrayList<File>();
        }
        if ((files = dir.listFiles()) != null) {
            File f;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                String fname = f.getName();
                if (f.isFile() && fname.endsWith(".jar") && !fname.endsWith("sources.jar") && (path == null || fname.contains(path))) {
                    fileList.add(f);
                }
                ++n2;
            }
            fileArray = files;
            n = files.length;
            n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                if (f.isDirectory()) {
                    this.searchFiles(f, path, fileList);
                }
                ++n2;
            }
        }
        return fileList;
    }

    public List<File> searchJarForGradle(String[] paths) {
        return this.searchJar(paths, this.gradleJarList);
    }

    public List<File> searchJarForMaven(String[] paths) {
        return this.searchJar(paths, this.mavenJarList);
    }

    public List<File> searchJar(String[] paths, List<File> targetFiles) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : targetFiles) {
            String filebody = f.getName().substring(0, f.getName().length() - 4);
            if (!DokonanJar.isContainsAll(filebody, paths)) continue;
            fileList.add(f);
        }
        return fileList;
    }

    public static boolean isContainsAll(String s, String[] members) {
        int i = 0;
        while (i < members.length) {
            if (!s.contains(members[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

