/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.dnj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DokonanFrame {
    public static final int INPUT_END_WAIT_MSEC = 200;
    private JFrame frame;
    private JCheckBox cbGradle;
    private JCheckBox cbMaven;
    private JTextField txtField;
    private JEditorPane resultArea;
    private JButton copyButton;
    public String fontName = null;
    private long lasttime = 0L;
    private ChangeListener changeListener;

    public void initComponent() {
        this.frame = new JFrame();
        this.frame.setSize(600, 300);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("DokonanJar - Gradle/Maven\u306eJar\u30d5\u30a1\u30a4\u30eb\u3092\u63a2\u3057\u3066\u30b3\u30d4\u30fc");
        final Font font = this.fontName == null ? this.frame.getFont() : new Font(this.fontName, 0, 12);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(0, 4, 0, 4));
        topPanel.setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)topPanel, "North");
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BorderLayout());
        topPanel.add((Component)editPanel, "North");
        this.cbGradle = new JCheckBox("Gradle");
        this.cbMaven = new JCheckBox("Maven");
        this.cbGradle.setSelected(true);
        this.cbMaven.setSelected(false);
        this.cbMaven.setFont(font);
        this.cbGradle.setFont(font);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(this.cbGradle);
        panel.add(this.cbMaven);
        editPanel.add((Component)panel, "Center");
        CheckBoxActionListener cbActionListener = new CheckBoxActionListener();
        this.cbGradle.addActionListener(cbActionListener);
        this.cbMaven.addActionListener(cbActionListener);
        this.txtField = new JTextField();
        this.txtField.getDocument().addDocumentListener(new FiDocumentListener());
        this.txtField.setToolTipText("\u3053\u3053\u306b\u5165\u529b\u3057\u305f\u6587\u5b57\u5217\u3092\u542b\u3080\u30d5\u30a1\u30a4\u30eb\u3092\u63a2\u3057\u307e\u3059\u3002\u7a7a\u767d\u533a\u5207\u308a\u3067\u8907\u6570\u6761\u4ef6");
        this.txtField.setFont(font);
        topPanel.add((Component)this.txtField, "South");
        this.resultArea = new JEditorPane();
        this.resultArea.setContentType("text/html; charset=UTF-8");
        this.resultArea.setFont(font);
        this.resultArea.setEditable(false);
        this.resultArea.setText("\u30ed\u30fc\u30ab\u30eb\u306b\u3042\u308bGradle/Maven\u306ejar\u3092\u30b9\u30ad\u30e3\u30f3\u4e2d\u3067\u3059...");
        if (font != null) {
            this.resultArea.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
        JScrollPane scrollPane = new JScrollPane(this.resultArea);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel2.setLayout(new BorderLayout());
        panel2.add(scrollPane);
        this.frame.getContentPane().add((Component)panel2, "Center");
        this.copyButton = new JButton("\u51fa\u529b\u5148\u306b\u30b3\u30d4\u30fc"){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip();
                toolTip.setFont(font);
                return toolTip;
            }
        };
        panel = new JPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.setLayout(new BorderLayout());
        panel.add(this.copyButton);
        editPanel.add((Component)panel, "East");
        this.frame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(Window w) {
                return DokonanFrame.this.txtField;
            }
        });
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JCheckBox getGradleCheckBox() {
        return this.cbGradle;
    }

    public JCheckBox getMavenCheckBox() {
        return this.cbMaven;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JEditorPane getResultArea() {
        return this.resultArea;
    }

    private synchronized void setLastTime(long msec) {
        this.lasttime = msec;
    }

    private synchronized long getLastTime() {
        return this.lasttime;
    }

    public void setChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void fireChangeListener(final String s) {
        final long msec = System.currentTimeMillis();
        this.setLastTime(msec);
        if (s.length() <= 0) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    long past;
                    do {
                        Thread.sleep(25L);
                        if (DokonanFrame.this.getLastTime() == msec) continue;
                        return;
                    } while ((past = System.currentTimeMillis() - msec) < 200L || !DokonanFrame.this.copyButton.isEnabled());
                    DokonanFrame.this.changeListener.stateChanged(new ChangeEvent(s));
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private class CheckBoxActionListener
    implements ActionListener {
        private CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DokonanFrame.this.fireChangeListener(DokonanFrame.this.txtField.getText());
        }
    }

    private class FiDocumentListener
    implements DocumentListener {
        private FiDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String s = doc.getText(0, doc.getLength());
                DokonanFrame.this.fireChangeListener(s);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}

