static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
 *	akxsList.c
 *
 *		coded   by A.Kobayashi 2004.4.18
 *
 *
 */
#include "akxcommon.h"

tdtRB_CTL *akxs_list_new(lBS,lRM)
int lBS,lRM;
{
	tdtRB_CTL *pCt;

	if (!(pCt = (tdtRB_CTL *)Malloc(sizeof(tdtRB_CTL)))) return NULL;
	memset(pCt,0,sizeof(tdtRB_CTL));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	return pCt;
}

int akxs_list_free(pCt,free_func)
tdtRB_CTL *pCt;
int (*free_func)();
{
	tdtRB_CHAIN *pw, *pn, *pp;
	char *p;

	if (!pCt) return -1;
	while (akxs_list_get(pCt,&p) > 0) {
		if (p) {
			if (free_func) free_func(p);
			else Free(p);
		}
	}
	Free(pCt);
	return 0;
}

int akxs_list_peek(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pr;

	if (!pCt) return -1;
	if (pr = pCt->rb_raddr) {
		*pp = pr->rbc_buf;
		return 1;
	}
	else return 0;
}

int akxs_list_peek_n(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pw;

	if (!pCt) return -1;
	if (pw = pCt->rb_waddr) {
		*pp = pw->rbc_buf;
		return 1;
	}
	else return 0;
}

int akxs_list_get(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pr;

	if (!pCt) return -1;
	
	if (pr = pCt->rb_raddr) {
		*pp = pr->rbc_buf;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
		if (pr == pCt->rb_waddr) pCt->rb_waddr = NULL;
		Free(pr);
		return 1;
	}
	else return 0;
}

int akxs_list_get_n(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pr, *pre, *pn;

	if (!pCt) return -1;
	
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
		if (!(pn = pr->rbc_next)) {
			*pp = pr->rbc_buf;
			if (pre) pre->rbc_next = pn;
			else pCt->rb_raddr = pn;
			pCt->rb_waddr = pre;
			pCt->rb_used--;
			return 1;
		}
		pre = pr;
		pr = pn;
	}
	return 0;
}

int akxs_list_set(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn;

	if (!pCt) return -1;
	
	if (!(pn = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) return 0;
	pn->rbc_buf = addr;
	pn->rbc_next = NULL;
	if (pw = pCt->rb_waddr) pw->rbc_next = pn;
	else pCt->rb_raddr = pn;
	pCt->rb_waddr = pn;
	pCt->rb_used++;
	return 1;
}

int akxs_list_set_t(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pr, *pn, *pp;

	if (!pCt) return -1;
	
	if (!(pn = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) return 0;
	pr = pCt->rb_raddr;
	pn->rbc_buf = addr;
	pn->rbc_next = pr;
	pCt->rb_raddr = pn;
	if (!pCt->rb_waddr) pCt->rb_waddr = pn;
	pCt->rb_used++;
	return 1;
}

int akxs_list_srch(pCt, addr, compar, opt)
tdtRB_CTL *pCt;
char *addr;
int (*compar)();
int opt;
{
	int f;
	tdtRB_CHAIN *pr,*pre;
	char *p;

	if (!pCt) return -1;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
		if (compar) f = !compar(addr,pr->rbc_buf);
		else f = (addr == pr->rbc_buf);
		if (f) {
			if (opt) {
				if (pre) pre->rbc_next = pr->rbc_next;
				else pCt->rb_raddr = pr->rbc_next;
				if (!pr->rbc_next) pCt->rb_waddr = pre;
				pCt->rb_used--;
			}
			pCt->rb_cur = pr;
			return 1;
		}
		pre = pr;
		pr = pr->rbc_next;
	}
	return 0;
}

int akxs_list_read(pCt, cmd, pp)
tdtRB_CTL *pCt;
int     cmd;
char   **pp;
{
	tdtRB_CHAIN *pr;

	if (!pCt) return -1;

	if (!cmd) {
		pCt->rb_cur = NULL;
	}
	else {
		if (cmd > 0) {
			if (pr = pCt->rb_cur) pr = pr->rbc_next;
			else pr = pCt->rb_raddr;
		}
		else {
			if (!(pr = pCt->rb_cur)) pr = pCt->rb_raddr;
		}
		if (pr) {
			pCt->rb_cur = pr;
			*pp = pr->rbc_buf;
			return 1;
		}
	}
	return 0;
}
