/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// this code is rewrite of flat_hash_map(cpp boost license) for c-lang.
// https://github.com/skarupke/flat_hash_map/blob/master/flat_hash_map.hpp

/*SH_doc
title=hfl section=3 repnl=\040

@name hfl
@_brief hash api for C-lang
@_syno
 typedef struct hfl_node_tag {
 	int tp;	//int/dbl/ptr/str(or struct) == 'i'/'d'/'p'/'s'
 	char* key;
 	int i;
 	double d;
 	void* p;
 	void* s;
 	//..inner data
 } hfl_nt;
 
 typedef struct hfl_tag{
 	uint32_t cnt;
 	//..inner data
 } hfl_t;
 
 hfl_t*  hfl_new([uint32_t sz]);
 void*	hfl_free(hfl_t* obj);
 hfl_nt* hfl_unset(hfl_t* obj, char* k);
 hfl_nt* hfl_find(hfl_t* obj, char* k);
 
 #define hfl_set_i(obj,k,v)	
 #define hfl_set_d(obj,k,v)
 #define hfl_set_p(obj,k,v)
 #define hfl_set_s(obj,k,ptr,[sz])
 #define hfl_foreach(node, obj)
	
@tl_dr
		@(code)
 #include "hfl.h"
 
 int main(int argc, char** argv){
 	hfl_t* obj = hfl_new();
 	hfl_nt* rp = hfl_set_i(obj, "k1", 12);
 	puts(rp->key);	// "k1"
 	int tp = rp->tp;	// int == 'i'
 	hfl_unset(obj, "k1");	//del
 
 	rp = hfl_set_s(obj, "k2", "hw");
 	puts(rp->s);	// "hw"
 	rp = hfl_find(obj, "k2");
 	puts(rp->s);	// "hw"
 	
 	float n = 12.3;
 	rp = hfl_set_s(obj, "k3", &n, sizeof(float) );
 	// ag4 isnt >> strdup()
 	// ag4 exist >> malloc()
 	n = *(float*)(rp->s);
 	
 	hfl_foreach(p, obj){
 		puts(p->key);
 		hfl_set_i(obj, p->key, 2);	//ok, replace/update
 		hfl_unset(obj, p->key);	//ok
 		// hfl_set_i(obj, "new", 2);	//NG, add newkey
 		p->i = 10;	//ok
 	}
 	
 	rp = hfl_unset(obj, "k2");
 	rp = hfl_find(obj, "k2");	//rp == NULL;
 	int cnt = obj->cnt;	//holding keys
 	
 	hfl_free(obj);
 	return 0;
 }
 //~$ cc src.c libhfl.a
		@()
@_desc
	c99 hsearch() allows only 1 hash tb in 1 pg. 
	hfl allows to hold many hashtb.
		@(code)
	--- bench mark: c_arr, c99hash, hfl, ghash
	  FAST: c_arr(1) < c99hash == hfl == ghash (20) :SLOW
		@()
	consume time of get/set is almost the same. --
	--
	hfl_set_s(obj, key, vptr, [memsz]) saves mem using strdup()/malloc().
	use malloc() if ag4 exist and not 0. buffmem is freed when hfl_free().

@_eg
	-
@return_value
	suc/fail == ptr, int 0 / NULL, int not0
@errors
	output emsg and exit(1) if fatal err
@notes -
@conforming_to POSIX.1-2001+
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-06-08 v1.0.1 (2022-05-29 v1.0.0)

@_see
https://probablydance.com/2017/02/26/i-wrote-the-fastest-hashtable/ --
https://github.com/skarupke/flat_hash_map --
//SH_docE*/
#ifndef hfl_61a25e678cdd
#define hfl_61a25e678cdd

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#ifdef hfl_p_
# include <emsg: detect conflict varname hfl.h/'_hfl_p' >
#endif

#include <stdint.h>
typedef struct hfl_node_tag {
	int tp;
	char* key;
	int i;
	double d;
	void* p;
	void* s;
	//
	uint32_t slot;
	struct hfl_node_tag* pre;
	struct hfl_node_tag* next;
} hfl_nt;

typedef uint32_t (s2u_ft)(const char* key);

typedef struct hfl_tag{
	uint32_t cnt;
	//
	uint32_t mcnt;
	uint32_t lcnt;
	s2u_ft* hashcb;
	hfl_nt** arr;
	hfl_nt* enode;
} hfl_t;

#define hfl_foreach(node, obj)	for(hfl_nt* (node)=obj->enode->pre, *hfl_p_; \
	 hfl_p_=(node)->pre, (node) != obj->enode; (node)=hfl_p_ )

#define hfl_set_i(obj,k,v)	hfl_set_cmn(obj,k,'i',(int)(v), 0)
#define hfl_set_d(obj,k,v)	hfl_set_cmn(obj,k,'d',(double)(v), 0)
#define hfl_set_p(obj,k,v)	hfl_set_cmn(obj,k,'p',(void*)(v), 0)
#define hfl_set_s(obj,k,v,...)	hfl_set_cmn(obj,k,'s',(char*)(v), (uint32_t)(__VA_ARGS__+0))

#define hfl_new(...)	hfl_new_impl(__VA_ARGS__ +0)
hfl_t* hfl_new_impl(uint32_t sz);
void*	hfl_free(hfl_t* obj);
hfl_nt* hfl_set_cmn(hfl_t* obj, char* k, int tp, ...);
hfl_nt* hfl_unset(hfl_t* obj, char* k);
hfl_nt* hfl_find(hfl_t* obj, char* k);

#endif /* inc_guard */
