#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

/*SH_LS*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// this code is rewrite of flat_hash_map(cpp boost license) for c-lang.
// https://github.com/skarupke/flat_hash_map/blob/master/flat_hash_map.hpp

/*SH_doc
title=hfl section=3 repnl=\040

@name hfl
@_brief hash api for C-lang
@_syno
 typedef struct hfl_node_tag {
 	int tp;	//int/dbl/ptr/str(or struct) == 'i'/'d'/'p'/'s'
 	char* key;
 	int i;
 	double d;
 	void* p;
 	void* s;
 	//..inner data
 } hfl_nt;
 
 typedef struct hfl_tag{
 	uint32_t cnt;
 	//..inner data
 } hfl_t;
 
 hfl_t*  hfl_new([uint32_t sz]);
 void*	hfl_free(hfl_t* obj);
 hfl_nt* hfl_unset(hfl_t* obj, char* k);
 hfl_nt* hfl_find(hfl_t* obj, char* k);
 
 #define hfl_set_i(obj,k,v)	
 #define hfl_set_d(obj,k,v)
 #define hfl_set_p(obj,k,v)
 #define hfl_set_s(obj,k,ptr,[sz])
 #define hfl_foreach(node, obj)
	
@tl_dr
		@(code)
 #include "hfl.h"
 
 int main(int argc, char** argv){
 	hfl_t* obj = hfl_new();
 	hfl_nt* rp = hfl_set_i(obj, "k1", 12);
 	puts(rp->key);	// "k1"
 	int tp = rp->tp;	// int == 'i'
 	hfl_unset(obj, "k1");	//del
 
 	rp = hfl_set_s(obj, "k2", "hw");
 	puts(rp->s);	// "hw"
 	rp = hfl_find(obj, "k2");
 	puts(rp->s);	// "hw"
 	
 	float n = 12.3;
 	rp = hfl_set_s(obj, "k3", &n, sizeof(float) );
 	// ag4 isnt >> strdup()
 	// ag4 exist >> malloc()
 	n = *(float*)(rp->s);
 	
 	hfl_foreach(p, obj){
 		puts(p->key);
 		hfl_set_i(obj, p->key, 2);	//ok, replace/update
 		hfl_unset(obj, p->key);	//ok
 		// hfl_set_i(obj, "new", 2);	//NG, add newkey
 		p->i = 10;	//ok
 	}
 	
 	rp = hfl_unset(obj, "k2");
 	rp = hfl_find(obj, "k2");	//rp == NULL;
 	int cnt = obj->cnt;	//holding keys
 	
 	hfl_free(obj);
 	return 0;
 }
 //~$ cc src.c lib*SH_bn*.a
		@()
@_desc
	c99 hsearch() allows only 1 hash tb in 1 pg. 
	hfl allows to hold many hashtb.
		@(code)
	--- bench mark: c_arr, c99hash, hfl, ghash
	  FAST: c_arr(1) < c99hash == hfl == ghash (20) :SLOW
		@()
	consume time of get/set is almost the same. --
	--
	hfl_set_s(obj, key, vptr, [memsz]) saves mem using strdup()/malloc().
	use malloc() if ag4 exist and not 0. buffmem is freed when hfl_free().

@_eg
	-
@return_value
	suc/fail == ptr, int 0 / NULL, int not0
@errors
	output emsg and exit(1) if fatal err
@notes -
@conforming_to POSIX.1-2001+
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-06-08 v1.0.1 (2022-05-29 v1.0.0)

@_see
https://probablydance.com/2017/02/26/i-wrote-the-fastest-hashtable/ --
https://github.com/skarupke/flat_hash_map --
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef hfl_61a25e678cdd
#define hfl_61a25e678cdd

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#ifdef hfl_p_
# include <emsg: detect conflict varname hfl.h/'_hfl_p' >
#endif

#include <stdint.h>
typedef struct hfl_node_tag {
	int tp;
	char* key;
	int i;
	double d;
	void* p;
	void* s;
	//
	uint32_t slot;
	struct hfl_node_tag* pre;
	struct hfl_node_tag* next;
} hfl_nt;

typedef uint32_t (s2u_ft)(const char* key);

typedef struct hfl_tag{
	uint32_t cnt;
	//
	uint32_t mcnt;
	uint32_t lcnt;
	s2u_ft* hashcb;
	hfl_nt** arr;
	hfl_nt* enode;
} hfl_t;

#define hfl_foreach(node, obj)	for(hfl_nt* (node)=obj->enode->pre, *hfl_p_; \
	 hfl_p_=(node)->pre, (node) != obj->enode; (node)=hfl_p_ )

#define hfl_set_i(obj,k,v)	hfl_set_cmn(obj,k,'i',(int)(v), 0)
#define hfl_set_d(obj,k,v)	hfl_set_cmn(obj,k,'d',(double)(v), 0)
#define hfl_set_p(obj,k,v)	hfl_set_cmn(obj,k,'p',(void*)(v), 0)
#define hfl_set_s(obj,k,v,...)	hfl_set_cmn(obj,k,'s',(char*)(v), (uint32_t)(__VA_ARGS__+0))

#define hfl_new(...)	hfl_new_impl(__VA_ARGS__ +0)
hfl_t* hfl_new_impl(uint32_t sz);
void*	hfl_free(hfl_t* obj);
hfl_nt* hfl_set_cmn(hfl_t* obj, char* k, int tp, ...);
hfl_nt* hfl_unset(hfl_t* obj, char* k);
hfl_nt* hfl_find(hfl_t* obj, char* k);

#endif /* inc_guard */
/*SH_ED*/

/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>
#include "*SH_bn*.h"

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"	//*SH_co*	*
	#include "hcut.h"
	#include "msgp.h"
	#include "laptime.h"
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__
#endif

//https://softwareengineering.stackexchange.com/questions/49550
#ifndef HFL_HASHCB
# define HFL_HASHCB			hash_fnv1a
#endif

typedef uint32_t uint;
// <sys/types.h> << omitted uint,  from c99 >> c11
// https://pubs.opengroup.org/onlinepubs/9699919799/

static uint hash_djb2(const char *str);
static uint hash_fnv1a(const char *str);

static uint hfl_nextsz(uint n);
static int hfl_delnode(hfl_t* obj, hfl_nt* p);
static hfl_t* hfl_renew(hfl_t* obj);
static hfl_nt* hfl_insnode(hfl_t* obj, char* key, hfl_nt* p);
static uint getslot(s2u_ft hashcb, uint hashsz, char* key);

//djb2: http://www.cse.yorku.ca/~oz/hash.html
static uint32_t hash_djb2(const char *str){
	unsigned char* s = (unsigned char*)str;
	uint32_t hash = 5381;	//init vec
	//hash * 33 + c
	for(; *s; s++){	hash = ((hash << 5) + hash) + *s; }
	return hash;
}

#ifdef TEST_
HCUT_ADD(t_djb) {
	//https://softwareengineering.stackexchange.com/questions/49550
	char* arr[] = { "hetairas" ,"heliotropes" ,"depravement" ,"stylist"
	,"joyful" ,"redescribed" ,"dram", NULL };
	char* brr[] = {"mentioner" ,"neurospora" ,"serafins" ,"subgenera"
	,"synaphea" ,"urites" ,"vivency", NULL };

	for(int i=0;arr[i];i++){
		uint n = hash_djb2(arr[i]);
		uint nn= hash_djb2(brr[i]);
		eq_i(n, nn, arr[i]);
	}
}
#endif


//fnv-1a: http://www.isthe.com/chongo/tech/comp/fnv/index.html#FNV-param
#define FNV32_INIT ((uint32_t)0x811c9dc5)
#define FNV32_PRIME	((uint32_t)0x01000193)
static uint32_t hash_fnv1a(const char *str){
	unsigned char* s = (unsigned char*)str;
	uint32_t h = FNV32_INIT;	//init vec
	for(; *s; s++) { h ^= *s; h *= FNV32_PRIME; }
    return h;
}

#ifdef TEST_
HCUT_ADD(t_fnv) {
	//https://softwareengineering.stackexchange.com/questions/49550
	char* arr[] = { "costarring", "declinate", "altarage", "altarages", NULL };
	char* brr[] = { "liquid", "macallums", "zinke", "zinkes", NULL };

	for(int i=0;arr[i];i++){
		uint n = hash_fnv1a(arr[i]);
		uint nn= hash_fnv1a(brr[i]);
		eq_i(n, nn, arr[i]);
	}
}
#endif

//https://stackoverflow.com/questions/14069737/
//only 6:  const int, enum, charint 'c', sizeof(), _Alignof(), (int)float/dbl
enum prime_etag {
 P0 =1			,P1 =2			,P2 =3			,P3 =7			,P4 =13
,P5 =31			,P6 =61			,P7 =127		,P8 =251		,P9 =509
,P10=1021		,P11=2039		,P12=4093		,P13=8191		,P14=16381
,P15=32749		,P16=65521		,P17=131071		,P18=262139		,P19=524287
,P20=1048573	,P21=2097143	,P22=4194301	,P23=8388593	,P24=16777213
,P25=33554393	,P26=67108859	,P27=134217689	,P28=268435399	,P29=536870909
,P30=1073741789	,P31=2147483647
};

static uint prime_arr[32+1] = {
 P0  ,P1  ,P2  ,P3	,P4		,P5  ,P6  ,P7  ,P8  ,P9  
,P10 ,P11 ,P12 ,P13 ,P14	,P15 ,P16 ,P17 ,P18 ,P19
,P20 ,P21 ,P22 ,P23 ,P24	,P25 ,P26 ,P27 ,P28 ,P29
,P30 ,P31 ,0
};
#ifndef HFL_SLOTDFL
# define HFL_SLOTDFL	31
#endif

#ifndef HFL_SLOTMAX
# define HFL_SLOTMAX 31
#endif
static uint hfl_nextsz(uint n){
	uint* arr = prime_arr;
	uint lim = prime_arr[HFL_SLOTMAX];
	lim < HFL_SLOTDFL ? lim=HFL_SLOTDFL: lim;
	for(int i=0;; i++){
		uint nn = arr[i];
		if( nn!=0 && nn<=lim && nn<=n ){ continue; }
		n = nn;
		break;
	}
	return n;
}
#ifdef TEST_
HCUT_ADD(t_nx) {
	uint n, rc;
	n = 0;
	rc =  hfl_nextsz(n);
	eq_i(rc, 1, "init");
	
	n=1;
	rc =  hfl_nextsz(n);
	eq_i(rc, 2);
	
	n=127;
	rc =  hfl_nextsz(n);
	eq_i(rc, 251);
}
#endif

#ifndef HFL_RATIO
# define HFL_RATIO	0.8
#endif

hfl_t* hfl_new_impl(uint sz){
	//if(sz==HFL_SLOTDFL){sz=HFL_SLOTDFL; }
	if(sz==0){sz=HFL_SLOTDFL; }
	hfl_t* obj = calloc(1, sizeof(hfl_t) );
	obj->hashcb = HFL_HASHCB;
	obj->cnt = 0;
	obj->mcnt = sz;
	obj->lcnt = sz * HFL_RATIO;
	obj->arr  = calloc(sz, sizeof(hfl_nt*) );
	obj->enode= calloc(1, sizeof(hfl_nt) );
	obj->enode->pre = obj->enode;
	obj->enode->next = obj->enode;
	
//idx系の管理になるのでf_rqからとってくる。arr[0]で固定位置
	return obj;

//deadcode
	hash_djb2("");
}
void* hfl_free(hfl_t* obj){
	hfl_nt* p = obj->enode;
	if(p){
		void* sv = p->pre;
		for(;;){
			p = sv;
			if(p == obj->enode){break;}
			free(p->key);
			free(p->s);
			sv=p->pre;
			free(p);
		}
	}
	free(obj->arr);
	free(obj->enode);
	free(obj);
	hfl_t buf ={0};
	*obj = buf;
	return obj;
}
#ifdef TEST
HCUT_ADD(t_new) {
	laptime(0);
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	laptime();
	
	eq_i(obj->cnt, 0);
	eq_i(obj->mcnt, 31);
	eq(obj->lcnt!=0);
	eq(obj->arr!=NULL);
	eq(obj->enode, "init new test");	//enode はセンチネルとして追加、単独番兵
//add nodelist
	eq_p(obj->enode->next, obj->enode->pre);

//clean test
	hfl_free(obj);
	eq_i(obj->cnt, 0);
	eq_i(obj->mcnt, 0);
	eq_i(obj->lcnt, 0);
	eq_p(obj->arr, NULL);
	eq_p(obj->enode, NULL);
}
#endif

static hfl_nt* hfl_insnode(hfl_t* obj, char* key, hfl_nt* p){
	if(obj==NULL|| key==NULL){ return NULL; }
	//編集するのはpのみ。xp,ppはobjのデータなのでp->系ではない
	if(obj->cnt > obj->lcnt){ hfl_renew(obj); }
	if(p==NULL){
		p = calloc(1, sizeof(hfl_nt) );
		p->key = strdup(key);
	}
	uint pos = getslot(obj->hashcb, obj->mcnt, key);
	hfl_nt* pp = obj->arr[pos];
	hfl_nt* xp;
	if(pp==NULL){
		pp = obj->enode->pre;
		xp = obj->enode;
	}
	else { xp = pp->next; }
	
	//insnode
	p->slot = pos;
	p->pre = pp;	//arr先頭に挿入。initはtailにセットされてる
	p->next = xp;
	
	pp->next = p;
	xp->pre = p;
	
	obj->arr[pos] = p;
	obj->cnt++;
	return p;
}

static hfl_t* hfl_renew(hfl_t* obj){
	if(obj==NULL){ return hfl_new(); }
	uint nsz = hfl_nextsz(obj->mcnt);
	if(nsz==0){
		obj->lcnt = obj->mcnt;
		return NULL;
	}
	
	hfl_t* nobj = hfl_new(nsz);
	uint ck=0;
//トリッキーだけどforは降順なのでxdiは見ない。逆方向にメモって修正すればいけそう
	hfl_foreach(p, obj){
		hfl_insnode(nobj, p->key, p);
		ck++;
	}
	STOP(ck != obj->cnt, "cnt unmatch");

	//rep
	free(obj->arr);
	free(obj->enode);
	*obj = *nobj;
	
	nobj->arr = NULL;
	nobj->enode =NULL;
	hfl_free(nobj);
	return obj;
}

#ifdef TEST_
HCUT_ADD(t_renew) {
	laptime(0);
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	
	obj = hfl_renew(obj);
	eq_i(obj->mcnt, 61);
	hfl_free(obj);
	laptime();
	obj = hfl_new();
	for(int i=6; i<=31; i++){
		hfl_t* nobj = hfl_renew(obj);
		eq_p(nobj, obj);
		eq_i(obj->mcnt, prime_arr[i]);
	}
	eq(obj->mcnt != obj->lcnt);
	
	uint n = obj->mcnt;
	hfl_t* nobj = hfl_renew(obj);

	eq(obj->mcnt == obj->lcnt);
	eq_p(nobj, NULL, "maxsz0");
	eq_i(obj->mcnt, n);
	
	//何回やっても同じ
	nobj = hfl_renew(obj);
	eq_p(nobj, NULL, "maxsz");
	eq(obj->mcnt == obj->lcnt);
	eq_i(obj->mcnt, n);
	
	hfl_free(obj);
	
	obj = hfl_renew(NULL);
	eq_i(obj->mcnt, 31);
	hfl_free(obj);
}
#endif

static int hfl_delnode(hfl_t* obj, hfl_nt* p){
	STOP(p==obj->enode, "try to del enode");

	hfl_nt*	pp = p->pre;
	hfl_nt* xp = p->next;

	xp->pre = pp;
	pp->next = xp;
	
	//slot
	uint pos = p->slot;
	if(obj->arr[pos] == p){
		if(pp->slot==pos){ obj->arr[pos] = pp; }
		else{ obj->arr[pos] = NULL; }
	}
	free(p->key);
	free(p->s);
	hfl_nt buf = {0};
	*p = buf;
	free(p);
	obj->cnt--;
	return 0;
}

static uint getslot(s2u_ft hashcb, uint hsz, char* key){
	uint idx = hashcb(key);
	// cc optimize: mod Strength reduction, case flow control
	// https://stackoverflow.com/questions/14069737/
	switch(hsz){
		case P0 : idx %= P0 ; break;
		case P1 : idx %= P1 ; break;
		case P2 : idx %= P2 ; break;
		case P3 : idx %= P3 ; break;
		case P4 : idx %= P4 ; break;
		case P5 : idx %= P5 ; break;
		case P6 : idx %= P6 ; break;
		case P7 : idx %= P7 ; break;
		case P8 : idx %= P8 ; break;
		case P9 : idx %= P9 ; break;
		case P10: idx %= P10; break;
		case P11: idx %= P11; break;
		case P12: idx %= P12; break;
		case P13: idx %= P13; break;
		case P14: idx %= P14; break;
		case P15: idx %= P15; break;
		case P16: idx %= P16; break;
		case P17: idx %= P17; break;
		case P18: idx %= P18; break;
		case P19: idx %= P19; break;
		case P20: idx %= P20; break;
		case P21: idx %= P21; break;
		case P22: idx %= P22; break;
		case P23: idx %= P23; break;
		case P24: idx %= P24; break;
		case P25: idx %= P25; break;
		case P26: idx %= P26; break;
		case P27: idx %= P27; break;
		case P28: idx %= P28; break;
		case P29: idx %= P29; break;
		case P30: idx %= P30; break;
		case P31: idx %= P31; break;
		default : idx %= hsz; break;
	}
	return idx;
}

#include <stdarg.h>
hfl_nt* hfl_set_cmn(hfl_t* obj, char* k, int tp, ...){
	hfl_nt* p = hfl_find(obj, k);
	if(p==NULL){ p = hfl_insnode(obj, k, NULL); }
	if(p==NULL){ return NULL; }
	
	char* yp;
	uint yu;
	
	p->tp = tp;
	va_list va;
	va_start(va, tp);
	switch(tp){
		case 'i': p->i = va_arg(va,int); break;
		case 'd': p->d = va_arg(va,double); break;
		case 'p': p->p = va_arg(va,void*); break;
		case 's':
			yp = va_arg(va,char*);
			yu = va_arg(va,uint32_t);
			if(yu==0){ p->s = strdup(yp); break; }

			p->s = malloc(yu);
			STOP(p->s == NULL, "mem err");
			memcpy(p->s, yp, yu);
			break;
		default: STOP(1, "invalid typechar");
	}
	va_end(va);
	return p;
}
#ifdef TEST
HCUT_ADD(t_set) {
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	
	hfl_nt* rp;
	rp =  hfl_set_i(obj, "unko", 10);
	eq_s(rp->key, "unko");
	eq_i(rp->i, 10);
	eq_i(obj->cnt, 1);
	
	rp =  hfl_set_i(obj, "1", 1);
	eq_s(rp->key, "1");
	eq_i(rp->i, 1);
	eq_i(obj->cnt, 2);

	hfl_set_i(obj, "ii", 10);
	hfl_set_d(obj, "dd", 1);
	hfl_set_s(obj, "ss", "hw");
	hfl_set_p(obj, "pp", "gw");
	eq_i(obj->cnt, 6);
	
	typedef struct my_tag{
		int a;
		int b;
	} my_t;
	
	my_t v = {10,20};
	rp = hfl_set_s(obj, "mem", &v, sizeof(v) );
	eq_i(rp->tp, 's');
	void* p = rp->s;
	int n = ((my_t*)p)->a;
	eq_i(n, 10);
	
	double d = 11.1;
	rp = hfl_set_s(obj, "k3", &d, sizeof(double) );
	d = *(double*)(rp->s);
	eq_d(d, 11.1);

	hfl_free(obj);
}
#endif

hfl_nt* hfl_unset(hfl_t* obj, char* k){
	hfl_nt*  p = hfl_find(obj, k);
	if(p==NULL){ return NULL; }
	hfl_delnode(obj, p);
	return p;
}

#ifdef TEST
HCUT_ADD(t_unset) {
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	hfl_nt* p;
	p =  hfl_set_i(obj, "unko", 10);
	eq_s(p->key, "unko");
	eq_i(p->i, 10);
	eq_i(obj->cnt, 1);

	p =  hfl_set_i(obj, "1", 1);
	eq_s(p->key, "1");
	eq_i(p->i, 1);
	eq_i(obj->cnt, 2);

	p = hfl_unset(obj, "1");
	eq(p);
	eq_i(obj->cnt, 1);
	
	p = hfl_find(obj, "unko");
	eq_s(p->key, "unko");
	eq_i(p->i, 10);
	eq_i(obj->cnt, 1);
	
	p =  hfl_set_i(obj, "unko", 11);
	eq_s(p->key, "unko");
	eq_i(p->i, 11);
	eq_i(obj->cnt, 1);

	p = hfl_unset(obj, "unk");
	eq_p(p, NULL);
	eq_i(obj->cnt, 1);

	hfl_free(obj);
}
#endif

//strcmp()はmemcmp()にくらべて遅い。memはword単位で比較可能
hfl_nt* hfl_find(hfl_t* obj, char* k){
	if(obj==NULL || k==NULL){ return NULL; }
	uint pos = getslot(obj->hashcb, obj->mcnt, k);
	hfl_nt* p = obj->arr[pos];
	if(p==NULL){ return NULL; }
	for(;p;){
		if(p->slot != pos || p==obj->enode){ p=NULL; break; }
		if(strcmp(p->key, k)==0){ break;}
		//if(memcmp(k, np->key, sz)==0){ break;}
		p = p->pre;
	}
	return p;
}

#ifdef TEST
HCUT_ADD(t_find) {
	hfl_t* obj = hfl_new();
	hfl_nt* p;
	eq_i(obj->mcnt, 31);
	
	int rc=0;
	eq_i(rc, 0);
	hfl_set_i(obj, "ii", 10);
	p = hfl_set_d(obj, "dd", 1.0);
	
	eq_s(p->key, "dd");
	
	hfl_set_s(obj, "ss", "hw");
	hfl_set_p(obj, "pp", "gw");
	eq_i(obj->cnt, 4);
	
	hfl_nt* u = hfl_find(obj, "ii");
	eq_s(u->key, "ii");
	eq_i(u->i, 10);
	eq_d(u->d, 0);
	eq_p(u->s, NULL);

	u = hfl_find(obj, "dd");
	eq_s(u->key, "dd");
	eq_i(u->i, 0);
	eq_d(u->d, 1);
	eq_p(u->s, NULL);

	u = hfl_find(obj, "ss");
	eq_s(u->key, "ss");
	eq_i(u->i, 0);
	eq_d(u->d, 0);
	eq_s(u->s, "hw");

	u = hfl_find(obj, "pp");
	eq_s(u->key, "pp");
	eq_i(u->i, 0);
	eq_d(u->d, 0);
	eq_p(u->s, NULL);
	eq_s(u->p, "gw");
	
	hfl_free(obj);
}
#endif

#ifdef TEST_
HCUT_ADD(t_max) {
laptime(0);
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	
	char s[100]={0};
	int lp = P16;
	//int lp = P22;
	for(uint i=1;i<=lp; i++){
		sprintf(s, "%u", i);
		hfl_nt* p = hfl_set_i(obj, s, i);
		hfl_nt* u = hfl_find(obj, s);
		eq_s(s, p->key, s);
		eq_s(s, u->key, s);
		eq_i(i, u->i, s);
	}
dbg(obj->mcnt, obj->lcnt, obj->cnt);
	hfl_free(obj);
laptime("maxtest");
}
#endif

#ifdef TEST_
#include <stdio.h>
#include <stdlib.h>
#include <search.h>	//c99

#include <glib.h>	/*SH_co* -pthread `pkg-config --cflags --libs glib-2.0` */
// -pthread/-lpthread == posix or not. -pthread is posix cc opt and holds macros.
// https://qastack.jp/programming/23250863
// man -k pthread

// real	145.106 ms	: ./hfl.tmp.c 665: t_bm0_sub(): msg:c99set: 1*1000*1000
// real	152.149 ms	: ./hfl.tmp.c 675: t_bm0_sub(): msg:c99find: 1*1000*1000
// real	269.933 ms	: ./hfl.tmp.c 692: t_bm0_sub(): msg:hflset : 1*1000*1000
// real	228.917 ms	: ./hfl.tmp.c 700: t_bm0_sub(): msg:hflfind: 1*1000*1000
// real	189.330 ms	: ./hfl.tmp.c 727: t_bm0_sub(): msg:ghashset : 1*1000*1000
// real	165.581 ms	: ./hfl.tmp.c 735: t_bm0_sub(): msg:ghashfind: 1*1000*1000

#define LP 10*1000*1000
HCUT_ADD(t_bm0) {
	char s[100]={0};
	//char* fmt = "%u";
	char* fmt = "key";
	
	//sprintf
	; laptime(0);
	loop(LP) {
		sprintf(s, fmt, lpcnt);
	}
	; laptime("sprintf(overhead) set: " qu(LP));
	; laptime(0);
	
	//c_arr
	; laptime(0);
	loop(LP) {
	//	sprintf(s, fmt, lpcnt);
		s[0] = lpcnt;
	}
	; laptime("c_arr set: " qu(LP));
	; laptime(0);
	loop(LP) {
		int n = s[0];
	}
	; laptime("c_arr get: " qu(LP));

	//c99hash
	ENTRY e;
	ENTRY *ep=NULL;
	eq_p(ep, NULL);
	hcreate(30);
	; laptime(0);
	loop(LP) {
		sprintf(s, fmt, lpcnt);
		e.key = s;
		e.data = (void *)(uintptr_t)lpcnt;
		ep = hsearch(e, ENTER);
	}
	; laptime("c99set: " qu(LP));
	; laptime(0);
	loop(LP) {
		sprintf(s, fmt, lpcnt);
		e.key = s;
		ep = hsearch(e, FIND);
// ep ? ep->key : "NULL", データがないとか
//		printf("%d\n", (int)ep->data );
		//printf("%9.9s -> %9.9s:%d\n", e.key, ep ? ep->key : "NULL", ep ? (int)(ep->data) : 0);
	}
	; laptime("c99find: " qu(LP));
	hdestroy();
//real	361.563 ms	: ./hfl.tmp.c 661: t_bm0_sub(): msg:c99set: 1*1000*1000
//real	367.082 ms	: ./hfl.tmp.c 671: t_bm0_sub(): msg:c99find: 1*1000*1000

//old_lbc data, fixkey
//real	46.685 ms	: ./lbc.ts.c 141: t_bm2_sub(): msg:c99setloop: 1000*1000
//real	44.315 ms	: ./lbc.ts.c 149: t_bm2_sub(): msg:c99getloop: 1000*1000


	//hflhash
	hfl_t* obj = hfl_new();
	; laptime(0);
	loop(LP){
		sprintf(s, fmt, lpcnt);
		hfl_set_i(obj, s, lpcnt);
//		hfl_unset(obj, s);
	}
	; laptime("hflset : " qu(LP));

	; laptime(0);
	loop(LP){
		sprintf(s, fmt, lpcnt);
		hfl_nt* u = hfl_find(obj, s);
		u++;
	}
	; laptime("hflfind: " qu(LP));
dbg(obj->mcnt, obj->lcnt, obj->cnt);
	hfl_free(obj);
//real	1754.678 ms	: ./hfl.tmp.c 689: t_bm0_sub(): msg:hflset : 1*1000*1000
//real	512.057 ms	: ./hfl.tmp.c 697: t_bm0_sub(): msg:hflfind: 1*1000*1000
//insが重いけどmalloc()を改善の余地がある。findは素で120%程度でそれなりに速い

//固定キー
//real	154.229 ms	: ./hfl.tmp.c 663: t_bm0_sub(): msg:c99set: 1*1000*1000
//real	154.199 ms	: ./hfl.tmp.c 673: t_bm0_sub(): msg:c99find: 1*1000*1000
//real	268.025 ms	: ./hfl.tmp.c 690: t_bm0_sub(): msg:hflset : 1*1000*1000
//real	233.123 ms	: ./hfl.tmp.c 698: t_bm0_sub(): msg:hflfind: 1*1000*1000
//arr:1, c99:2, hfl:3-4, lj:10 なのでそれなりに意義はある。c99を越えたいけど
//なかなか難しそうだ。malloc()の改善からなら手っ取り早そうだけど。

// glibもc99並に速いので160ms程度まであげてアドバンテージを稼ぎたい。
// glibはかなり強力な最適化をしているようだ

	//glib系
	//https://developer.gnome.org/glib/2.40/glib-Hash-Tables.html
	
	// ag1 hashcb() type, str,int etc. ag2 cmpcb()
	GHashTable* gobj = g_hash_table_new(g_str_hash, g_str_equal);
	; laptime(0);
	loop(LP){
		sprintf(s, fmt, lpcnt);
		g_hash_table_insert(gobj, s, (void*)(uintptr_t)lpcnt);	//ag3 ptronly
//		g_hash_table_remove (gobj, s);
	}
	; laptime("ghashset : " qu(LP));

	; laptime(0);
	loop(LP){
		sprintf(s, fmt, lpcnt);
		char* u = (char*)g_hash_table_lookup(gobj, s);
		u++;
	}
	; laptime("ghashfind: " qu(LP));
	g_hash_table_destroy(gobj);

//real	189.330 ms	: ./hfl.tmp.c 727: t_bm0_sub(): msg:ghashset : 1*1000*1000
//real	165.581 ms	: ./hfl.tmp.c 735: t_bm0_sub(): msg:ghashfind: 1*1000*1000

// real	674.891 ms	: ./hfl.tmp.c 744: t_bm0_sub(): msg:sprintf(overhead) set: 10*1000*1000
// real	21.649 ms	: ./hfl.tmp.c 753: t_bm0_sub(): msg:c_arr set: 10*1000*1000
// real	27.676 ms	: ./hfl.tmp.c 759: t_bm0_sub(): msg:c_arr get: 10*1000*1000
// real	1138.546 ms	: ./hfl.tmp.c 773: t_bm0_sub(): msg:c99set: 10*1000*1000
// real	1151.986 ms	: ./hfl.tmp.c 783: t_bm0_sub(): msg:c99find: 10*1000*1000
// real	2036.911 ms	: ./hfl.tmp.c 801: t_bm0_sub(): msg:hflset : 10*1000*1000
// real	1695.991 ms	: ./hfl.tmp.c 809: t_bm0_sub(): msg:hflfind: 10*1000*1000
// real	1235.623 ms	: ./hfl.tmp.c 838: t_bm0_sub(): msg:ghashset : 10*1000*1000
// real	1204.668 ms	: ./hfl.tmp.c 846: t_bm0_sub(): msg:ghashfind: 10*1000*1000
}
#endif

#ifdef TEST
HCUT_ADD(t_use) {
	hfl_t* obj = hfl_new();
	hfl_nt* rp = hfl_find(obj, "unko");
	eq_p(rp, NULL);
	
	rp = hfl_set_i(obj, "unko", 10);
	eq_i(rp->i, 10);
	eq_i(obj->cnt, 1);
	
	rp = hfl_unset(obj, "unko");
	eq(rp!=NULL);
	eq_i(obj->cnt, 0);
	
	rp = hfl_set_s(obj, "unko", "str");

	eq_i(rp->tp, 's');
	eq_s(rp->key, "unko");
	eq_s(rp->s, "str");
	eq_i(obj->cnt, 1);
	
	rp = hfl_set_i(obj, "unko", 22);
	eq_i(rp->tp, 'i');
	eq_s(rp->key, "unko");
	eq_i(rp->i, 22);
	eq_i(obj->cnt, 1);
	
	rp = hfl_set_i(obj, "unk", 12);
	eq_i(rp->tp, 'i');
	eq_s(rp->key, "unk");
	eq_i(rp->i, 12);
	eq_i(obj->cnt, 2);
	
	rp = hfl_unset(obj, "kk");
	eq(rp==NULL);
	eq_i(obj->cnt, 2);
	
	hfl_free(obj);
}
#endif

#ifdef TEST_
HCUT_ADD(t_s) {
	hfl_t* obj = hfl_new();
	hfl_nt* rp = hfl_set_i(obj, "unko", 10);
	puts(rp->key);
	hfl_free(obj);
}
#endif

/*SH_SMP
#include <stdio.h>
#include "hfl.h"

int main(int argc, char** argv){
	hfl_t* obj = hfl_new();
	hfl_nt* rp = hfl_set_i(obj, "k1", 12);
	puts(rp->key);	// "k1"
	int tp = rp->tp;	// int == 'i'
	hfl_unset(obj, "k1");	//del

	rp = hfl_set_s(obj, "k2", "hw");
	puts(rp->s);	// "hw"
	rp = hfl_find(obj, "k2");
	puts(rp->s);	// "hw"
	
	float n = 12.3;
	rp = hfl_set_s(obj, "k3", &n, sizeof(float) );
	// ag4 isnt >> strdup()
	// ag4 exist >> malloc()
	n = *(float*)(rp->s);
	
	hfl_foreach(p, obj){
		puts(p->key);
		hfl_set_i(obj, p->key, 2);	//ok, replace/update
		hfl_unset(obj, p->key);	//ok
		// hfl_set_i(obj, "new", 2);	//NG, add newkey
		p->i = 10;	//ok
	}
	
	rp = hfl_unset(obj, "k2");
	rp = hfl_find(obj, "k2");	//rp == NULL;
	int cnt = obj->cnt;	//holding keys
	
	hfl_free(obj);
	return 0;
}
//~$ gcc src.c lib*SH_bn*.a
//SH_SMPE*/

#ifdef TEST
#ifndef TLV
# define TLV	1
#endif /**/
HCUT_RUN("stderr", TLV,
		 t_0)
#endif

/*
 change log
 --
2022-06-08	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: update, fix doc

2022-05-29	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: init.

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -static -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CB";fgr0 "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fml()(
 cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '/^HCUT_ADD/ && index($0,"("w")")==0 {
 while(index($0,"}")!=1){getline}
 next }
 /^HCUT_ADD/ { $0="void " w "(int argc, char** argv){" }
 /^HCUT_RUN/ {exit}
 {print $0}
 '
 $p"int main(int argc, char** argv){ $1(argc, argv); return 0;}"
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ "$1" = " " ] && cmd='ftm $b' && shift
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl" $Rm-|$e"$cmd"
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DTLV=$1"&&shift
 fte "$@"<$tf>$Rm;mv $Rm $tf;cat $Rs $tf>$Rm
}
fborn(){
 fgr0 "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$R0 |fgr0 "^#ifdef TEST" "^#endif$"|fbn|fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
