/**********************************************/
/*                                            */
/*   sR|hϊvO (LF to CRLF)    */
/*                                            */
/*      coded by A.Kobayashi 2003.02.22       */
/*    updated by A.Kobayashi 2003.03.31       */
/*    updated by A.Kobayashi 2015.11.14       */
/*                                            */
/**********************************************/
/*
	cc -O f2rfe.c -o f2rfe
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char f,*s,*prg;
static int s_len;
static FILE *fp;

static void usage()
{
	fprintf(stderr,"usage: %s [-wumqQ] [-s[ ]string] [file_name|-]\n",prg);
}

static char *omit_quote(char *dat)
{
	char c,*p,quote;
	int len;

	p = dat;
	c = *p;
	if (c=='\'' || c=='"') {
		quote = c;
		len = strlen(++p);
		if (len>0 && p[len-1]==quote) p[len-1] = '\0';
	}
	return p;
}

static void cr_lf(char cc)
{
	char c;
	int  i,sf;

	c = cc;
	sf = 1;
	if (c == '\r') {
		if ((c=getc(fp)) != '\n') ungetc(c,fp);
	}
	else {
		if (f=='w' || f=='m') {		/* change to '\r\n' / '\r' */
			 if (c != '\n') sf = 0;
		}
		else		/* change to '\n' */
			sf = 0;
	}
	if (sf) for (i=0;i<s_len;i++) putchar(s[i]);
	else putchar(c);
}

int main(int argc, char *argv[])
{
	int c,c2,i,qf;
	char cc,*p,*fname,quot;

	prg = argv[0];
	if (argc < 2) {
		usage();
		exit(1);
	}
	f = 'w';
	fname = s = NULL;
	fp = NULL;
	qf = 0;
	while (argc >= 2) {
		p = argv[1];
		if (*p++ == '-') {
			cc = *p++;
			if (!cc) {
				if (fname) {
					fprintf(stderr,"too file [%s] !!\n",fname);
					exit(1);
				}
				else fp = stdin;
			}
			else {
				while (cc) {
					if ((cc=='w') || (cc=='u') || (cc=='m')) f = cc;
					else if (cc == 'q') qf = 1;
					else if (cc == 'Q') qf = 2;
					else if (cc == 's') {
						if (*p) s = p;
						else if (argc >= 3) {
							argc--;
							argv++;
							s = omit_quote(argv[1]);
						}
						else s = "";
						break;
					}
					else {
						usage();
						exit(1);
					}
					cc = *p++;
				}
			}
		}
		else {
			if (fp || fname) {
				fprintf(stderr,"too file [%s] !!\n",argv[1]);
				exit(1);
			}
			fname = argv[1];
		}
		argc--;
		argv++;
	}
	if (!s) {
		if (f == 'w') s = "\r\n";
		else if (f == 'u') s = "\n";
		else s = "\r";
	}
	s_len = strlen(s);

	if (fname) {
		if (!(fp=fopen(fname,"r"))) {
			fprintf(stderr,"file [%s] open error!!\n",fname);
			exit(1);
		}
	}
	else fp = stdin;

	while ((c=getc(fp)) != EOF) {
		if (qf && (c=='\'' || c=='"')) {
			quot = c;
			putchar(c);
			while ((c=getc(fp)) != EOF) {
				if (c == quot) {
					putchar(c);
					if ((c2=getc(fp)) != EOF) {
						if (c2 != quot) {
							ungetc(c2,fp);
							break;
						}
						else putchar(c2);
					}
					else break;
				}
				else if (qf == 2) cr_lf(c);
				else putchar(c);
			}
		}
		else if (qf == 2) {
			putchar(c);
		}
		else {
			cr_lf(c);
		}
	}
	fclose(fp);
	exit(0);
}
