//
// Make Grant select 
//
define array cola 11;
proc main;
	option  3 2;
	option 10 1;
	if (%0 < 1) then
		putline('usage: ',SCRIPTNAME,' [-c|-d|-syn|-psyn|-dsyn] [-{g|r} privilege] -u userid -t table_list [file ...]');
		return -1;
	end if;
	opt = '-g';
	try;
		while (%0 > 0) do
			if left(%1,1) == '-' then
				switch %1;
				case '-c','-d','-syn','-psyn','-dsyn';
					opt = %1;
				case '-g','-r';
					opt = %1;
					let shift;
					privilege = %1;
				case '-u';
					let shift;
					userid = %1;
				case '-t';
					let shift;
					tn = getargs(%1,1,100);
					for (i=1;i<=tn;i++) do
						table = $$i;
						make_ddl();
					end do;
				end switch;
			else
				file = %1;
				exec ip sub;
			end if;
			let shift;
		end do;
	catch;
		putline(ERRMSG);
	end try;
	return ERROR;
end proc;

proc sub;
	fpi = fopen(file);
	try;
		loop do
			line = fgetline(fpi);
			n = getargs(line,1,3);
			if $3 != '0' then
				table = $2;
				make_ddl();
			end if;
		end do;
	catch;
//		putline(ERRMSG);
	end try;
	fclose(fpi);
	fpi = 0;
	return ERROR;
end proc;

func make_ddl;
	switch (opt);
	case '-g', '-r';
		if opt == '-g' then
			$sql = 'grant ';
			dire = ' to ';
		else
			$sql = 'revoke ';
			dire = ' from ';
		end if;
		$sql = $sql & privilege & ' on ' & table & dire & userid & ';';
	case '-c';
		$sql = 'create table ' & table &
		       ' as select * from ' & userid & '.' & table & ';';
	case '-d';
		$sql = 'drop table ' & table & ';';
	case '-syn', '-psyn';
		$sql = 'create';
		if opt == '-psyn' then
			$sql = $sql & ' public';
		end if;
		$sql = $sql & ' synonym ' & table & ' for ' & userid & '.' & table & ';';
	case '-dsyn';
		$sql = 'drop synonym ' & table & ';';
	endsw;
	putline($sql);
	return ERROR;
end func;
