/*
 * cppds
 * lru.h
 * KDTree class
 * Copylight (C) 2006, 2008 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */

// LRU container Template Library

#ifndef IRU_CONTAINER_H_
#define IRU_CONTAINER_H_

#include <list>
#include <map>

namespace cppds{
	template <typename T> class lru{
		std::list<T> sequence;
		std::map<T, typename std::list<T>::iterator> map;
		size_t buffer_size_;
	public:
		typedef typename std::list<T>::iterator iterator;
		typedef typename std::list<T>::reverse_iterator reverse_iterator;
		lru(size_t buffer_size = 100) : buffer_size_(buffer_size){
		}
		bool add(T t, T &removed){
			if (map.count(t)){
				sequence.erase(map[t]);
				sequence.push_front(t);
				map[t] = sequence.begin();
				return false;
			}else{
				sequence.push_front(t);
				map[t] = sequence.begin();
				if (sequence.size() > buffer_size_){
					removed = sequence.back();
					sequence.pop_back();
					map.erase(removed);
					return true;
				}
			}
			return false;
		}
		iterator begin(){
			return sequence.begin();
		}
		iterator end(){
			return sequence.end();
		}
		reverse_iterator rbegin(){
			return sequence.rbegin();
		}
		reverse_iterator rend(){
			return sequence.rend();
		}
	};
}

#endif // IRU_CONTAINER_H_
