static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi 2010.05.10		*/
/*											*/
/********************************************/
#include "akxcommon.h"

static char *gsep=" \t,;()[]{}<>='\"!^*/";

/********************************************************/
/*														*/
/********************************************************/
int memicmp(sa,sb,len)
uchar *sa,*sb;
int len;
{
	uchar ca,cb;
	int i,dif;

	if (!sa || !sb) return -1;
	dif = 0;
	for (i=0;i<len;i++) {
		ca = *sa++;
		cb = *sb++;
		if (dif=akxcupper(ca)-akxcupper(cb)) break;
	}

	return dif;
}

/********************************************************/
/*														*/
/********************************************************/
int memncpy(d, s, len, n)
char *d,*s;
int len,n;
{
	if (!d || !s) return -1;
	if (n < len) len = n;
	if (len < 0) len = 0;
	memcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memzcpy(d, s, len)
char *d,*s;
int len;
{
	if (!d || !s) return -1;
	if (len < 0) len = 0;
	if (len > 0) memcpy(d,s,len);
	*(d+len) = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memnzcpy(d, s, len, n)
char *d,*s;
int len,n;
{
	n--;
	if (!d || !s) return -1;
	if (n < len) len = n;
	if (len < 0) len = 0;
	memzcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memcat(d, s, len)
char *d,*s;
int len;
{
	if (!d || !s) return -1;
	memzcpy(d+strlen(d),s,len);
	return len;
}

#if !defined(SUNOS5) && !defined(SUNOS) && !defined(LINUX)
/********************************************************/
/*														*/
/********************************************************/
int stricmp(sa,sb)
uchar *sa,*sb;
{
	uchar ca,cb;
	int d=0;

	if (!sa || !sb) return -1;
	for (;;) {
		ca = *sa++;
		cb = *sb++;
		if (!ca && !cb) break;
		if (d=akxcupper(ca)-akxcupper(cb)) break;
	}

	return d;
}
#endif

#if defined(SUNOS) || defined(AIX)
/********************************************************/
/*														*/
/********************************************************/
char *strerror(err)
int err;
{
	char *p;
	extern char *sys_errlist[];
	extern int  sys_nerr;

	if (err>=0 && err<sys_nerr) p = sys_errlist[err];
	else p = AKX_NULL_PRINT;
	return p;
}
#endif

/********************************************************/
/*														*/
/********************************************************/
char *strnzcpy(d, s, len)
char *d,*s;
int len;
{
	if (!d || !s) return NULL;
	if (len < 0) len = 0;
	*(d+len) = '\0';
	return strncpy(d,s,len);
}

/****************************************/
/*										*/
/****************************************/
int akxmemwork(len,pp1,pp0,work,w_len)
int  len;
char **pp0,**pp1,*work;
int  w_len;
{
	char *p,*mem;
	int im;

	if (!pp1 || len<0) return -1;
	im = 1;
	mem = work;
	if (work && len<w_len) im = 0;
	if (im) {
		if (pp0) {
			if (p=MRealloc(*pp0,len+1)) {
				mem = *pp0 = p;
			}
		}
		else p = NULL;
		if (!p) {
			if (work) len = w_len -1;
			else len = -1;
		}
	}
	*pp1 = mem;

	return len;
}

/****************************************/
/*										*/
/****************************************/
char *strmem(s,len)
char *s;
int  len;
{
	static char wrk[256],*p0=NULL;
	char *p;

	if ((len=akxmemwork(len,&p,&p0,wrk,sizeof(wrk))) >= 0) {
		memnzcpy(p,s,len);
	}
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv0(argc,argv,argl,pp0)
int   argc;
char *argv[];
int   argl[];
char **pp0;
{
	char *p,*p0,*pp,*pM;
	int  alen,blen;
	int i,len,same;

	if (!pp0) return NULL;
/*
printf("memadd0: alen=%d a=[%s] blen=%d b=[%s]\n",alen,a,blen,b);
*/
	p0 = *pp0;
	len = 1;
	same = 0;
	for (i=0;i<argc;i++) {
		len += argl[i];
		if (!argv[i]) same = 1;
	}
	if (!p0 || same) {
		if (!(pM=Malloc(len))) return NULL;
	}
	else {
		if (!(pM=Realloc(p0,len))) return NULL;
		p0 = NULL;
	}
	pp = pM;
	for (i=0;i<argc;i++) {
		if (p=argv[i]) {
			memcpy(pp,p,len=argl[i]);
			pp += len;
		}
	}
	*pp = '\0';
	if (p0) Free(p0);
/*
printf("memaddv0:%s\n",p);
*/
	*pp0 = pM;
	return pM;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv(argc,argv,argl)
int   argc;
char *argv[];
int   argl[];
{
	static char *p0=NULL;

	return memaddv0(argc,argv,argl,&p0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd0(a,alen,b,blen,pp0)
char *a,*b,**pp0;
int  alen,blen;
{
	char *argv[2];
	int   argl[2];

	argv[0] = a;
	argv[1] = b;
	argl[0] = alen;
	argl[1] = blen;
	return memaddv0(2,argv,argl,pp0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd(a,alen,b,blen)
char *a,*b;
int  alen,blen;
{
	static char *p0=NULL;

	return memadd0(a,alen,b,blen,&p0);
}

/****************************************/
/*										*/
/****************************************/
char *straddv(argc,argv)
int   argc;
char *argv[];
{
	static int *argl=NULL;
	int i;
	char *p;

	if (argc<=0 || !argv) return NULL;
	if (!(argl=(int *)MRealloc(argl,argc*sizeof(int)))) return NULL;
	memset(argl,0,argc*sizeof(int));
	for (i=0;i<argc;i++) {
		if (p=argv[i]) argl[i] = strlen(p);
	}
	return memaddv(argc,argv,argl);
}

/****************************************/
/*										*/
/****************************************/
char *stradd5(a,b,c,d,e)
char *a,*b,*c,*d,*e;
{
	char *argv[5];

	argv[0] = a;
	argv[1] = b;
	argv[2] = c;
	argv[3] = d;
	argv[4] = e;
	return straddv(5,argv);
}

/****************************************/
/*										*/
/****************************************/
char *stradd(a,b)
char *a,*b;
{
	if (!a) return b;
	if (!*a) return b;
	if (!b) return a;
	if (!*b) return a;
	return stradd5(a,b,NULL,NULL,NULL);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrnlen(s,len)
char *s;
int len;
{
	int i;
	char *p=s;

	for (i=0;i<len;i++) if (!*p++) break;

	return i;
}

/********************************************************/
/*														*/
/********************************************************/
char akxcupper(cc)
char cc;
{
	char c;

	if ((c=cc)>='a' && c<='z') c &= ~0x20;
	return c;
}

/********************************************************/
/*														*/
/********************************************************/
int akxqupper(cc)
char cc;
{
	char c;
	int ret;

	if ((c=cc)>='A' && c<='Z') ret = 1;
	else ret = 0;
	return ret;
}

/****************************************************************************/
/*  : akxtgwnsl															*/
/* @\ : 񂩂w肳ꂽ؂蕶ŋ؂ă[ho    		*/
/*        Xy[Xƃ^uȊŐ؂蕶IvVɂo    		*/
/*         --------------+----------------------*--------------------- 		*/
/*          " "̈    | opt & 0x200=0        | opt & 0x200<>0       		*/
/*         --------------+----------------------*--------------------- 		*/
/*          sep "  | "x" [hƂ   | " [hƂ     		*/
/*          sepT[`  | " ͋؂           | " ͋؂           		*/
/*         --------------+----------------------*--------------------- 		*/
/*          sep " Ȃ | "x" [hƂȂ | " [hƂȂ   		*/
/*          sepT[`  | "x" ΂         | " "`FbNȂ  		*/
/*         --------------+----------------------*--------------------- 		*/
/*  : buf	: ւ̃|C^B										*/
/*				  I[́ANULLA'\n'܂'\r'A񒷂܂				*/
/*				  IvVɂA'\'̌͋؂蕶̑ΏۂɂȂȂ	*/
/*		  len	: 񒷁ioCgjB										*/
/*		  sspl	: [ho\̂ւ̃|C^							*/
/*				  sp: T[`JnʒuA擪͂OoCgځB					*/
/*				  wd: [hi[GAւ̃|C^B[hi[		*/
/*					  IvVłANULL̂Ƃ́Ai[ȂB			*/
/*				  wdmax: > 0 : [hi[ő咷(oCg)						*/
/*						 = 0 : dɃ[h̐擪AhXԂ				*/
/*						 < 0 : `FbNɊi[					*/
/*				  attr[0]:[h										*/
/*							=1 :  or 							*/
/*							=5 : 'xxxx'										*/
/*							=6 : "xxxx"										*/
/*							=0x80 or asc : ؂蕶						*/
/*									 asc:؂蕶̔pR[h				*/
/*										 płȂƂ́A0x7F				*/
/*				  attr[1]:QoCgLtOB1/0=^Ȃ			*/
/*				  attr[2]:sSkQdlp̂ƂA0x01					*/
/*						  [hi[ɃI[o[t[A0x02OR	*/
/*				  attr[3]:[Qd]pɘA[Qd]p̂ƂA1 */
/*				  code: R[h = 0 : VXe̕R[h				*/
/*		  sep	: ؂蕶B											*/
/*		  opt	: IvV												*/
/* 0x01 = 0/1 : sXy[Xƃ^uXLbvȂ / XLbv			*/
/* 0x02 = 0/1 : QdpAp͂Ȃ(sSG[) / ͂	*/
/* 0x04 = 0/1 : QdpAp̘̒AQ̂PɂȂ	*/
/*              / Pɂ												*/
/* 0x08 = 0/1 : QdpAp̏ / Ȃ				*/
/* 0x10 = 0/1 : ؂蕶ȊO܂ŃXLbvȂ / L	*/
/* 0x20 = 0/1 : gpBsspl->wdmaxgp								*/
/*      wdmax= 0:ssp->wdɃ[hi[A[h̐擪AhX	*/
/*      wdmax<>0:ssp->wdɃ[hi[ (wdmax<0:`FbNȂ)	*/
/* 0x40 = 0/1 : '\n'܂'\r'I[Ƃ / I[ƂȂ					*/
/*				(=1 ́Ap̂Ƃ̂ݗL)								*/
/* 0x80  = 1 : '\'GXP[vƂBp̒ȊO'\'͍폜B	*/
/* 0x100 = 1 : p̏Ȃ											*/
/* 0x200 = 1 : Qdp̏Ȃ										*/
/* 0x400 = 1 : ؂蕶p̏ꍇA啶ʂȂB			*/
/****************************************************************************/
int akxtgwnsl(buf, len, sspl, sep, opt)
char *buf, *sep;
SSPL_S *sspl;
int len, opt;
{
	int	opt_0,opt_1,opt_2,opt_3,opt_4,opt_5,opt_6,opt_8,opt_9,opt_80,opt_400;
	int i, l, pos, nsep, lmax, m,splen,in_opt;
	char *s, ch, *w, quat, *psep, cs;
	uchar pattr[4],code_type;

	if (!buf || !sspl) return -2;
	if (!sep) sep = gsep;

	pos = sspl->sp;
/*
printf("akxtgwnsl:Enter len=%d pos=%d\n",len,pos);
*/
	w = sspl->wd;
	lmax = sspl->wdmax;
	pattr[1] = 0;
	sspl->attr[0] = 0;
	sspl->attr[1] = 0;
	sspl->attr[2] = 0;
	sspl->attr[3] = 0;
	opt_2 = opt & 0x04;
	if (lmax) opt_5 = 1;
	else {
		opt_2 = 0;
		opt_5 = 0;
	}
	if (opt_5) *w = '\0';
	else sspl->wd = "";

	if (pos > len) {
/*
printf("akxtgwnsl:Exit2 pos=%d w=[%s]\n",pos,sspl->wd);
*/
		return -1;
	}
	else if (pos == len) {
		sspl->sp++;
/*
printf("akxtgwnsl:Exit1 pos=%d w=[%s]\n",sspl->sp,sspl->wd);
*/
		return 0;
	}

	nsep = strlen(sep);
	s = buf + pos;
	pattr[1] = 0;
	opt_0 = opt & 0x01;
	opt_1 = opt & 0x02;
	opt_3 = !(opt & 0x08);
	opt_4 = opt & 0x10;
	opt_6 = !(opt & 0x40);
	opt_8 = !(opt & (0x100 | 0x08));
	opt_9 = !(opt & (0x200 | 0x08));
	opt_80 = opt & 0x80;
	if (opt_400 = opt & 0x400) in_opt = 1;
	else in_opt = 0;
	l = 0;

	if ((code_type=sspl->code) == CD_TYPE_SYSTEM) code_type = akxt_get_code_type();

	/* ؂蕶ȊO܂ŃXLbv */
	if (opt_4) {
#if 1	/* 2021.4.20 */
		while((pos<len)&&((ch=*s)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			m = akxqmbsnlen(code_type,s,len-pos);
			if (akxs_in_mem_opt(sep,nsep,s,m,in_opt) <= 0) {
				l = m;
				break;
			}
			s += m;
			pos += m;
		}
printf("akxtgwnsl:opt_4: pos=%d l=%d\n",pos,l);
#else
		while((pos<len)&&((ch=*s++)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			for (i=0,psep=sep;i<nsep;i++) {
				cs = *psep++;
				if (opt_400) {
					ch = akxcupper(ch);
					cs = akxcupper(cs);
				}
				if (ch == cs) break;
			}
			if (i>=nsep) {
				l = 1;
				break;
			}
			pos++;
		}
#endif
		sspl->sp = pos;
		if (opt_5) *w = '\0';
		else sspl->wd = s;
/*
printf("akxtgwnsl:Exit3 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
	/* sXy[Xƃ^uXLbv */
	if (opt_0) {
#if 1	/* 2020.3.9 */
		while (pos < len) {
			if ((ch=*s)=='\\' && opt_80) {
				pos++;
				s++;
				if (pos < len) {
					if (!(m=akxqismbs(code_type,s))) m = 1;
					pos += m;
					s += m;
				}
			}
			else if (((ch=*s)==' ')||(ch=='\t')||
			         (!opt_6 && ((ch=='\n')||(ch=='\r')))) {
				pos++;
				s++;
			}
			else break;
#else
		while((pos<len)&&(((ch=*s)==' ')||(ch=='\t')||
		                  (!opt_6 && ((ch=='\n')||(ch=='\r'))))) {
			pos++;
			s++;
#endif
/*
printf("akxtgwnsl:1 pos=%d c=[%c]\n",pos,*s);
*/
		}
/*
printf("akxtgwnsl:2 pos=%d c=[%c]\n",pos,*s);
*/
		if (pos>=len) {
			sspl->sp = pos;
			if (opt_5) *w = '\0';
			else sspl->wd = s;
/*
printf("akxtgwnsl:Exit4 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
			return l;
		}
	}
	if (!opt_5) sspl->wd = s;
	ch = *s;

/*	if (opt_3 && (pos<len) && (ch=='"' || ch=='\'')) {	*/
#if 1	/* 2020.3.9 */
	if ((pos<len) && ch=='\\' && opt_80) {	/* GXP[v̏ */
/*
printf("akxtgwnsl:4 pos=%d ch=[%c]\n",pos,ch);
*/
		pos++;
		s++;
		if (pos < len) {
#if 1
			if (!(m=akxqismbs(code_type,s))) m = 1;
			l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
			pos += m;
			s += m;
#else
			ch = *s;
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			pos++;
			s++;
#endif
			ch = *s;
		}
	}
	else
#endif
	if ((pos<len) && ((ch=='"' && opt_9) || (ch=='\'' && opt_8))) {	/* p */
		if (opt_1 && !opt_5) sspl->wd++;
		if (ch=='"') sspl->attr[0] = 6;
		else if (ch=='\'') sspl->attr[0] = 5;
		quat=ch;
		pos++;
		s++;
		if (!opt_1) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
		}
		while((pos<len)&&((ch=*s)!='\0')) {
/*
printf("akxtgwnsl:3 pos=%d c=[%c]\n",pos,ch);
*/
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			if (m=akxqismbs(code_type,s)) {
				l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
				pos += m;
				s += m;
				sspl->attr[1] = 1;
			}
#if 1	/* 2020.3.9 */
			else if (ch=='\\' && opt_80) {
/*
printf("akxtgwnsl:5 pos=%d ch=[%c]\n",pos,ch);
*/
#if 1	/* add 2020.10.10 */
				l = akxwdmax_chk(&w,pattr,lmax,l,ch);
#endif
				pos++;
				s++;
				ch = *s;
				if (pos < len) {
					if (!(m=akxqismbs(code_type,s))) m = 1;
					l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
					pos += m;
					s += m;
				}
			}
#endif
			else {
				pos++;
				s++;
				if (ch == quat) {
					if ((pos >= len) || (*s != quat)) {
						if (!opt_1) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						if (opt_5) *w = '\0';
						sspl->sp = pos;
						if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit5 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
						return l;
					}
					else {
						sspl->attr[3] = 1;
						if (!opt_2) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						l = akxwdmax_chk(&w,pattr,lmax,l,quat);
						pos++;
						s++;
					}
				}
				else {
					l = akxwdmax_chk(&w,pattr,lmax,l,ch);
				}
			}
		}
		if (opt_5) *w = '\0';
		sspl->sp = pos;
		if (!opt_1) sspl->attr[2] = 1;
		if (pattr[1]) sspl->attr[2] |= 0x02;
/*
printf("akxtgwnsl:Exit6 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
	/* ؂蕶̏ */
#if 1	/* 2021.4.20 */
	m = akxqmbsnlen(code_type,s,len-pos);
	if (akxs_in_mem_opt(sep,nsep,s,m,in_opt) > 0) {
		l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
		if (opt_5) *w = '\0';
		pos += m;
		sspl->sp = pos;
		if (m > 1) ch = 0x7f;
		sspl->attr[0] = ch | 0x80;
		if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit7 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
#else
	for (i=0,psep=sep;i<nsep;i++) {
		cs = *psep++;
		if (opt_400) {
			ch = akxcupper(ch);
			cs = akxcupper(cs);
		}
		if (ch==cs) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			if (opt_5) *w = '\0';
			pos++;
			sspl->sp = pos;
			sspl->attr[0] = ch | 0x80;
			if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit7 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
			return l;
		}
	}
#endif
	while ((pos<len)&&((ch=*s)!='\0')) {
/*
printf("akxtgwnsl: pos=%d ch=[%c]\n",pos,ch);
*/
		if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
#if 0	/* 2021.4.20 */
		if ((pos+1<len) && (m=akxqismbs(code_type,s))) {
			l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
			pos += m;
			s += m;
			sspl->attr[1] = 1;
		}
		else {
#endif
			if ((pos+1==len) && akxqismbs1(code_type,*s)) {
				pos++;
				break;
			}
			if ((pos<len) && ch=='\\' && opt_80) {
/*
printf("akxtgwnsl:6 pos=%d ch=[%c]\n",pos,ch);
*/
				pos++;
				s++;
#if 1	/* 2021.4.20 */
				m = akxqmbsnlen(code_type,s,len-pos);
				if (pos < len) {
					l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
					pos += m;
					s += m;
				}
#else
				ch = *s;
				if (pos < len) {
					l = akxwdmax_chk(&w,pattr,lmax,l,ch);
					pos++;
					s++;
				}
#endif
			}
			else {
				/* ؂蕶̏ */
#if 1	/* 2021.4.20 */
				m = akxqmbsnlen(code_type,s,len-pos);
				if (akxs_in_mem_opt(sep,nsep,s,m,in_opt) > 0) {
#if 1
					break;
#else
					if (opt_5) *w = '\0';
					sspl->sp = pos;
					sspl->attr[0] = 1;
					if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit8 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
					return l;
#endif
				}
				l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
				pos += m;
				s += m;
#else
				for (i=0,psep=sep;i<nsep;i++) {
					if (ch==*psep++) {
						if (opt_5) *w = '\0';
						sspl->sp = pos;
						sspl->attr[0] = 1;
						if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit8 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
						return l;
					}
				}
				l = akxwdmax_chk(&w,pattr,lmax,l,ch);
				pos++;
				s++;
#endif
			}
#if 0	/* 2021.4.20 */
		}
#endif
	}
	if (opt_5) *w = '\0';
	sspl->sp = pos;
	if (l>0) sspl->attr[0] = 1;
	if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit pos=%d i=%d w=[%s]\n",pos,l,sspl->wd);
*/
	return l;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwns(buf, len, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int len, opt;
{
	SSPL_S sspl;
	int ret;

	memcpy(&sspl,ssp,sizeof(SSP_S));
	if (opt & 0x20) sspl.wdmax = 0;
	else sspl.wdmax = -1;
	sspl.code = 0;
	ret = akxtgwnsl(buf,len,&sspl, sep, opt);
	memcpy(ssp,&sspl,sizeof(SSP_S));
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwse(buf, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int opt;
{
	return akxtgwns(buf,INT_MAX,ssp,sep,opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwsp(buf, ssp)
char *buf;
SSP_S *ssp;
{
	return akxtgwse(buf,ssp,gsep,0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpknsl(s, slen, ssp, sep, opt)
char *s, *sep;
SSPL_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwnsl(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpkns(s, slen, ssp, sep, opt)
char *s, *sep;
SSP_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwns(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcctox(puc,len,pux)
uchar *puc,*pux;
int len;
{
	int sw,m,n;
	uchar *pucw,*puxw,uc;

	if (!(pucw=puc) || !(puxw=pux)) return -1;
	n = len;
	m=sw=0;
	while (n--) {
		uc = *pucw++;
 		if   ((uc>='0') && (uc<='9')) uc -= '0';
		else if ((uc>='A') && (uc<='F')) uc -= 'A' + 10;
		else if ((uc>='a') && (uc<='f')) uc -= 'a' + 10;
		else uc = 0;
		if (sw) {
			*puxw |= uc;
			sw=0;
			puxw++;
		}
		else {
			*puxw = uc<<4;
			sw=1;
			m++;
		}
	}
	return m;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtsrepc(s,cs,cd)
char *s,cs,cd;
{
	int n=0;
	char c;

	while (c=*s) {
		if (c == cs) {
			n++;
			*s = cd;
		}
		s++;
	}
	return n;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_get_last_name(delm,path)
char *delm, *path;
{
	int len, i;
	char *name, *p;

	if (!path) return NULL;
	if (!delm) return path;
	if (!(*delm)) return path;

	len = strlen(name=path);
	i = akxnrskipto(name,len,delm);
	if (i >= 0) name += i;
	return name;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcxtoc(s,len,d)
char *s, *d;
int len;
{
	int i;
	uchar ucH, ucL;

	for (i=0;i<len;i++) {
		ucH = *s >> 4 & 0x0F;
		ucL  = *s++ & 0x0F;
		if (ucH >= 10) *d++ = (ucH-10) + 'a';
		else *d++ = ucH + '0';
		if (ucL >= 10) *d++ = (ucL-10) + 'a';
		else *d++ = ucL + '0';
	}
	return len*2;
}

/********1*********2*********3*********4*********5*********6**********7**/
/*  : akxcxtocn														*/
/* @\ : \[Xf[^oCgPʂ16i\ɕϊB				*/
/*		  interval0<>0 ̂Ƃ́ÅԊuŃXy[XB̂ƂA */
/*		  Ō̃Xy[X͏o͂ȂB									*/
/*  : IN    s        : \[Xf[^									*/
/*				len      : \[Xf[^̃oCg						*/
/*				d        : o͈										*/
/*				mlen     : õ͈oCg(I[null܂)			*/
/*				interval0: Xy[Xo͊Ԋu(\[Xf[^ł̃oCg)	*/
/*							=0 : len							*/
/*							<0 : o͊ԊuSă[̂ƂA'Z'o	*/
/* ԋp : ϊoCg(I[null܂܂Ȃ)							*/
/************************************************************************/
int akxcxtocn(s,len,d,mlen,interval0)
char *s, *d;
int len,mlen,interval0;
{
	int i,m,n,interval,interval1;
	char c,*p;

	n = 0;
	if ((interval1=interval0) < 0) interval1 = -interval1;
	interval = interval1;
	if (!interval) interval = len;
	if (interval > len) interval = len;
/*
printf("akxcxtocn:Enter: len=%d mlen=%d interval0=%d interva=%d\n",len,mlen,interval0,interval);
*/
	mlen--;
	while (len > 0) {
		if (mlen < 2) break;
		if (len < interval) interval = len;
		if (mlen/2 < interval) interval = mlen/2;
/*
printf("akxcxtocn: mlen=%d interval=%d\n",mlen,interval);
*/
		c = ' ';
		if (interval0<0 && interval==interval1) {
			c = '\0';
			p = s;
			for (i=0;i<interval;i++) c |= *p++;
		}
		if (!c && interval>1) {
		/*	*d = '0';
			*(d+1) = '*';
			m = 2;	*/
			*d = 'Z';
			m = 1;
		}
		else m = akxcxtoc(s,interval,d);
		len -= interval;
		s += interval;
		d += m;
		*d++ = ' ';
		m++;
		n += m;
		mlen -= m;
	}
	if (*(d-1) == ' ') {
		d--;
		n--;
	}
	*d = '\0';
	return n;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_add_dir2(cpDir,cpFile,cppPath)
char *cpDir,*cpFile,**cppPath;
{
	char *cpPath;
	char *p;
	int len;

	if (!cpDir) return cpFile;
	if (!(*cpDir)) return cpFile;
	if (!cpFile || !*cpFile) return cpDir;
	if (*cpFile == '/') return cpFile;
	if (!cppPath) return NULL;

	cpPath = *cppPath;
	len = strlen(cpDir) + strlen(cpFile) + 2 + 8;
	if (cpPath) {
		if (!(cpPath=Realloc(cpPath,len))) return NULL;
	}
	else {
		if (!(cpPath=Malloc(len))) return NULL;
	}
	strcpy(cpPath,cpDir);
	p = cpPath + strlen(cpPath);
	if (*(p-1) != '/') *p++ = '/';
	strcpy(p,cpFile);
	*cppPath = cpPath;
	return cpPath;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_set_bits(ipBits,iMask,iSet)
int *ipBits,iMask,iSet;
{
	int b,m,i;

	b = *ipBits;
	m = iMask;
	if (i=iSet) {
		if (i < 0) b &= ~m;
		else if (i == 1) b |= m;
		else b = m;
		*ipBits = b;
	}
	return b & m;
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_in_mem_opt(target,ltar,str,lstr,opt)
char *target,*str;
int  ltar,lstr,opt;
{
	char *pt,*ps,z1[5];
	int  i,k,n,opt01,opt02,opt04,opt08,pos,unmatch,opt40;
	int  opt20,m,optw,nn[3],mtar,mstr,len,kk,mm,opt_type,code_type;

	if ((pt=target) && (ps=str)) {
		if (!ltar || !lstr) return 0;
/*
printf("akxs_in_mem_opt: ltar=%d pt=[%s] opt=%08x\n",ltar,pt,opt);
printf("                 lstr=%d ps=[%s]\n",lstr,ps);
*/
		opt01 = opt & 0x01;	/* ignore case */
		opt02 = opt & 0x02;	/* reverse */
		opt04 = opt & 0x04;	/* return moji position */
		opt08 = opt & 0x08;	/* compare top only */
		opt20 = opt & 0x20;	/* ignore zenkaku hankaku */
		opt40 = opt & 0x40;	/* compare except */
		optw = 0x10 | opt01 | (opt20>>4) | opt40;
		opt_type = opt & 0x7f000000;
		code_type = opt_type>>24;
		optw |= opt_type;
		if (opt20) {
			mtar = akxctozen_type_opt(ltar,pt,0,code_type,opt_type);
			mstr = akxctozen_type_opt(lstr,ps,0,code_type,opt_type);
			if (opt08 && (mtar != mstr)) return 0;
		}
		else {
			if (opt08 && (ltar != lstr)) return 0;
			mstr = akxqmlen_type(ps,lstr,code_type);
			mtar = akxqmlen_type(pt,ltar,code_type);
		}
		n = mtar - mstr + 1;
/*		n = ltar - lstr + 1;	*/
		if (opt08 && n>1) n = 1;
/*
printf("akxs_in_mem_opt: n=%d opt=%04x optw=%04x\n",n,opt,optw);
*/
		pos = 0;
		len = ltar;
		i = kk = 1;
#if 1
		for (k=1;k<=n;k++) {
#else
		for (k=1,i=1;i<=n;i++,k++,pt++) {
#endif
/*
printf("akxs_in_mem_opt: k=%d i=%d kk=%d len=%d\n",k,i,kk,len);
*/
#if 1
			unmatch = akxmbncmp_type_opt(pt,len,ps,lstr,code_type,optw);
#else
			if (opt01) unmatch = akxmemicmp(pt,ps,lstr);	/* ignore case */
			else       unmatch = akxmemcmp(pt,ps,lstr);
#endif
			if (!unmatch) {
				if (opt04) {
					if (opt02) pos = kk;	/* reverse */
					else return kk;
				}
				else {
					if (opt02) pos = i;	/* reverse */
					else return i;
				}
			}
			mm = m = 1;
			if (opt20) {
				akxctozen1_type_opt(len,pt,0,nn,code_type,opt_type);
				m = nn[0];
				mm = nn[2];
/*
printf("akxs_in_mem_opt:opt20: m=%d mm=%d\n",m,mm);
*/
			}
			else if (k < n) {
			/*	m = akxqkanjilen(pt);	*/
				m = akxqmbsnlen(code_type,pt,len);
/*
printf("akxs_in_mem_opt: m=%d\n",m);
*/
			}
			len -= m;
			kk += mm;
			i  += m;
			pt += m;
		}
		return pos;
	}
	else return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_in_str_opt(target,str,opt)
char *target,*str;
int opt;
{
	char *pt,*ps;

	if ((pt=target) && (ps=str))
		return akxs_in_mem_opt(pt,strlen(pt),ps,strlen(ps),opt);
	else
		return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int instrchar(target,c)
char *target,c;
{
	char str[2];

	str[0] = c;
	str[1] = '\0';
	if (!*target || !c) return 0;
	else return akxs_in_str_opt(target,str,0);
}

/********************************************************/
/*														*/
/********************************************************/
int inistr(target,str)
char *target,*str;
{
	return akxs_in_str_opt(target,str,1);
}

/********************************************************/
/*														*/
/********************************************************/
char *stristr(target,str)
char *target,*str;
{
	int i;

	if ((i=akxs_in_str_opt(target,str,1)) > 0) return target+i-1;
	return NULL;
}

/****************************************/
/*	Get General-Purpose Data			*/
/*		coded by A.Kobayashi 2003.11.19	*/
/****************************************/
int akxt_get_gep_data(klen,p,kpp,plalen)
int  klen;
char *p,**kpp;
int  *plalen;
{
	int  lalen;
	INT4 lklen;

	if (!p) return -1;
	if (klen>0) lalen=lklen=klen;
	else if (klen<0) {
		memcpy(&lklen,p,sizeof(INT4));
		if (lklen<0) return -2;
		p += sizeof(INT4);
		lalen=lklen+sizeof(INT4);
	}
	else {
		lklen=strlen(p);
		lalen=lklen+1;
	}
	if (kpp) *kpp = p;
	if (plalen) *plalen = lalen;
	return lklen;
}

/****************************************/
/*	Cmp General-Purpose Data			*/
/*		coded by A.Kobayashi 2003.11.25	*/
/****************************************/
int akxt_cmp_gep_data_opt(klen,kp,lklen,p,opt)
int  klen,lklen,opt;
char *kp,*p;
{
	INT4 ldlen;
	int  s,iCASE;

	if (!kp || !p) return -256;
	iCASE = opt & 0x01;
	if (klen>0) {
		if (iCASE) s = akxmemicmp(kp,p,lklen);
		else s = memcmp(kp,p,lklen);
	}
	else {
		if (klen<0) {
			memcpy(&ldlen,p,sizeof(INT4));
			if (ldlen<0) return -257;
			if (!(s=ldlen-lklen)) {
				if (iCASE) s = akxmemicmp(kp,p,lklen);
				else s = memcmp(kp,p+sizeof(INT4),lklen);
			}
		}
		else {
			if (iCASE) s = akxstricmp(kp,p);
			else s = strcmp(kp,p);
		}
	}
	return s;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_cmp_gep_data(klen,kp,lklen,p)
int  klen,lklen;
char *kp,*p;
{
	return akxt_cmp_gep_data_opt(klen,kp,lklen,p,0);
}

/********************************************************/
/*														*/
/********************************************************/
tdtConvMsgHead *akxc_conv_msg_new(mesg)
tdtMessages mesg[];
{
	tdtConvMsgHead *p;

	if (p=(tdtConvMsgHead *)Malloc(sizeof(tdtConvMsgHead))) {
		p->cmh_try      = 1;
		p->cmh_langmax  = -1;
		p->cmh_no_max   = 0;
		p->cmh_messages = mesg;
		p->cmh_index    = NULL;
		p->cmh_xhp      = NULL;
		akxc_conv_msg(p,1,0);
	}
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxc_conv_msg(cmh,no,lang)
tdtConvMsgHead *cmh;
int no,lang;
{
	tdtRbChain *xhp;
	tdtMessages *mesg,*me,**index;
	int  langmax,no_max,i,k,ix,reg_max;
	char *p;

	if (!cmh) return NULL;
	if (!(mesg=cmh->cmh_messages)) return NULL;
	me = &mesg[0];
	if (no <= 0) return (char *)me->mm_msg;

	xhp   = cmh->cmh_xhp;
	index = cmh->cmh_index;
	p = "";
	if (cmh->cmh_try && !xhp && !index) {
		cmh->cmh_try = 0;
		for (k=0;k<3;k++) {
			if (!me->mm_msg[k] || !*me->mm_msg[k]) break;
		}
		cmh->cmh_langmax = k - 1;
		no_max = k = 0;
		reg_max = me->mm_msgno;
		me++;
		for (;(i=me->mm_msgno)>=0;me++) {
			k++;
			if (i > no_max) no_max = i;
		}
		cmh->cmh_no_max = no_max;
/*
printf("akxc_conv_msg: langmax=%d msg_count=%d no_max=%d\n",cmh->cmh_langmax,k,no_max);
*/
		if (k > no_max/2) {
			if (index = (tdtMessages **)Malloc(sizeof(tdtMessages *)*no_max)) {
				memset(index,0,sizeof(tdtMessages *)*no_max);
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					index[i-1] = me;
				}
			}
		}
		if (!index && k>100) {
			if (reg_max <= 0) reg_max = k;
			if (xhp=akxs_xhasl_new(sizeof(int),reg_max,0,0)) {
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					if (akxs_xhasl(xhp,'S',i,&me) <= 0) {
						akxs_xhasl_free(xhp);
						xhp = NULL;
						break;
					}
				}
			}
		}
		cmh->cmh_xhp   = xhp;
		cmh->cmh_index = index;
/*
printf("akxc_conv_msg: xhp=%08x index=%08x\n",xhp,index);
*/
	}
	langmax = cmh->cmh_langmax;
	no_max  = cmh->cmh_no_max;
	ix = 0;
	if ((lang>=0 && lang<=langmax) && no<=no_max) {
		if (index) {
			if (me = index[no-1]) ix = no;
		}
		else if (xhp) {
			ix = akxs_xhasl(xhp,'R',no,&me);
		}
		else {
			for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
				if (i == no) {
					ix = i;
					break;
				}
			}
		}
		if (ix > 0) {
			p = me->mm_msg[lang];
			if (!p || !*p) {
				for (k=lang+1;k<=langmax;k++) {
					if ((p=me->mm_msg[k]) && *p) break;
				}
			}
		}
	}
/*
printf("akxc_conv_msg: no=%d ix=%d\n",no,ix);
*/
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_get_gen_int_data(p)
tdtGeneralData *p;
{
	int len,i=0;
	short s;
	char *pd;

	if (p && (pd=p->gd_data)) {
		if (len == 4) memcpy(&i,pd,sizeof(INT4));
		else if ((len=p->gd_dlen) == 2) {
			memcpy(&s,pd,sizeof(short));
			i = s;
		}
		else i = *(uchar *)pd;
	}
	return i;
}

/********************************************************/
/*														*/
/********************************************************/
UINT4 akxcmb2ul(s,len)
uchar *s;
int  len;	/* >=1, <=4 */
{
	uchar *p=s;
	int n=len;
	UINT4 ul;

#if 1
	if (n <= 0) ul = 0;
	else {
		ul = *p++;
		if (n == 2) ul = ul<<8 | *p;
		else if (n == 3) ul = (ul<<8 | *p)<<8 | *(p+1);
		else if (n == 1) ;
		else ul = ((ul<<8 | *p)<<8 | *(p+1))<<8 | *(p+2);
	}
#else	/* [v̕x */
	ul = 0;
	while (n-- > 0) {
		ul = ul<<8 | *p++;
	}
#endif
	return ul;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcul2mb(s,ul)
uchar *s;
UINT4 ul;
{
	uchar *p=s,uc;
	int i,len;

	if (!s) return -1;
	len = 0;
	p = s + 4;
	for (i=0;i<4;i++) {
		uc = ul & 0x000000ff;
		if (uc) {
			*(--p) = uc;
			len++;
		}
		ul >>= 8;
	}
	if (len < 4) memcpy(s,p,len);
	*(s+len) = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxmbcmp(s1,m1,s2,m2)
uchar *s1,*s2;
int m1,m2;
{
	return akxcmb2ul(s1,m1) - akxcmb2ul(s2,m2);
}

/********************************************************/
/*	ƕr							*/
/********************************************************/
int akxmbncmp_type_opt(pstr1,nstr1,pstr2,nstr2,type,opt)
uchar *pstr1,*pstr2;
int nstr1,nstr2,type,opt;
{
	uchar *s1,*s2,c1,c2;
	int len1,len2,m1,m2,opt01,opt02,opt10,dif,opt40,d,opt80;
	uchar u1[5],u2[5],z1[5],z2[5],uc,*p1,*p2;
	int n1,n2,nn[3];

	if (!(s1=pstr1) || !(s2=pstr2)) return -1;
/*
printtx("akxmbncmp_opt",pstr1,nstr1);
printtx("             ",pstr2,nstr2);
printf("             : type=%d opt=%04x\n",type,opt);
*/
	if (type <= 0) type = akxt_get_code_type();
	opt01 = opt & 0x01;	/* ignore case */
	opt02 = opt & 0x02;	/* ignore zenkaku hankaku */
	opt10 = opt & 0x10;	/* =0:strcmp(), =1:memcmp() */
	opt40 = opt & 0x40;	/* compare except */
	opt80 = opt & 0x80;	/* '\0'ƌȂ */
	len1 = nstr1;
	len2 = nstr2;
	if (!len1 || !len2) {
		if (!len1 && !len2) dif = 0;
		else if (!len1) dif = -1;
		else if (!len2) dif =  1;
		if (opt40) {
			if (dif) dif = 0;
			else dif = 1;
		}
		return dif;
	}
	dif = 0;
/*	for (;;) {	*/
	while (len1>0 || len2>0) {
		c1 = c2 = '\0';
		if (len1 > 0) c1 = *s1;
		if (len2 > 0) c2 = *s2;
		if (!opt80) {
			if (!c1) len1 = 0;
			if (!c2) len2 = 0;
		}
		m1 = m2 = 1;
	/*	if (len1 >= 2) m1 = akxqkanjilen(s1);
		if (len2 >= 2) m2 = akxqkanjilen(s2);	*/
		if (len1 >= 2) m1 = akxqmbsnlen(type,s1,len1);
		if (len2 >= 2) m2 = akxqmbsnlen(type,s2,len2);
/*
printf("akxmbncmp_opt: m1=%d m2=%d\n",m1,m2);
*/
		if (m1==1 && m2==1) {
			if (opt01) {
				c1 = akxcupper(c1);
				c2 = akxcupper(c2);
			}
/*
printf("akxmbncmp_opt: c1=[%c] c2=[%c]\n",c1,c2);
*/
#if 1
			d = c1 - c2;
			if (opt40) {
				if (!d) {
					dif = 1;
					break;
				}
			}
			else if (dif=d) break;
#else
			if (dif=c1-c2) break;
#endif
			len1--;
			len2--;
			s1++;
			s2++;
		}
		else {
			n1 =m1;
			n2 =m2;
			if (opt02) {
				p1 = s1;
				p2 = s2;
				if (m1==1 || type==CD_TYPE_UTF8) {
					m1 = akxctozen1_type_opt(len1,s1,z1,nn,type,0);
					n1 = nn[0];
					p1 = z1;
/*
printtx("akxmbncmp_opt:zen1:1",p1,m1);
*/
				}
				if (m2==1 || type==CD_TYPE_UTF8) {
					m2 = akxctozen1_type_opt(len2,s2,z2,nn,type,0);
					n2 = nn[0];
					p2 = z2;
/*
printtx("akxmbncmp_optzen1:2",p2,m2);
*/
				}
				if (opt & 0x01) {
					akxcuplw(u1,z1,0);
					akxcuplw(u2,z2,0);
					p1 = u1;
					p2 = u2;
/*
printtx("akxmbncmp_opt:up:1",p1,m1);
printtx("             :up:2",p2,m2);
*/
				}
			}
			else {
				if (m1 > len1) m1 = len1;
				if (m2 > len2) m2 = len2;
				p1 = s1;
				p2 = s2;
			}
/*
printf("akxmbncmp_opt: p1=[%s] m1=%d p2=[%s] m2=%d\n",p1,m1,p2,m2);
*/
#if 1
			d = akxmbcmp(p1,m1,p2,m2);
			if (opt40) {
				if (!d) {
					dif = 1;
					break;
				}
			}
			else if (dif=d) break;
#else
			if (dif=akxmbcmp(p1,m1,p2,m2)) break;
#endif
/*
printf("akxmbncmp_opt: n1=%d n2=%d\n",n1,n2);
*/
			s1 += n1;
			s2 += n2;
			len1 -= n1;
			len2 -= n2;
		}
		if (opt10 && (len1<=0 || len2<=0)) break;
	}
/*
printf("akxmbncmp_opt: dif=%d\n",dif);
*/
	return dif;
}

/********************************************************/
/*	ƕr							*/
/********************************************************/
int akxmbncmp_opt(pstr1,nstr1,pstr2,nstr2,opt)
uchar *pstr1,*pstr2;
int nstr1,nstr2,opt;
{
	akxmbncmp_type_opt(pstr1,nstr1,pstr2,nstr2,akxt_get_code_type(),opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrcmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstricmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemcmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x10);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemicmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x11);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemcmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
/*
if (*s2=='%') {
int ret;
printf("len1=%d s1=[%s] len2=%d s2=[%s]\n",len1,s1,len2,s2);
	ret = akxmbncmp_opt(s1,len1,s2,len2,0x10);
printf("ret=%d\n",ret);
	return ret;
}
else
*/
	return akxmbncmp_opt(s1,len1,s2,len2,0x10);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemicmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0x11);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrcmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstricmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0x01);
}

/********************************************************/
/*	(pm1,len)̕(pm2)ʒuԂ		*/
/********************************************************/
int akx_mem_chr_opt(pm1,pm2,len,opt)
uchar *pm1,*pm2;
int len,opt;
{
	uchar *s1,*s2,c1,c2;
	int pos,opt01,n,m1,m2,dif,code_type;

	if (!(s1=pm1) || !(s2=pm2)) return -1;
	opt01 = opt & 0x01;	/* ignore case */
	code_type = (opt & 0x7f000000)>>24;
/*	if (!(m2=akxqiskanji(s2))) {	*/
	if (!(m2=akxqismbs(code_type,s2))) {
		c2 = *s2;
		 if (opt01) c2 = akxcupper(c2);
	}
	pos=0;
	n = len;
	while (n > 0) {
	/*	if (n >= 2) m1=akxqiskanji(s1);	*/
		if (n >= 2) m1=akxqismbs(code_type,s1);
		else m1=0;
		if (m1 && m2) {
			if (m1==m2 && n>=m1) {
				if (!memcmp(s1,s2,m1)) {
					pos=len-n+1;
					break;
				}
			}
		}
		else if (m1==m2) {
			c1 = *s1;
			if (opt01) dif=akxcupper(c1)-c2;
			else dif=c1-c2;
			if (!dif) {
				pos=len-n+1;
				break;
			}
		}
		if (m1) {
			s1+=m1;
			n -=m1;
		}
		else {
			s1++;
			n--;
		}
	}

	return pos;
}

/********************************************************/
/* ԋp : >=0 XLbvoCg܂͕			*/
/*			p^[Ɉv镶ȂƂ́A		*/
/*				IN : 0									*/
/*				TO : len+1 or Ώە				*/
/********************************************************/
int akxn_skip_opt(buf,len,ptn,ptn_len,opt)
char *buf,*ptn;
int  len,ptn_len,opt;
{
	int  i,lptn,m,k,flg,flgb;
	char *p;
	int  n,opt01,opt02,opt04,opt08,pos,match;

	if (!buf || !ptn) return -1;
	if (len<=0 || (lptn=ptn_len)<=0) return 0;
	opt04 = opt & 0x04;	/* return moji position */
/*
	if (!*ptn) {
		if (opt04) pos = akxqmlen(buf,len);
		else pos = len;
		return pos;
	}
*/
	opt01 = opt & 0x7f000001;	/* code_type | ignore case */
	opt02 = opt & 0x02;	/* reverse */
	opt08 = opt & 0x08;	/* 0/1=in/to */
	if (opt02) opt08 = opt08 ? 0 : 1;
	pos = 0;
	p = buf;
	m = 1;
	flgb = 0;
	for (i=k=0;i<len;k++) {
		if (!(*p)) break;
		match = akx_mem_chr_opt(ptn,p,lptn,opt01);
/*
printf("akx_skip_opt: i=%d lptn=%d ptn=[%c] p=[%c]\n",i,lptn,*ptn,*p);
*/
		flg = (opt08 && match) || (!opt08 && !match);
		if (opt02) {
			if (!flgb && flg) {
				if (opt04) pos = k;
				else pos = i;
			}
			flgb = flg;
		}
		else {
			if (flg) {
				if (opt04) i = k;
				return i;
			}
		}
		m=akxqkanjilen(p);
		p += m;
		i += m;
	}
	if (opt02) {
		if (!flgb) {
			if (opt04) pos = k;
			else pos = i;
		}
	}
	else {
		if (opt04) pos = k;
		else pos = i;
	}
	return pos;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_skip_opt(buf,len,ptn,opt)
char *buf,*ptn;
int  len,opt;
{
	if (!ptn) return -1;
	return akxn_skip_opt(buf,len,ptn,strlen(ptn),opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x02);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08|0x02);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipin2(buf,len,ptn,lptn)
char *buf,*ptn;
int  len,lptn;
{
	return akxn_skip_opt(buf,len,ptn,lptn,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipto2(buf,len,ptn,lptn)
char *buf,*ptn;
int  len,lptn;
{
	return akxn_skip_opt(buf,len,ptn,lptn,0x08);
}

/********************************************************/
/*														*/
/********************************************************/
int akx_conv_yen1(s,len,ssp)
uchar *s;
int    len;
SSP_S *ssp;
{
	uchar *p,c,uc,escape,cc;
	int i,h,n,max,rad,d;

	i = ssp->sp;
	ssp->attr[1] = '\0';
	if (i >= len) return -1;
	p = s + i++;
	escape = ssp->attr[0];
	c = *p++;
	if (escape && c==escape && i<len) {
		c = *p;
		if ((c>='0' && c<='9') || c=='x') {
			if (c == 'x') {
				max = 2;
				rad = 16;
				i++;
				p++;
			}
			else {
				max = 3;
				rad = 8;
			}
			max = X_MIN(i+max,len);
			n=0;
			uc = '\0';
			for (;i<max;i++,p++) {
				c = *p;
				if (c>='0' && c<='7') d = c - '0';
				else d = -1;
				if (rad == 16) {
					if (c>='a' && c<='f') d = c - 'a' + 10;
					else if (c>='A' && c<='F') d = c - 'A' + 10;
				}
				if (d>=0 && d<rad) {
					uc = uc*rad + d;
					n++;
				}
				else {
					break;
				}
			}
			c = uc;
		}
		else {
			switch (c) {
				case 'a': c = '\a'; break;
				case 'b': c = '\b'; break;
				case 'f': c = '\f'; break;
				case 'n': c = '\n'; break;
				case 'r': c = '\r'; break;
				case 't': c = '\t'; break;
				case 'v': c = '\v'; break;
			}
			i++;
		}
	}
	ssp->sp = i;
	ssp->attr[1] = c;
	return 0;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtstrim(opt,pData,len,ptn)
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLNAȂ */
char *pData,*ptn;
int len;
{
	int  ol;
	char *p;
	ParList pa_dat;

	ol = akxtstrim2(opt,pData,len,&pa_dat,ptn);
	if (ol>0 && pData != (p=pa_dat.par)) {
		memcpy(pData,p,ol);
		if (!(opt & 0x04)) pData[ol] = '\0';
	}
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtstrim2(opt,pData,len,pa_dat,ptn)
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLNAȂ */
char *pData,*ptn;
int len;
ParList *pa_dat;
{
	int i,ol,opt1,opt2,opt4,lptn;
	char *p;

	pa_dat->par    = pData;
	pa_dat->parlen = len;
	if (!(p=pData)) return -1;
	else if ((ol=len) <= 0) return ol;
	if (!ptn) ptn = " \t";
	else if (!(lptn = strlen(ptn))) return ol;

	opt4 = opt & 0x04;
	opt &= 0x03;
	if (!opt) opt = 0x03;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	if (opt2) {	/* O  */
		i = akxnskipin(pData,len,ptn);
		ol = len - i;
		p = pData + i;
	}
	if (opt1 && ol>0) {	/*  */
		ol = akxnrskipin(p,ol,ptn);
	}
/*
	if (opt>=1 && i>0) memcpy(pData,p,ol);
*/
	if (!opt4 && ol<len) p[ol] = '\0';

	pa_dat->par    = p;
	pa_dat->parlen = ol;

	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtsapb(opt,pData,len)
#if 1	/* 2017.11.03 */
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLNAȂ */
#else
int opt;	/* 0: 1:O 2: O*/
#endif
char *pData;
int len;
{
#if 1	/* 2019.10.03 */
	int ol;

	ol = akxtstrim(opt,pData,len,NULL);
#else
	int i,ol,opt1,opt2;
	char *p, *pb, c;

#if 1	/* 2017.11.03 */
	if (!(p = pData)) return -1;
	else if (len <= 0) return len;

#else
	p = pData;
#endif
	for (ol=0;ol<len;ol++) {
		if (!*p) break;
		p++;
	}
	p = pData;
#if 1	/* 2017.11.03 */
	if (!opt) opt = 0x03;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	if (opt2) {	/* O  */
#else
	if (opt >= 1) {
#endif
		while (ol>0 && ((c = *p) == ' ') || (c == '\t')) {
			p++;
			ol--;
		}
		if (ol <= 0) {
			*pData = '\0';
			return (0);
		}
	}
#if 1	/* 2017.11.03 */
	if (opt1) {	/*  */
#else
	if (opt <= 1) {
#endif
		pb = p + ol - 1;
		while (ol>0) {
			if (((c = *pb--) != ' ') && (c != '\t')) break;
			ol--;
		}
	}
#if 1	/* 2017.11.03 */
	if (opt2
#else
	if (opt>=1
#endif
	    && pData != p) memcpy(pData,p,ol);

	if (ol<len) pData[ol] = '\0';
#endif	/* 2019.10.03 */
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
int akxttrim(opt,pData,len)
#if 1	/* 2017.10.14 */
int opt;	/* 0:O 0x02:O 0x01: */
#else
int opt;	/* 0: 1:O 2:O */
#endif
char *pData;
int len;
{
#if 1	/* 2019.10.03 */
	int ol;

	ol = akxtstrim(opt,pData,len,NULL);
#else
	int i,ol,ib,opt1,opt2;
	char *p, c, *pp;

	if (!(p = pData)) return -1;
	else if ((ol = len) <= 0) return ol;

#if 1	/* 2017.10.14 */
	if (!opt) opt = 0x03;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	if (opt2) {	/* O  */
#else
	if (opt >= 1) {
#endif
		while (ol>0 && ((c = *p) == ' ') || (c == '\t')) {
			p++;
			ol--;
		}
		if (ol <= 0) {
			*pData = '\0';
			return 0;
		}
	}
	pp = p;
#if 1	/* 2017.10.14 */
	if (opt1) {	/*  */
#else
	if (opt <= 1) {
#endif
		ib = -1;
		for (i=0;i<ol;i++,p++) {
			if (((c = *p)==' ') || (c=='\t')) {
				ib = i;
				for (;i<ol;i++,p++) {
					if (((c = *p)==' ') || (c=='\t')) ;
					else {
						if (c) ib = -1;
						break;
					}
				}
			}
			if (!c) {
				ol = i;
				break;
			}
		}
		if (ib >= 0) ol = ib;
	}

#if 1	/* 2017.10.14 */
	if (opt2
#else
	if (opt>=1
#endif
	    && pData != pp) memcpy(pData,pp,ol);

	if (ol<len) pData[ol] = '\0';
#endif	/* 2019.10.03 */
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
void printtx(msg,p,len)
char *msg,*p;
int len;
{
	int i;

	printf("%s:",msg);
	printf(" len=%d text=[",len);
	for (i=0;i<len;i++) printf("%c",*p++);
	printf("]\n");
}

/********************************************************/
/*														*/
/********************************************************/
int mem_set_int(a,val,n)
int *a,n,val;
{
	int ret;

	if (a) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *a++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_int(d,s,n)
int *d,*s,n;
{
	int ret;

	if (d && s) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *d++ = *s++;
	}
	else ret = -1;
	return ret;
}

#if defined(_LP64)
/********************************************************/
/*														*/
/********************************************************/
int mem_set_long(a,val,n)
long *a,val;
int n;
{
	int ret;

	if (a) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *a++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_long(d,s,n)
long *d,*s;
int n;
{
	int ret;

	if (d && s) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *d++ = *s++;
	}
	else ret = -1;
	return ret;
}
#else
/********************************************************/
/*														*/
/********************************************************/
int mem_set_long(a,val,n)
long *a,val;
int n;
{
	return mem_set_int(a,val,n);
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_long(d,s,n)
long *d,*s;
int n;
{
	return mem_cpy_int(d,s,n);
}
#endif

/********************************************************/
/*														*/
/********************************************************/
int mem_set_addr(d,val,n)
char *d[],*val;
int n;
{
	int ret;

	if (d) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *d++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_addr(d,s,n)
char *d[],*s[];
int n;
{
	int ret;

	if (d && s) {
		if (n < 0) n = 0;
		ret = n;
		while (n-- > 0) *d++ = *s++;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/*							0x01 : 			*/
/*							0x02 : p			*/
/*							0x04 : L			*/
/*							0x08 : pJi			*/
/*							0x10 : p			*/
/*							0x20 : Sp			*/
/*							0x40 : l(+-.0-9,EDF)			*/
/*							0x80 : O(擪 A-Z,Sp,pJi)	*/
/*							0x100: - 				*/
/*							0x200: . 				*/
/********************************************************/
int akxq_char_kind(s,s_len,opt)
char *s;
int  s_len,opt;
{
	int i,opt4,ret,m,n;
	int x1,x2,x4,x8,x10,x20,x40,x80,x100,x200;
	char c,w[4];

	opt4 = opt & 0x04;
	x1=x2=x4=x8=x10=x20=x100=x200=0;
	x40=0x40;
	x80=0x80;
	i = 0;
	while (i < s_len) {
		m = n = akxqkanjilen2(s,s_len);
		if (m == 1) {
			x10 = 0x10;
		}
		else if (akxqis_hankaku_kana(s,m)) {
			x8 = 8;
		}
		else {
			x20 = 0x20;
			if (opt4) {
				m = akxctohan(m,s,w);
				if (m == 1) c = *w;
				else if (akxqis_hankaku_kana(w,m)) x8 = 8;
			}
			else x40 = 0;
		}
		if (m == 1) {
			c = akxcupper(c);
			if (c>='0' && c<='9') {
				x1 = 1;
				if (!i) x80 = 0;
			}
			else if (c>='A' && c<='Z') {
				x2 = 2;
				if (!(c=='D' || c=='E' || c=='F')) x40 = 0;
			}
			else if (c>=161 && c<=223) {
				x8 = 8;
			}
			else {
				x4 = 4;
				if (c == '.') {
					x200 = 0x200;
				}
				else if (c == '+') {
					x80 = 0;
				}
				else if (c == '-') {
					x100 = 0x100;
				}
				else if (c == '_') {
					x40 = 0;
				}
				else {
					x80 = x40 = 0;
				}
			}
		}
		i += n;
		s += n;
	}
	ret = x1 *+ x2 + x4 + x8 + x10 + x20 + x40 + x80;
	if (opt4) ret += x100 + x200;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
char *nval1(p)
char *p;
{
	if (!p) p = "(null)";
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
char *nval(p,p1)
char *p,*p1;
{
	if (!p) {
		p = p1;
		p = nval1(p);
	}
	return p;
}

/********************************************/
/*                                          */
/********************************************/
char *nvalid(p,p1)
char *p,*p1;
{
	if (!akxm_addrchk(p)) {
		p = p1;
		if (!akxm_addrchk(p)) p = "(invalid)";
	}
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cmp_int(p1,p2,n)
int *p1,*p2;
int  n;
{
	int i,d;

	while (n-- > 0) {
		d = *p1++ - *p2++;
		if (d) break;
	}
	return d;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cmp_int_n(p1,n1,p2,n2)
int *p1,*p2,n1,n2;
{
	int d;

	if (!p1 && !p2) d = 0;
	else if (!p1) d = -1;
	else if (!p2) d = 1;
	else {
		if (!n1 && !n2) d = 0;
		else if(n1 < n2) {
			if (!(d = mem_cmp_int(p1,p2,n1))) d = -1;
		}
		else if(n1 > n2) {
			if (!(d = mem_cmp_int(p1,p2,n2))) d = 1;
		}
		else
			d = mem_cmp_int(p1,p2,n1);
	}
	return d;
}

#if defined(_LP64)
/********************************************************/
/*														*/
/********************************************************/
long x_htonll(x)
long x;
{
	char w[8],*p,*ww,*pp;
	int i;

	pp = p = (char *)&x;
	ww = w + 7;
	for (i=0;i<8;i++) *ww-- = *pp++;
	memcpy(p,w,8);
	return x;
}
long x_ntohll(x)
long x;
{
	return x_htonll(x);
}
#endif

/********1*********2*********3*********4*********5*********6*********7***/
/*																		*/
/* 0x01 : ؂蕶̑啶ʂȂB						*/
/* 0x02 : ÕXy[Xƃ^u폜B								*/
/* 0x04 : max_argv؂񐔂ƌȂAmax_argv+1ɕB		*/
/* 0x08 : ؂蕶̂ǂꂩAƂ́A1̋؂蕶ƌȂB	*/
/* 0x10 : sep==NULLsep_len<=0̂ƂɁAJ}؂蕶ɉB	*/
/************************************************************************/
int akxtnsplit(buf,buf_len,argv,maxargv,parm,parm_len,sep,sep_len,opt)
char *buf,*argv[],*parm,*sep;
int buf_len,maxargv,parm_len,sep_len,opt;
{
	char *p,*pm,*pp,ssep[4];
	int len,pmlen,splen,m,n,pos,opt02,opt04,opt08,mlen,gw_opt,in_opt,code_type,iSETW;
	SSPL_S sspl;

	if (!(p=buf) || !argv || !(pm=parm)) return -1;
/*
printf("akxtnsplit: buf_len=%d buf=[%s] sep_len=%d sep=[%s]\n",buf_len,buf,sep_len,sep);
printf("akxtnsplit: parm_len=%d opt=%08x\n",parm_len,opt);
*/
	if ((len=buf_len)<=0 || maxargv<=0 || (pmlen=parm_len)<=0) return 0;
	opt02 = opt & 0x02;
	opt04 = opt & 0x04;
	opt08 = opt & 0x08;
	code_type = opt & 0x7f000000;
	if (in_opt = opt & 0x01) gw_opt = 0x400;
	else gw_opt = 0;
	gw_opt |= 0x06;
	if (!sep || (splen=sep_len)<=0) {
		sep = ssep;
		memcpy(sep," \t",3);
		if (opt & 0x10) memcpy(sep+2,",",2);
		splen = strlen(sep);
	}
	memset(&sspl,0,sizeof(SSPL_S));
	in_opt |= code_type;
	code_type >>= 24;
	sspl.code = code_type;
	n = 0;
	len = buf_len;
	pp = pm;
	*pp = '\0';
	iSETW = 0;
	while (len > 0) {
		/*  */
		if (opt08)
			pos = akxn_skip_opt(p,len,sep,splen,in_opt);
		else if (len > 0) {
			pos = akxqmbsnlen(code_type,p,len);
			if (akxs_in_mem_opt(sep,splen,p,pos,in_opt) <= 0) pos = 0;
		}
		else pos = 0;
		if (pos > 0) {
			if (!iSETW) {
				*pm = '\0';
				argv[n++] = pm;
				pm++;
				pmlen--;
			}
			p += pos;
			len -= pos;
			iSETW = 0;
/*
printf("akxtnsplit:1: iSETW=%d pos=%d len=%d n=%d pmlen=%d\n",iSETW,pos,len,n,pmlen);
*/
			if (n >= maxargv) break;
		}
		else {
		/*  */
			sspl.sp = 0;
			sspl.wd = pm;
			sspl.wdmax = pmlen - 1;
			pos = akxtgwnsl(p,len,&sspl,sep,gw_opt);
			if (pmlen <= pos) break;
		/*	memzcpy(pm,p,pos);	*/
			mlen = pos;
			if (opt02 && sspl.attr[0]!=5 && sspl.attr[0]!=6) mlen = akxttrim(0,pm,pos);
			argv[n++] = pm;
			if (!opt04 && n>=maxargv) break;
			p += sspl.sp;
			len -= sspl.sp;
			mlen++;
			pm += mlen;
			pmlen -= mlen;
			iSETW = 1;
/*
printf("akxtnsplit:2: iSETW=%d pos=%d len=%d n=%d pmlen=%d\n",iSETW,pos,len,n,pmlen);
*/
		}
		pp = pm - 1;
	}
	if (opt04 && pmlen>0) {
		mlen = memnzcpy(pm,p,len,pmlen);
		if (opt02) akxttrim(0,pm,mlen);
		argv[n++] = pm;
	}
	m = n;
	while (n < maxargv) argv[n++] = pp;
	return m;
}
