package com.xxxxxxx.drvpp.fw.common.util;

import java.util.List;

/**
 * 設定インターフェース.
 */
public interface Setting {
	/**
	 * 値(文字列)取得.
	 * @param key キー
	 * @return 値(文字列)
	 */
	String get(String key);
	/**
	 * 値(数値)取得.
	 * @param key キー
	 * @return 値(数値)
	 */
	int getInt(String key);
	/**
	 * 取得(リスト).
	 * @param key キー
	 * @return 値(リスト)
	 */
	List<?> getList(String key);
	/**
	 * 値(オブジェクト)取得.
	 * @param key キー
	 * @return 値(オブジェクト)
	 */
	Object getObject(String key);
}
