static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akalib5.c
 *
 *        coded by A.Kobayashi 97/12/1
 *      updated by A.Kobayashi 99/03/11
 *      updated by A.Kobayashi 99/06/16
 *      updated by A.Kobayashi 2000/02/18
 *      updated by A.Kobayashi 2008/10/08
 *
 *************************************************/
#include "akacommon.h"

extern tdtMSG_CTL         tMsgCtl;
extern tdtCLASS_CTLHead   tClassHead;

#ifndef NO_CHANNEL_QUE
void    akaQueBuffFree();
#endif

#if 0
/********************************************************/
/*                                                      */
/********************************************************/
static int _MakeSocketUDP(host,service,sa)
char *service,*host;
struct sockaddr_in *sa;
{
	ushort port_no;
	int    ret;
	UINT4  host_addr_h;

	if (!service || !sa) return -1;
/*
printf("_MakeSocketUDP:host=[%s] service=[%s]\n",host,service);
*/
	ret = akb_get_host_addr(host,&host_addr_h);
	if (ret < 0) return ret;
	ret = akb_get_port_no_proto(service,"udp");
	if (ret < 0) return ret;
	port_no = ret;
	memset((char *)sa, 0, sizeof(struct sockaddr));
	sa->sin_family      = AF_INET;
	sa->sin_port        = htons(port_no);
	sa->sin_addr.s_addr = htonl(host_addr_h);
	ret = socket(AF_INET, SOCK_DGRAM, 0);
#ifdef  PERROR
	if (ret < 0) perror("MakeSocketUDP: socket");
#endif
	return ret;
}
#endif

/********************************************************/
/*                                                      */
/********************************************************/
static int _set_head_len_woffset(pCh,iOpt,iHeadLen)
tdtCHANNEL *pCh;
int iOpt,iHeadLen;
{
	if (iOpt & AKA_CHSO_USE_AKB_HEAD) {
		pCh->head_len = sizeof(tdtCOMM_PACK_HEAD);
		pCh->woffset = 0;
	}
	else {
		pCh->head_len = iHeadLen;
		pCh->woffset = sizeof(tdtCOMM_PACK_HEAD);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _uioopen(pCh,host,service)
tdtCHANNEL *pCh;
char *host,*service;
{
	int iRc;
	tdtCHANNEL_USER_IO *pCuio;

	if (!pCh) return -1;
	if (!(pCuio=pCh->cuio)) return -1;
	iRc = 0;
	if (pCh->sys_opt & AKA_CHSO_UIO_CON_OPEN) {
		if (pCuio->connect) {
			iRc = pCuio->connect(pCh->index,pCuio->parm,iRc,host,service);
			if (iRc == 0) iRc = -18508210;
		}
		if (iRc>=0 && pCuio->open) {
			iRc = pCuio->open(pCh->index,pCuio->parm,host,service);
			if (iRc == 0) iRc = -18508209;
		}
	}
	else {
		if (pCuio->open) {
			iRc = pCuio->open(pCh->index,pCuio->parm,host,service);
			if (iRc == 0) iRc = -18508209;
		}
		if (iRc>=0 && pCuio->connect) {
			iRc = pCuio->connect(pCh->index,pCuio->parm,iRc,host,service);
			if (iRc == 0) iRc = -18508210;
		}
	}
	if (iRc == 0) iRc = -18508211;
	memset(&pCuio->select_time,0,sizeof(struct timeval));
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCHANNEL *aka_channel_new(iMax)
int iMax;
{
	tdtCHANNEL *pCh;
	int n,i;
	char *p;

	if (pCh = (tdtCHANNEL *)Malloc(n=sizeof(tdtCHANNEL)*iMax)) {
		memset((char *)pCh,0,n);
		for (i=0;i<iMax;i++) {
			if (p = akb_packet_new(0)) {
				pCh[i].wpack_head = (tdtCOMM_PACK_HEAD *)p;
			}
			else {
				aka_channel_free(pCh,iMax);
				pCh = NULL;
				break;
			}
		}
	}
	else pCh = NULL;
	return pCh;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_free(pCh,iMax)
tdtCHANNEL *pCh;
int iMax;
{
	int i;
	tdtCOMM_PACK_HEAD *p;

	if (!pCh) return -1;
	for (i=0;i<iMax;i++) {
		if (p = pCh[i].wpack_head) Free(p);
	}
	Free(pCh);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_open(pCha)
tdtCHANNEL_OPEN *pCha;
{
	tdtCHANNEL *pCh,**pChPA;
	int iCh,iRc,iProto=0,iServer=0,iparm[4];
	tdtCHANNEL_USER_IO *pCuioa, *pCuio;
	struct sockaddr_in *sa;
	char *argv[2],tmp[256],*service,*host;
	UINT4 host_addr_h;

	if (tMsgCtl.sd<0) return -18508201;
	if (!pCha) {
		return -18508202;
	}
	if (pCha->sd <= 0) {
		if (!pCha->service){
			return -18508203;
		}
	}
	if (!(pCha->opt & AKA_CHSO_USE_AKB_HEAD)) {
	/*	if (!pCha->iHeadLen)  return -18508205;	*/
		if (!pCha->head_check) return -18508204;
	}
	if (tMsgCtl.channel_used >= tMsgCtl.channel_max) {
		iRc = aka_expand_tables(5);
	/* 1999.5.13 Koba
		if (iRc) return 0;
	*/
		if (iRc) return -18508206;
	}

	pChPA = tMsgCtl.channel_pa;
	for (iCh=1,pChPA++;iCh<tMsgCtl.channel_max;iCh++,pChPA++) {
		if (pCh = *pChPA) {
			if (pCh->status == 0) break;
		}
	}
	if (iCh >= tMsgCtl.channel_max) {
		return 0;
	}
	pCh->linger = -1;
	pCh->sa = NULL;
	pCh->cuio = NULL;
	if (pCuioa=pCha->cuio) {
		if (!(pCuio = (tdtCHANNEL_USER_IO *)Malloc(sizeof(tdtCHANNEL_USER_IO)))) {
			return -18508208;
		}
		memcpy(pCuio,pCuioa,sizeof(tdtCHANNEL_USER_IO));
		memset(&pCuio->select_time,0,sizeof(struct timeval));
		pCh->cuio = pCuio;
	}
	host = pCha->host_name;
	if (host && *host == '*') iServer = 1;
	service = pCha->service;
	if (pCha->sd <= 0) {
		if (!akb_service_proto(service,argv)) {
			if (!stricmp(argv[1],"udp")) iProto = 1;
			service = argv[0];
		}
	}
	if (!iServer || iProto) {
		if (!(pCha->opt & AKA_CHSO_USE_AKB_HEAD) && !pCha->head_len) {
			iRc = -18508205;
			goto Err;
		}
	}
	if (iProto || pCha->sa) {	/* UDP */
	/* 2001.12.10 Koba
		if (pCha->head_len<=0 || pCha->head_len>USHRT_MAX) {
			iRc = -18508205;
			goto Err;
		} */
		if (!(sa=(struct sockaddr_in *)Malloc(sizeof(struct sockaddr_in)))) {
			iRc = -18508212;
			goto Err;
		}
		pCh->sa = sa;
	}
	if (pCha->sd > 0) {
		pCh->sd = pCha->sd;
		if (pCha->sa) {
			memcpy(pCh->sa,pCha->sa,sizeof(struct sockaddr_in));
			iProto = 1;
		}
	}
	else if (!pCuioa) {
		iRc = 0;
		if (iProto) {	/* UDP */
#if 0
			if (iServer) {
				iRc = akb_make_socket(pCha->service,0);
				if (iRc == 0) iRc = -18508207;
				else if (iRc < 0) iRc -= 18508220;
				else if (akb_get_make_sock_addr(pCh->sa,sizeof(struct sockaddr_in))<0)
					iRc = -18508214;
			}
			else if (service) {
				iRc = _MakeSocketUDP(host,service,pCh->sa);
			}
			else iRc = -18508214;
			if (iRc < 0) goto Err;
#else
			service = pCha->service;
			if (iServer)
				;
			else if (service) {
				if (!host) host = "";
				if (strlen(host)+strlen(service)+1 < sizeof(tmp)) {
					sprintf(tmp,"%s:%s",host,service);
					service = tmp;
				}
				else iRc = -18508213;
			}
			else iRc = -18508214;
			if (iRc < 0) goto Err;
			iRc = akb_make_socket(service,0);
			if (iRc == 0) iRc = -18508207;
			else if (iRc < 0) iRc -= 18508220;
			else if (akb_get_make_sock_addr(pCh->sa,sizeof(struct sockaddr_in))<0)
				iRc = -18508214;
#endif
		}
		else {	/* TCP */
			if (iServer) {
				iRc = akb_make_socket(service,pCha->head_len);
				if (iRc == 0) iRc = -18508207;
				else if (iRc < 0) iRc -= 18508220;
				akb_get_make_sock_parm(4,iparm);
				pCh->linger = iparm[3];
			}
			else {
			/* 2001.12.10 Koba
				if (pCha->head_len<=0 || pCha->head_len>USHRT_MAX) {
					iRc = -18508205;
				}
				else { */
					iRc = akb_connect(host,service,0,0);
					if (iRc == 0) iRc = -18508207;
					else if (iRc < 0) iRc -= 18508220;
			/*	} */
			}
		}
/*
printf("aka_channel_open: iCh = %d, iSd = %d\n",iCh,iRc);
*/
	/* 1999.5.13 Koba
		if (iRc <= 0) return iRc;
	*/
		if (iRc < 0) goto Err;

		pCh->sd = pCha->sd = iRc;
	}
	else {
	/* 2003.6.26 Koba
		if (pCha->head_len<=0 || pCha->head_len>USHRT_MAX) {
			iRc = -18508205;
			goto Err;
		}
	*/
		iRc = 0;
		if (!(pCha->opt & AKA_CHSO_UIO_NOT_EXEC)) {
#if 1
			iRc = _uioopen(pCh,host,service);
#else
			if (pCuio->open) {
				iRc = pCuio->open(pCh->index,pCuio->parm,host,service);
				if (iRc == 0) iRc = -18508209;
			}
			if (iRc>=0 && pCuio->connect) {
				iRc = pCuio->connect(pCh->index,pCuio->parm,iRc,host,service);
				if (iRc == 0) iRc = -18508210;
			}
#endif
			if (iRc <= 0) {
				if (iRc == 0) iRc = -18508211;
				goto Err;
			}
		}
		pCh->sd = pCha->sd = iRc;
	}
	tMsgCtl.read_que_pa[iCh]->rwq_sd = tMsgCtl.write_que_pa[iCh]->rwq_sd = pCh->sd;
												/* add 2000.9.5 Koba */
#if 1	/* 2003.6.25 Koba */
	_set_head_len_woffset(pCh,pCha->opt,pCha->head_len);
#else
	if (pCha->opt & AKA_CHSO_USE_AKB_HEAD) {
		pCh->head_len = sizeof(tdtCOMM_PACK_HEAD);
		pCh->woffset = 0;
	}
	else {
		pCh->head_len = pCha->head_len;
		pCh->woffset = sizeof(tdtCOMM_PACK_HEAD);
	}
#endif
	pCh->head_check = pCha->head_check;
	pCh->exception = pCha->exception;
	pCh->parm    = pCha->parm;
	pCh->status = 1;
	pCh->sys_opt = pCha->opt;
	memset(pCh->wpack_head,0,sizeof(tdtCOMM_PACK_HEAD));	/* add 2000.9.7 Koba */
	if (iProto) {
		if (iServer) pCh->status |= AKA_CH_UDP_S;
		else pCh->status |= AKA_CH_UDP_C;
	}
	else if (iServer) pCh->status |= AKA_CH_ACCEPT;

	if (iCh >= tMsgCtl.channel_used) tMsgCtl.channel_used++;
	
	return iCh;
Err:
	if (pCh->sa) Free(pCh->sa);
	if (pCh->cuio) Free(pCh->cuio);
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_uioopen(iCh)
int iCh;
{
	tdtCHANNEL *pCh;
	int iRc=0;

	if (!(pCh = aka_channel_get(iCh))) return -18508251;

	if (pCh->sd <= 0) {
		if ((pCh->sys_opt & AKA_CHSO_CLOSE_EXCEPT) && pCh->exception)
			pCh->exception(iCh,22);

		if ((iRc=_uioopen(pCh,NULL,NULL)) > 0) {
			tMsgCtl.read_que_pa[iCh]->rwq_sd =
				tMsgCtl.write_que_pa[iCh]->rwq_sd = pCh->sd = iRc;
		}
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_shut(iCh,iOpt)
int iCh,iOpt;
{
	tdtCHANNEL *pCh;

	if (!(pCh = aka_channel_get(iCh))) return -18508301;
/*
	if (tMsgCtl.sd<0) return -18508301;
	if (iCh<=0 || iCh>=tMsgCtl.channel_used) {
		return -18508302;
	}
	pCh = &tMsgCtl.channel[iCh];
	if (pCh->status == 0) {
		return -18508303;
	}
	else
*/
	if (AKAGETCHSTATUS(pCh->status) == 2) {
		return 18508304;
	}
	AKASETCHSTATUS(pCh->status,2);
	if (iOpt & 0x01) pCh->status |= AKA_CH_WRTEND;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_close(iCh)
int iCh;
{
	tdtCHANNEL *pCh;
	tdtCHANNEL_USER_IO *pCuioa, *pCuio;
	int s,s_issock;
	struct stat tStat;

	if (!(pCh = aka_channel_get(iCh))) return -18508401;
/*
	if (tMsgCtl.sd<0) return -18508401;
	if (iCh<0 || iCh>=tMsgCtl.channel_used) {
		return -18508402;
	}
	pCh = &tMsgCtl.channel[iCh];
	if (pCh->status == 0) {
		return -18508403;
	}
*/
	if ((pCh->sys_opt & AKA_CHSO_CLOSE_EXCEPT) && pCh->exception)
		pCh->exception(iCh,17);
	pCuio = pCh->cuio;
	if ((s=pCh->sd)>0 || (!iCh && !s)) {
		if (pCuio) {
			if (pCuio->shutdown) pCuio->shutdown(iCh,pCuio->parm,s);
			if (pCuio->close)    pCuio->close(iCh,pCuio->parm,s);
		}
		else {
			s_issock = 1;
			if (!iCh && !s) {
				s_issock = 0;
				if (!fstat(s,&tStat)) {
					if (S_ISSOCK(tStat.st_mode)) s_issock = 1;
				}
			}
			if (s_issock) {
#if 1	/* 2003.7.22 Koba */
				if (AKAGETCHACCEPT(pCh->status)) close(s);
				else aka_shut_down(s);
#else
				if (!AKAGETCHACCEPT(pCh->status)) shutdown(s,2);
				close(s);
#endif
			}
		}
	}

	aka_channel_clear(iCh);
	if (pCuio) Free(pCuio);
	if (pCh->sa) Free(pCh->sa);
	if (iCh) {
		pCh->status = 0;
		pCh->sd = -1;
		if (iCh == tMsgCtl.channel_used-1) tMsgCtl.channel_used--;
	}
	else {
		tMsgCtl.sd = pCh->sd = 0;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_uioclose(iCh)
int iCh;
{
	tdtCHANNEL *pCh;
	tdtCHANNEL_USER_IO *pCuio;

	if (!(pCh = aka_channel_get(iCh))) return -18508451;
	if (!(pCuio=pCh->cuio)) return -18508452;

	if ((pCh->sys_opt & AKA_CHSO_CLOSE_EXCEPT) && pCh->exception)
		pCh->exception(iCh,23);

	if (pCh->sd > 0) {
		if (pCuio->shutdown) pCuio->shutdown(iCh,pCuio->parm,pCh->sd);
		if (pCuio->close)    pCuio->close(iCh,pCuio->parm,pCh->sd);
	}

	pCh->sd = -1;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_command(pCh,iClass,iDisp)
tdtCHANNEL *pCh;
int iClass,iDisp;
{
	static tdtCOMM_PACK_HEAD   Head;
	ushort usWrk;

	if (!pCh) return -1;
	if (!iClass) return -2;
	memset((char *)&Head,0,sizeof(tdtCOMM_PACK_HEAD));
	Head.cph_prt.prt_ver = 'C';
	Head.cph_prt.prt_cmnd = htons(AKB_CMD_SEND);
	Head.cph_dinf.ind_hoid = htonl(tMsgCtl.host_id);
	usWrk = iClass;
	Head.cph_dinf.ind_clid = htons(usWrk);
	Head.cph_dinf.ind_prid = htons(tMsgCtl.us_proc);
	Head.cph_dinf.ind_disp = AKA_AKO_CHANNEL | AKA_AKO_CHANNEL_CMD;
	if (iDisp == 0) Head.cph_dinf.ind_disp |= AKA_AKO_NOREPLY;
	usWrk = pCh->index;	/* add 2000.9.6 Koba */
	Head.cph_sinf.ind_prid = htons(usWrk);
	Head.cph_sinf.ind_disp = iDisp;
	Head.cph_sinf.ind_thrd = 1;
	pCh->rpack_head = &Head;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_resume(iCh,iOpt)
int iCh,iOpt;
{
	tdtCHANNEL *pCh;

	if (!(pCh = aka_channel_get(iCh))) return -18508601;
/*
	if (tMsgCtl.sd<0) return -18508601;
	if (iCh<=0 || iCh>=tMsgCtl.channel_used) {
		return -18508602;
	}
	pCh = &tMsgCtl.channel[iCh];
	if (pCh->status == 0) {
		return -18508603;
	}
	else
*/
	if (AKAGETCHSTATUS(pCh->status) != 2) {
		return 18508604;
	}
	pCh->status &= ~AKA_CH_WRTEND;
	AKASETCHSTATUS(pCh->status,1);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_clear(iCh)
int iCh;
{
	tdtCHANNEL *pCh;
	tdtRW_QUE  *pRQue;

	if (!(pCh = aka_channel_get(iCh))) return -18508701;
/*
	if (tMsgCtl.sd<0) return -18508701;
	if (iCh<0 || iCh>=tMsgCtl.channel_used) {
		return -18508702;
	}
	pCh = &tMsgCtl.channel[iCh];
	if (pCh->status != 0) {
		return -18508703;
	}
*/
/*****
	pRQue = tMsgCtl.read_que[iCh];
	pRQue->rwq_torwlen = 0;
	if (pRQue->rwq_buf) Free(pRQue->rwq_buf);
	pRQue->rwq_buf = NULL;
****/
	akb_clear_rwque(tMsgCtl.read_que_pa[iCh],-1);
	akb_clear_rwque(tMsgCtl.write_que_pa[iCh],-1);
#ifndef NO_CHANNEL_QUE
	akxs_que_buf_free(pCh->wpack_que);
#endif
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
#define MIN_ALLOC_LEN	32
#define MIN_ALLOC_MASK	~(MIN_ALLOC_LEN-1)
#define min_alloc_len(x) (((x + MIN_ALLOC_LEN - 1) & MIN_ALLOC_MASK) + 1)

int  aka_read_que(pChannel, pReadQue, pRbRCtl)
tdtCHANNEL *pChannel;
tdtRW_QUE  *pReadQue;
tdtRB_CTL  *pRbRCtl;
{
	pRcPacketTable  pNew ;
	tdtCOMM_PACK_HEAD   *pH;
	tdtREP_HEAD *pRH;
	char *pData;
	int  iLenData, iLenHead, iSd;
	int  iOffset,iLen,iRc,iEvent,from_len;
	tdtCHANNEL_USER_IO *pCuio;
	struct sockaddr_in *psa,sa_in;
	ushort usWrk;

	iSd = pChannel->sd;
	if (pReadQue->rwq_torwlen == 0) {
		pReadQue->rwq_mode     = 'H';
		pReadQue->rwq_offset    = 0;
		pReadQue->rwq_tcount = 0;
		if (pChannel->sys_opt & AKA_CHSO_USE_AKB_HEAD)
			pReadQue->rwq_torwlen = sizeof(tdtCOMM_PACK_HEAD);
		else
			pReadQue->rwq_torwlen = pChannel->head_len;
		pReadQue->rwq_rwlen      = 0;
		if (!(pReadQue->rwq_buf=Malloc(min_alloc_len(pChannel->head_len)))) {
			if (pChannel->exception) pChannel->exception(pChannel->index,3);
			return -1;
		}
		pChannel->resv4 = 0;
		pChannel->rwlen_last = 0;
		pChannel->from_len = 0;
		pChannel->opt = 0;
		/* pPbgʃwb_̓ǂݍ */
/*
printf("[aka_read_que] Header read start.\n");
*/
	}
	if (pReadQue->rwq_tcount == 255) {
		if (pChannel->exception) iRc=pChannel->exception(pChannel->index,21);
		else iRc = 0;
		if (iRc <= 0) {
			pReadQue->rwq_torwlen = 0;
			return -1;
		}
		else {
			iLenData = iLen = 0;
		}
	}
	else {
		iLen    = pReadQue->rwq_torwlen - pReadQue->rwq_rwlen;
		iOffset = pReadQue->rwq_offset + pReadQue->rwq_rwlen;
		if (pCuio=pChannel->cuio) {	/* USER DEFINED I/O */
			if (pCuio->read)
				iLenData = pCuio->read(pChannel->index,pCuio->parm,
				           pReadQue->rwq_mode, pReadQue->rwq_torwlen,
				           iSd ,pReadQue->rwq_buf+iOffset, iLen);
			else iLenData = 0;
		}
		else if (AKAGETCHUDP(pChannel->status)) {	/* UDP */
			iLenData=sk_nolp_recv_from(iSd ,pReadQue->rwq_buf+iOffset, iLen,
			           &sa_in,&from_len);
			/*
			           psa,&pChannel->from_len);
			*/
/*
printf("[aka_read_que] UDP recv_from len=%d host=%08x port=%d\n",
iLenData,ntohl(sa_in.sin_addr.s_addr), ntohs(sa_in.sin_port));
*/
			if (iLenData == 0) return 0;
			else if (iLenData > 0) {
				pReadQue->rwq_torwlen = iLen = iLenData;
			}
		}
		else	/* TCP */
			iLenData = sk_nolp_read(iSd ,pReadQue->rwq_buf+iOffset, iLen);
		if (iLenData <= 0 || iLenData > iLen) {
			if (pReadQue->rwq_mode == 'H') {
				Free(pReadQue->rwq_buf);
				pReadQue->rwq_buf = NULL;	/* add 2003.1.29 Koba */
			}
		/*
			else
				akbSaveHeadAndData(pReadQue->rwq_buf);
		*/
			pReadQue->rwq_torwlen = 0;
			if (iLenData == 0) iEvent = 1;
			else if (iLenData < 0) iEvent = 13;
			else iEvent = 14;
			if (pChannel->exception) pChannel->exception(pChannel->index,iEvent);
			return -1;
		}
		pChannel->rwlen_last = pReadQue->rwq_rwlen;
#ifndef NO_RWQTIMEOUT
		akb_set_que_out_time(pReadQue,NULL);
#endif
		pReadQue->rwq_rwlen += iLenData;
	}
	if (iLenData == iLen) {
		if (pReadQue->rwq_mode == 'H' || pReadQue->rwq_mode == 'A') {
			if (pChannel->sys_opt & AKA_CHSO_USE_AKB_HEAD) {
				iRc = akb_head_check2(pChannel->index,pReadQue,
				                    pChannel->sys_opt & AKA_CHSO_NOT_RECOVERY);
DEBUGOUTL1(AKA_LOG_GROUP|254,"aka_read_que: akb_head_check2 iRc=%d",iRc);
#if 0	/* 2003.3.24 Koba */
				if (iRc == 0) {
				/*
					if (!AKAGETCHUDP(pChannel->status)) return 0;
				*/
					iRc = 1;
				}
				else if (iRc > 0) iRc = 0;
#endif
			}
			else {
				pChannel->rpack_head = NULL;
				pData = pReadQue->rwq_buf;
				iRc = pChannel->head_check(pChannel,pData,pReadQue->rwq_rwlen);
				if (AKAGETCHUDP(pChannel->status) && iRc>0) iRc = 0;
			}
			if (iRc < 0) {
				pReadQue->rwq_torwlen = 0;
				if (pReadQue->rwq_buf) {		/* add 2001.12.10 Koba */
					Free(pReadQue->rwq_buf);		/* add 1997.10.02 Koba */
					pReadQue->rwq_buf = NULL;	/* add 1997.10.02 Koba */
				}
				if (pChannel->exception)
					pChannel->exception(pChannel->index,2);
				return iRc;
			}
			if (pChannel->sys_opt & AKA_CHSO_USE_AKB_HEAD) {
				pH = (tdtCOMM_PACK_HEAD *)pReadQue->rwq_buf;
			    if (pH->cph_sinf.ind_thrd) {	/* Command Packet */
					pH->cph_dinf.ind_disp|=(AKA_AKO_CHANNEL|AKA_AKO_CHANNEL_CMD);
					usWrk = pChannel->index;
					pH->cph_sinf.ind_prid = htons(usWrk);
				}
			}
			else {
				if (pChannel->opt & AKA_CHUO_DATA_AWAY) {
					pChannel->rwlen_last = 0;
					pReadQue->rwq_rwlen = 0;
					pReadQue->rwq_torwlen = 0;
				}
				pChannel->opt = 0;
				if (iRc>0 && pChannel->resv4) {	/* Next Header */
					pReadQue->rwq_torwlen += iRc;
					if (!(pReadQue->rwq_buf=Realloc(pReadQue->rwq_buf,
					                    min_alloc_len(pReadQue->rwq_torwlen)))) {
						if (pChannel->exception)
							pChannel->exception(pChannel->index,7);
						pReadQue->rwq_torwlen = 0;
						return -1;
					}
					return 0;
				}
				pReadQue->rwq_mode  = 'D';
				pReadQue->rwq_tcount = 0;
				pReadQue->rwq_offset = sizeof(tdtCOMM_PACK_HEAD);
				pReadQue->rwq_torwlen += iRc;
				/* pPbg̈̊m */
				pReadQue->rwq_buf=Malloc(pReadQue->rwq_offset+pReadQue->rwq_torwlen+1);
				if (!(pReadQue->rwq_buf)) {
					Free(pData);
					/* f[^̓ǂݎ̂ */
				/*	akb_sk_dmy_read(pChannel->iSd,iRc);	*/
					if (pChannel->exception)
						pChannel->exception(pChannel->index,4);
					pReadQue->rwq_torwlen = 0;
					return D_ERR_MEM_ALLOC;
				}
				pRH = NULL;
				if (!(pH=pChannel->rpack_head)) {	/* when Reply Packet */
					pH = pChannel->wpack_head;
					if (akxs_que_get(pChannel->wpack_que,QUE_DFLT,&pRH) == 1) {
						if (pRH) {
							pH = (tdtCOMM_PACK_HEAD *)pRH;
						}
						else {
							if (pChannel->exception)
								if (pChannel->exception(pChannel->index,9))
									return -1;
						}
					}
					else {
						if (pChannel->exception)
							if (pChannel->exception(pChannel->index,8))
								return -1;
					}
				}
				memcpy(pReadQue->rwq_buf,(char *)pH,sizeof(tdtCOMM_PACK_HEAD));
				if (pRH) Free(pRH);
				memcpy(pReadQue->rwq_buf+sizeof(tdtCOMM_PACK_HEAD),pData,
				       pReadQue->rwq_rwlen);	/* 1998.3.11 Koba */
				pH = (tdtCOMM_PACK_HEAD *)pReadQue->rwq_buf;
				pH->cph_plen = htonl(pReadQue->rwq_torwlen);
				Free(pData);
			}
			if (AKAGETCHUDP(pChannel->status) &&
			    pH->cph_sinf.ind_thrd) {
				pH->cph_sinf.ind_hoid   = sa_in.sin_addr.s_addr;
				pH->cph_sinf.ind_clid = sa_in.sin_port;
/*
printf("[aka_read_que] UDP Command Package host=%08x port=%d\n",
pH->cph_sinf.ind_hoid,pH->cph_sinf.ind_clid);
*/
			}
			if (iRc > 0) return 0;
		}
/*
printf("[aka_read_que] Packet read end.(Sd=%d) Packet len = %d\n",
iSd,pReadQue->rwq_offset+pReadQue->rwq_torwlen);
*/
		if (AKAGETCHSTATUS(pChannel->status) != 1) {
			pReadQue->rwq_mode  = ' ';
			pReadQue->rwq_torwlen = 0;
			Free(pReadQue->rwq_buf);
			pReadQue->rwq_buf = NULL;
			return 0;
		}

		/* pPbgǗe[u֐ݒ */
		pNew = akb_packet_tbl_new(0);
		if ( pNew == NULL ) {
		/*	akbSaveHeadAndData(pReadQue->cpBuff);	*/
			pReadQue->rwq_torwlen = 0;
			if (pChannel->exception) pChannel->exception(pChannel->index,5);
			return D_ERR_MEM_ALLOC;
		}
		pNew->sp_content = pReadQue->rwq_buf ;
		pNew->sp_len     = pReadQue->rwq_offset + pReadQue->rwq_torwlen;
		pNew->sp_ch      = pChannel->index;
		if (pChannel->sys_opt & AKA_CHSO_USE_AKB_HEAD)
			pNew->sp_srcch   = pChannel->index + 1;
		pReadQue->rwq_mode  = ' ';
		pReadQue->rwq_torwlen = 0;
		pReadQue->rwq_buf = NULL;
		if (!akxs_rb_set_n(pRbRCtl,pNew)) {
		/*	akbSaveHeadAndData(pNew->pContent);	*/
			Free(pNew->sp_content);
			Free(pNew);
			if (pChannel->exception) pChannel->exception(pChannel->index,6);
        	return D_ERR_MEM_ALLOC;
		}
	}
/*
	else {
printf("[akb_read_que] Packet read suspended.fd = %d\n",iSd);
	}
*/
    return 0 ;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_set_seq(iCh,iLen,pSeq)
int iCh,iLen;
char *pSeq;
{
	tdtCHANNEL *pCh;
	tdtREP_HEAD *pRH;

	if (!(pCh = aka_channel_get(iCh))) return -18508801;
/*
	if (tMsgCtl.sd<0) return -18508801;
	if (iCh<=0 || iCh>=tMsgCtl.channel_used) {
		return -18508802;
	}
	pCh = &tMsgCtl.channel[iCh];
*/
	if (AKAGETCHSTATUS(pCh->status) != 1) {
		return -18508803;
	}
	if ((iLen <= 0) || (iLen > AKA_CHANNEL_SEQMAX)) return -18508804;
	if (!pSeq) return -18508805;
	if (akxs_que_peek(pCh->wpack_que,QUE_BOT,&pRH) <= 0) return -18508806;
	if (!pRH) return -18508807;
	pRH->packet_head.cph_plen = htonl(iLen);
	memcpy(pRH->sequence,pSeq,iLen);
/*
printf("aka_channel_set_seq:iCh=%d iLen=%d pSeq=[%s]\n",iCh,iLen,pSeq);
*/
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_rep_seq(pCh,iLen,pSeq)
tdtCHANNEL *pCh;
int iLen;
char *pSeq;
{
	static tdtCOMM_PACK_HEAD   Head;
	tdtREP_HEAD *pRH;
	int iRc;

	if (tMsgCtl.sd<0) return -18508901;
	if (!pCh) {
		return -18508902;
	}
	if (AKAGETCHSTATUS(pCh->status) != 1) {
		return -18508903;
	}
	if ((iLen <= 0) || (iLen > AKA_CHANNEL_SEQMAX)) return -18508904;
	if (!pSeq) return -18508905;
	akxs_que_move(pCh->wpack_que,QUE_TOP_PREV);
	while ((iRc=akxs_que_peek(pCh->wpack_que,QUE_NEXT,&pRH)) > 0) {
		if (pRH) {
/*
printf("pRH->Sequence=[%s]\n",pRH->sequence);
*/
			if (ntohl(pRH->packet_head.cph_plen) == iLen) {
				if (!memcmp(pRH->sequence,pSeq,iLen)) {
					akxs_que_get(pCh->wpack_que,QUE_CUR,&pRH);
					memcpy(&Head,pRH,sizeof(tdtCOMM_PACK_HEAD));
					pCh->rpack_head = &Head;
					Free(pRH);
					return 0;
				}
			}
		}
	}
	if (iRc < 0) return -18508906;
	return -18508907;
}

/********************************************************/
/*                                                      */
/********************************************************/
int  aka_write_que(pCh, pWriteQue)
tdtCHANNEL *pCh;
tdtRW_QUE *pWriteQue;
{
	int iLenData,iOffset,iLen, iRc, iEvent,iSd;
	char *pData;
	tdtCHANNEL_USER_IO *pCuio;
	tdtCOMM_PACK_HEAD   *pH;
	struct sockaddr_in *psa,sa_in;

	if (pWriteQue->rwq_torwlen == 0) return 0;
	else if (pWriteQue->rwq_tcount == 255) {
		pWriteQue->rwq_mode   = ' ';
		return -1;
	}
	iSd = pWriteQue->rwq_sd;
	iLen    = pWriteQue->rwq_torwlen - pWriteQue->rwq_rwlen;
	iOffset = pWriteQue->rwq_rwlen;
	pData   = pWriteQue->rwq_buf + iOffset;
	if (pCuio = pCh->cuio) {
		if (pCuio->write)
			iLenData = pCuio->write(pCh->index,pCuio->parm,
			                        pWriteQue->rwq_mode,pWriteQue->rwq_torwlen,
			                        iSd,pData,iLen);
		else iLenData = -1;
	}
	else if (AKAGETCHUDP(pCh->status)) {	/* UDP */
/*
printf("[aka_write_que] UDP iOffset=%d\n",iOffset);
akxaxdump("akbhead",pWriteQue->rwq_buf,32);
*/
		pH = (tdtCOMM_PACK_HEAD *)pWriteQue->rwq_buf;
		memset((char *)&sa_in,0,sizeof(sa_in));
		sa_in.sin_family      = AF_INET;
		sa_in.sin_port        = pH->cph_dinf.ind_clid;
		sa_in.sin_addr.s_addr = pH->cph_dinf.ind_hoid;
/*
printf("[aka_write_que] UDP send_to host=%08x port=%d len=%d\n",
pH->cph_dinf.ind_hoid,pH->cph_dinf.ind_clid,iLen);
*/
		iLenData = akb_sk_send_to(iSd,pData,iLen,&sa_in,sizeof(sa_in));
		if (iLenData == 0) return 0;
	}
	else	/* TCP */
		iLenData = sk_nolp_write(iSd,pData,iLen);
	if (iLenData < 0 || iLenData > iLen) {
		if (iLenData < 0) iEvent = 15;
		else iEvent = 16;
		if (pCh->exception) pCh->exception(pCh->index,iEvent);
		pWriteQue->rwq_mode   = ' ';
		return -1;
	}
#ifndef NO_RWQTIMEOUT
	akb_set_que_out_time(pWriteQue,NULL);
#endif
	pWriteQue->rwq_rwlen += iLenData;
	if (iLenData == iLen) {
		iRc = 0;
		if (pCuio) {
			if (pCuio->write_end) {
				iRc = pCuio->write_end(pCh->index,pCuio->parm,
				         pWriteQue->rwq_sd,pWriteQue->rwq_buf,pWriteQue->rwq_torwlen);
			}
		}
		if (AKAGETCHWRTEND(pCh->status) && pCh->exception) {
			if (pCh->exception(pCh->index,10)) iRc = -1;
		}
/*
printf("[aka_write_que] Packet write end.(Sd=%d) Packet len = %d\n",
pWriteQue->rwq_sd,pWriteQue->rwq_rwlen);
*/
		pWriteQue->rwq_mode   = ' ';
		pWriteQue->rwq_torwlen = 0;
		Free(pWriteQue->rwq_buf);
		pWriteQue->rwq_buf = NULL;
		if (iRc > 0) iRc = 0;
		return iRc;
	}
/*
	else {
printf("[aka_write_que] Packet write suspended.fd = %d\n",pWriteQue->rwq_sd);
	}
*/
	return 1 ;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_inst_free_seq(lInstHandl)
long lInstHandl;
{
	tdtCHANNEL *pCh,**ppCh;
	tdtREP_HEAD *pRH;
	int i,iRc,iThread,iClassId,n=0;
	long mask;

	if (tMsgCtl.sd<0) return -18509101;

	iThread  = (lInstHandl>>16) & 0xff;
	iClassId = lInstHandl & 0xffff;
	if (iClassId) {
		mask = 0xffff;
		if (iThread) mask |= 0xff0000;
	}
	else mask = 0;

	lInstHandl &= mask;
/*
printf("InstFreeSeq: lInstHandl=%08x\n",lInstHandl);
*/
	i = tMsgCtl.channel_akb_used;
	ppCh = &tMsgCtl.channel_pa[i];
	for (;i<tMsgCtl.channel_used;i++,ppCh++) {
		if (!(pCh = *ppCh)) continue;
		if (AKAGETCHSTATUS(pCh->status)) {
			akxs_que_move(pCh->wpack_que,QUE_TOP);
			while ((iRc=akxs_que_peek(pCh->wpack_que,QUE_CUR,&pRH)) > 0) {
				if (pRH) {
/*
printf("InstFreeSeq: pRH->Sequence=[%s]\n",pRH->sequence);
getchar();
*/
					if ((pRH->instance_handle & mask)== lInstHandl) {
						akxs_que_get(pCh->wpack_que,QUE_CUR,&pRH);
						n++;
						continue;
					}
				}
				akxs_que_move(pCh->wpack_que,QUE_NEXT);
			}
		}
	}
	return n;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_move(iCh)
int iCh;
{
	tdtCHANNEL *pCh;
	int iRc,iSd;

	if (!(pCh = aka_channel_get(iCh))) return -18509201;
/*
	if (tMsgCtl.sd) return -18509201;
	if (iCh<=0 || iCh>=tMsgCtl.channel_used) {
		return -18509202;
	}
	pCh = &tMsgCtl.channel[iCh];
	if (pCh->status == 0) {
		return -18509203;
	}
	else
*/
	if ((iSd=pCh->sd) <= 0) {
		return -18509204;
	}
	pCh->sd = -1;
	if (iRc=aka_channel_close(iCh)) return iRc;

	return aka_init_zero(iSd);
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCHANNEL *aka_channel_get(iCh)
int iCh;
{
	tdtCHANNEL *pCh=NULL;

	if (tMsgCtl.sd >= 0) {
		if (iCh>=0 && iCh<tMsgCtl.channel_used) {
			if (pCh = tMsgCtl.channel_pa[iCh]) {
				if (!pCh->status) pCh = NULL;
			}
		}
	}
	return pCh;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_channel_option(iCh,iOption,iSet,ipRet)
int iCh,iOption,iSet,*ipRet;
{
	tdtCHANNEL *pCh;
	int iOpt;

	if (!(pCh = aka_channel_get(iCh))) return -18509401;

	iOpt = iOption;
	if (iSet) {
		if (iSet > 0) pCh->sys_opt |= iOpt;
		else pCh->sys_opt &= ~iOpt;
		if (iOpt & AKA_CHSO_USE_AKB_HEAD)
			_set_head_len_woffset(pCh,pCh->sys_opt,1);
	}
	if (ipRet) *ipRet = pCh->sys_opt & iOpt;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cuioselect_interval(iCh,iInterval,iSet,ipRet)
int iCh,iInterval,iSet,*ipRet;
{
	tdtCHANNEL *pCh;
	tdtCHANNEL_USER_IO *pCuio;

	if (!(pCh = aka_channel_get(iCh))) return -18509501;
	if (!(pCuio = pCh->cuio)) return -18509502;

	if (iSet > 0) pCuio->select_interval = iInterval;
	if (ipRet) *ipRet = pCuio->select_interval;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_hyp_channel_get_one(iCh)
int iCh;
{
	int i,max;

	if (iCh) {
		if (!aka_channel_get(iCh)) return -18509501;
	}
	
	max = tMsgCtl.hyp_channel->hyp_cha_used;
	for (i=0;i<max;i++) {
		if (tMsgCtl.hyp_channel->hyp_cha[i+1] < 0) break;
	}
	if (i >= max) {
		if (max >= AKA_CHANNEL_MAX) i = 0;
		else tMsgCtl.hyp_channel->hyp_cha_used = ++i;
	}
	if (i > 0) {
		tMsgCtl.hyp_channel->hyp_cha[i] = iCh;
		if (iCh) tMsgCtl.hyp_channel->cha[iCh] = 0;
	}
	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_hyp_channel_add_ch(iHypCh,iCh)
int iHypCh,iCh;
{
	int ix,ix0;

	if (iHypCh<=0 || iHypCh>AKA_CHANNEL_MAX) return -18509601;
	if ((ix=tMsgCtl.hyp_channel->hyp_cha[iHypCh]) < 0) return -18509602;
	if (!aka_channel_get(iCh)) return -18509603;
	if (ix == iCh) return -18509604;

	if (!ix) tMsgCtl.hyp_channel->hyp_cha[iHypCh] = iCh;
	else {
		while (ix) {
			ix0 = ix;
			ix = tMsgCtl.hyp_channel->cha[ix];
			if (ix == iCh)  return -18509604;
		}
		tMsgCtl.hyp_channel->cha[ix0] = iCh;
	}
	tMsgCtl.hyp_channel->cha[iCh] = 0;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_hyp_channel_del_ch(iHypCh,iCh)
int iHypCh,iCh;
{
	int ix,ix0;

	if (iHypCh<=0 || iHypCh>AKA_CHANNEL_MAX) return -18509701;
	if ((ix=tMsgCtl.hyp_channel->hyp_cha[iHypCh]) < 0) return -18509702;
	if (!aka_channel_get(iCh)) return -18509703;

	if (ix == iCh) tMsgCtl.hyp_channel->hyp_cha[iHypCh] = tMsgCtl.hyp_channel->cha[ix];
	else {
		while (ix) {
			ix0 = ix;
			ix = tMsgCtl.hyp_channel->cha[ix];
			if (ix == iCh) break;
		}
	}
	if (!ix) return -18509704;
	else tMsgCtl.hyp_channel->cha[ix0] = tMsgCtl.hyp_channel->cha[iCh];
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_hyp_channel_close(iHypCh)
int iHypCh;
{
	int ix;

	if (iHypCh<=0 || iHypCh>AKA_CHANNEL_MAX) return -18509801;
	if ((ix=tMsgCtl.hyp_channel->hyp_cha[iHypCh]) < 0) return -18509802;

	while (ix) {
		aka_channel_close(ix);
		ix = tMsgCtl.hyp_channel->cha[ix];
	}
	return 0;
}
