#!/bin/busybox sh

[ -x /usr/local/Kobo/pickel ] || exit
for p in . /etc/fakesh/tools "$HOME/bin" /root/bin \
         /usr/bin /bin /usr/local/bin '' ; do
  [ -z "$p" ] && exit 1
  shot=$p/screenShot-jpeg.sh
  [ -x $shot ] && break
done
shot="$(readlink -f "$shot")"
cd /

tdir=/mnt/onboard/etc_images
[ -d $tdir ] && exit
mkdir $tdir
for raw in /etc/images/*.raw.gz ; do
  [ -f "$raw" ] || continue
  [ -L "$raw" ] && continue
  b="${raw##*/}"; b="${b%.raw.gz}"
  case "$b" in
  kraken-*) fbparams='w=1024;h=758;' ;;
  *) fbparams='w=800;h=600;' ;;
  esac
  "$shot" conv fmt:ppm "$tdir/$b" fb:$fbparams wait < "$raw"
done >/dev/null 2>&1 </dev/null &

exit 0
