/* psbb.h
 *
 * Declaration of .psbb request handling API.
 *
 * Written by Keith Marshall <keith@users.osdn.me>
 * Copyright (C) 2017, Free Software Foundation, Inc.
 *
 * This file is part of groff.
 *
 * groff is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * groff is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef YY_PSBB_H_INCLUDED
#define YY_PSBB_H_INCLUDED

#include <stdio.h>

#define yylval  psbb_lval
#define yyparse psbb_parse
#define yyerror psbb_error

#define psbb_error errprintf

#undef EXTERN_C
#ifdef __cplusplus
# define EXTERN_C  extern "C"
#else
# define EXTERN_C
#endif

EXTERN_C void  psbb_get_bounding_box (const char *);
EXTERN_C FILE *psbb_open_file_for_parse (const char *);
EXTERN_C void  psbb_assign_registers (int, int, int, int);
EXTERN_C void  psbb_error (const char *, ...);

EXTERN_C void  psbb_lookup (int, int);
EXTERN_C void  psbb_locate (int, int);
EXTERN_C int   psbb_chkref (int, int);

EXTERN_C void  psbb_walk (void);

#endif /* YY_PSBB_H_INCLUDED: end of file */
