#!/bin/busybox sh
# i am a superuer, no farther check
hk=/bin/rm  # command to wrap (hook)

################
[ -L "$hk" -a /bin/busybox = "$(readlink -f "$hk")" ] || exit 1
hk="${hk#/*}"

if [ ! -f versions.lst ] ; then 
  ## example of versions.lst
  cat >versions.lst <<- '  EOVLST'
	name: fakesh
	firmware_version,hardware comment
	2.1.*,*300  first kobo Touch
	2.2.0,*
	 2.2.1,*3[1-3]? except for first kobo Touch
	2.3.1,*300
	  2.3.2,*3[34]0 buggy
	# *,* all versions
	script:dst: 
	script:pre: 
	script:exe: 
  EOVLST
  ### end of example
  echo "An example of versions.lst was generated" 1>&2
  exit 1
fi

dos2unix versions.lst
wd="$(mktemp -p . -d zXXXXXX)"
cd $wd
if [ ! -f ../KoboRoot.tgz ] ; then
  mkdir -p -m 1777 var/tmp
  date -Iseconds > var/tmp/addVerCheck-SUCC
  tar cfz ../KoboRoot.tgz ./var/tmp ./var/tmp/addVerCheck-SUCC
  rm -rf var
fi

name=addvercheck  # default name of this package
while read tag val ; do
  case "$tag" in
  name:) name="$val" ;;
  script:dst:) scr_dst="$val" ;; # abs path of script
  script:pre:) scr_pre="$val" ;; # cmds output to stdout to $scr_dst, 
  script:exe:) scr_exe="$val" ;; # exe command line
  esac
done < ../versions.lst

# scr_dst : abs path of script
[ -z "$scr_dst" ] && scr_dst="/mnt/onboard/_root_${wd##*/z}.tar"
scr_dst="${scr_dst#/}"
mkdir -p "${hk%/*}" "${scr_dst%/*}"

# scr_exe : exe command line
[ -z "$scr_exe" ] && scr_exe="tar xf /$scr_dst -C /"

# scr_pre : cmdline of preparing $scr_dst, output to stdout
[ -z "$scr_pre" ] && scr_pre="zcat ../KoboRoot.tgz; rm -f ../KoboRoot.tgz;"
eval "$scr_pre" > "$scr_dst"
chmod +x "$scr_dst"

bbx=busybox
case ${hk%/*} in
bin) lnk=$bbx ;;
*/*) lnk=../../bin/$bbx ;;
*) lnk=../bin/$bbx ;;
esac

upgrd=mnt/onboard/.kobo/upgrade
[ -d $upgrd ] || mkdir -p $upgrd
md5=mnt/onboard/.kobo/manifest.md5sum
echo 'fakesh ^o^;' > $md5

cat > $hk << EOH
#!/bin/$bbx sh
# i may not a superuer, check
[ \$(id -u) -eq 0 ] || exec $bbx "\${0##*/}" "\$@"
# dont upgrade u-boot or kernel
[ -e /$upgrd ] && $bbx rm -rf /$upgrd /$md5
if [ -x '/$scr_dst' ] ; then
  $bbx ln -sf '$lnk' '/$hk'
  read fw < /mnt/onboard/.kobo/version
  hw=\${fw##*,}; fw="\${fw#*,}"; fw="\${fw#*,}"
  case "\${fw%%,*},\$hw" in
EOH

printf '\nname: %s\nVersions:\n' "$name" 1>&2
d='  '  # delimiter
while read vv cmt ; do
  case "$vv" in
  *,*,*) continue ;;
  [0-9]*,* | '['[0-9]*,* | '*'*,* ) ;;
  *) continue ;;
  esac
  printf '  %s\t\t%s\n' "$vv" "$cmt" 1>&2
  printf "${d}%s" "$vv"
  d=' |\\\n  '
done < ../versions.lst >> $hk

cat >> $hk << EOT
 )
    $scr_exe
  ;;
  *)
    touch "/mnt/onboard/Error_install_$name"
  ;;
  esac >/dev/null 2>&1 </dev/null
  $bbx "\${0##*/}" "\$@"  # do the given command
  exitN=\$?
  # here may recursively call "rm", when
  # "$scr_exe" replaced "rm" !
  rm -f '/$scr_dst'
  $bbx sync; $bbx sync; $bbx sync
  # reboot # (^^; # will be done by the caller
  exit \$exitN
else
  exec $bbx "\${0##*/}" "\$@"
fi
EOT
chmod +x $hk

tar cfz ../KoboRoot.tgz ./"$hk" ./"$scr_dst" ./$upgrd ./$md5

printf '\n## INSIDE NEW KoboRoot.tgz\n'
tar tfvz ../KoboRoot.tgz
printf \\n
echo "## INSTALLER(/$hk):"
busybox sh -nv ./"$hk" && printf '##NO-SYNTAX-ERROR\n'
printf \\n

cd ..
rm -rf $wd

exit

