/*
 * Decompiled with CFR 0.152.
 */
package countstatement.handlers;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WhileStatement;

public class StatementVisitor
extends ASTVisitor {
    final String LINE_END_STR = ",";
    final int PUBLIC_TYPE = 1;
    final int PRIVATE_TYPE = 2;
    final int CLS_DATA = 0;
    final int CLASS_DEF = 1;
    final int METHOD_DEF = 2;
    private long classDefCnt = 0L;
    private long publicClass = 0L;
    private long privatClass = 0L;
    private long methodCnt = 0L;
    private long publicMethodCnt = 0L;
    private long privateMethodCnt = 0L;
    private long ifCnt = 0L;
    private long switchCnt = 0L;
    private long forCnt = 0L;
    private long whileCnt = 0L;
    private long doCnt = 0L;
    private long ifNestCnt = 0L;
    private long loopNestCnt = 0L;
    private long tempIfNestCnt = 0L;
    private long tempLoopNestCnt = 0L;
    private int modifyFlag = 0;

    public String toString() {
        return "class=" + this.classDefCnt + "," + "method=" + this.methodCnt + "," + "if=" + this.ifCnt + "," + "for=" + this.forCnt + "," + "while=" + this.whileCnt + "," + "do=" + this.doCnt + "," + "switch case=" + this.switchCnt + "," + "if nest=" + this.ifNestCnt + "," + "loop nest=" + this.loopNestCnt + "," + "public Class=" + this.publicClass + "," + "private Class=" + this.privatClass + "," + "public method=" + this.publicMethodCnt + "," + "private method=" + this.privateMethodCnt;
    }

    public boolean visit(IfStatement node) {
        ++this.ifCnt;
        node.getElseStatement();
        node.getThenStatement();
        node.getExpression();
        return true;
    }

    public boolean visit(ForStatement node) {
        ++this.forCnt;
        return true;
    }

    public boolean visit(EnhancedForStatement node) {
        ++this.forCnt;
        return true;
    }

    public boolean visit(WhileStatement node) {
        ++this.whileCnt;
        return true;
    }

    public boolean visit(DoStatement node) {
        ++this.doCnt;
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ++this.classDefCnt;
        this.modifyFlag = 1;
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        ++this.methodCnt;
        this.modifyFlag = 2;
        return true;
    }

    public boolean visit(Modifier node) {
        if (this.modifyFlag == 1) {
            if (node.isPublic()) {
                ++this.publicClass;
            } else if (node.isPrivate()) {
                ++this.privatClass;
            }
            this.modifyFlag = 0;
        } else if (this.modifyFlag == 2) {
            if (node.isPublic()) {
                ++this.publicMethodCnt;
            } else if (node.isPrivate()) {
                ++this.privateMethodCnt;
            }
            this.modifyFlag = 0;
        }
        return true;
    }

    public boolean visit(SwitchStatement node) {
        ++this.tempIfNestCnt;
        return true;
    }

    public void endVisit(SwitchStatement node) {
        if (this.tempIfNestCnt > this.ifNestCnt) {
            this.ifNestCnt = this.tempIfNestCnt;
        }
        --this.tempIfNestCnt;
    }

    public boolean visit(SwitchCase node) {
        ++this.switchCnt;
        return true;
    }

    public boolean visit(Block node) {
        if (node.getParent() instanceof IfStatement) {
            ++this.tempIfNestCnt;
        } else if (node.getParent() instanceof ForStatement || node.getParent() instanceof EnhancedForStatement || node.getParent() instanceof WhileStatement || node.getParent() instanceof DoStatement) {
            ++this.tempLoopNestCnt;
        }
        return true;
    }

    public void endVisit(Block node) {
        if (node.getParent() instanceof IfStatement) {
            if (this.tempIfNestCnt > this.ifNestCnt) {
                this.ifNestCnt = this.tempIfNestCnt;
            }
            --this.tempIfNestCnt;
        } else if (node.getParent() instanceof ForStatement || node.getParent() instanceof EnhancedForStatement || node.getParent() instanceof WhileStatement || node.getParent() instanceof DoStatement) {
            if (this.tempLoopNestCnt > this.loopNestCnt) {
                this.loopNestCnt = this.tempLoopNestCnt;
            }
            --this.tempLoopNestCnt;
        }
    }
}

