/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.android_r.drawable;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Checkable;
import android.widget.FrameLayout;
import org.routine_work.android_r.R;

/**
 *
 * @author sawai
 */
public class ColorSampleView extends FrameLayout implements Checkable
{

	private Checkable checkable;

	public ColorSampleView(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs, defStyle);
		initViews();
	}

	public ColorSampleView(Context context, AttributeSet attrs)
	{
		super(context, attrs);
		initViews();
	}

	public ColorSampleView(Context context)
	{
		super(context);
		initViews();
	}

	private void initViews()
	{
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View rootView = inflater.inflate(R.layout.color_sample_view, this);
		View colorNameView = rootView.findViewById(R.id.color_name_textview);
		if (colorNameView instanceof Checkable)
		{
			checkable = (Checkable) colorNameView;
		}
	}

	public void toggle()
	{
		checkable.toggle();
	}

	public void setChecked(boolean arg0)
	{
		checkable.setChecked(arg0);
	}

	public boolean isChecked()
	{
		return checkable.isChecked();
	}
}
