/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.routine_work.android_r.drawable;

import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.DialogInterface;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import org.routine_work.android_r.R;
import org.routine_work.android_r.utils.Log;

/**
 *
 * @author sawai
 */
public class BackgroundColorDialogPreference extends DialogPreference
{

	private static final String LOG_TAG = "android.R";
	private BackgroundColorListAdapterFactory backgroundColorListAdapterFactory;
	private String bgColorDefaultValue;
	private int checkedColorIndex = -1;

	public BackgroundColorDialogPreference(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs, defStyle);
	}

	public BackgroundColorDialogPreference(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	@Override
	protected View onCreateView(ViewGroup parent)
	{
		View view = super.onCreateView(parent);

		backgroundColorListAdapterFactory = new BackgroundColorListAdapterFactory(getContext());

		bgColorDefaultValue = getContext().getString(R.string.drawable_background_color_default_value);

		updateSummary();

		return view;
	}

	@Override
	protected void onPrepareDialogBuilder(Builder builder)
	{
		Log.v(LOG_TAG, "Hello");

		super.onPrepareDialogBuilder(builder);
		ListAdapter listAdapter = backgroundColorListAdapterFactory.createBackgroundColorListAdapter();

		String colorValue = getPersistedString(bgColorDefaultValue);
		Log.d(LOG_TAG, "colorValue => " + colorValue);
		int checkedIndex = backgroundColorListAdapterFactory.getIndexByColorValue(colorValue);
		Log.d(LOG_TAG, "checkedIndex => " + checkedIndex);
		String colorName = backgroundColorListAdapterFactory.getColorNameAt(checkedIndex);
		Log.d(LOG_TAG, "colorName => " + colorName);
		setSummary(colorName);

		builder.setSingleChoiceItems(listAdapter, checkedIndex, new DialogInterface.OnClickListener()
		{

			public void onClick(DialogInterface dialog, int index)
			{
				Log.v(LOG_TAG, "Hello");

				String[] values = backgroundColorListAdapterFactory.getColorValues();
				if (index >= 0 && index < values.length)
				{
					Log.d(LOG_TAG, "checked color index => " + index);
					checkedColorIndex = index;
				}

				Log.v(LOG_TAG, "Bye");
			}
		});

		Log.v(LOG_TAG, "Bye");
	}

	@Override
	protected void onDialogClosed(boolean positiveResult)
	{
		Log.v(LOG_TAG, "Hello");

		Log.d(LOG_TAG, "positiveResult => " + positiveResult);
		if (positiveResult)
		{
			String colorValue = backgroundColorListAdapterFactory.getColorValueAt(checkedColorIndex);
			Log.d(LOG_TAG, "checked color value => " + colorValue);
			// save to preferences
			if (callChangeListener(colorValue))
			{
				Log.d(LOG_TAG, "callChangeListener() is true.");
				persistString(colorValue);
				updateSummary();
			}
		}
		super.onDialogClosed(positiveResult);

		Log.v(LOG_TAG, "Bye");
	}

	private void updateSummary()
	{
		String bgColorValue = getPersistedString(bgColorDefaultValue);
		int index = backgroundColorListAdapterFactory.getIndexByColorValue(bgColorValue);
		String bgColorName = backgroundColorListAdapterFactory.getColorNameAt(index);
		Log.d(LOG_TAG, "bgColorName => " + bgColorName);
		setSummary(bgColorName);
	}
}
