/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import saccubus.conv.Chat;
import saccubus.conv.CommandReplace;
import saccubus.conv.Packet;

public class NicoXMLReader
extends DefaultHandler {
    private final Packet packet;
    private Chat item;
    private boolean item_kicked;
    private final Pattern NG_Word;
    private final Pattern NG_ID;
    private final CommandReplace NG_Cmd;
    private boolean item_fork;
    private final int ng_Score;
    private int countNG_Score = 0;
    private int countNG_Word = 0;
    private int countNG_ID = 0;

    public NicoXMLReader(Packet packet, Pattern ngIdPat, Pattern ngWordPat, CommandReplace cmd, int scoreLimit) {
        this.packet = packet;
        this.NG_Word = ngWordPat;
        this.NG_ID = ngIdPat;
        this.NG_Cmd = cmd;
        this.ng_Score = scoreLimit;
    }

    public static final Pattern makePattern(String word) throws PatternSyntaxException {
        if (word == null || word.length() <= 0) {
            return null;
        }
        String[] tmp = word.split(" ");
        String[] tmp2 = new String[tmp.length];
        int tmp_index = 0;
        int index = 0;
        while (index < tmp.length && tmp_index < tmp.length) {
            StringBuffer str;
            String tmpw = tmp[tmp_index];
            if (tmpw.startsWith("/") && !tmpw.endsWith("/")) {
                str = new StringBuffer(tmpw);
                ++tmp_index;
                while (tmp_index < tmp.length) {
                    str.append(" " + tmp[tmp_index]);
                    if (tmp[tmp_index].endsWith("/")) {
                        ++tmp_index;
                        break;
                    }
                    ++tmp_index;
                }
                tmp2[index] = str.substring(0);
            } else if (tmpw.startsWith("\"") && !tmpw.endsWith("\"")) {
                str = new StringBuffer(tmpw);
                ++tmp_index;
                while (tmp_index < tmp.length) {
                    str.append(" " + tmp[tmp_index]);
                    if (tmp[tmp_index].endsWith("\"")) {
                        ++tmp_index;
                        break;
                    }
                    ++tmp_index;
                }
                tmp2[index] = str.substring(0);
            } else {
                tmp2[index] = tmpw;
                ++tmp_index;
            }
            ++index;
        }
        String[] elt = new String[index];
        int i = 0;
        while (i < index) {
            elt[i] = tmp2[i];
            ++i;
        }
        StringBuffer regb = new StringBuffer();
        int i2 = 0;
        while (i2 < elt.length) {
            String e = elt[i2];
            System.out.println(e);
            if (i2 > 0) {
                regb.append("|");
            }
            if (e.length() > 1 && e.startsWith("/") && e.endsWith("/")) {
                regb.append("(" + e.substring(1, e.length() - 1) + ")");
            } else if (e.length() > 1 && e.startsWith("\"") && e.endsWith("\"")) {
                regb.append("(" + Pattern.quote(e.substring(1, e.length() - 1)) + ")");
            } else {
                regb.append("(.*(" + Pattern.quote(e) + ")+.*)");
            }
            ++i2;
        }
        String reg = regb.substring(0);
        System.out.println("reg:" + reg);
        Pattern pat = Pattern.compile(reg);
        return pat;
    }

    private static final boolean match(Pattern pat, String word) {
        if (word == null || word.length() <= 0 || pat == null) {
            return false;
        }
        return pat.matcher(word).matches();
    }

    @Override
    public void startDocument() {
        System.out.println("Start converting to intermediate file.");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.toLowerCase().equals("chat")) {
            String mail;
            this.item = new Chat();
            this.item_kicked = false;
            this.item_fork = false;
            String deleted = attributes.getValue("deleted");
            if ("1".equals(deleted) || "2".equals(deleted)) {
                this.item_kicked = true;
                return;
            }
            if (this.ng_Score > Integer.MIN_VALUE) {
                String score_str = attributes.getValue("score");
                int score = 0;
                if (score_str != null) {
                    try {
                        score = Integer.parseInt(score_str);
                    }
                    catch (NumberFormatException e) {
                        score = 0;
                    }
                }
                if (score <= this.ng_Score) {
                    this.item_kicked = true;
                    ++this.countNG_Score;
                    return;
                }
            }
            if ((mail = attributes.getValue("mail")) == null) {
                mail = "186";
            } else if (!mail.contains("184")) {
                mail = String.valueOf(mail) + " 186";
            }
            if (NicoXMLReader.match(this.NG_Word, mail)) {
                this.item_kicked = true;
                ++this.countNG_Word;
                return;
            }
            mail = this.NG_Cmd.replace(mail);
            this.item.setMail(mail);
            this.item.setNo(attributes.getValue("no"));
            String user_id = attributes.getValue("user_id");
            if (NicoXMLReader.match(this.NG_ID, user_id)) {
                this.item_kicked = true;
                ++this.countNG_ID;
                return;
            }
            String forkval = attributes.getValue("fork");
            if (forkval != null && forkval.equals("1")) {
                this.item_fork = true;
            }
            this.item.setVpos(attributes.getValue("vpos"));
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        if (this.item != null) {
            if (this.item_fork && length > 0 && ch[offset] == '/') {
                this.item_kicked = true;
                return;
            }
            int i = offset;
            while (i < offset + length) {
                if (!Character.isDefined(ch[i])) {
                    ch[i] = 63;
                }
                ++i;
            }
            String com = new String(ch, offset, length);
            boolean script = false;
            if ((com.startsWith("@") || com.startsWith("\uff20")) && this.item_fork) {
                String nicos = com.substring(1);
                if (nicos.startsWith("\u9006")) {
                    this.item.addCmd(16);
                    script = true;
                } else if (nicos.startsWith("\u30c7\u30d5\u30a9\u30eb\u30c8")) {
                    this.item.addCmd(16);
                    script = true;
                }
            }
            if (!script && NicoXMLReader.match(this.NG_Word, com)) {
                this.item_kicked = true;
                ++this.countNG_Word;
                return;
            }
            this.item.setComment(com);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.toLowerCase().equals("chat")) {
            if (!this.item_kicked) {
                this.packet.addChat(this.item);
            }
            this.item = null;
        }
    }

    @Override
    public void endDocument() {
        System.out.println("Converting finished. " + this.packet.size() + " items.");
        System.out.println("Deleted NG Word:" + this.countNG_Word + " ID:" + this.countNG_ID + " Score:" + this.countNG_Score);
    }
}

