/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import saccubus.conv.ChatArray;
import saccubus.conv.ChatSave;

public class MultiXMLHandler
extends DefaultHandler {
    private final ChatArray chatArray;
    private ChatSave chat;
    private boolean chat_kicked;

    public MultiXMLHandler(ChatArray chatArray) {
        this.chatArray = chatArray;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.toLowerCase().equals("thread")) {
            String thread = attributes.getValue("thread");
            this.chatArray.setThread(thread);
            return;
        }
        if (qName.toLowerCase().equals("chat")) {
            this.chat = new ChatSave();
            this.chat_kicked = false;
            String deleted = attributes.getValue("deleted");
            if (deleted != null && deleted.equals("1")) {
                this.chat_kicked = true;
                return;
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < attributes.getLength()) {
                sb.append(attributes.getQName(i));
                sb.append("=\"");
                sb.append(ChatSave.safeReference(attributes.getValue(i)));
                sb.append("\" ");
                ++i;
            }
            this.chat.setAttributeString(sb.substring(0));
            this.chat.setNo(attributes.getValue("no"));
            return;
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        if (this.chat != null) {
            this.chat.setComment(new String(ch, offset, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase("chat")) {
            if (!this.chat_kicked) {
                this.chatArray.addChat(this.chat);
            }
            this.chat = null;
        }
    }

    @Override
    public void endDocument() {
        System.out.print(".");
    }
}

