/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_UTIL_H
#define CD_UTIL_H

#include <stdio.h>
#include <gtk/gtk.h>

typedef struct _RectCorner RectCorner;
typedef double Matrix[3][2];
struct _RectCorner
{
  GdkPoint p1;
  GdkPoint p2;
  GdkPoint p3;
  GdkPoint p4;
};

void cd_util_init();
gboolean cd_util_select_rect(GdkRectangle *rect, int x, int y);
gboolean cd_util_select_line(GdkPoint *start, GdkPoint *end, int x, int y);

double cd_util_get_theta(double x1, double x2, double y1, double y2);
void cd_util_get_rect_corner(GdkRectangle *rect, RectCorner *cn);

void cd_util_rotate(Matrix matrix, double theta);

void cd_util_save_header(FILE *fp);
int cd_util_load_header(FILE *fp);

void cd_util_message(gchar *str);

#endif
