/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_CANVAS_H
#define CD_CANVAS_H

#include <stdio.h>
#include <gtk/gtk.h>

#include "cd_define.h"

typedef struct _CdToolbarItem CdToolbarItem;

struct _CdToolbarItem
{
  char *tooltips;
  char **xpm;
  void *func;
};

void cd_canvas_toolbar_new(GtkWidget *window, GtkWidget *vbox);
void cd_canvas_new(GtkWidget *window, GtkWidget *vbox);
void cd_canvas_update_all();
void cd_canvas_white();

void cd_canvas_mode_select();
void cd_canvas_mode_umlclass();
void cd_canvas_mode_association();
void cd_canvas_mode_association2();
void cd_canvas_mode_aggregation();
void cd_canvas_mode_aggregation2();
void cd_canvas_mode_generalization();
void cd_canvas_mode_pgclass();
CdToolType cd_canvas_mode_get_tool_type();

void cd_canvas_set_size(int width, int height);
void cd_canvas_get_size(int *width, int *height);
void cd_canvas_size_update();

void cd_canvas_save(FILE *fp);
void cd_canvas_load(FILE *fp);

#endif
