#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: createdb.sh,v 1.27 2004/10/07 16:00:03 taru Exp $

#  createdb.sh [restore [<format>]]

set -e

eval `ultrapossum-config init` 2> /dev/null

if test -d "$CHROOTDIRECTORY$DIRECTORY"; then
  echo "W: $CHROOTDIRECTORY$DIRECTORY already exist" 1>&2
  exit 0
fi

if test "x$DBWORKDIR" != "x"; then
  echo -n "Preparing database working directory: $DBWORKDIR... " 1>&2
  DBWORKDIR="$DBWORKDIR/ultrapossum-createdb.$$"
  install -d $DBWORKDIR
  ln -s $DBWORKDIR $DIRECTORY
  echo "done" 1>&2
else
  if test "x$CHROOTDIRECTORY" != "x"; then
    install -d $DBDIRECTORY
    ln -s $CHROOTDIRECTORY$DIRECTORY $DIRECTORY
  fi
  install -d $CHROOTDIRECTORY$DIRECTORY > /dev/null
fi

create_environ

if test "x$HOST" != "x$MASTER" && include "$HOST" "$SYNCBACKUPS"; then
  exit 0
fi

format=ldif
if test "x$2" != "x"; then
  format=$2
fi

term() {
  /bin/rm -f $tmp
  if test "x$DBWORKDIR" != "x"; then
    /bin/rm -rf $DBWORKDIR
    if ! /bin/ls -L "$DIRECTORY" > /dev/null 2> /dev/null; then
      /bin/rm $DIRECTORY
    fi
  fi
  eval `ultrapossum-config term`
}

# find_latest <format>
find_latest()
{
 latest=`/bin/ls $BACKUPDIR/$SUFFIX-*$1.gz 2> /dev/null | sort -r | head -1`
 if ! test -f "$latest"; then
   echo "E: can't find any backup" 1>&2
   /bin/rm -rf $DIRECTORY
   exit 1
 fi
 echo $latest
}

case "x$format" in
  xldif)

tmp=`tempfile`
chmod 600 $tmp
trap "eval 'term'" 0

if test "x$1" = "xrestore"; then
 ldiffile=$tmp
 latest=`find_latest "ldif"`
 echo -n "Preparing resotre environment for `basename $latest`... " 1>&2
 zcat $latest > $tmp
 echo "done" 1>&2
elif test "x$HOST" = "x$MASTER"; then
 ldiffile=$tmp
 cat $ULTRAPOSSUMLDIF > $tmp
 echo "" >> $tmp
 extraldifs="$APPSLDIF"
 # FIXME: handle grep incompatibility
 if test -f "$INITLDIF" && head -n 100 "$INITLDIF" | egrep "^dn: " > /dev/null; then
   extraldifs="$extraldifs $INITLDIF"
 fi
 extraldifs="$extraldifs `find $INITLDIFDIR -type f | sort | tr '\n' ' '`"
else
 ldiffile=$DIRECTORY/$HOST.ldif
 if ! test -s $ldiffile; then
   if ! $SHAREDIR/sshman cmd "$MASTER" server/fetchldif > $ldiffile; then
     echo "E: fail to fetch the initial directory from $MASTER" 1>&2
     /bin/rm -rf $DIRECTORY
     exit 1
   fi
 fi
fi

if test "x$HOST" = "x$MASTER" && include "$HOST" "$SYNCBACKUPS"; then
  SLAPADD_EXTRA_ARGS="$SLAPADD_EXTRA_ARGS -p -w"
fi

echo -n "Creating Initial Directory in $CHROOTDIRECTORY$DIRECTORY... " 1>&2
if $SLAPADD -b $SUFFIX -f $SLAPDCONF $SLAPADD_EXTRA_ARGS < $ldiffile; then
  echo "done" 1>&2
else
  /bin/mv $DIRECTORY $DIRECTORY-`date +%Y%m%d%H%M%S`
  echo "failed" 1>&2
  exit 1
fi

for l in $extraldifs
do
  if test "x$HOST" = "x$MASTER" && include "$HOST" "$SYNCBACKUPS"; then
    sleep 1 # ad-hoc? slapadd must be run in 1 seconds for contextCSN
  fi
  echo -n "Setting up `basename $l .ldif` entries... " 1>&2
  if $SLAPADD -b $SUFFIX -f $SLAPDCONF $SLAPADD_EXTRA_ARGS < $l; then
    echo "done" 1>&2
  else
    /bin/mv $DIRECTORY $DIRECTORY-`date +%Y%m%d%H%M%S`
    echo "failed" 1>&2
    exit 1
  fi
done

 ;;
 xtar)
   latest=`find_latest "tar"`
   (cd $DIRECTORY; tar zxf $latest )
 ;;
 x*)
   echo "unknown format: $format" 1>&2
   exit 1
 ;;
esac

if test "x$DBWORKDIR" != "x"; then
  echo -n "Adjusting database... " 1>&2
  /bin/rm $DIRECTORY
  install -d $CHROOTDIRECTORY`dirname $DIRECTORY`
  /bin/cp -rp $DBWORKDIR $CHROOTDIRECTORY$DIRECTORY
  if test "x$CHROOTDIRECTORY" != "x"; then
    /bin/ln -s $CHROOTDIRECTORY$DIRECTORY $DIRECTORY
  fi
  echo "done" 1>&2
fi
