#include <QtGui>

class Player;
class Video;
class Playlist;
class QAction;

#define MAX_RECENT_FILES 10

class MainWindow: public QMainWindow
{
  Q_OBJECT

public:
  MainWindow();
  ~MainWindow();

private slots:
  void OpenFile();
  void OpenUrl();
  void OpenPlaylistItem(const QString);
  void OpenRecentFile();
  void ClearRecentFiles();
  void CopyCurrentUrl();
  void DownloadCurrentVideo();
  void About();
  void OpenHomePage();
  void PlayRemoteVideo();
  void StopRemoteVideo();
  void PlayNext();
  void TogglePlaylist();
  void ToggleSeekBar();
#if defined(Q_OS_WIN)
  void TopMost();
#endif

protected:
  void closeEvent(QCloseEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
  void dropEvent(QDropEvent *event);
  void PlayUrl(const QUrl& url);

private:
  void CreateMenus();
  void SetTitle(const QString& title);
  void UpdateRecentFileActions();
  void SetCurrentFile(const QString& file_name);
  Player *player;
  Video *video;
  Playlist *playlist;
  bool is_playlist;
  QAction *recent_actions[MAX_RECENT_FILES];
};
