#!/bin/sh

VERSION=0.0.3
SVNREPO=http://svn.sourceforge.jp/svnroot/tubebrowser/tags/$VERSION

if [ "$1" = "-win32" ]; then
  # Make a binary package for win32.
  mkdir -p tmp && cd tmp && \
  svn export $SVNREPO tubebrowser-$VERSION && \
  cd tubebrowser-$VERSION && \
  cp -a ../../vendor/ vendor && \
  qmake -win32 tubebrowser.pro && mingw32-make && lrelease tubebrowser.pro && \
  nkf -c README > README.txt && nkf -c CHANGES > CHANGES.txt && \
  nkf -c COPYING > COPYING.txt && \
  mkdir -p ../TubeBrowser && \
  mv release/tubebrowser.exe ../TubeBrowser && \
  mv README.txt CHANGES.txt COPYING.txt ../TubeBrowser && \
  mkdir -p ../TubeBrowser/translations && \
  mv translations/*.qm ../TubeBrowser/translations && \
  mv vendor/win32/lib/* ../TubeBrowser && \
  cd .. && zip -r tubebrowser-$VERSION-win32.zip TubeBrowser && \
  cd .. && mv tmp/tubebrowser-$VERSION-win32.zip . && \
  rm -rf tmp/

else
  # Make a source package.
  mkdir -p tmp && cd tmp && \
  svn export $SVNREPO tubebrowser-$VERSION && \
  tar -czv --owner 0 --group 0 -f tubebrowser-$VERSION.tar.gz tubebrowser-$VERSION && \
  cd .. && mv tmp/tubebrowser-$VERSION.tar.gz . && \
  rm -rf tmp/
fi
