#include <QtGui/QApplication>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
  QApplication app(argc, argv);
  app.setApplicationName("TubeBrowser");

  QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
  QString locale = QLocale::system().name();

  QTranslator translator;
  const QString app_dir = QCoreApplication::applicationDirPath();
  const QString data_dir = app_dir + "/../share/tubebrowser";

  if (QFile::exists(app_dir + "/translations")) {
    translator.load(app_dir + "/translations/tubebrowser_" + locale);
  } else {
    translator.load(data_dir + "/translations/tubebrowser_" + locale);
  }
  app.installTranslator(&translator);

  MainWindow *window = new MainWindow;
  window->show();
  return app.exec();
}
