/*
 * StringConverter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import java.util.Collection;
import java.util.List;
import java.util.ArrayList;

/**
 * ϊ郁\bhW߂NXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:52 $
 */
public class StringConverter
{
  /**
   * ftHgRXgN^B
   */
  protected StringConverter()
  {}

  /**
   * t@Cǂݍ񂾕Ȃǂʏ̕ɕϊB
   * <br>
   * ̕񂩂GXP[vAgsB
   * AAGXP[v̂ɂ󔒕̓g̑ΏۂƂȂB
   * <br>
   * w肳ꂽꕶ̑OɃGXP[v݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * <br>
   * ꕶȊȎ̕OɃGXP[v݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws EndWithEscapeCharException GXP[vŏIꍇB
   * @throws StringConvertException ̕ϊȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   * @deprecated <code>char</code>ϐ̎gp邽ߔp~B{@link
   *   #fromReadString(String,String,Collection)}gpĉB
   */
  @Deprecated
  public static String fromReadString(
    String readStr, char escape, CharSequence specChars
  ) throws EndWithEscapeCharException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int len = readStr.length();
    int nSpec = specChars.length();

    StringBuilder buf = new StringBuilder(len);

    int i = 0;
    for ( ; i<len; i++) {
      char ch = readStr.charAt(i);
      if (!Character.isWhitespace(ch)) {
        break;
      }
    }

    int beginSpace = len;
    boolean isEsc = false;
    for ( ; i<len; i++) {
      char ch = readStr.charAt(i);
      if (isEsc) {
        buf.append(ch);
        beginSpace = buf.length();
        isEsc = false;
      }
      else if (ch == escape) {
        beginSpace = buf.length();
        isEsc = true;
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            throw new StringConvertException(i, buf,
              "A special character is not escaped.");
          }
        }
        buf.append(ch);
        if (! Character.isWhitespace(ch)) {
          beginSpace = buf.length();
        }
      }
    }

    String convStr = buf.substring(0, beginSpace);
    if (isEsc) {
      throw new EndWithEscapeCharException(len - 1, convStr, null);
    }

    return convStr;
  }

  /**
   * t@Cǂݍ񂾊ʂň͂܂ꂽȂǂʏ̕ɕϊB
   * <br>
   * ̕񂩂痼[̊ʂAGXP[vB
   * <br>
   * [ɊʂȂꍇ͗OX[B
   * <br>
   * w肳ꂽꕶ̑OɃGXP[v݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * ȂAꕶɂ͊ʂIɊ܂܂悤ɂĂB
   * <br>
   * ꕶȊȎ̕OɃGXP[v݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escape GXP[vB
   * @param  openPar JʕB
   * @param  closePar ʕB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws EndWithEscapeCharException GXP[vŏIꍇB
   * @throws StringConvertException ̕ϊȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   * @deprecated <code>char</code>ϐ̎gp邽ߔp~B{@link
   *   #fromReadString(String,String,String,String,Collection)}gp
   *   B
   */
  @Deprecated
  public static String fromReadString(String readStr,
    char openPar, char closePar, char escape, CharSequence specChars
  ) throws EndWithEscapeCharException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (specChars != null) : "@param:specChars is null.";

    if (!readStr.startsWith(String.valueOf(openPar))) {
      throw new StringConvertException(0, "",
        "The specified string does not start with the parenthesis.");
    }

    int nSpec = specChars.length();

    StringBuilder buf = new StringBuilder();

    boolean isEsc = false;
    for (int i=1; i<readStr.length(); i++) {
      char ch = readStr.charAt(i);
      if (isEsc) {
        buf.append(ch);
        isEsc = false;
      }
      else if (ch == escape) {
        isEsc = true;
      }
      else if (ch == closePar) {
        if (i == readStr.length() - 1) {
          return buf.toString();
        }
        throw new StringConvertException(i, buf.toString(),
          "A special character is not escaped.");
      }
      else if (ch == openPar) {
        throw new StringConvertException(i, buf.toString(),
          "A special character is not escaped.");
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            throw new StringConvertException(i, buf.toString(),
              "A special character is not escaped.");
          }
        }
        buf.append(ch);
      }
    }

    if (readStr.charAt(readStr.length() - 1) != closePar) {
      throw new EndWithEscapeCharException(readStr.length(), buf);
    }

    if (escape == closePar) {
      return buf.toString();
    }

    throw new EndWithEscapeCharException(readStr.length() - 1,
      buf.substring(0, buf.length() - 1), null);
  }

  /**
   * ʏ̕t@Co͗p̕ɕϊB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * <br>
   * ̕񂪋󔒂ŊJnĂꍇ́Aŏ̋󔒕̑OɃGXP[v
   * }B
   * ̕񂪋󔒂ŏIĂꍇ́AŌ̋󔒕̑OɃGXP[v
   * }B
   *
   * @param  str B
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   * @deprecated <code>char</code>ϐ̎gp邽ߔp~B{@link
   *   #toWriteString(String,String,Collection)}gpĉB
   */
  @Deprecated
  public static String toWriteString(
    String str, char escape, CharSequence specChars)
  {
    assert (str != null) : "@param:str is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int nSpec = specChars.length();
    int len = str.length();
    if (len == 0) {
      return "";
    }
    if (Character.isWhitespace(str.charAt(len-1))) {
      len --;
    }

    int i = 0;
    StringBuilder buf = new StringBuilder(len);
    if (Character.isWhitespace(str.charAt(0))) {
      buf.append(escape).append(str.charAt(0));
      i ++;
    }

    LOOP1:
    for (; i<len; i++) {
      char ch = str.charAt(i);
      if (ch == escape) {
        buf.append(escape).append(ch);
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            buf.append(escape).append(ch);
            continue LOOP1;
          }
        }
        buf.append(ch);
      }
    }

    if (len > 0 && len == str.length() - 1) {
      buf.append(escape).append(str.charAt(len));
    }

    return buf.toString();
  }

  /**
   * ʏ̕ʂň͂܂ꂽt@Co͗p̕ɕϊB
   * <br>
   * ̗̕[ɊʂtB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * ̕Ɋʂ܂܂ꍇȂOɃGXP[v}B
   *
   * @param  str B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   * @deprecated <code>char</code>ϐ̎gp邽ߔp~B{@link
   *   #toWriteString(String,String,String,String,Collection)}gp
   *   B
   */
  @Deprecated
  public static String toWriteString(String str, char openPar, char closePar,
    char escape, CharSequence specChars)
  {
    assert (str != null) : "@param:str is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int nSpec = specChars.length();
    int len = str.length();

    StringBuilder buf = new StringBuilder(len + 2);
    buf.append(openPar);

    LOOP1:
    for (int i=0; i<len; i++) {
      char ch = str.charAt(i);
      if (ch == escape) {
        buf.append(escape).append(ch);
      }
      else if (ch == openPar) {
        buf.append(escape).append(ch);
      }
      else if (ch == closePar) {
        buf.append(escape).append(ch);
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            buf.append(escape).append(ch);
            continue LOOP1;
          }
        }
        buf.append(ch);
      }
    }

    buf.append(closePar);
    return buf.toString();
  }

  /**
   * t@Cǂݍ񂾕Ȃǂʏ̕ɕϊB
   * <br>
   * ̕񂩂GXP[vAgsB
   * AAGXP[v̂ɂ󔒕̓g̑ΏۂƂȂB
   * <br>
   * w肳ꂽꕶ̑OɃGXP[v񂪑݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * <br>
   * ꕶȊȎ̕OɃGXP[v񂪑݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escapeStr GXP[vB
   * @param  specialStrs ꕶ̏WB
   * @return ϊ̕B
   *
   * @throws StringConvertException ̕ϊȂꍇB
   * @throws IllegalArgumentException GXP[vꕶɋ󕶎
   *           ܂܂ĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String fromReadString(
    String readStr, String escapeStr, Collection<String> specialStrs
  ) throws IllegalArgumentException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (escapeStr != null) : "@param:escapeStr is null.";
    assert (specialStrs != null) : "@param:specialStrs is null.";

    int escapeLen = StringOperation.length(escapeStr);
    if (escapeLen == 0) {
      throw new IllegalArgumentException("@param:escapeStr is empty.");
    }
    if (specialStrs.contains(null)) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains null.");
    }
    if (specialStrs.contains("")) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains an empty string.");
    }


    StringBuilder buf = new StringBuilder(readStr.length());
    StringSequence seq = new StringSequence(readStr).skipWhitespaces();
    String s;

    while (seq.validIndex()) {
      if (seq.startsWith(escapeStr)) {
        if (! seq.next(escapeLen).validIndex()) {
          throw new EndWithEscapeCharException(seq.index() - escapeLen, buf);
        }
        buf.append(seq.character());
        seq.next();
      }
      else if ((s = seq.startsWithOneOf(specialStrs)) != null) {
        throw new SpecialCharNotEscapedException(seq.index(), buf, s);
      }
      else if (StringOperation.isWhitespaces(seq.character())) {
        StringSequence bgn = seq.copy();
        if (! seq.skipWhitespaces().validIndex()) {
          break;
        }
        buf.append(bgn.substring(seq));
      }
      else {
        buf.append(seq.character());
        seq.next();
      }
    }

    return buf.toString();
  }

  /**
   * t@Cǂݍ񂾊ʂň͂܂ꂽȂǂʏ̕ɕϊB
   * <br>
   * ̕񂩂痼[̊ʂAGXP[vB
   * <br>
   * [ɊʂȂꍇ͗OX[B
   * <br>
   * w肳ꂽꕶ⊇ʂ̑OɃGXP[v񂪑݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * <br>
   * ꕶ⊇ʈȊȎ̕OɃGXP[v񂪑݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escapeStr GXP[vB
   * @param  openPar JʕB
   * @param  closePar ʕB
   * @param  specialStrs ꕶ̏WB
   * @return ϊ̕B
   * @throws StringConvertException ̕ϊȂꍇB
   * @throws IllegalArgumentException GXP[v⊇ʁAꕶ
   *           󕶎񂪊܂܂ĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String fromReadString(String readStr, String openPar,
    String closePar, String escapeStr, Collection<String> specialStrs
  ) throws IllegalArgumentException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (openPar != null) : "@param:openPar is null.";
    assert (closePar != null) : "@param:closePar is null.";
    assert (escapeStr != null) : "@param:escapeStr is null.";
    assert (specialStrs != null) : "@param:specialStrs is null.";

    int escapeLen = StringOperation.length(escapeStr);
    if (escapeLen == 0) {
      throw new IllegalArgumentException("@param:escapeStr is empty.");
    }
    int openParLen = StringOperation.length(openPar);
    if (openParLen == 0) {
      throw new IllegalArgumentException("@param:openPar is empty.");
    }
    int closeParLen = StringOperation.length(closePar);
    if (closeParLen == 0) {
      throw new IllegalArgumentException("@param:closePar is empty.");
    }
    if (specialStrs.contains(null)) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains null.");
    }
    if (specialStrs.contains("")) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains an empty string.");
    }

    if (! StringOperation.startsWith(readStr, openPar)) {
      throw new StartWithoutParenthesisException(0, "");
    }

    StringBuilder buf = new StringBuilder(readStr.length());
    StringSequence seq = new StringSequence(readStr).next(openParLen);
    String s;

    while (seq.validIndex()) {
      if (seq.startsWith(escapeStr)) {
        if (! seq.next(escapeLen).validIndex()) {
          if (escapeStr.equals(closePar)) {
            return buf.toString();
          }
          throw new EndWithEscapeCharException(seq.index() - escapeLen, buf);
        }
        buf.append(seq.character());
        seq.next();
      }
      else if (seq.startsWith(closePar)) {
        if (seq.next(closeParLen).validIndex()) {
          throw new SpecialCharNotEscapedException(
            seq.index() - closeParLen, buf, closePar);
        }
        return buf.toString();
      }
      else if (seq.startsWith(openPar)) {
        throw new SpecialCharNotEscapedException(seq.index(), buf, openPar);
      }
      else if ((s = seq.startsWithOneOf(specialStrs)) != null) {
        throw new SpecialCharNotEscapedException(seq.index(), buf, s);
      }
      else {
        buf.append(seq.character());
        seq.next();
      }
    }

    if (StringOperation.endsWith(readStr, closePar)) {
      throw new EndWithEscapeCharException(seq.index() - closeParLen,
        buf.substring(0, buf.length() - closeParLen));
    }

    throw new EndWithoutParenthesisException(seq.index(), buf);
  }

  /**
   * ʏ̕t@Co͗p̕ɕϊB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * <br>
   * ̕񂪋󔒂ŊJnĂꍇ́Aŏ̋󔒕̑OɃGXP[v
   * }B
   * ̕񂪋󔒂ŏIĂꍇ́AŌ̋󔒕̑OɃGXP[v
   * }B
   *
   * @param  str B
   * @param  escapeStr GXP[vB
   * @param  specialStrs ꕶ̏WB
   * @return ϊ̕B
   * @throws IllegalArgumentException GXP[vꕶ񂪋󕶎
   *           ܂łꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static String toWriteString(
    String str, String escapeStr, Collection<String> specialStrs)
  {
    assert (str != null) : "@param:str is null.";
    assert (escapeStr != null) : "@param:escapeStr is null.";
    assert (specialStrs != null) : "@param:specialStrs is null.";

    int escapeLen = StringOperation.length(escapeStr);
    if (escapeLen == 0) {
      throw new IllegalArgumentException("@param:escapeStr is empty.");
    }
    if (specialStrs.contains(null)) {
      throw new IllegalArgumentException("@param:specialStrs contains null.");
    }
    if (specialStrs.contains("")) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains an empty string.");
    }


    StringBuilder buf = new StringBuilder(str.length());
    StringSequence seq = new StringSequence(str);
    String s;

    if (StringOperation.isWhitespaces(seq.character())) {
      buf.append(escapeStr).append(seq.character());
      seq.next();
    }

    while (seq.validIndex()) {
      if (seq.startsWith(escapeStr)) {
        buf.append(escapeStr).append(escapeStr);
        seq.next(escapeLen);
      }
      else if ((s = seq.startsWithOneOf(specialStrs)) != null) {
        buf.append(escapeStr).append(s);
        seq.next(StringOperation.length(s));
      }
      else if(StringOperation.isWhitespaces(seq.character())&& !seq.hasNext()){
        buf.append(escapeStr).append(seq.character());
        break;
      }
      else {
        buf.append(seq.character());
        seq.next();
      }
    }

    return buf.toString();
  }

  /**
   * ʏ̕ʂň͂܂ꂽt@Co͗p̕ɕϊB
   * <br>
   * ̗̕[ɊʂtB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * ̕Ɋʂ܂܂ꍇȂOɃGXP[v}B
   *
   * @param  str B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escapeStr GXP[vB
   * @param  specialStrs ꕶ̏WB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String toWriteString(String str,String openPar,String closePar,
    String escapeStr, Collection<String> specialStrs)
  {
    assert (str != null) : "@param:str is null.";
    assert (openPar != null) : "@param:openPar is null.";
    assert (closePar != null) : "@param:closePar is null.";
    assert (escapeStr != null) : "@param:escapeStr is null.";
    assert (specialStrs != null) : "@param:specialStrs is null.";

    int escapeLen = StringOperation.length(escapeStr);
    if (escapeLen == 0) {
      throw new IllegalArgumentException("@param:escapeStr is empty.");
    }
    int closeParLen = StringOperation.length(closePar);
    if (closeParLen == 0) {
      throw new IllegalArgumentException("@param:closePar is empty.");
    }
    int openParLen = StringOperation.length(openPar);
    if (openParLen == 0) {
      throw new IllegalArgumentException("@param:openPar is empty.");
    }
    if (specialStrs.contains(null)) {
      throw new IllegalArgumentException("@param:specialStrs contains null.");
    }
    if (specialStrs.contains("")) {
      throw new IllegalArgumentException(
        "@param:specialStrs contains an empty string.");
    }

    StringBuilder buf = new StringBuilder(str.length() + 2);
    buf.append(openPar);

    StringSequence seq = new StringSequence(str);
    String s;

    while (seq.validIndex()) {
      if (seq.startsWith(escapeStr)) {
        buf.append(escapeStr).append(escapeStr);
        seq.next(escapeLen);
      }
      else if (seq.startsWith(closePar)) {
        buf.append(escapeStr).append(closePar);
        seq.next(closeParLen);
      }
      else if (seq.startsWith(openPar)) {
        buf.append(escapeStr).append(openPar);
        seq.next(openParLen);
      }
      else if ((s = seq.startsWithOneOf(specialStrs)) != null) {
        buf.append(escapeStr).append(s);
        seq.next(StringOperation.length(s));
      }
      else {
        buf.append(seq.character());
        seq.next();
      }
    }

    buf.append(closePar);
    return buf.toString();
  }
}
