/*
 * StartWithoutParenthesisExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.text.StartWithoutParenthesisException StartWithoutParenthesisException}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:52 $
 */
public class StartWithoutParenthesisExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(StartWithoutParenthesisExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("StartWithoutParenthesisException NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor_index_string()
  {
    MSG("CfbNXƕɂƂRXgN^B");
    try {
      throw new StartWithoutParenthesisException(10, "abc");
    } catch (StartWithoutParenthesisException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getMessage(), null);
      EQUAL(e.toString(), e.getClass().getName());
    }
    try {
      throw new StartWithoutParenthesisException(10, null);
    } catch (StartWithoutParenthesisException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), null);
      EQUAL(e.getMessage(), null);
      EQUAL(e.toString(), e.getClass().getName());
    }
  }

  public void constructor_index_string_msg()
  {
    MSG("CfbNXƕAObZ[WɂƂRXgN^B");

    try {
      throw new StartWithoutParenthesisException(10, "abc", "def");
    } catch (StartWithoutParenthesisException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getMessage(), "def");
      EQUAL(e.toString(), e.getClass().getName() + ": def");
    }

    try {
      throw new StartWithoutParenthesisException(10, "abc", null);
    } catch (StartWithoutParenthesisException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getMessage(), null);
      EQUAL(e.toString(), e.getClass().getName());
    }

    try {
      throw new StartWithoutParenthesisException(10, null, "def");
    } catch (StartWithoutParenthesisException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), null);
      EQUAL(e.getMessage(), "def");
      EQUAL(e.toString(), e.getClass().getName() + ": def");
    }
  }
}

