/*
 * Header class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;

/**
 * e[ũJEL[i[wb_EIuWFNg̃C^[tFCXB
 * <br>
 * JJEL[擾邽߂̃\bhAR[h쐬郁\bh
 * ̐錾񋟂B
 * <br>
 * <br>
 * wb_JEL[폜邽߂̃\bh͗pӂĂȂB
 *
 * @param <C> JEL[̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:51 $
 */
public interface Header<C> extends Cloneable, Serializable
{
  /**
   * ̃wb_Ɋi[ĂJEL[̐擾B
   *
   * @return JEL[̐B
   */
  int columnCount();

  /**
   * ̃wb_Ɋi[ĂJEL[Ɏ擾邽߂̃Ce[^
   * 擾B
   *
   * @return  JEL[̃Ce[^B
   */
  Enumeration<C> columns();

  /**
   * w肳ꂽIuWFNgƓJEL[̃wb_Ɋi[Ă邩
   * ǂmFB
   *
   * @param  column JEL[B
   * @return w肳ꂽJEL[̃IuWFNgɊi[Ăꍇ
   *         <tt>true</tt>ԂB
   */
  boolean hasColumn(Object column);

  /**
   * JEL[ǉB
   *
   * @param  column JEL[B
   */
  void addColumn(C column);
}

