/*
 * AttributeNameEmptyExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.resource.AttributeNameEmptyException AttributeNameEmptyException}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:48 $
 */
public class AttributeNameEmptyExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(AttributeNameEmptyExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("AttributeNameEmptyException NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor_key()
  {
    MSG("L[ɂƂRXgN^B");

    try {
      throw new AttributeNameEmptyException("aaa.bbb");
    } catch (AttributeNameEmptyException e) {
      TRUE(e instanceof IllegalKeyException);
      EQUAL(e.getKey(), "aaa.bbb");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new AttributeNameEmptyException(null);
    } catch (AttributeNameEmptyException e) {
      TRUE(e instanceof IllegalKeyException);
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg()
  {
    MSG("L[ƃbZ[WɂƂRXgN^B");

    try {
      throw new AttributeNameEmptyException("aaa.bbb", "");
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "aaa.bbb");
      EQUAL(e.getMessage(), "");
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new AttributeNameEmptyException(null, (String) null);
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg_cause()
  {
    MSG("L[ƃbZ[WƌɂƂRXgN^B");

    Exception e0 = new Exception();

    try {
      throw new AttributeNameEmptyException("aaa.bbb", "", e0);
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "aaa.bbb");
      EQUAL(e.getMessage(), "");
      EQUAL(e.getCause(), e0);
    }
  }

  public void constructor_key_msg_cause_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new AttributeNameEmptyException(null, null, null);
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_cause()
  {
    MSG("L[ƌɂƂRXgN^B");

    Exception e0 = new Exception();

    try {
      throw new AttributeNameEmptyException("aaa.bbb", e0);
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "aaa.bbb");
      EQUAL(e.getMessage(), e0.getClass().getName());
      EQUAL(e.getCause(), e0);
    }
  }

  public void constructor_key_cause_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new AttributeNameEmptyException(null, (Throwable) null);
    } catch (AttributeNameEmptyException e) {
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }
}

