/*
 * FileNameRegexFilterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.File;

/**
 * {@link ts.util.file.FileNameRegexFilter FileNameRegexFilter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:46 $
 */
public class FileNameRegexFilterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileNameRegexFilterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileNameRegexFilter NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("K\ɂƂRXgN^B");

    File file = new File("javadoc.css");
    String regex = "^java.*\\.cs*$";

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("fileNameRegex_", regex);
    FileNameRegexFilter filter = new FileNameRegexFilter(regex);

    try {
      oi.inspect(filter);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_1()
  {
    MSG("k̏ꍇB");

    try {
      FileNameRegexFilter filter = new FileNameRegexFilter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void accept()
  {
    MSG("̊mFB");

    File file = new File("javadoc.css");
    String regex = "^java.*\\.cs*$";
    FileNameRegexFilter filter = new FileNameRegexFilter(regex);
    TRUE(filter.accept(file));

    String regex2 = "^java*\\.cs*$";
    FileNameRegexFilter filter2 = new FileNameRegexFilter(regex2);
    FALSE(filter2.accept(file));
  }

  public void accept_1()
  {
    MSG("k̏ꍇB");

    String regex = "^java.*\\.cs*$";
    FileNameRegexFilter filter = new FileNameRegexFilter(regex);

    try {
      filter.accept(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

